/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core.script.configuration.listener;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Alarm;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.core.script.ScriptConfigurationManager;
import org.jetbrains.kotlin.idea.core.script.ScriptUtilsKt;
import org.jetbrains.kotlin.idea.core.script.configuration.listener.DefaultScriptChangeListener;
import org.jetbrains.kotlin.idea.core.script.configuration.listener.ScriptChangeListener;
import org.jetbrains.kotlin.idea.core.script.configuration.listener.ScriptChangesNotifier;
import org.jetbrains.kotlin.idea.core.script.configuration.listener.ScriptConfigurationUpdater;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0012\u001a\u00020\u0013H\u0002J\u001a\u0010\u0014\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/configuration/listener/ScriptChangesNotifier;", "", "project", "Lcom/intellij/openapi/project/Project;", "updater", "Lorg/jetbrains/kotlin/idea/core/script/configuration/listener/ScriptConfigurationUpdater;", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/kotlin/idea/core/script/configuration/listener/ScriptConfigurationUpdater;)V", "defaultListener", "Lorg/jetbrains/kotlin/idea/core/script/configuration/listener/DefaultScriptChangeListener;", "listeners", "Lkotlin/sequences/Sequence;", "Lorg/jetbrains/kotlin/idea/core/script/configuration/listener/ScriptChangeListener;", "getListeners", "()Lkotlin/sequences/Sequence;", "scriptChangesListenerDelay", "", "scriptsQueue", "Lcom/intellij/util/Alarm;", "areListenersDisabled", "", "getListener", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "listenForChangesInScripts", "", "idea-core"})
public final class ScriptChangesNotifier {
    private final Alarm scriptsQueue;
    private final int scriptChangesListenerDelay = 1400;
    private final DefaultScriptChangeListener defaultListener;
    private final Project project;
    private final ScriptConfigurationUpdater updater;

    private final void listenForChangesInScripts() {
        this.project.getMessageBus().connect().subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerListener(this){
            final /* synthetic */ ScriptChangesNotifier this$0;

            public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
                Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
                Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
                this.runScriptDependenciesUpdateIfNeeded(file2);
            }

            public void selectionChanged(@NotNull FileEditorManagerEvent event) {
                block0: {
                    Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                    VirtualFile virtualFile2 = event.getNewFile();
                    if (virtualFile2 == null) break block0;
                    VirtualFile virtualFile3 = virtualFile2;
                    boolean bl = false;
                    boolean bl2 = false;
                    VirtualFile it = virtualFile3;
                    boolean bl3 = false;
                    VirtualFile virtualFile4 = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile4, (String)"it");
                    this.runScriptDependenciesUpdateIfNeeded(virtualFile4);
                }
            }

            private final void runScriptDependenciesUpdateIfNeeded(VirtualFile file2) {
                block0: {
                    ScriptChangeListener scriptChangeListener = ScriptChangesNotifier.access$getListener(this.this$0, ScriptChangesNotifier.access$getProject$p(this.this$0), file2);
                    if (scriptChangeListener == null) break block0;
                    scriptChangeListener.editorActivated(file2, ScriptChangesNotifier.access$getUpdater$p(this.this$0));
                }
            }
            {
                this.this$0 = $outer;
            }
        });
        EditorFactory editorFactory = EditorFactory.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)editorFactory, (String)"EditorFactory.getInstance()");
        editorFactory.getEventMulticaster().addDocumentListener(new DocumentListener(this){
            final /* synthetic */ ScriptChangesNotifier this$0;

            public void documentChanged(@NotNull DocumentEvent event) {
                Object object;
                block6: {
                    block5: {
                        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                        Document document = event.getDocument();
                        Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"event.document");
                        Document document2 = document;
                        object = FileDocumentManager.getInstance().getFile(document2);
                        if (object == null) break block5;
                        VirtualFile virtualFile2 = object;
                        boolean bl = false;
                        boolean bl2 = false;
                        VirtualFile it = virtualFile2;
                        boolean bl3 = false;
                        VirtualFile virtualFile3 = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile3, (String)"it");
                        object = virtualFile3.isInLocalFileSystem() ? virtualFile2 : null;
                        if (object != null) break block6;
                    }
                    return;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"FileDocumentManager.getI\u2026calFileSystem } ?: return");
                VirtualFile file2 = object;
                ScriptChangeListener scriptChangeListener = ScriptChangesNotifier.access$getListener(this.this$0, ScriptChangesNotifier.access$getProject$p(this.this$0), file2);
                if (scriptChangeListener == null) {
                    return;
                }
                ScriptChangeListener listener2 = scriptChangeListener;
                Application application = ApplicationManager.getApplication();
                Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
                if (application.isUnitTestMode()) {
                    listener2.documentChanged(file2, ScriptChangesNotifier.access$getUpdater$p(this.this$0));
                }
                ScriptChangesNotifier.access$getScriptsQueue$p(this.this$0).cancelAllRequests();
                ScriptChangesNotifier.access$getScriptsQueue$p(this.this$0).addRequest(new Runnable(this, listener2, file2){
                    final /* synthetic */ listenForChangesInScripts.2 this$0;
                    final /* synthetic */ ScriptChangeListener $listener;
                    final /* synthetic */ VirtualFile $file;

                    public final void run() {
                        this.$listener.documentChanged(this.$file, ScriptChangesNotifier.access$getUpdater$p(this.this$0.this$0));
                    }
                    {
                        this.this$0 = var1_1;
                        this.$listener = scriptChangeListener;
                        this.$file = virtualFile2;
                    }
                }, ScriptChangesNotifier.access$getScriptChangesListenerDelay$p(this.this$0), true);
            }
            {
                this.this$0 = $outer;
            }
        }, (Disposable)this.project.getMessageBus().connect());
    }

    private final Sequence<ScriptChangeListener> getListeners() {
        return SequencesKt.sequence((Function2)((Function2)new Function2<SequenceScope<? super ScriptChangeListener>, Continuation<? super Unit>, Object>(this, null){
            private SequenceScope p$;
            Object L$0;
            int label;
            final /* synthetic */ ScriptChangesNotifier this$0;

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object $result) {
                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        $this$sequence = this.p$;
                        v0 = ScriptChangeListener.Companion.getLISTENER().getPoint((AreaInstance)ScriptChangesNotifier.access$getProject$p(this.this$0));
                        Intrinsics.checkExpressionValueIsNotNull((Object)v0, (String)"LISTENER.getPoint(project)");
                        v1 = v0.getExtensionList();
                        Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"LISTENER.getPoint(project).extensionList");
                        this.L$0 = $this$sequence;
                        this.label = 1;
                        v2 = $this$sequence.yieldAll((Iterable)v1, (Continuation)this);
                        if (v2 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl20
                    }
                    case 1: {
                        $this$sequence = (SequenceScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl20:
                        // 2 sources

                        this.L$0 = $this$sequence;
                        this.label = 2;
                        v3 = $this$sequence.yield((Object)ScriptChangesNotifier.access$getDefaultListener$p(this.this$0), (Continuation)this);
                        if (v3 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl30
                    }
                    case 2: {
                        $this$sequence = (SequenceScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v3 = $result;
lbl30:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }
            {
                this.this$0 = scriptChangesNotifier;
                super(2, continuation2);
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> completion) {
                Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
                Function2<SequenceScope<? super ScriptChangeListener>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                SequenceScope sequenceScope = function2.p$ = (SequenceScope)value2;
                return function2;
            }

            public final Object invoke(Object object, Object object2) {
                return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    private final ScriptChangeListener getListener(Project project2, VirtualFile file2) {
        Object v0;
        block3: {
            if (project2.isDisposed() || this.areListenersDisabled()) {
                return null;
            }
            if (ScriptConfigurationManager.Companion.isManualConfigurationLoading(file2)) {
                return null;
            }
            Sequence<ScriptChangeListener> $this$firstOrNull$iv = this.getListeners();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ScriptChangeListener it = (ScriptChangeListener)element$iv;
                boolean bl = false;
                if (!it.isApplicable(file2)) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        return v0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean areListenersDisabled() {
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
        if (!application.isUnitTestMode()) return false;
        Application application2 = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application2, (String)"ApplicationManager.getApplication()");
        if (!Intrinsics.areEqual((Object)ScriptUtilsKt.isScriptChangesNotifierDisabled(application2), (Object)true)) return false;
        return true;
    }

    public ScriptChangesNotifier(@NotNull Project project2, @NotNull ScriptConfigurationUpdater updater2) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)updater2, (String)"updater");
        this.project = project2;
        this.updater = updater2;
        this.scriptsQueue = new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)this.project);
        this.scriptChangesListenerDelay = 1400;
        this.listenForChangesInScripts();
        this.defaultListener = new DefaultScriptChangeListener(this.project);
    }

    public static final /* synthetic */ ScriptChangeListener access$getListener(ScriptChangesNotifier $this, Project project2, VirtualFile file2) {
        return $this.getListener(project2, file2);
    }

    public static final /* synthetic */ Project access$getProject$p(ScriptChangesNotifier $this) {
        return $this.project;
    }

    public static final /* synthetic */ ScriptConfigurationUpdater access$getUpdater$p(ScriptChangesNotifier $this) {
        return $this.updater;
    }

    public static final /* synthetic */ Alarm access$getScriptsQueue$p(ScriptChangesNotifier $this) {
        return $this.scriptsQueue;
    }

    public static final /* synthetic */ int access$getScriptChangesListenerDelay$p(ScriptChangesNotifier $this) {
        return $this.scriptChangesListenerDelay;
    }

    public static final /* synthetic */ DefaultScriptChangeListener access$getDefaultListener$p(ScriptChangesNotifier $this) {
        return $this.defaultListener;
    }
}

