/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core.script.configuration.utils;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Alarm;
import com.intellij.util.containers.HashSetQueue;
import java.util.Queue;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.core.script.ScriptUtilsKt;
import org.jetbrains.kotlin.idea.core.script.configuration.utils.BackgroundExecutor;
import org.jetbrains.kotlin.idea.core.script.configuration.utils.DefaultBackgroundExecutor;
import org.jetbrains.kotlin.idea.core.script.configuration.utils.ScriptClassRootsIndexer;
import org.jetbrains.kotlin.idea.core.util.KotlinIdeaCoreBundle;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\b\u0000\u0018\u0000 )2\u00020\u0001:\u0005)*+,-B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u001e\u001a\u00020\u001fH\u0002J\b\u0010 \u001a\u00020\u001fH\u0002J\u001e\u0010!\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020\b2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001f0$H\u0016J\b\u0010%\u001a\u00020\u001fH\u0002J\b\u0010&\u001a\u00020\u001fH\u0002J\b\u0010'\u001a\u00020\u001fH\u0002J\u0006\u0010(\u001a\u00020\u001fR\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\b\u0018\u00010\u0019R\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\b\u0018\u00010\u001bR\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lorg/jetbrains/kotlin/idea/core/script/configuration/utils/DefaultBackgroundExecutor;", "Lorg/jetbrains/kotlin/idea/core/script/configuration/utils/BackgroundExecutor;", "project", "Lcom/intellij/openapi/project/Project;", "rootsManager", "Lorg/jetbrains/kotlin/idea/core/script/configuration/utils/ScriptClassRootsIndexer;", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/kotlin/idea/core/script/configuration/utils/ScriptClassRootsIndexer;)V", "currentFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "currentProgressDone", "", "currentProgressSize", "inTransaction", "", "longRunningAlaramRequested", "longRunningAlarm", "Lcom/intellij/util/Alarm;", "getProject", "()Lcom/intellij/openapi/project/Project;", "queue", "Ljava/util/Queue;", "Lorg/jetbrains/kotlin/idea/core/script/configuration/utils/DefaultBackgroundExecutor$LoadTask;", "getRootsManager", "()Lorg/jetbrains/kotlin/idea/core/script/configuration/utils/ScriptClassRootsIndexer;", "silentWorker", "Lorg/jetbrains/kotlin/idea/core/script/configuration/utils/DefaultBackgroundExecutor$SilentWorker;", "underProgressWorker", "Lorg/jetbrains/kotlin/idea/core/script/configuration/utils/DefaultBackgroundExecutor$UnderProgressWorker;", "work", "", "endBatch", "", "ensureInTransaction", "ensureScheduled", "key", "actions", "Lkotlin/Function0;", "requireSilentWorker", "requireUnderProgressWorker", "restartProgressBar", "updateProgress", "Companion", "LoadTask", "SilentWorker", "UnderProgressWorker", "Worker", "idea-core"})
public final class DefaultBackgroundExecutor
implements BackgroundExecutor {
    private final Object work;
    private final Queue<LoadTask> queue;
    private int currentProgressSize;
    private int currentProgressDone;
    private SilentWorker silentWorker;
    private UnderProgressWorker underProgressWorker;
    private final Alarm longRunningAlarm;
    private boolean longRunningAlaramRequested;
    private boolean inTransaction;
    private VirtualFile currentFile;
    @NotNull
    private final Project project;
    @NotNull
    private final ScriptClassRootsIndexer rootsManager;
    public static final int PROGRESS_INDICATOR_DELAY = 1000;
    public static final int PROGRESS_INDICATOR_MIN_QUEUE = 3;
    public static final Companion Companion = new Companion(null);

    @Override
    public synchronized void ensureScheduled(@NotNull VirtualFile key, @NotNull Function0<Unit> actions) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull(actions, (String)"actions");
        LoadTask task2 = new LoadTask(key, actions);
        if (this.queue.add(task2)) {
            ScriptUtilsKt.debug(task2.getKey(), (Function0<String>)((Function0)ensureScheduled.1.INSTANCE));
            if (this.queue.size() > 3) {
                this.requireUnderProgressWorker();
            } else {
                this.requireSilentWorker();
                if (!this.longRunningAlaramRequested) {
                    this.longRunningAlaramRequested = true;
                    this.longRunningAlarm.addRequest(new Runnable(this){
                        final /* synthetic */ DefaultBackgroundExecutor this$0;

                        public final void run() {
                            DefaultBackgroundExecutor.access$setLongRunningAlaramRequested$p(this.this$0, false);
                            DefaultBackgroundExecutor.access$requireUnderProgressWorker(this.this$0);
                        }
                        {
                            this.this$0 = defaultBackgroundExecutor;
                        }
                    }, 1000);
                }
            }
        }
    }

    private final synchronized void requireSilentWorker() {
        if (this.silentWorker == null && this.underProgressWorker == null) {
            SilentWorker silentWorker;
            SilentWorker silentWorker2 = new SilentWorker();
            DefaultBackgroundExecutor defaultBackgroundExecutor = this;
            boolean bl = false;
            boolean bl2 = false;
            SilentWorker it = silentWorker2;
            boolean bl3 = false;
            it.start();
            defaultBackgroundExecutor.silentWorker = silentWorker = silentWorker2;
        }
    }

    private final synchronized void requireUnderProgressWorker() {
        if (this.queue.isEmpty() && this.silentWorker == null) {
            return;
        }
        SilentWorker silentWorker = this.silentWorker;
        if (silentWorker != null) {
            silentWorker.stopGracefully();
        }
        if (this.underProgressWorker == null) {
            UnderProgressWorker underProgressWorker;
            UnderProgressWorker underProgressWorker2 = new UnderProgressWorker();
            DefaultBackgroundExecutor defaultBackgroundExecutor = this;
            boolean bl = false;
            boolean bl2 = false;
            UnderProgressWorker it = underProgressWorker2;
            boolean bl3 = false;
            it.start();
            defaultBackgroundExecutor.underProgressWorker = underProgressWorker = underProgressWorker2;
            this.restartProgressBar();
            this.updateProgress();
        }
    }

    private final synchronized void restartProgressBar() {
        this.currentProgressSize = this.queue.size();
        this.currentProgressDone = 0;
    }

    public final synchronized void updateProgress() {
        block4: {
            UnderProgressWorker underProgressWorker = this.underProgressWorker;
            if (underProgressWorker == null || (underProgressWorker = underProgressWorker.getProgressIndicator()) == null) break block4;
            UnderProgressWorker underProgressWorker2 = underProgressWorker;
            boolean bl = false;
            boolean bl2 = false;
            UnderProgressWorker it = underProgressWorker2;
            boolean bl3 = false;
            Object object = this.currentFile;
            if (object == null || (object = object.getPath()) == null) {
                object = "";
            }
            it.setText2((String)object);
            if (this.queue.size() == 0) {
                it.setIndeterminate(true);
            } else {
                it.setIndeterminate(false);
                if (this.currentProgressDone > this.currentProgressSize) {
                    this.restartProgressBar();
                }
                it.setFraction((double)this.currentProgressDone / (double)this.currentProgressSize);
            }
        }
    }

    private final synchronized void ensureInTransaction() {
        if (this.inTransaction) {
            return;
        }
        this.inTransaction = true;
        this.rootsManager.startTransaction();
    }

    private final synchronized void endBatch() {
        boolean bl = this.inTransaction;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Check failed.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        this.rootsManager.commit();
        this.inTransaction = false;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final ScriptClassRootsIndexer getRootsManager() {
        return this.rootsManager;
    }

    public DefaultBackgroundExecutor(@NotNull Project project2, @NotNull ScriptClassRootsIndexer rootsManager) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)rootsManager, (String)"rootsManager");
        this.project = project2;
        this.rootsManager = rootsManager;
        this.work = new Object();
        this.queue = (Queue)new HashSetQueue();
        this.longRunningAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this.project);
    }

    public static final /* synthetic */ VirtualFile access$getCurrentFile$p(DefaultBackgroundExecutor $this) {
        return $this.currentFile;
    }

    public static final /* synthetic */ UnderProgressWorker access$getUnderProgressWorker$p(DefaultBackgroundExecutor $this) {
        return $this.underProgressWorker;
    }

    public static final /* synthetic */ SilentWorker access$getSilentWorker$p(DefaultBackgroundExecutor $this) {
        return $this.silentWorker;
    }

    public static final /* synthetic */ boolean access$getLongRunningAlaramRequested$p(DefaultBackgroundExecutor $this) {
        return $this.longRunningAlaramRequested;
    }

    public static final /* synthetic */ void access$setLongRunningAlaramRequested$p(DefaultBackgroundExecutor $this, boolean bl) {
        $this.longRunningAlaramRequested = bl;
    }

    public static final /* synthetic */ void access$requireUnderProgressWorker(DefaultBackgroundExecutor $this) {
        $this.requireUnderProgressWorker();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/configuration/utils/DefaultBackgroundExecutor$LoadTask;", "", "key", "Lcom/intellij/openapi/vfs/VirtualFile;", "actions", "Lkotlin/Function0;", "", "(Lcom/intellij/openapi/vfs/VirtualFile;Lkotlin/jvm/functions/Function0;)V", "getActions", "()Lkotlin/jvm/functions/Function0;", "getKey", "()Lcom/intellij/openapi/vfs/VirtualFile;", "equals", "", "other", "hashCode", "", "idea-core"})
    public static final class LoadTask {
        @NotNull
        private final VirtualFile key;
        @NotNull
        private final Function0<Unit> actions;

        public boolean equals(@Nullable Object other) {
            return this == other || other instanceof LoadTask && Intrinsics.areEqual((Object)this.key, (Object)((LoadTask)other).key);
        }

        public int hashCode() {
            return this.key.hashCode();
        }

        @NotNull
        public final VirtualFile getKey() {
            return this.key;
        }

        @NotNull
        public final Function0<Unit> getActions() {
            return this.actions;
        }

        public LoadTask(@NotNull VirtualFile key, @NotNull Function0<Unit> actions) {
            Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
            Intrinsics.checkParameterIsNotNull(actions, (String)"actions");
            this.key = key;
            this.actions = actions;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u00a2\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0004H\u0014J\b\u0010\u0006\u001a\u00020\u0007H$J\b\u0010\b\u001a\u00020\u0007H\u0004J\b\u0010\t\u001a\u00020\u0007H\u0016J\u0006\u0010\n\u001a\u00020\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/configuration/utils/DefaultBackgroundExecutor$Worker;", "", "(Lorg/jetbrains/kotlin/idea/core/script/configuration/utils/DefaultBackgroundExecutor;)V", "shouldStop", "", "checkCancelled", "close", "", "run", "start", "stopGracefully", "idea-core"})
    private abstract class Worker {
        private boolean shouldStop;

        public void start() {
            DefaultBackgroundExecutor.this.ensureInTransaction();
        }

        public final void stopGracefully() {
            this.shouldStop = true;
        }

        protected boolean checkCancelled() {
            return false;
        }

        protected abstract void close();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        protected final void run() {
            boolean bl;
            Object object;
            try {
                while (true) {
                    Object object2 = DefaultBackgroundExecutor.this.work;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    // MONITORENTER : object2
                    boolean bl4 = false;
                    object = DefaultBackgroundExecutor.this;
                    bl = false;
                    boolean bl5 = false;
                    // MONITORENTER : object
                    boolean bl6 = false;
                    if (this.shouldStop) {
                        // MONITOREXIT : object
                        // MONITOREXIT : object2
                        this.close();
                        return;
                    }
                    if (!this.checkCancelled()) break block19;
                    break;
                }
            }
            catch (Throwable throwable) {
                this.close();
                throw throwable;
            }
            {
                Object object3;
                block19: {
                    DefaultBackgroundExecutor.this.queue.clear();
                    DefaultBackgroundExecutor.this.endBatch();
                    // MONITOREXIT : object
                    // MONITOREXIT : object2
                    this.close();
                    return;
                }
                if (DefaultBackgroundExecutor.this.queue.isEmpty()) {
                    DefaultBackgroundExecutor.this.endBatch();
                    // MONITOREXIT : object
                    // MONITOREXIT : object2
                    this.close();
                    return;
                }
                if ((LoadTask)DefaultBackgroundExecutor.this.queue.poll() != null) {
                    LoadTask loadTask;
                    boolean bl7 = false;
                    boolean bl8 = false;
                    LoadTask it = loadTask;
                    boolean bl9 = false;
                    DefaultBackgroundExecutor.this.currentFile = it.getKey();
                    DefaultBackgroundExecutor defaultBackgroundExecutor = DefaultBackgroundExecutor.this;
                    int n = defaultBackgroundExecutor.currentProgressDone;
                    defaultBackgroundExecutor.currentProgressDone = n + 1;
                    DefaultBackgroundExecutor.this.updateProgress();
                    object3 = loadTask;
                } else {
                    object3 = null;
                }
                Function0<Unit> function0 = object3;
                // MONITOREXIT : object
                Function0<Unit> next2 = function0;
                Function0<Unit> function02 = next2;
                if (function02 != null && (function02 = function02.getActions()) != null) {
                    Unit cfr_ignored_0 = (Unit)function02.invoke();
                }
                object = DefaultBackgroundExecutor.this.work;
                bl = false;
                boolean bl10 = false;
                // MONITORENTER : object
                boolean bl11 = false;
                DefaultBackgroundExecutor.this.currentFile = null;
                Unit unit = Unit.INSTANCE;
                // MONITOREXIT : object
                Unit unit2 = Unit.INSTANCE;
                // MONITOREXIT : object2
                continue;
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\n\u001a\u00020\u000bH\u0014J\b\u0010\f\u001a\u00020\rH\u0014J\b\u0010\u000e\u001a\u00020\rH\u0016R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/configuration/utils/DefaultBackgroundExecutor$UnderProgressWorker;", "Lorg/jetbrains/kotlin/idea/core/script/configuration/utils/DefaultBackgroundExecutor$Worker;", "Lorg/jetbrains/kotlin/idea/core/script/configuration/utils/DefaultBackgroundExecutor;", "(Lorg/jetbrains/kotlin/idea/core/script/configuration/utils/DefaultBackgroundExecutor;)V", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "getProgressIndicator", "()Lcom/intellij/openapi/progress/ProgressIndicator;", "setProgressIndicator", "(Lcom/intellij/openapi/progress/ProgressIndicator;)V", "checkCancelled", "", "close", "", "start", "idea-core"})
    private final class UnderProgressWorker
    extends Worker {
        @Nullable
        private ProgressIndicator progressIndicator;

        @Nullable
        public final ProgressIndicator getProgressIndicator() {
            return this.progressIndicator;
        }

        public final void setProgressIndicator(@Nullable ProgressIndicator progressIndicator) {
            this.progressIndicator = progressIndicator;
        }

        @Override
        public void start() {
            super.start();
            new Task.Backgroundable(this, DefaultBackgroundExecutor.this.getProject(), KotlinIdeaCoreBundle.message("text.kotlin.loading.script.dependencies", new Object[0]), true){
                final /* synthetic */ UnderProgressWorker this$0;

                public void run(@NotNull ProgressIndicator indicator) {
                    Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
                    this.this$0.setProgressIndicator(indicator);
                    this.this$0.DefaultBackgroundExecutor.this.updateProgress();
                    this.this$0.run();
                }
                {
                    this.this$0 = $outer;
                    super($super_call_param$1, $super_call_param$2, $super_call_param$3);
                }
            }.queue();
        }

        @Override
        protected boolean checkCancelled() {
            ProgressIndicator progressIndicator = this.progressIndicator;
            return progressIndicator != null && progressIndicator.isCanceled();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void close() {
            DefaultBackgroundExecutor defaultBackgroundExecutor = DefaultBackgroundExecutor.this;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (defaultBackgroundExecutor) {
                boolean bl3 = false;
                DefaultBackgroundExecutor.this.underProgressWorker = null;
                this.progressIndicator = null;
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0014J\b\u0010\u0006\u001a\u00020\u0005H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/configuration/utils/DefaultBackgroundExecutor$SilentWorker;", "Lorg/jetbrains/kotlin/idea/core/script/configuration/utils/DefaultBackgroundExecutor$Worker;", "Lorg/jetbrains/kotlin/idea/core/script/configuration/utils/DefaultBackgroundExecutor;", "(Lorg/jetbrains/kotlin/idea/core/script/configuration/utils/DefaultBackgroundExecutor;)V", "close", "", "start", "idea-core"})
    private final class SilentWorker
    extends Worker {
        @Override
        public void start() {
            super.start();
            BackgroundTaskUtil.executeOnPooledThread((Disposable)((Disposable)DefaultBackgroundExecutor.this.getProject()), (Runnable)new Runnable(this){
                final /* synthetic */ SilentWorker this$0;

                public final void run() {
                    this.this$0.run();
                }
                {
                    this.this$0 = silentWorker;
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void close() {
            DefaultBackgroundExecutor defaultBackgroundExecutor = DefaultBackgroundExecutor.this;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (defaultBackgroundExecutor) {
                boolean bl3 = false;
                DefaultBackgroundExecutor.this.silentWorker = null;
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/configuration/utils/DefaultBackgroundExecutor$Companion;", "", "()V", "PROGRESS_INDICATOR_DELAY", "", "PROGRESS_INDICATOR_MIN_QUEUE", "idea-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

