/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.fir;

import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.FirSourceElementKt;
import org.jetbrains.kotlin.fir.builder.RawFirBuilder;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.resolve.FirProvider;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.impl.FirProviderImpl;
import org.jetbrains.kotlin.fir.scopes.FirScope;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.idea.stubindex.KotlinExactPackagesIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinFullClassNameIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinTopLevelFunctionFqnNameIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinTopLevelPropertyFqnNameIndex;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwnerStub;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u00012B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\u0015\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\"\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020\rJ\u0016\u0010!\u001a\u0004\u0018\u00010\u001f2\n\u0010\"\u001a\u0006\u0012\u0002\b\u00030#H\u0016J\u0016\u0010$\u001a\b\u0012\u0002\b\u0003\u0018\u00010%2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0014\u0010&\u001a\u00020\u001f2\n\u0010\"\u001a\u0006\u0012\u0002\b\u00030\u0016H\u0016J\u0010\u0010&\u001a\u00020\u001f2\u0006\u0010'\u001a\u00020\u0018H\u0016J\u0016\u0010(\u001a\u0004\u0018\u00010\u001f2\n\u0010\"\u001a\u0006\u0012\u0002\b\u00030\u0016H\u0016J\u0012\u0010(\u001a\u0004\u0018\u00010\u001f2\u0006\u0010'\u001a\u00020\u0018H\u0016J\u0016\u0010)\u001a\b\u0012\u0004\u0012\u00020\u001f0*2\u0006\u0010'\u001a\u00020+H\u0016J\u0012\u0010,\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u000e\u0010-\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\rJ\"\u0010.\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030#0*2\u0006\u0010/\u001a\u00020+2\u0006\u00100\u001a\u000201H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u00063"}, d2={"Lorg/jetbrains/kotlin/idea/fir/IdeFirProvider;", "Lorg/jetbrains/kotlin/fir/resolve/FirProvider;", "project", "Lcom/intellij/openapi/project/Project;", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/psi/search/GlobalSearchScope;Lorg/jetbrains/kotlin/fir/FirSession;)V", "cacheProvider", "Lorg/jetbrains/kotlin/fir/resolve/impl/FirProviderImpl;", "files", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "Lorg/jetbrains/kotlin/idea/fir/IdeFirProvider$FirFileWithStamp;", "getProject", "()Lcom/intellij/openapi/project/Project;", "getScope", "()Lcom/intellij/psi/search/GlobalSearchScope;", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "getClassLikeSymbolByFqName", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "getClassUseSiteMemberScope", "Lorg/jetbrains/kotlin/fir/scopes/FirScope;", "useSiteSession", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "getFile", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "ktFile", "getFirCallableContainerFile", "symbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "getFirClassifierByFqName", "Lorg/jetbrains/kotlin/fir/declarations/FirClassLikeDeclaration;", "getFirClassifierContainerFile", "fqName", "getFirClassifierContainerFileIfAny", "getFirFilesByPackage", "", "Lorg/jetbrains/kotlin/name/FqName;", "getNestedClassifierScope", "getOrBuildFile", "getTopLevelCallableSymbols", "packageFqName", "name", "Lorg/jetbrains/kotlin/name/Name;", "FirFileWithStamp", "idea-core"})
public final class IdeFirProvider
extends FirProvider {
    private final FirProviderImpl cacheProvider;
    private final Map<KtFile, FirFileWithStamp> files;
    @NotNull
    private final Project project;
    @NotNull
    private final GlobalSearchScope scope;
    @NotNull
    private final FirSession session;

    @Override
    @Nullable
    public FirClassLikeDeclaration<?> getFirClassifierByFqName(@NotNull ClassId classId) {
        Intrinsics.checkParameterIsNotNull((Object)classId, (String)"classId");
        FirClassLikeDeclaration<?> firClassLikeDeclaration = this.cacheProvider.getFirClassifierByFqName(classId);
        if (firClassLikeDeclaration == null) {
            FirClassLikeDeclaration<?> firClassLikeDeclaration2;
            IdeFirProvider ideFirProvider = this;
            boolean bl = false;
            boolean bl2 = false;
            IdeFirProvider $this$run = ideFirProvider;
            boolean bl3 = false;
            try {
                Object v4;
                block5: {
                    Collection<KtClassOrObject> collection = KotlinFullClassNameIndex.getInstance().get(classId.asSingleFqName().asString(), $this$run.project, $this$run.scope);
                    Intrinsics.checkExpressionValueIsNotNull(collection, (String)"KotlinFullClassNameIndex\u2026String(), project, scope)");
                    Collection<KtClassOrObject> classes2 = collection;
                    Iterable $this$firstOrNull$iv = classes2;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        KtClassOrObject it = (KtClassOrObject)element$iv;
                        boolean bl4 = false;
                        FqName fqName2 = classId.getPackageFqName();
                        KtClassOrObject ktClassOrObject = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)ktClassOrObject, (String)"it");
                        if (!Intrinsics.areEqual((Object)fqName2, (Object)ktClassOrObject.getContainingKtFile().getPackageFqName())) continue;
                        v4 = element$iv;
                        break block5;
                    }
                    v4 = null;
                }
                KtClassOrObject ktClassOrObject = v4;
                if (ktClassOrObject == null) {
                    return null;
                }
                KtClassOrObject ktClass2 = ktClassOrObject;
                KtFile ktFile = ktClass2.getContainingKtFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)ktFile, (String)"ktClass.containingKtFile");
                KtFile ktFile2 = ktFile;
                $this$run.getOrBuildFile(ktFile2);
                firClassLikeDeclaration2 = $this$run.cacheProvider.getFirClassifierByFqName(classId);
            }
            catch (ProcessCanceledException e) {
                return null;
            }
            firClassLikeDeclaration = firClassLikeDeclaration2;
        }
        return firClassLikeDeclaration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final FirFile getOrBuildFile(@NotNull KtFile ktFile) {
        FirFile firFile2;
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)ktFile, (String)"ktFile");
        long modificationStamp = ktFile.getModificationStamp();
        FirFileWithStamp firFileWithStamp = this.files.get(ktFile);
        if (firFileWithStamp != null) {
            FirFileWithStamp firFileWithStamp2 = firFileWithStamp;
            bl = false;
            boolean bl2 = false;
            FirFileWithStamp $dstr$firFile$stamp = firFileWithStamp2;
            boolean bl3 = false;
            FirFile firFile3 = $dstr$firFile$stamp.component1();
            long stamp = $dstr$firFile$stamp.component2();
            if (stamp == modificationStamp) {
                void firFile4;
                return firFile4;
            }
        }
        boolean bl4 = false;
        bl = false;
        synchronized (ktFile) {
            FirFile firFile5;
            boolean bl5 = false;
            FirFileWithStamp fileWithStamp = this.files.get(ktFile);
            if (fileWithStamp != null && fileWithStamp.getStamp() == modificationStamp) {
                firFile5 = fileWithStamp.getFile();
            } else {
                FirFile file2 = new RawFirBuilder(this.session, false).buildFirFile(ktFile);
                this.cacheProvider.recordFile(file2);
                fileWithStamp = new FirFileWithStamp(file2, modificationStamp);
                this.files.put(ktFile, fileWithStamp);
                firFile5 = file2;
            }
            firFile2 = firFile5;
        }
        return firFile2;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final FirFile getFile(@NotNull KtFile ktFile) {
        Intrinsics.checkParameterIsNotNull((Object)ktFile, (String)"ktFile");
        FirFileWithStamp firFileWithStamp = this.files.get(ktFile);
        if (firFileWithStamp == null) {
            return null;
        }
        FirFileWithStamp firFileWithStamp2 = firFileWithStamp;
        FirFile firFile2 = firFileWithStamp2.component1();
        long stamp = firFileWithStamp2.component2();
        if (stamp == ktFile.getModificationStamp()) {
            void firFile3;
            return firFile3;
        }
        return null;
    }

    @Override
    @Nullable
    public FirClassLikeSymbol<?> getClassLikeSymbolByFqName(@NotNull ClassId classId) {
        Intrinsics.checkParameterIsNotNull((Object)classId, (String)"classId");
        FirClassLikeDeclaration<?> firClassLikeDeclaration = this.getFirClassifierByFqName(classId);
        return firClassLikeDeclaration != null ? firClassLikeDeclaration.getSymbol() : null;
    }

    @Override
    @NotNull
    public List<FirCallableSymbol<?>> getTopLevelCallableSymbols(@NotNull FqName packageFqName, @NotNull Name name2) {
        List<FirCallableSymbol<?>> list2;
        Intrinsics.checkParameterIsNotNull((Object)packageFqName, (String)"packageFqName");
        Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
        String packagePrefix = packageFqName.isRoot() ? "" : "" + packageFqName + '.';
        try {
            KtTypeParameterListOwnerStub it;
            Collection<KtNamedFunction> collection = KotlinTopLevelFunctionFqnNameIndex.getInstance().get(packagePrefix + name2, this.project, this.scope);
            Intrinsics.checkExpressionValueIsNotNull(collection, (String)"KotlinTopLevelFunctionFq\u2026ix$name\", project, scope]");
            Collection<KtNamedFunction> topLevelFunctions = collection;
            Collection<KtProperty> collection2 = KotlinTopLevelPropertyFqnNameIndex.getInstance().get(packagePrefix + name2, this.project, this.scope);
            Intrinsics.checkExpressionValueIsNotNull(collection2, (String)"KotlinTopLevelPropertyFq\u2026ix$name\", project, scope]");
            Collection<KtProperty> topLevelProperties = collection2;
            Iterable $this$forEach$iv = topLevelFunctions;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (KtNamedFunction)element$iv;
                boolean bl = false;
                KtNamedFunction ktNamedFunction = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)ktNamedFunction, (String)"it");
                KtFile ktFile = ktNamedFunction.getContainingKtFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)ktFile, (String)"it.containingKtFile");
                this.getOrBuildFile(ktFile);
            }
            $this$forEach$iv = topLevelProperties;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (KtProperty)element$iv;
                boolean bl = false;
                KtTypeParameterListOwnerStub ktTypeParameterListOwnerStub = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)ktTypeParameterListOwnerStub, (String)"it");
                KtFile ktFile = ktTypeParameterListOwnerStub.getContainingKtFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)ktFile, (String)"it.containingKtFile");
                this.getOrBuildFile(ktFile);
            }
            list2 = this.cacheProvider.getTopLevelCallableSymbols(packageFqName, name2);
        }
        catch (ProcessCanceledException e) {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    @Override
    @NotNull
    public FirFile getFirClassifierContainerFile(@NotNull ClassId fqName2) {
        Intrinsics.checkParameterIsNotNull((Object)fqName2, (String)"fqName");
        this.getFirClassifierByFqName(fqName2);
        return this.cacheProvider.getFirClassifierContainerFile(fqName2);
    }

    @Override
    @Nullable
    public FirFile getFirClassifierContainerFileIfAny(@NotNull ClassId fqName2) {
        Intrinsics.checkParameterIsNotNull((Object)fqName2, (String)"fqName");
        this.getFirClassifierByFqName(fqName2);
        return this.cacheProvider.getFirClassifierContainerFileIfAny(fqName2);
    }

    @Override
    @NotNull
    public FirFile getFirClassifierContainerFile(@NotNull FirClassLikeSymbol<?> symbol2) {
        Intrinsics.checkParameterIsNotNull(symbol2, (String)"symbol");
        FirFile firFile2 = this.getFirClassifierContainerFileIfAny(symbol2);
        if (firFile2 == null) {
            String string = "Couldn't find container for " + symbol2.getClassId();
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return firFile2;
    }

    @Override
    @Nullable
    public FirFile getFirClassifierContainerFileIfAny(@NotNull FirClassLikeSymbol<?> symbol2) {
        PsiElement psi2;
        Intrinsics.checkParameterIsNotNull(symbol2, (String)"symbol");
        FirSourceElement firSourceElement = ((FirClassLikeDeclaration)symbol2.getFir()).getSource();
        Object object = psi2 = firSourceElement != null ? FirSourceElementKt.getPsi(firSourceElement) : null;
        if (psi2 instanceof KtElement) {
            FirFile firFile2;
            try {
                KtFile ktFile = ((KtElement)psi2).getContainingKtFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)ktFile, (String)"psi.containingKtFile");
                KtFile ktFile2 = ktFile;
                firFile2 = this.getOrBuildFile(ktFile2);
            }
            catch (ProcessCanceledException e) {
                firFile2 = null;
            }
            return firFile2;
        }
        return this.getFirClassifierContainerFileIfAny(symbol2.getClassId());
    }

    @Override
    @Nullable
    public FirFile getFirCallableContainerFile(@NotNull FirCallableSymbol<?> symbol2) {
        Intrinsics.checkParameterIsNotNull(symbol2, (String)"symbol");
        return this.cacheProvider.getFirCallableContainerFile(symbol2);
    }

    @Override
    @NotNull
    public List<FirFile> getFirFilesByPackage(@NotNull FqName fqName2) {
        List<FirFile> list2;
        Intrinsics.checkParameterIsNotNull((Object)fqName2, (String)"fqName");
        try {
            Collection<KtFile> collection = KotlinExactPackagesIndex.getInstance().get(fqName2.asString(), this.project, this.scope);
            Intrinsics.checkExpressionValueIsNotNull(collection, (String)"KotlinExactPackagesIndex\u2026String(), project, scope]");
            Collection<KtFile> files2 = collection;
            Iterable $this$forEach$iv = files2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                KtFile it = (KtFile)element$iv;
                boolean bl = false;
                KtFile ktFile = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)ktFile, (String)"it");
                this.getOrBuildFile(ktFile);
            }
            list2 = this.cacheProvider.getFirFilesByPackage(fqName2);
        }
        catch (ProcessCanceledException e) {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    @Override
    @Nullable
    public FirScope getNestedClassifierScope(@NotNull ClassId classId) {
        Intrinsics.checkParameterIsNotNull((Object)classId, (String)"classId");
        this.getFirClassifierByFqName(classId);
        return this.cacheProvider.getNestedClassifierScope(classId);
    }

    @Override
    @Nullable
    public FirScope getClassUseSiteMemberScope(@NotNull ClassId classId, @NotNull FirSession useSiteSession, @NotNull ScopeSession scopeSession) {
        Intrinsics.checkParameterIsNotNull((Object)classId, (String)"classId");
        Intrinsics.checkParameterIsNotNull((Object)useSiteSession, (String)"useSiteSession");
        Intrinsics.checkParameterIsNotNull((Object)scopeSession, (String)"scopeSession");
        this.getFirClassifierByFqName(classId);
        return this.cacheProvider.getClassUseSiteMemberScope(classId, useSiteSession, scopeSession);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final GlobalSearchScope getScope() {
        return this.scope;
    }

    @NotNull
    public final FirSession getSession() {
        return this.session;
    }

    public IdeFirProvider(@NotNull Project project2, @NotNull GlobalSearchScope scope2, @NotNull FirSession session2) {
        Map map2;
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)scope2, (String)"scope");
        Intrinsics.checkParameterIsNotNull((Object)session2, (String)"session");
        this.project = project2;
        this.scope = scope2;
        this.session = session2;
        this.cacheProvider = new FirProviderImpl(this.session);
        IdeFirProvider ideFirProvider = this;
        boolean bl = false;
        ideFirProvider.files = map2 = (Map)new LinkedHashMap();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/fir/IdeFirProvider$FirFileWithStamp;", "", "file", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "stamp", "", "(Lorg/jetbrains/kotlin/fir/declarations/FirFile;J)V", "getFile", "()Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "getStamp", "()J", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "idea-core"})
    public static final class FirFileWithStamp {
        @NotNull
        private final FirFile file;
        private final long stamp;

        @NotNull
        public final FirFile getFile() {
            return this.file;
        }

        public final long getStamp() {
            return this.stamp;
        }

        public FirFileWithStamp(@NotNull FirFile file2, long stamp) {
            Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
            this.file = file2;
            this.stamp = stamp;
        }

        @NotNull
        public final FirFile component1() {
            return this.file;
        }

        public final long component2() {
            return this.stamp;
        }

        @NotNull
        public final FirFileWithStamp copy(@NotNull FirFile file2, long stamp) {
            Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
            return new FirFileWithStamp(file2, stamp);
        }

        public static /* synthetic */ FirFileWithStamp copy$default(FirFileWithStamp firFileWithStamp, FirFile firFile2, long l, int n, Object object) {
            if ((n & 1) != 0) {
                firFile2 = firFileWithStamp.file;
            }
            if ((n & 2) != 0) {
                l = firFileWithStamp.stamp;
            }
            return firFileWithStamp.copy(firFile2, l);
        }

        @NotNull
        public String toString() {
            return "FirFileWithStamp(file=" + this.file + ", stamp=" + this.stamp + ")";
        }

        public int hashCode() {
            FirFile firFile2 = this.file;
            return (firFile2 != null ? firFile2.hashCode() : 0) * 31 + Long.hashCode(this.stamp);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof FirFileWithStamp)) break block3;
                    FirFileWithStamp firFileWithStamp = (FirFileWithStamp)object;
                    if (!Intrinsics.areEqual((Object)this.file, (Object)firFileWithStamp.file) || this.stamp != firFileWithStamp.stamp) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

