/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.formatter;

import com.intellij.formatting.ASTBlock;
import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.TokenType;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.idea.core.formatter.KotlinCodeStyleSettings;
import org.jetbrains.kotlin.idea.formatter.CommonAlignmentStrategy;
import org.jetbrains.kotlin.idea.formatter.KotlinCommonBlock;
import org.jetbrains.kotlin.idea.formatter.KotlinCommonBlockKt;
import org.jetbrains.kotlin.idea.formatter.KotlinCommonCodeStyleSettings;
import org.jetbrains.kotlin.idea.formatter.KotlinSpacingBuilder;
import org.jetbrains.kotlin.idea.formatter.KtCodeStyleSettingsKt;
import org.jetbrains.kotlin.idea.formatter.NodeIndentStrategy;
import org.jetbrains.kotlin.idea.formatter.SyntheticKotlinBlock;
import org.jetbrains.kotlin.idea.util.FormatterUtilKt;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0011\b&\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0010\b\u0002\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fJ\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u000eJS\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\t2'\u0010\u0018\u001a#\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001c\u0012\u0006\u0012\u0004\u0018\u00010\u001d0\u0019j\u0002`\u001e2\u0010\b\u0002\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u000bH\u0002J\u000e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002JG\u0010 \u001a\b\u0012\u0004\u0012\u00020\u000f0\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010!\u001a\u00020\t2'\u0010\u0018\u001a#\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001c\u0012\u0006\u0012\u0004\u0018\u00010\u001d0\u0019j\u0002`\u001eH\u0002J\u001e\u0010\"\u001a\u00020#2\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00030%H\u0002J\u001a\u0010&\u001a\u00020\t2\u0006\u0010'\u001a\u00020\u00112\b\u0010(\u001a\u0004\u0018\u00010)H$JN\u0010*\u001a\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\t2\b\u0010+\u001a\u0004\u0018\u00010,2\b\u0010-\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0010\b\u0002\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u000bH$J\u0012\u0010.\u001a\u0004\u0018\u00010,2\u0006\u0010\u0017\u001a\u00020\u0003H\u0002J\u0010\u0010/\u001a\u00020,2\u0006\u00100\u001a\u00020\u0011H\u0002J\u0010\u00101\u001a\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\u0003H$J\u0012\u00102\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\n\u00103\u001a\u0004\u0018\u00010)H$J\u0010\u00104\u001a\u00020\t2\u0006\u00105\u001a\u00020\u0011H$J\u000e\u00106\u001a\u0002072\u0006\u00108\u001a\u000209J\b\u0010:\u001a\u00020\tH\u0002J\b\u0010;\u001a\u00020\tH$J\u000e\u0010<\u001a\b\u0012\u0004\u0012\u00020\u00150\u000eH$J\u0010\u0010=\u001a\u0002072\u0006\u00108\u001a\u000209H$J\u0006\u0010>\u001a\u00020?J)\u0010@\u001a#\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001c\u0012\u0006\u0012\u0004\u0018\u00010\u001d0\u0019j\u0002`\u001eH\u0002J\u0010\u0010A\u001a\u00020\u00112\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0006\u0010B\u001a\u00020\u0011J\b\u0010C\u001a\u00020\u0011H$J\u0006\u0010D\u001a\u00020\u0011J\u001c\u0010E\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\f\u0010F\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J\u001c\u0010G\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\f\u0010F\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J\u001e\u0010H\u001a\u00020\u000f*\u00020\u000f2\b\u0010-\u001a\u0004\u0018\u00010\u001d2\u0006\u00100\u001a\u00020\u0011H\u0002J*\u0010I\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e*\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010J\u001a\u00020\u000f2\b\b\u0002\u0010K\u001a\u000209H\u0002JL\u0010L\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e*\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010K\u001a\u0002092\b\u0010+\u001a\u0004\u0018\u00010,2\b\u0010-\u001a\u0004\u0018\u00010\u001d2\n\b\u0002\u0010M\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010N\u001a\u0004\u0018\u00010\u000fH\u0002J&\u0010O\u001a\u00020\u000f*\b\u0012\u0004\u0012\u00020\u000f0\u000e2\b\u0010M\u001a\u0004\u0018\u00010\u00032\b\u0010N\u001a\u0004\u0018\u00010\u000fH\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0010\u001a\u00020\u0011*\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006P"}, d2={"Lorg/jetbrains/kotlin/idea/formatter/KotlinCommonBlock;", "", "node", "Lcom/intellij/lang/ASTNode;", "settings", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "spacingBuilder", "Lorg/jetbrains/kotlin/idea/formatter/KotlinSpacingBuilder;", "alignmentStrategy", "Lorg/jetbrains/kotlin/idea/formatter/CommonAlignmentStrategy;", "overrideChildren", "Lkotlin/sequences/Sequence;", "(Lcom/intellij/lang/ASTNode;Lcom/intellij/psi/codeStyle/CodeStyleSettings;Lorg/jetbrains/kotlin/idea/formatter/KotlinSpacingBuilder;Lorg/jetbrains/kotlin/idea/formatter/CommonAlignmentStrategy;Lkotlin/sequences/Sequence;)V", "mySubBlocks", "", "Lcom/intellij/formatting/ASTBlock;", "wrapForFirstCallInChainIsAllowed", "", "getWrapForFirstCallInChainIsAllowed", "(Lcom/intellij/lang/ASTNode;)Z", "buildChildren", "Lcom/intellij/formatting/Block;", "buildSubBlock", "child", "wrappingStrategy", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "childElement", "Lcom/intellij/formatting/Wrap;", "Lorg/jetbrains/kotlin/idea/formatter/WrappingStrategy;", "buildSubBlocks", "buildSubBlocksForChildNode", "childrenAlignmentStrategy", "collectBinaryExpressionChildren", "", "result", "", "createAlignmentStrategy", "alignOption", "defaultAlignment", "Lcom/intellij/formatting/Alignment;", "createBlock", "indent", "Lcom/intellij/formatting/Indent;", "wrap", "createChildIndent", "createIndentForQualifierExpression", "enforceIndentToChildren", "createSyntheticSpacingNodeBlock", "createWrapForQualifierExpression", "getAlignment", "getAlignmentForCaseBranch", "shouldAlignInColumns", "getChildAttributes", "Lcom/intellij/formatting/ChildAttributes;", "newChildIndex", "", "getChildrenAlignmentStrategy", "getNullAlignmentStrategy", "getSubBlocks", "getSuperChildAttributes", "getTextRange", "Lcom/intellij/openapi/util/TextRange;", "getWrappingStrategy", "isInCodeChunk", "isIncomplete", "isIncompleteInSuper", "isLeaf", "splitSubBlocksOnDot", "nodeSubBlocks", "splitSubBlocksOnElvis", "processBlock", "replaceBlock", "block", "index", "splitAtIndex", "anchor", "parentBlock", "wrapToBlock", "formatter"})
public abstract class KotlinCommonBlock {
    private volatile List<? extends ASTBlock> mySubBlocks;
    private final ASTNode node;
    private final CodeStyleSettings settings;
    private final KotlinSpacingBuilder spacingBuilder;
    private final CommonAlignmentStrategy alignmentStrategy;
    private final Sequence<ASTNode> overrideChildren;

    @NotNull
    public final TextRange getTextRange() {
        if (this.overrideChildren != null) {
            int n = ((ASTNode)SequencesKt.first(this.overrideChildren)).getStartOffset();
            TextRange textRange = ((ASTNode)SequencesKt.last(this.overrideChildren)).getTextRange();
            Intrinsics.checkExpressionValueIsNotNull((Object)textRange, (String)"overrideChildren.last().textRange");
            return new TextRange(n, textRange.getEndOffset());
        }
        TextRange textRange = this.node.getTextRange();
        Intrinsics.checkExpressionValueIsNotNull((Object)textRange, (String)"node.textRange");
        return textRange;
    }

    @NotNull
    protected abstract ASTBlock createBlock(@NotNull ASTNode var1, @NotNull CommonAlignmentStrategy var2, @Nullable Indent var3, @Nullable Wrap var4, @NotNull CodeStyleSettings var5, @NotNull KotlinSpacingBuilder var6, @Nullable Sequence<? extends ASTNode> var7);

    public static /* synthetic */ ASTBlock createBlock$default(KotlinCommonBlock kotlinCommonBlock, ASTNode aSTNode, CommonAlignmentStrategy commonAlignmentStrategy, Indent indent, Wrap wrap2, CodeStyleSettings codeStyleSettings, KotlinSpacingBuilder kotlinSpacingBuilder, Sequence sequence2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createBlock");
        }
        if ((n & 0x40) != 0) {
            sequence2 = null;
        }
        return kotlinCommonBlock.createBlock(aSTNode, commonAlignmentStrategy, indent, wrap2, codeStyleSettings, kotlinSpacingBuilder, (Sequence<? extends ASTNode>)sequence2);
    }

    @NotNull
    protected abstract ASTBlock createSyntheticSpacingNodeBlock(@NotNull ASTNode var1);

    @NotNull
    protected abstract List<Block> getSubBlocks();

    @NotNull
    protected abstract ChildAttributes getSuperChildAttributes(int var1);

    protected abstract boolean isIncompleteInSuper();

    @NotNull
    protected abstract CommonAlignmentStrategy getAlignmentForCaseBranch(boolean var1);

    @Nullable
    protected abstract Alignment getAlignment();

    @NotNull
    protected abstract CommonAlignmentStrategy createAlignmentStrategy(boolean var1, @Nullable Alignment var2);

    @NotNull
    protected abstract CommonAlignmentStrategy getNullAlignmentStrategy();

    public final boolean isLeaf() {
        return this.node.getFirstChildNode() == null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isIncomplete() {
        if (this.isIncompleteInSuper()) {
            return true;
        }
        if (!Intrinsics.areEqual((Object)this.node.getElementType(), (Object)KtNodeTypes.MODIFIER_LIST)) return false;
        ASTNode aSTNode = this.node.getTreeParent();
        if (!Intrinsics.areEqual((Object)(aSTNode != null ? aSTNode.getElementType() : null), (Object)KtNodeTypes.CLASS_BODY)) return false;
        return true;
    }

    @NotNull
    public final List<Block> buildChildren() {
        if (this.mySubBlocks != null) {
            List<? extends ASTBlock> list2 = this.mySubBlocks;
            if (list2 == null) {
                Intrinsics.throwNpe();
            }
            return list2;
        }
        List<ASTBlock> nodeSubBlocks = this.buildSubBlocks();
        if (KotlinCommonBlockKt.access$getQUALIFIED_EXPRESSIONS$p().contains(this.node.getElementType())) {
            nodeSubBlocks = this.splitSubBlocksOnDot(nodeSubBlocks);
        } else {
            PsiElement psi2 = this.node.getPsi();
            if (psi2 instanceof KtBinaryExpression && Intrinsics.areEqual((Object)((KtBinaryExpression)psi2).getOperationToken(), (Object)((Object)KtTokens.ELVIS))) {
                nodeSubBlocks = this.splitSubBlocksOnElvis(nodeSubBlocks);
            }
        }
        this.mySubBlocks = nodeSubBlocks;
        return nodeSubBlocks;
    }

    private final List<ASTBlock> splitSubBlocksOnDot(List<? extends ASTBlock> nodeSubBlocks) {
        block5: {
            block4: {
                ASTNode aSTNode = this.node.getTreeParent();
                if (aSTNode != null && KotlinCommonBlockKt.access$isQualifier$p(aSTNode)) break block4;
                if (!KotlinCommonBlockKt.access$isCallChainWithoutWrap$p(this.node)) break block5;
            }
            return nodeSubBlocks;
        }
        int operationBlockIndex = KotlinCommonBlockKt.access$indexOfBlockWithType(nodeSubBlocks, KotlinCommonBlockKt.access$getQUALIFIED_OPERATION$p());
        if (operationBlockIndex == -1) {
            return nodeSubBlocks;
        }
        ASTBlock block2 = (ASTBlock)CollectionsKt.first(nodeSubBlocks);
        Wrap wrap2 = this.createWrapForQualifierExpression(this.node);
        boolean enforceIndentToChildren = KotlinCommonBlockKt.access$anyCallInCallChainIsWrapped(this.node);
        Indent indent = this.createIndentForQualifierExpression(enforceIndentToChildren);
        ASTBlock newBlock = this.processBlock(block2, wrap2, enforceIndentToChildren);
        return KotlinCommonBlock.splitAtIndex$default(this, this.replaceBlock(nodeSubBlocks, newBlock, 0), operationBlockIndex, indent, wrap2, null, null, 24, null);
    }

    private final ASTBlock processBlock(@NotNull ASTBlock $this$processBlock, Wrap wrap2, boolean enforceIndentToChildren) {
        Wrap wrap3;
        ASTNode currentNode = FormatterUtilKt.requireNode($this$processBlock);
        boolean enforceIndent = enforceIndentToChildren && KotlinCommonBlockKt.access$anyCallInCallChainIsWrapped(currentNode);
        Indent indent = this.createIndentForQualifierExpression(enforceIndent);
        List list2 = $this$processBlock.getSubBlocks();
        if (list2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.List<com.intellij.formatting.ASTBlock>");
        }
        List subBlocks = list2;
        IElementType iElementType = currentNode.getElementType();
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType, (String)"currentNode.elementType");
        IElementType elementType = iElementType;
        if (Intrinsics.areEqual((Object)elementType, (Object)KtNodeTypes.POSTFIX_EXPRESSION) ^ true && !KotlinCommonBlockKt.access$getQUALIFIED_EXPRESSIONS$p().contains(elementType)) {
            return $this$processBlock;
        }
        int index2 = 0;
        if (this.getWrapForFirstCallInChainIsAllowed(currentNode)) {
            wrap3 = wrap2;
            if (wrap3 == null) {
                wrap3 = this.createWrapForQualifierExpression(currentNode);
            }
        } else {
            wrap3 = null;
        }
        Wrap resultWrap = wrap3;
        List list3 = subBlocks;
        KotlinCommonBlock kotlinCommonBlock = this;
        boolean bl = false;
        Object object = list3.get(index2);
        ASTBlock newBlock = kotlinCommonBlock.processBlock((ASTBlock)object, resultWrap, enforceIndent);
        list3 = this.replaceBlock(subBlocks, newBlock, index2);
        kotlinCommonBlock = this;
        bl = false;
        boolean bl2 = false;
        List it = list3;
        boolean bl3 = false;
        int operationIndex = KotlinCommonBlockKt.access$indexOfBlockWithType(subBlocks, KotlinCommonBlockKt.access$getQUALIFIED_OPERATION$p());
        object = operationIndex != -1 ? KotlinCommonBlock.splitAtIndex$default(this, it, operationIndex, indent, resultWrap, null, null, 24, null) : it;
        return kotlinCommonBlock.wrapToBlock((List<? extends ASTBlock>)object, currentNode, $this$processBlock);
    }

    private final List<ASTBlock> replaceBlock(@NotNull List<? extends ASTBlock> $this$replaceBlock, ASTBlock block2, int index2) {
        List list2 = CollectionsKt.toMutableList((Collection)$this$replaceBlock);
        boolean bl = false;
        boolean bl2 = false;
        List $this$apply = list2;
        boolean bl3 = false;
        $this$apply.set(index2, block2);
        return list2;
    }

    static /* synthetic */ List replaceBlock$default(KotlinCommonBlock kotlinCommonBlock, List list2, ASTBlock aSTBlock, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: replaceBlock");
        }
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return kotlinCommonBlock.replaceBlock(list2, aSTBlock, n);
    }

    private final boolean getWrapForFirstCallInChainIsAllowed(@NotNull ASTNode $this$wrapForFirstCallInChainIsAllowed) {
        ASTNode aSTNode = KotlinCommonBlockKt.access$unwrapQualifier($this$wrapForFirstCallInChainIsAllowed);
        if (aSTNode == null || !KotlinCommonBlockKt.access$isCall$p(aSTNode)) {
            return false;
        }
        return KtCodeStyleSettingsKt.getKotlinCommonSettings((CodeStyleSettings)this.settings).WRAP_FIRST_METHOD_IN_CALL_CHAIN || KotlinCommonBlockKt.access$receiverIsCall($this$wrapForFirstCallInChainIsAllowed);
    }

    private final Wrap createWrapForQualifierExpression(ASTNode node2) {
        return this.getWrapForFirstCallInChainIsAllowed(node2) && KotlinCommonBlockKt.access$receiverIsCall(node2) ? Wrap.createWrap((int)KtCodeStyleSettingsKt.getKotlinCommonSettings((CodeStyleSettings)this.settings).METHOD_CALL_CHAIN_WRAP, (boolean)true) : null;
    }

    private final Indent createIndentForQualifierExpression(boolean enforceIndentToChildren) {
        Indent.Type indentType = KtCodeStyleSettingsKt.getKotlinCustomSettings((CodeStyleSettings)this.settings).CONTINUATION_INDENT_FOR_CHAINED_CALLS ? (enforceIndentToChildren ? Indent.Type.CONTINUATION : Indent.Type.CONTINUATION_WITHOUT_FIRST) : Indent.Type.NORMAL;
        Indent indent = Indent.getIndent((Indent.Type)indentType, (boolean)false, (boolean)enforceIndentToChildren);
        Intrinsics.checkExpressionValueIsNotNull((Object)indent, (String)"Indent.getIndent(\n      \u2026ndentToChildren\n        )");
        return indent;
    }

    private final ASTBlock wrapToBlock(@NotNull List<? extends ASTBlock> $this$wrapToBlock, ASTNode anchor2, ASTBlock parentBlock) {
        return (ASTBlock)CollectionsKt.single(this.splitAtIndex($this$wrapToBlock, 0, null, null, anchor2, parentBlock));
    }

    private final List<ASTBlock> splitAtIndex(@NotNull List<? extends ASTBlock> $this$splitAtIndex, int index2, Indent indent, Wrap wrap2, ASTNode anchor2, ASTBlock parentBlock) {
        ASTBlock operationBlock = $this$splitAtIndex.get(index2);
        Function1 createParentSyntheticSpacingBlock2 = parentBlock != null ? (Function1)new Function1<ASTNode, ASTBlock>(parentBlock){
            final /* synthetic */ ASTBlock $parentBlock;

            @NotNull
            public final ASTBlock invoke(@NotNull ASTNode it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return this.$parentBlock;
            }
            {
                this.$parentBlock = aSTBlock;
                super(1);
            }
        } : (Function1)new Function1<ASTNode, ASTBlock>(this){
            final /* synthetic */ KotlinCommonBlock this$0;

            @NotNull
            public final ASTBlock invoke(@NotNull ASTNode it) {
                ASTNode aSTNode;
                ASTNode parent2;
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                ASTNode aSTNode2 = it.getTreeParent();
                if (aSTNode2 == null) {
                    aSTNode2 = parent2 = KotlinCommonBlock.access$getNode$p(this.this$0);
                }
                if (parent2.getElementType() == KtNodeTypes.OPERATION_REFERENCE) {
                    aSTNode = parent2.getTreeParent();
                    if (aSTNode == null) {
                        aSTNode = parent2;
                    }
                } else {
                    aSTNode = parent2;
                }
                ASTNode skipOperationNodeParent = aSTNode;
                return this.this$0.createSyntheticSpacingNodeBlock(skipOperationNodeParent);
            }
            {
                this.this$0 = kotlinCommonBlock;
                super(1);
            }
        };
        ASTNode aSTNode = anchor2;
        if (aSTNode == null) {
            aSTNode = FormatterUtilKt.requireNode(operationBlock);
        }
        SyntheticKotlinBlock operationSyntheticBlock = new SyntheticKotlinBlock(aSTNode, $this$splitAtIndex.subList(index2, $this$splitAtIndex.size()), null, indent, wrap2, this.spacingBuilder, (Function1<? super ASTNode, ? extends ASTBlock>)createParentSyntheticSpacingBlock2);
        return CollectionsKt.plus((Collection)$this$splitAtIndex.subList(0, index2), (Object)operationSyntheticBlock);
    }

    static /* synthetic */ List splitAtIndex$default(KotlinCommonBlock kotlinCommonBlock, List list2, int n, Indent indent, Wrap wrap2, ASTNode aSTNode, ASTBlock aSTBlock, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: splitAtIndex");
        }
        if ((n2 & 8) != 0) {
            aSTNode = null;
        }
        if ((n2 & 0x10) != 0) {
            aSTBlock = null;
        }
        return kotlinCommonBlock.splitAtIndex(list2, n, indent, wrap2, aSTNode, aSTBlock);
    }

    private final List<ASTBlock> splitSubBlocksOnElvis(List<? extends ASTBlock> nodeSubBlocks) {
        int elvisIndex = KotlinCommonBlockKt.access$indexOfBlockWithType(nodeSubBlocks, KotlinCommonBlockKt.access$getELVIS_SET$p());
        if (elvisIndex >= 0) {
            Indent indent = KtCodeStyleSettingsKt.getKotlinCustomSettings((CodeStyleSettings)this.settings).CONTINUATION_INDENT_IN_ELVIS ? Indent.getContinuationIndent() : Indent.getNormalIndent();
            return KotlinCommonBlock.splitAtIndex$default(this, nodeSubBlocks, elvisIndex, indent, null, null, null, 24, null);
        }
        return nodeSubBlocks;
    }

    private final Indent createChildIndent(ASTNode child) {
        ASTNode prev2;
        ASTNode childParent = child.getTreeParent();
        IElementType iElementType = child.getElementType();
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType, (String)"child.elementType");
        IElementType childType = iElementType;
        if (childParent != null && this.isInCodeChunk(childParent)) {
            return Indent.getNoneIndent();
        }
        if (childParent != null && childParent.getPsi() instanceof KtDeclaration && (prev2 = KotlinCommonBlockKt.access$getPrevWithoutWhitespace(child)) != null && KtTokens.COMMENTS.contains(prev2.getElementType()) && KotlinCommonBlockKt.getSiblingWithoutWhitespaceAndComments$default(prev2, false, 2, null) == null) {
            return Indent.getNoneIndent();
        }
        for (NodeIndentStrategy strategy : KotlinCommonBlockKt.access$getINDENT_RULES$p()) {
            Indent indent = strategy.getIndent(child, this.settings);
            if (indent == null) continue;
            return indent;
        }
        if (childParent != null) {
            IElementType iElementType2 = childParent.getElementType();
            Intrinsics.checkExpressionValueIsNotNull((Object)iElementType2, (String)"childParent.elementType");
            IElementType parentType = iElementType2;
            if (parentType == KtNodeTypes.VALUE_PARAMETER_LIST || parentType == KtNodeTypes.VALUE_ARGUMENT_LIST) {
                ASTNode prev3 = KotlinCommonBlockKt.access$getPrevWithoutWhitespace(child);
                if (!(childType != KtTokens.RPAR || prev3 != null && prev3.getElementType() == KtTokens.COMMA && KotlinCommonBlockKt.access$hasDoubleLineBreakBefore(child))) {
                    return Indent.getNoneIndent();
                }
                return KtCodeStyleSettingsKt.getKotlinCustomSettings((CodeStyleSettings)this.settings).CONTINUATION_INDENT_IN_ARGUMENT_LISTS ? Indent.getContinuationWithoutFirstIndent() : Indent.getNormalIndent();
            }
            if (parentType == KtNodeTypes.TYPE_PARAMETER_LIST || parentType == KtNodeTypes.TYPE_ARGUMENT_LIST) {
                return Indent.getContinuationWithoutFirstIndent();
            }
        }
        return Indent.getNoneIndent();
    }

    private final boolean isInCodeChunk(ASTNode node2) {
        ASTNode aSTNode = node2.getTreeParent();
        if (aSTNode == null) {
            return false;
        }
        ASTNode parent2 = aSTNode;
        if (Intrinsics.areEqual((Object)node2.getElementType(), (Object)KtNodeTypes.BLOCK) ^ true) {
            return false;
        }
        IElementType iElementType = parent2.getElementType();
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType, (String)"parent.elementType");
        IElementType parentType = iElementType;
        return Intrinsics.areEqual((Object)parentType, (Object)KtNodeTypes.SCRIPT) || Intrinsics.areEqual((Object)parentType, (Object)KtNodeTypes.BLOCK_CODE_FRAGMENT) || Intrinsics.areEqual((Object)parentType, (Object)KtNodeTypes.EXPRESSION_CODE_FRAGMENT) || Intrinsics.areEqual((Object)parentType, (Object)KtNodeTypes.TYPE_CODE_FRAGMENT);
    }

    @NotNull
    public final ChildAttributes getChildAttributes(int newChildIndex) {
        ChildAttributes childAttributes;
        IElementType iElementType = this.node.getElementType();
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType, (String)"node.elementType");
        IElementType type2 = iElementType;
        if (this.isInCodeChunk(this.node)) {
            return new ChildAttributes(Indent.getNoneIndent(), null);
        }
        if (Intrinsics.areEqual((Object)type2, (Object)KtNodeTypes.IF)) {
            ASTBlock elseBlock;
            List<? extends ASTBlock> list2 = this.mySubBlocks;
            ASTBlock aSTBlock = elseBlock = list2 != null ? (ASTBlock)CollectionsKt.getOrNull(list2, (int)newChildIndex) : null;
            if (elseBlock != null && Intrinsics.areEqual((Object)FormatterUtilKt.requireNode(elseBlock).getElementType(), (Object)((Object)KtTokens.ELSE_KEYWORD))) {
                ChildAttributes childAttributes2 = ChildAttributes.DELEGATE_TO_NEXT_CHILD;
                Intrinsics.checkExpressionValueIsNotNull((Object)childAttributes2, (String)"ChildAttributes.DELEGATE_TO_NEXT_CHILD");
                return childAttributes2;
            }
        }
        if (newChildIndex > 0) {
            List<? extends ASTBlock> list3 = this.mySubBlocks;
            ASTBlock prevBlock = list3 != null ? list3.get(newChildIndex - 1) : null;
            ASTBlock aSTBlock = prevBlock;
            if (Intrinsics.areEqual((Object)(aSTBlock != null && (aSTBlock = aSTBlock.getNode()) != null ? aSTBlock.getElementType() : null), (Object)KtNodeTypes.MODIFIER_LIST)) {
                return new ChildAttributes(Indent.getNoneIndent(), null);
            }
        }
        IElementType iElementType2 = type2;
        if (KotlinCommonBlockKt.access$getCODE_BLOCKS$p().contains(iElementType2) || Intrinsics.areEqual((Object)iElementType2, (Object)KtNodeTypes.WHEN) || Intrinsics.areEqual((Object)iElementType2, (Object)KtNodeTypes.IF) || Intrinsics.areEqual((Object)iElementType2, (Object)KtNodeTypes.FOR) || Intrinsics.areEqual((Object)iElementType2, (Object)KtNodeTypes.WHILE) || Intrinsics.areEqual((Object)iElementType2, (Object)KtNodeTypes.DO_WHILE) || Intrinsics.areEqual((Object)iElementType2, (Object)KtNodeTypes.WHEN_ENTRY)) {
            childAttributes = new ChildAttributes(Indent.getNormalIndent(), null);
        } else if (Intrinsics.areEqual((Object)iElementType2, (Object)KtNodeTypes.TRY)) {
            childAttributes = new ChildAttributes(Indent.getNoneIndent(), null);
        } else if (KotlinCommonBlockKt.access$getQUALIFIED_EXPRESSIONS$p().contains(iElementType2)) {
            childAttributes = new ChildAttributes(Indent.getContinuationWithoutFirstIndent(), null);
        } else if (Intrinsics.areEqual((Object)iElementType2, (Object)KtNodeTypes.VALUE_PARAMETER_LIST) || Intrinsics.areEqual((Object)iElementType2, (Object)KtNodeTypes.VALUE_ARGUMENT_LIST)) {
            List<Block> subBlocks = this.getSubBlocks();
            if (newChildIndex != 1 && newChildIndex != 0 && newChildIndex < subBlocks.size()) {
                Block block2 = subBlocks.get(newChildIndex);
                childAttributes = new ChildAttributes(block2.getIndent(), block2.getAlignment());
            } else {
                Indent indent = Intrinsics.areEqual((Object)type2, (Object)KtNodeTypes.VALUE_PARAMETER_LIST) && !KtCodeStyleSettingsKt.getKotlinCustomSettings((CodeStyleSettings)this.settings).CONTINUATION_INDENT_IN_PARAMETER_LISTS || Intrinsics.areEqual((Object)type2, (Object)KtNodeTypes.VALUE_ARGUMENT_LIST) && !KtCodeStyleSettingsKt.getKotlinCustomSettings((CodeStyleSettings)this.settings).CONTINUATION_INDENT_IN_ARGUMENT_LISTS ? Indent.getNormalIndent() : Indent.getContinuationIndent();
                childAttributes = new ChildAttributes(indent, null);
            }
        } else if (Intrinsics.areEqual((Object)iElementType2, (Object)KtTokens.DOC_COMMENT)) {
            childAttributes = new ChildAttributes(Indent.getSpaceIndent((int)1), null);
        } else if (Intrinsics.areEqual((Object)iElementType2, (Object)KtNodeTypes.PARENTHESIZED)) {
            childAttributes = this.getSuperChildAttributes(newChildIndex);
        } else {
            List<Block> blocks2 = this.getSubBlocks();
            if (newChildIndex != 0) {
                boolean isIncomplete;
                boolean bl = isIncomplete = newChildIndex < blocks2.size() ? blocks2.get(newChildIndex - 1).isIncomplete() : this.isIncompleteInSuper();
                if (isIncomplete) {
                    Block lastInParent;
                    if (blocks2.size() == newChildIndex && !KtCodeStyleSettingsKt.getKotlinCustomSettings((CodeStyleSettings)this.settings).CONTINUATION_INDENT_FOR_EXPRESSION_BODIES && (lastInParent = (Block)CollectionsKt.last(blocks2)) instanceof ASTBlock) {
                        ASTNode aSTNode = ((ASTBlock)lastInParent).getNode();
                        if (KtTokens.ALL_ASSIGNMENTS.contains((IElementType)(aSTNode != null ? aSTNode.getElementType() : null))) {
                            return new ChildAttributes(Indent.getNormalIndent(), null);
                        }
                    }
                    return this.getSuperChildAttributes(newChildIndex);
                }
            }
            if (blocks2.size() > newChildIndex) {
                Block block3 = blocks2.get(newChildIndex);
                return new ChildAttributes(block3.getIndent(), block3.getAlignment());
            }
            childAttributes = new ChildAttributes(Indent.getNoneIndent(), null);
        }
        return childAttributes;
    }

    private final CommonAlignmentStrategy getChildrenAlignmentStrategy() {
        CommonAlignmentStrategy commonAlignmentStrategy;
        KotlinCommonCodeStyleSettings kotlinCommonSettings = KtCodeStyleSettingsKt.getKotlinCommonSettings(this.settings);
        KotlinCodeStyleSettings kotlinCustomSettings = KtCodeStyleSettingsKt.getKotlinCustomSettings(this.settings);
        IElementType iElementType = this.node.getElementType();
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType, (String)"node.elementType");
        IElementType parentType = iElementType;
        if (parentType == KtNodeTypes.VALUE_PARAMETER_LIST) {
            boolean bl = kotlinCommonSettings.ALIGN_MULTILINE_PARAMETERS;
            IElementType iElementType2 = KtNodeTypes.VALUE_PARAMETER;
            Intrinsics.checkExpressionValueIsNotNull((Object)iElementType2, (String)"VALUE_PARAMETER");
            KtSingleValueToken ktSingleValueToken = KtTokens.COMMA;
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktSingleValueToken), (String)"COMMA");
            IElementType iElementType3 = ktSingleValueToken;
            boolean bl2 = kotlinCommonSettings.ALIGN_MULTILINE_METHOD_BRACKETS;
            KtSingleValueToken ktSingleValueToken2 = KtTokens.LPAR;
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktSingleValueToken2), (String)"LPAR");
            IElementType iElementType4 = ktSingleValueToken2;
            KtSingleValueToken ktSingleValueToken3 = KtTokens.RPAR;
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktSingleValueToken3), (String)"RPAR");
            commonAlignmentStrategy = KotlinCommonBlockKt.access$getAlignmentForChildInParenthesis(bl, iElementType2, iElementType3, bl2, iElementType4, ktSingleValueToken3);
        } else if (parentType == KtNodeTypes.VALUE_ARGUMENT_LIST) {
            boolean bl = kotlinCommonSettings.ALIGN_MULTILINE_PARAMETERS_IN_CALLS;
            IElementType iElementType5 = KtNodeTypes.VALUE_ARGUMENT;
            Intrinsics.checkExpressionValueIsNotNull((Object)iElementType5, (String)"VALUE_ARGUMENT");
            KtSingleValueToken ktSingleValueToken = KtTokens.COMMA;
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktSingleValueToken), (String)"COMMA");
            IElementType iElementType6 = ktSingleValueToken;
            boolean bl3 = kotlinCommonSettings.ALIGN_MULTILINE_METHOD_BRACKETS;
            KtSingleValueToken ktSingleValueToken4 = KtTokens.LPAR;
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktSingleValueToken4), (String)"LPAR");
            IElementType iElementType7 = ktSingleValueToken4;
            KtSingleValueToken ktSingleValueToken5 = KtTokens.RPAR;
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktSingleValueToken5), (String)"RPAR");
            commonAlignmentStrategy = KotlinCommonBlockKt.access$getAlignmentForChildInParenthesis(bl, iElementType5, iElementType6, bl3, iElementType7, ktSingleValueToken5);
        } else {
            commonAlignmentStrategy = parentType == KtNodeTypes.WHEN ? this.getAlignmentForCaseBranch(kotlinCustomSettings.ALIGN_IN_COLUMNS_CASE_BRANCH) : (parentType == KtNodeTypes.WHEN_ENTRY ? this.alignmentStrategy : (KotlinCommonBlockKt.access$getBINARY_EXPRESSIONS$p().contains(parentType) && KotlinCommonBlockKt.access$getALIGN_FOR_BINARY_OPERATIONS$p().contains(KotlinCommonBlockKt.access$getOperationType(this.node)) ? this.createAlignmentStrategy(kotlinCommonSettings.ALIGN_MULTILINE_BINARY_OPERATION, this.getAlignment()) : (parentType == KtNodeTypes.SUPER_TYPE_LIST ? this.createAlignmentStrategy(kotlinCommonSettings.ALIGN_MULTILINE_EXTENDS_LIST, this.getAlignment()) : (parentType == KtNodeTypes.PARENTHESIZED ? (CommonAlignmentStrategy)new CommonAlignmentStrategy(kotlinCommonSettings){
                private Alignment bracketsAlignment;
                final /* synthetic */ KotlinCommonCodeStyleSettings $kotlinCommonSettings;

                @Nullable
                public Alignment getAlignment(@NotNull ASTNode node2) {
                    Intrinsics.checkParameterIsNotNull((Object)node2, (String)"node");
                    IElementType iElementType = node2.getElementType();
                    Intrinsics.checkExpressionValueIsNotNull((Object)iElementType, (String)"node.elementType");
                    IElementType childNodeType = iElementType;
                    ASTNode prev2 = KotlinCommonBlockKt.access$getPrevWithoutWhitespace(node2);
                    if (prev2 != null && prev2.getElementType() == TokenType.ERROR_ELEMENT || childNodeType == TokenType.ERROR_ELEMENT) {
                        return this.bracketsAlignment;
                    }
                    if (childNodeType == KtTokens.LPAR || childNodeType == KtTokens.RPAR) {
                        return this.bracketsAlignment;
                    }
                    return null;
                }
                {
                    this.$kotlinCommonSettings = $captured_local_variable$0;
                    this.bracketsAlignment = $captured_local_variable$0.ALIGN_MULTILINE_BINARY_OPERATION ? Alignment.createAlignment() : null;
                }
            } : (Intrinsics.areEqual((Object)parentType, (Object)KtNodeTypes.TYPE_CONSTRAINT_LIST) ? this.createAlignmentStrategy(true, this.getAlignment()) : this.getNullAlignmentStrategy())))));
        }
        return commonAlignmentStrategy;
    }

    private final ASTBlock buildSubBlock(ASTNode child, CommonAlignmentStrategy alignmentStrategy, Function1<? super ASTNode, ? extends Wrap> wrappingStrategy, Sequence<? extends ASTNode> overrideChildren) {
        ASTNode operationNode;
        Wrap childWrap = (Wrap)wrappingStrategy.invoke((Object)child);
        if (child.getElementType() == KtNodeTypes.OPERATION_REFERENCE && (operationNode = child.getFirstChildNode()) != null) {
            return this.createBlock(operationNode, alignmentStrategy, this.createChildIndent(child), childWrap, this.settings, this.spacingBuilder, overrideChildren);
        }
        return this.createBlock(child, alignmentStrategy, this.createChildIndent(child), childWrap, this.settings, this.spacingBuilder, overrideChildren);
    }

    static /* synthetic */ ASTBlock buildSubBlock$default(KotlinCommonBlock kotlinCommonBlock, ASTNode aSTNode, CommonAlignmentStrategy commonAlignmentStrategy, Function1 function1, Sequence sequence2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: buildSubBlock");
        }
        if ((n & 8) != 0) {
            sequence2 = null;
        }
        return kotlinCommonBlock.buildSubBlock(aSTNode, commonAlignmentStrategy, (Function1<? super ASTNode, ? extends Wrap>)function1, (Sequence<? extends ASTNode>)sequence2);
    }

    private final List<ASTBlock> buildSubBlocks() {
        Sequence sequence2;
        CommonAlignmentStrategy childrenAlignmentStrategy = this.getChildrenAlignmentStrategy();
        Function1<ASTNode, Wrap> wrappingStrategy = this.getWrappingStrategy();
        if (this.overrideChildren != null) {
            Sequence sequence3 = this.overrideChildren;
            boolean bl = false;
            sequence2 = sequence3;
        } else if (Intrinsics.areEqual((Object)this.node.getElementType(), (Object)KtNodeTypes.BINARY_EXPRESSION)) {
            KtBinaryExpression binaryExpression;
            PsiElement psiElement2 = this.node.getPsi();
            if (!(psiElement2 instanceof KtBinaryExpression)) {
                psiElement2 = null;
            }
            if ((binaryExpression = (KtBinaryExpression)psiElement2) != null && KtTokens.ALL_ASSIGNMENTS.contains(binaryExpression.getOperationToken())) {
                sequence2 = PsiUtilsKt.children(this.node);
            } else {
                boolean bl = false;
                List binaryExpressionChildren = new ArrayList();
                this.collectBinaryExpressionChildren(this.node, binaryExpressionChildren);
                sequence2 = CollectionsKt.asSequence((Iterable)binaryExpressionChildren);
            }
        } else {
            sequence2 = PsiUtilsKt.children(this.node);
        }
        Sequence childNodes = sequence2;
        return SequencesKt.toList((Sequence)SequencesKt.flatMap((Sequence)SequencesKt.filter(childNodes, (Function1)buildSubBlocks.1.INSTANCE), (Function1)((Function1)new Function1<ASTNode, Sequence<? extends ASTBlock>>(this, childrenAlignmentStrategy, wrappingStrategy){
            final /* synthetic */ KotlinCommonBlock this$0;
            final /* synthetic */ CommonAlignmentStrategy $childrenAlignmentStrategy;
            final /* synthetic */ Function1 $wrappingStrategy;

            @NotNull
            public final Sequence<ASTBlock> invoke(@NotNull ASTNode it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return KotlinCommonBlock.access$buildSubBlocksForChildNode(this.this$0, it, this.$childrenAlignmentStrategy, this.$wrappingStrategy);
            }
            {
                this.this$0 = kotlinCommonBlock;
                this.$childrenAlignmentStrategy = commonAlignmentStrategy;
                this.$wrappingStrategy = function1;
                super(1);
            }
        })));
    }

    private final Sequence<ASTBlock> buildSubBlocksForChildNode(ASTNode node2, CommonAlignmentStrategy childrenAlignmentStrategy, Function1<? super ASTNode, ? extends Wrap> wrappingStrategy) {
        if (Intrinsics.areEqual((Object)node2.getElementType(), (Object)KtNodeTypes.FUN)) {
            // empty if block
        }
        return SequencesKt.sequenceOf((Object[])new ASTBlock[]{KotlinCommonBlock.buildSubBlock$default(this, node2, childrenAlignmentStrategy, wrappingStrategy, null, 8, null)});
    }

    private final void collectBinaryExpressionChildren(ASTNode node2, List<ASTNode> result2) {
        for (ASTNode child : PsiUtilsKt.children(node2)) {
            if (Intrinsics.areEqual((Object)child.getElementType(), (Object)KtNodeTypes.BINARY_EXPRESSION)) {
                this.collectBinaryExpressionChildren(child, result2);
                continue;
            }
            result2.add(child);
        }
    }

    private final Function1<ASTNode, Wrap> getWrappingStrategy() {
        KotlinCommonCodeStyleSettings commonSettings = KtCodeStyleSettingsKt.getKotlinCommonSettings(this.settings);
        IElementType iElementType = this.node.getElementType();
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType, (String)"node.elementType");
        IElementType elementType = iElementType;
        ASTNode aSTNode = this.node.getTreeParent();
        IElementType parentElementType = aSTNode != null ? aSTNode.getElementType() : null;
        PsiElement nodePsi = this.node.getPsi();
        if (elementType == KtNodeTypes.VALUE_ARGUMENT_LIST) {
            int wrapSetting = commonSettings.CALL_PARAMETERS_WRAP;
            if (wrapSetting == 1 || wrapSetting == 4) {
                PsiElement psiElement2 = nodePsi;
                Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"nodePsi");
                if (!KotlinCommonBlockKt.needWrapArgumentList(psiElement2)) {
                    return getWrappingStrategy.1.INSTANCE;
                }
            }
            IElementType iElementType2 = KtNodeTypes.VALUE_ARGUMENT;
            Intrinsics.checkExpressionValueIsNotNull((Object)iElementType2, (String)"VALUE_ARGUMENT");
            return KotlinCommonBlockKt.getWrappingStrategyForItemList$default(wrapSetting, iElementType2, false, 4, null);
        }
        if (elementType == KtNodeTypes.VALUE_PARAMETER_LIST) {
            if (parentElementType == KtNodeTypes.FUN || parentElementType == KtNodeTypes.PRIMARY_CONSTRUCTOR || parentElementType == KtNodeTypes.SECONDARY_CONSTRUCTOR) {
                Wrap wrap2 = Wrap.createWrap((int)commonSettings.METHOD_PARAMETERS_WRAP, (boolean)false);
                return (Function1)new Function1<ASTNode, Wrap>(wrap2){
                    final /* synthetic */ Wrap $wrap;

                    @Nullable
                    public final Wrap invoke(@NotNull ASTNode childElement) {
                        Intrinsics.checkParameterIsNotNull((Object)childElement, (String)"childElement");
                        Wrap wrap2 = this.$wrap;
                        boolean bl = false;
                        boolean bl2 = false;
                        Wrap it = wrap2;
                        boolean bl3 = false;
                        return childElement.getElementType() == KtNodeTypes.VALUE_PARAMETER ? wrap2 : null;
                    }
                    {
                        this.$wrap = wrap2;
                        super(1);
                    }
                };
            }
        } else {
            if (elementType == KtNodeTypes.SUPER_TYPE_LIST) {
                Wrap wrap3 = Wrap.createWrap((int)commonSettings.EXTENDS_LIST_WRAP, (boolean)false);
                return (Function1)new Function1<ASTNode, Wrap>(wrap3){
                    final /* synthetic */ Wrap $wrap;

                    @Nullable
                    public final Wrap invoke(@NotNull ASTNode childElement) {
                        Intrinsics.checkParameterIsNotNull((Object)childElement, (String)"childElement");
                        return childElement.getPsi() instanceof KtSuperTypeListEntry ? this.$wrap : null;
                    }
                    {
                        this.$wrap = wrap2;
                        super(1);
                    }
                };
            }
            if (elementType == KtNodeTypes.CLASS_BODY) {
                int n = commonSettings.ENUM_CONSTANTS_WRAP;
                IElementType iElementType3 = KtNodeTypes.ENUM_ENTRY;
                Intrinsics.checkExpressionValueIsNotNull((Object)iElementType3, (String)"ENUM_ENTRY");
                return KotlinCommonBlockKt.getWrappingStrategyForItemList$default(n, iElementType3, false, 4, null);
            }
            if (elementType == KtNodeTypes.MODIFIER_LIST) {
                ASTNode aSTNode2 = this.node.getTreeParent();
                Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode2, (String)"node.treeParent");
                PsiElement parent2 = aSTNode2.getPsi();
                if (parent2 instanceof KtParameter) {
                    int n = commonSettings.PARAMETER_ANNOTATION_WRAP;
                    TokenSet tokenSet = KotlinCommonBlockKt.access$getANNOTATIONS$p();
                    ASTNode aSTNode3 = this.node.getTreeParent();
                    Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode3, (String)"node.treeParent");
                    return KotlinCommonBlockKt.access$getWrappingStrategyForItemList(n, tokenSet, !KotlinCommonBlockKt.access$isFirstParameter(aSTNode3));
                }
                if (parent2 instanceof KtClassOrObject || parent2 instanceof KtTypeAlias) {
                    return KotlinCommonBlockKt.getWrappingStrategyForItemList$default(commonSettings.CLASS_ANNOTATION_WRAP, KotlinCommonBlockKt.access$getANNOTATIONS$p(), false, 4, null);
                }
                if (parent2 instanceof KtNamedFunction || parent2 instanceof KtSecondaryConstructor) {
                    return KotlinCommonBlockKt.getWrappingStrategyForItemList$default(commonSettings.METHOD_ANNOTATION_WRAP, KotlinCommonBlockKt.access$getANNOTATIONS$p(), false, 4, null);
                }
                if (parent2 instanceof KtProperty) {
                    return KotlinCommonBlockKt.getWrappingStrategyForItemList$default(((KtProperty)parent2).isLocal() ? commonSettings.VARIABLE_ANNOTATION_WRAP : commonSettings.FIELD_ANNOTATION_WRAP, KotlinCommonBlockKt.access$getANNOTATIONS$p(), false, 4, null);
                }
            } else {
                if (elementType == KtNodeTypes.VALUE_PARAMETER) {
                    return KotlinCommonBlockKt.access$wrapAfterAnnotation(commonSettings.PARAMETER_ANNOTATION_WRAP);
                }
                if (nodePsi instanceof KtClassOrObject || nodePsi instanceof KtTypeAlias) {
                    return KotlinCommonBlockKt.access$wrapAfterAnnotation(commonSettings.CLASS_ANNOTATION_WRAP);
                }
                if (nodePsi instanceof KtNamedFunction || nodePsi instanceof KtSecondaryConstructor) {
                    return (Function1)new Function1<ASTNode, Wrap>(this, commonSettings){
                        final /* synthetic */ KotlinCommonBlock this$0;
                        final /* synthetic */ KotlinCommonCodeStyleSettings $commonSettings;

                        @Nullable
                        public final Wrap invoke(@NotNull ASTNode childElement) {
                            Intrinsics.checkParameterIsNotNull((Object)childElement, (String)"childElement");
                            Wrap wrap2 = KotlinCommonBlockKt.access$getWrapAfterAnnotation(childElement, this.$commonSettings.METHOD_ANNOTATION_WRAP);
                            if (wrap2 != null) {
                                Wrap wrap3 = wrap2;
                                boolean bl = false;
                                boolean bl2 = false;
                                Wrap it = wrap3;
                                boolean bl3 = false;
                                return it;
                            }
                            ASTNode aSTNode = KotlinCommonBlockKt.getSiblingWithoutWhitespaceAndComments$default(childElement, false, 2, null);
                            if (Intrinsics.areEqual((Object)(aSTNode != null ? aSTNode.getElementType() : null), (Object)((Object)KtTokens.EQ))) {
                                return Wrap.createWrap((int)KtCodeStyleSettingsKt.getKotlinCustomSettings((CodeStyleSettings)KotlinCommonBlock.access$getSettings$p((KotlinCommonBlock)this.this$0)).WRAP_EXPRESSION_BODY_FUNCTIONS, (boolean)true);
                            }
                            return null;
                        }
                        {
                            this.this$0 = kotlinCommonBlock;
                            this.$commonSettings = kotlinCommonCodeStyleSettings;
                            super(1);
                        }
                    };
                }
                if (nodePsi instanceof KtProperty) {
                    return (Function1)new Function1<ASTNode, Wrap>(this, nodePsi, commonSettings){
                        final /* synthetic */ KotlinCommonBlock this$0;
                        final /* synthetic */ PsiElement $nodePsi;
                        final /* synthetic */ KotlinCommonCodeStyleSettings $commonSettings;

                        @Nullable
                        public final Wrap invoke(@NotNull ASTNode childElement) {
                            Intrinsics.checkParameterIsNotNull((Object)childElement, (String)"childElement");
                            int wrapSetting = ((KtProperty)this.$nodePsi).isLocal() ? this.$commonSettings.VARIABLE_ANNOTATION_WRAP : this.$commonSettings.FIELD_ANNOTATION_WRAP;
                            Wrap wrap2 = KotlinCommonBlockKt.access$getWrapAfterAnnotation(childElement, wrapSetting);
                            if (wrap2 != null) {
                                Wrap wrap3 = wrap2;
                                boolean bl = false;
                                boolean bl2 = false;
                                Wrap it = wrap3;
                                boolean bl3 = false;
                                return it;
                            }
                            ASTNode aSTNode = KotlinCommonBlockKt.getSiblingWithoutWhitespaceAndComments$default(childElement, false, 2, null);
                            if (Intrinsics.areEqual((Object)(aSTNode != null ? aSTNode.getElementType() : null), (Object)((Object)KtTokens.EQ))) {
                                return Wrap.createWrap((int)KtCodeStyleSettingsKt.getKotlinCommonSettings((CodeStyleSettings)KotlinCommonBlock.access$getSettings$p((KotlinCommonBlock)this.this$0)).ASSIGNMENT_WRAP, (boolean)true);
                            }
                            return null;
                        }
                        {
                            this.this$0 = kotlinCommonBlock;
                            this.$nodePsi = psiElement2;
                            this.$commonSettings = kotlinCommonCodeStyleSettings;
                            super(1);
                        }
                    };
                }
                if (nodePsi instanceof KtBinaryExpression) {
                    if (Intrinsics.areEqual((Object)((KtBinaryExpression)nodePsi).getOperationToken(), (Object)((Object)KtTokens.EQ))) {
                        return (Function1)new Function1<ASTNode, Wrap>(this){
                            final /* synthetic */ KotlinCommonBlock this$0;

                            @Nullable
                            public final Wrap invoke(@NotNull ASTNode childElement) {
                                Intrinsics.checkParameterIsNotNull((Object)childElement, (String)"childElement");
                                ASTNode aSTNode = KotlinCommonBlockKt.getSiblingWithoutWhitespaceAndComments$default(childElement, false, 2, null);
                                return Intrinsics.areEqual((Object)(aSTNode != null ? aSTNode.getElementType() : null), (Object)KtNodeTypes.OPERATION_REFERENCE) ? Wrap.createWrap((int)KtCodeStyleSettingsKt.getKotlinCommonSettings((CodeStyleSettings)KotlinCommonBlock.access$getSettings$p((KotlinCommonBlock)this.this$0)).ASSIGNMENT_WRAP, (boolean)true) : null;
                            }
                            {
                                this.this$0 = kotlinCommonBlock;
                                super(1);
                            }
                        };
                    }
                    if (Intrinsics.areEqual((Object)((KtBinaryExpression)nodePsi).getOperationToken(), (Object)((Object)KtTokens.ELVIS))) {
                        PsiElement $this$getStrictParentOfType$iv = nodePsi;
                        boolean $i$f$getStrictParentOfType = false;
                        if (PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtStringTemplateExpression.class, (boolean)true) == null) {
                            return (Function1)new Function1<ASTNode, Wrap>(this){
                                final /* synthetic */ KotlinCommonBlock this$0;

                                /*
                                 * Enabled force condition propagation
                                 * Lifted jumps to return sites
                                 */
                                @Nullable
                                public final Wrap invoke(@NotNull ASTNode childElement) {
                                    Intrinsics.checkParameterIsNotNull((Object)childElement, (String)"childElement");
                                    if (!Intrinsics.areEqual((Object)childElement.getElementType(), (Object)KtNodeTypes.OPERATION_REFERENCE)) return null;
                                    PsiElement psiElement2 = childElement.getPsi();
                                    if (!(psiElement2 instanceof KtOperationReferenceExpression)) {
                                        psiElement2 = null;
                                    }
                                    KtOperationReferenceExpression ktOperationReferenceExpression = (KtOperationReferenceExpression)psiElement2;
                                    if (!Intrinsics.areEqual((Object)((Object)(ktOperationReferenceExpression != null ? ktOperationReferenceExpression.getOperationSignTokenType() : null)), (Object)((Object)KtTokens.ELVIS))) return null;
                                    Wrap wrap2 = Wrap.createWrap((int)KtCodeStyleSettingsKt.getKotlinCustomSettings((CodeStyleSettings)KotlinCommonBlock.access$getSettings$p((KotlinCommonBlock)this.this$0)).WRAP_ELVIS_EXPRESSIONS, (boolean)true);
                                    return wrap2;
                                }
                                {
                                    this.this$0 = kotlinCommonBlock;
                                    super(1);
                                }
                            };
                        }
                    }
                    return getWrappingStrategy.8.INSTANCE;
                }
            }
        }
        return getWrappingStrategy.9.INSTANCE;
    }

    public KotlinCommonBlock(@NotNull ASTNode node2, @NotNull CodeStyleSettings settings2, @NotNull KotlinSpacingBuilder spacingBuilder, @NotNull CommonAlignmentStrategy alignmentStrategy, @Nullable Sequence<? extends ASTNode> overrideChildren) {
        Intrinsics.checkParameterIsNotNull((Object)node2, (String)"node");
        Intrinsics.checkParameterIsNotNull((Object)settings2, (String)"settings");
        Intrinsics.checkParameterIsNotNull((Object)spacingBuilder, (String)"spacingBuilder");
        Intrinsics.checkParameterIsNotNull((Object)alignmentStrategy, (String)"alignmentStrategy");
        this.node = node2;
        this.settings = settings2;
        this.spacingBuilder = spacingBuilder;
        this.alignmentStrategy = alignmentStrategy;
        this.overrideChildren = overrideChildren;
    }

    public /* synthetic */ KotlinCommonBlock(ASTNode aSTNode, CodeStyleSettings codeStyleSettings, KotlinSpacingBuilder kotlinSpacingBuilder, CommonAlignmentStrategy commonAlignmentStrategy, Sequence sequence2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            sequence2 = null;
        }
        this(aSTNode, codeStyleSettings, kotlinSpacingBuilder, commonAlignmentStrategy, (Sequence<? extends ASTNode>)sequence2);
    }

    public static final /* synthetic */ ASTNode access$getNode$p(KotlinCommonBlock $this) {
        return $this.node;
    }

    public static final /* synthetic */ Sequence access$buildSubBlocksForChildNode(KotlinCommonBlock $this, ASTNode node2, CommonAlignmentStrategy childrenAlignmentStrategy, Function1 wrappingStrategy) {
        return $this.buildSubBlocksForChildNode(node2, childrenAlignmentStrategy, (Function1<? super ASTNode, ? extends Wrap>)wrappingStrategy);
    }

    public static final /* synthetic */ CodeStyleSettings access$getSettings$p(KotlinCommonBlock $this) {
        return $this.settings;
    }
}

