/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.inspections.collections.FunctionUtilsKt;
import org.jetbrains.kotlin.idea.intentions.SelfTargetingIntention;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyDelegate;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtStatementExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u000e\u0010\r\u001a\u0004\u0018\u00010\u000e*\u00020\u000fH\u0002J\u000e\u0010\u0010\u001a\u0004\u0018\u00010\u0011*\u00020\u000eH\u0002\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/ConvertLazyPropertyToOrdinaryIntention;", "Lorg/jetbrains/kotlin/idea/intentions/SelfTargetingIntention;", "Lorg/jetbrains/kotlin/psi/KtProperty;", "()V", "applyTo", "", "element", "editor", "Lcom/intellij/openapi/editor/Editor;", "isApplicableTo", "", "caretOffset", "", "functionLiteral", "Lorg/jetbrains/kotlin/psi/KtFunctionLiteral;", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "singleStatement", "Lorg/jetbrains/kotlin/psi/KtExpression;", "idea"})
public final class ConvertLazyPropertyToOrdinaryIntention
extends SelfTargetingIntention<KtProperty> {
    @Override
    public boolean isApplicableTo(@NotNull KtProperty element3, int caretOffset) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        KtPropertyDelegate ktPropertyDelegate = element3.getDelegate();
        KtExpression ktExpression = ktPropertyDelegate != null ? ktPropertyDelegate.getExpression() : null;
        if (!(ktExpression instanceof KtCallExpression)) {
            ktExpression = null;
        }
        KtCallExpression ktCallExpression = (KtCallExpression)ktExpression;
        if (ktCallExpression == null) {
            return false;
        }
        KtCallExpression delegateExpression2 = ktCallExpression;
        KtStatementExpression ktStatementExpression = this.functionLiteral(delegateExpression2);
        if (ktStatementExpression == null || (ktStatementExpression = ((KtFunctionLiteral)ktStatementExpression).getBodyExpression()) == null) {
            return false;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktStatementExpression, (String)"delegateExpression.funct\u2026xpression ?: return false");
        KtStatementExpression lambdaBody = ktStatementExpression;
        if (((KtBlockExpression)lambdaBody).getStatements().isEmpty()) {
            return false;
        }
        return FunctionUtilsKt.isCalling$default(delegateExpression2, new FqName("kotlin.lazy"), null, 2, null);
    }

    @Override
    public void applyTo(@NotNull KtProperty element3, @Nullable Editor editor2) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        KtPropertyDelegate ktPropertyDelegate = element3.getDelegate();
        if (ktPropertyDelegate == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktPropertyDelegate, (String)"element.delegate ?: return");
        KtPropertyDelegate delegate2 = ktPropertyDelegate;
        KtExpression ktExpression = delegate2.getExpression();
        if (!(ktExpression instanceof KtCallExpression)) {
            ktExpression = null;
        }
        KtCallExpression ktCallExpression = (KtCallExpression)ktExpression;
        if (ktCallExpression == null) {
            return;
        }
        KtCallExpression delegateExpression2 = ktCallExpression;
        KtFunctionLiteral ktFunctionLiteral = this.functionLiteral(delegateExpression2);
        if (ktFunctionLiteral == null) {
            return;
        }
        KtFunctionLiteral functionLiteral = ktFunctionLiteral;
        KtExpression ktExpression2 = this.singleStatement(functionLiteral);
        if (ktExpression2 == null) {
            ktExpression2 = KtPsiFactoryKt.KtPsiFactory$default(element3, false, 2, null).createExpression("run " + functionLiteral.getText());
        }
        element3.setInitializer(ktExpression2);
        delegate2.delete();
    }

    private final KtFunctionLiteral functionLiteral(@NotNull KtCallExpression $this$functionLiteral) {
        List<KtLambdaArgument> list2 = $this$functionLiteral.getLambdaArguments();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"lambdaArguments");
        KtElement ktElement = (KtLambdaArgument)CollectionsKt.singleOrNull(list2);
        return ktElement != null && (ktElement = ((KtLambdaArgument)ktElement).getLambdaExpression()) != null ? ((KtLambdaExpression)ktElement).getFunctionLiteral() : null;
    }

    private final KtExpression singleStatement(@NotNull KtFunctionLiteral $this$singleStatement) {
        boolean bl;
        KtBlockExpression body2;
        block3: {
            KtBlockExpression ktBlockExpression = $this$singleStatement.getBodyExpression();
            if (ktBlockExpression == null) {
                return null;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)ktBlockExpression, (String)"this.bodyExpression ?: return null");
            body2 = ktBlockExpression;
            Sequence $this$any$iv = PsiUtilsKt.getAllChildren((PsiElement)body2);
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                PsiElement it = (PsiElement)element$iv;
                boolean bl2 = false;
                if (!(it instanceof PsiComment)) continue;
                bl = true;
                break block3;
            }
            bl = false;
        }
        if (bl) {
            return null;
        }
        List<KtExpression> list2 = body2.getStatements();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"body.statements");
        return (KtExpression)CollectionsKt.singleOrNull(list2);
    }

    public ConvertLazyPropertyToOrdinaryIntention() {
        super(KtProperty.class, KotlinBundle.message("convert.to.ordinary.property", new Object[0]), null, 4, null);
    }
}

