/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.intentions.SelfTargetingIntention;
import org.jetbrains.kotlin.idea.project.PlatformKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.platform.js.JsPlatformKt;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/ConvertUnsafeCastToUnsafeCastCallIntention;", "Lorg/jetbrains/kotlin/idea/intentions/SelfTargetingIntention;", "Lorg/jetbrains/kotlin/psi/KtBinaryExpressionWithTypeRHS;", "()V", "applyTo", "", "element", "editor", "Lcom/intellij/openapi/editor/Editor;", "isApplicableTo", "", "caretOffset", "", "idea"})
public final class ConvertUnsafeCastToUnsafeCastCallIntention
extends SelfTargetingIntention<KtBinaryExpressionWithTypeRHS> {
    @Override
    public boolean isApplicableTo(@NotNull KtBinaryExpressionWithTypeRHS element3, int caretOffset) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        if (!JsPlatformKt.isJs(PlatformKt.getPlatform(element3))) {
            return false;
        }
        if (Intrinsics.areEqual((Object)element3.getOperationReference().getReferencedNameElementType(), (Object)((Object)KtTokens.AS_KEYWORD)) ^ true) {
            return false;
        }
        KtTypeReference ktTypeReference = element3.getRight();
        if (ktTypeReference == null) {
            return false;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktTypeReference, (String)"element.right ?: return false");
        KtTypeReference right2 = ktTypeReference;
        BindingContext context2 = ResolutionUtils.analyze((KtElement)right2, (BodyResolveMode)BodyResolveMode.PARTIAL);
        KotlinType kotlinType = (KotlinType)context2.get(BindingContext.TYPE, right2);
        if (kotlinType == null) {
            return false;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"context[BindingContext.T\u2026E, right] ?: return false");
        KotlinType type2 = kotlinType;
        if (TypeUtils.isNullableType(type2)) {
            return false;
        }
        Object[] objectArray = new Object[2];
        KtExpression ktExpression = element3.getLeft();
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"element.left");
        String string = ktExpression.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"element.left.text");
        objectArray[0] = string;
        String string2 = right2.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"right.text");
        objectArray[1] = string2;
        this.setText(KotlinBundle.message("convert.to.0.unsafecast.1", objectArray));
        return true;
    }

    @Override
    public void applyTo(@NotNull KtBinaryExpressionWithTypeRHS element3, @Nullable Editor editor2) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        KtTypeReference ktTypeReference = element3.getRight();
        if (ktTypeReference == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktTypeReference, (String)"element.right ?: return");
        KtTypeReference right2 = ktTypeReference;
        KtPsiFactory ktPsiFactory = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)element3, false, 2, null);
        Object[] objectArray = new Object[2];
        KtExpression ktExpression = element3.getLeft();
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"element.left");
        objectArray[0] = ktExpression;
        objectArray[1] = right2;
        KtExpression newExpression2 = CreateByPatternKt.createExpressionByPattern$default(ktPsiFactory, "$0.unsafeCast<$1>()", objectArray, false, 4, null);
        element3.replace((PsiElement)newExpression2);
    }

    public ConvertUnsafeCastToUnsafeCastCallIntention() {
        super(KtBinaryExpressionWithTypeRHS.class, KotlinBundle.message("convert.to.unsafecast.call", new Object[0]), null, 4, null);
    }
}

