/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.kdoc;

import com.intellij.codeInsight.documentation.DocumentationManagerUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.flavours.MarkdownFlavourDescriptor;
import org.intellij.markdown.flavours.commonmark.CommonMarkFlavourDescriptor;
import org.intellij.markdown.parser.MarkdownParser;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.kdoc.KDocRenderer;
import org.jetbrains.kotlin.idea.references.ReferenceUtilKt;
import org.jetbrains.kotlin.kdoc.psi.impl.KDocLink;
import org.jetbrains.kotlin.kdoc.psi.impl.KDocName;
import org.jetbrains.kotlin.kdoc.psi.impl.KDocSection;
import org.jetbrains.kotlin.kdoc.psi.impl.KDocTag;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtExpression;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u00012B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eJ\"\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\n0\u00122\n\u0010\u0013\u001a\u00060\u0014j\u0002`\u0015H\u0002J\u001c\u0010\u0016\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\u000e2\n\u0010\u0013\u001a\u00060\u0014j\u0002`\u0015H\u0002J&\u0010\u0017\u001a\u00020\u00102\b\u0010\u0018\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0019\u001a\u00020\u00042\n\u0010\u0013\u001a\u00060\u0014j\u0002`\u0015H\u0002J*\u0010\u001a\u001a\u00020\u00102\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\n0\u00122\u0006\u0010\u0019\u001a\u00020\u00042\n\u0010\u0013\u001a\u00060\u0014j\u0002`\u0015H\u0002J\u0010\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u0004H\u0002J\u0016\u0010\u001e\u001a\u00020\u0010*\u00060\u0014j\u0002`\u00152\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\u001f\u001a\u00020\u0010*\u00060\u0014j\u0002`\u00152\u0006\u0010\r\u001a\u00020\u000eJ\u0018\u0010 \u001a\u00020\u0010*\u00020!2\n\u0010\u0013\u001a\u00060\u0014j\u0002`\u0015H\u0002J\u0014\u0010\"\u001a\n #*\u0004\u0018\u00010\u00040\u0004*\u00020$H\u0002J\u000e\u0010%\u001a\u0004\u0018\u00010$*\u00020!H\u0002J\f\u0010&\u001a\u00020\u0004*\u00020\u0004H\u0002J5\u0010'\u001a\u00020\u0010*\u00060\u0014j\u0002`\u00152\u0006\u0010\u0019\u001a\u00020\u00042\u001b\u0010(\u001a\u0017\u0012\b\u0012\u00060\u0014j\u0002`\u0015\u0012\u0004\u0012\u00020\u00100)\u00a2\u0006\u0002\b*H\u0002J\f\u0010+\u001a\u00020\u0004*\u00020,H\u0002J\u0010\u0010-\u001a\u00020\u0010*\u00060\u0014j\u0002`\u0015H\u0002J,\u0010.\u001a\u00020\u0010*\u00020,2\u001e\u0010/\u001a\u001a\u0012\u0004\u0012\u00020,\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001001\u0012\u0004\u0012\u00020\u001000H\u0002\u00a8\u00063"}, d2={"Lorg/jetbrains/kotlin/idea/kdoc/KDocRenderer;", "", "()V", "markdownToHtml", "", "markdown", "allowSingleParagraph", "", "renderKDoc", "docComment", "Lorg/jetbrains/kotlin/kdoc/psi/impl/KDocTag;", "renderKDocContent", "renderKDocSection", "section", "Lorg/jetbrains/kotlin/kdoc/psi/impl/KDocSection;", "renderSamplesList", "", "sampleTags", "", "to", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "renderSeeAlso", "renderTag", "tag", "title", "renderTagList", "tags", "trimCommonIndent", "text", "appendKDocContent", "appendKDocSection", "createHyperlink", "Lorg/jetbrains/kotlin/kdoc/psi/impl/KDocLink;", "extractExampleText", "kotlin.jvm.PlatformType", "Lcom/intellij/psi/PsiElement;", "getTargetElement", "htmlEscape", "renderSection", "content", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "toHtml", "Lorg/jetbrains/kotlin/idea/kdoc/KDocRenderer$MarkdownNode;", "trimEnd", "visit", "action", "Lkotlin/Function2;", "Lkotlin/Function0;", "MarkdownNode", "idea"})
public final class KDocRenderer {
    public static final KDocRenderer INSTANCE;

    @NotNull
    public final String renderKDoc(@NotNull KDocTag docComment) {
        Intrinsics.checkParameterIsNotNull((Object)docComment, (String)"docComment");
        return docComment instanceof KDocSection ? this.renderKDocContent(docComment) + this.renderKDocSection((KDocSection)docComment) : this.renderKDocContent(docComment);
    }

    @NotNull
    public final String renderKDocContent(@NotNull KDocTag docComment) {
        Intrinsics.checkParameterIsNotNull((Object)docComment, (String)"docComment");
        return this.markdownToHtml(docComment.getContent(), true);
    }

    public final void appendKDocContent(@NotNull StringBuilder $this$appendKDocContent, @NotNull KDocTag docComment) {
        Intrinsics.checkParameterIsNotNull((Object)$this$appendKDocContent, (String)"$this$appendKDocContent");
        Intrinsics.checkParameterIsNotNull((Object)docComment, (String)"docComment");
        $this$appendKDocContent.append(this.renderKDocContent(docComment));
    }

    @NotNull
    public final String renderKDocSection(@NotNull KDocSection section) {
        Intrinsics.checkParameterIsNotNull((Object)section, (String)"section");
        boolean bl = false;
        StringBuilder stringBuilder2 = new StringBuilder();
        boolean bl2 = false;
        boolean bl3 = false;
        StringBuilder $this$buildString = stringBuilder2;
        boolean bl4 = false;
        INSTANCE.appendKDocSection($this$buildString, section);
        String string = stringBuilder2.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public final void appendKDocSection(@NotNull StringBuilder $this$appendKDocSection, @NotNull KDocSection section) {
        void $this$filterTo$iv$iv;
        void $this$filterTo$iv$iv2;
        void $this$filterTo$iv$iv3;
        Intrinsics.checkParameterIsNotNull((Object)$this$appendKDocSection, (String)"$this$appendKDocSection");
        Intrinsics.checkParameterIsNotNull((Object)section, (String)"section");
        this.renderTag(section.findTagByName("receiver"), KotlinBundle.message("kdoc.section.title.receiver", new Object[0]), $this$appendKDocSection);
        Iterable $this$filter$iv = section.findTagsByName("param");
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv3) {
            KDocTag it = (KDocTag)element$iv$iv;
            boolean bl = false;
            if (!(it.getSubjectName() != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List paramTags = (List)destination$iv$iv;
        this.renderTagList(paramTags, KotlinBundle.message("kdoc.section.title.parameters", new Object[0]), $this$appendKDocSection);
        this.renderTag(section.findTagByName("return"), KotlinBundle.message("kdoc.section.title.returns", new Object[0]), $this$appendKDocSection);
        Iterable $this$filter$iv2 = CollectionsKt.union((Iterable)section.findTagsByName("exception"), (Iterable)section.findTagsByName("throws"));
        boolean $i$f$filter2 = false;
        destination$iv$iv = $this$filter$iv2;
        Iterable destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            KDocTag it = (KDocTag)element$iv$iv;
            boolean bl = false;
            if (!(it.getSubjectName() != null)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List throwsTags = (List)destination$iv$iv2;
        this.renderTagList(throwsTags, KotlinBundle.message("kdoc.section.title.throws", new Object[0]), $this$appendKDocSection);
        this.renderTag(section.findTagByName("author"), KotlinBundle.message("kdoc.section.title.author", new Object[0]), $this$appendKDocSection);
        this.renderTag(section.findTagByName("since"), KotlinBundle.message("kdoc.section.title.since", new Object[0]), $this$appendKDocSection);
        this.renderSeeAlso(section, $this$appendKDocSection);
        Iterable $this$filter$iv3 = section.findTagsByName("sample");
        boolean $i$f$filter3 = false;
        destination$iv$iv2 = $this$filter$iv3;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$filterTo3 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            KDocTag it = (KDocTag)element$iv$iv;
            boolean bl = false;
            if (!(it.getSubjectLink() != null)) continue;
            destination$iv$iv3.add(element$iv$iv);
        }
        List sampleTags = (List)destination$iv$iv3;
        this.renderSamplesList(sampleTags, $this$appendKDocSection);
    }

    private final void createHyperlink(@NotNull KDocLink $this$createHyperlink, StringBuilder to) {
        DocumentationManagerUtil.createHyperlink((StringBuilder)to, (String)$this$createHyperlink.getLinkText(), (String)$this$createHyperlink.getLinkText(), (boolean)false);
    }

    private final PsiElement getTargetElement(@NotNull KDocLink $this$getTargetElement) {
        PsiElement $this$getChildrenOfType$iv = (PsiElement)$this$getTargetElement;
        boolean $i$f$getChildrenOfType = false;
        Object[] objectArray = PsiTreeUtil.getChildrenOfType((PsiElement)$this$getChildrenOfType$iv, KDocName.class);
        if (objectArray == null) {
            objectArray = new KDocName[]{};
        }
        return ReferenceUtilKt.getMainReference((KDocName)ArraysKt.last((Object[])objectArray)).resolve();
    }

    private final String extractExampleText(@NotNull PsiElement $this$extractExampleText) {
        String string;
        PsiElement psiElement2 = $this$extractExampleText;
        if (psiElement2 instanceof KtDeclarationWithBody) {
            KtExpression bodyExpression = ((KtDeclarationWithBody)$this$extractExampleText).getBodyExpression();
            KtExpression ktExpression = bodyExpression;
            if (ktExpression instanceof KtBlockExpression) {
                String string2 = ((KtBlockExpression)bodyExpression).getText();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"bodyExpression.text");
                string = StringsKt.removeSurrounding((String)string2, (CharSequence)"{", (CharSequence)"}");
            } else {
                KtExpression ktExpression2 = bodyExpression;
                if (ktExpression2 == null) {
                    Intrinsics.throwNpe();
                }
                string = ktExpression2.getText();
            }
        } else {
            string = $this$extractExampleText.getText();
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final String trimCommonIndent(String text2) {
        void $this$mapTo$iv$iv;
        String it;
        Iterable $this$filterTo$iv$iv;
        trimCommonIndent.1 $fun$leadingIndent$1 = trimCommonIndent.1.INSTANCE;
        List lines = StringsKt.split$default((CharSequence)text2, (char[])new char[]{'\n'}, (boolean)false, (int)0, (int)6, null);
        Iterable $this$filter$iv = lines;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            CharSequence charSequence = it;
            boolean bl2 = false;
            String string = charSequence;
            if (string == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            charSequence = ((Object)StringsKt.trim((CharSequence)string)).toString();
            bl2 = false;
            if (!(charSequence.length() > 0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p1;
            it = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Integer n = trimCommonIndent.1.INSTANCE.invoke((String)p1);
            collection.add(n);
        }
        Integer n = (Integer)CollectionsKt.min((Iterable)((List)destination$iv$iv));
        int minIndent = n != null ? n : 0;
        return CollectionsKt.joinToString$default((Iterable)lines, (CharSequence)"\n", null, null, (int)0, null, (Function1)((Function1)new Function1<String, String>(minIndent){
            final /* synthetic */ int $minIndent;

            @NotNull
            public final String invoke(@NotNull String it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return StringsKt.drop((String)it, (int)this.$minIndent);
            }
            {
                this.$minIndent = n;
                super(1);
            }
        }), (int)30, null);
    }

    private final void renderSection(@NotNull StringBuilder $this$renderSection, String title, Function1<? super StringBuilder, Unit> content2) {
        StringsKt.append((StringBuilder)$this$renderSection, (String[])new String[]{"<tr><td valign='top' class='section'><p>", title, ":", "</td><td valign='top'>"});
        content2.invoke((Object)$this$renderSection);
        $this$renderSection.append("</td>");
    }

    private final void renderSamplesList(List<? extends KDocTag> sampleTags, StringBuilder to) {
        if (sampleTags.isEmpty()) {
            return;
        }
        this.renderSection(to, KotlinBundle.message("kdoc.section.title.samples", new Object[0]), (Function1<? super StringBuilder, Unit>)((Function1)new Function1<StringBuilder, Unit>(sampleTags, to){
            final /* synthetic */ List $sampleTags;
            final /* synthetic */ StringBuilder $to;

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull StringBuilder $this$renderSection) {
                Intrinsics.checkParameterIsNotNull((Object)$this$renderSection, (String)"$receiver");
                Iterable $this$forEach$iv = this.$sampleTags;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    void prefix$iv$iv;
                    void $this$wrap$iv$iv;
                    void $this$wrapTag$iv;
                    void prefix$iv$iv2;
                    void $this$wrap$iv$iv2;
                    void $this$wrapTag$iv2;
                    KDocLink kDocLink;
                    KDocTag it = (KDocTag)element$iv;
                    boolean bl = false;
                    if (it.getSubjectLink() == null) continue;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    KDocLink subjectLink = kDocLink;
                    boolean bl4 = false;
                    $this$renderSection.append("<p>");
                    KDocRenderer.access$createHyperlink(KDocRenderer.INSTANCE, subjectLink, this.$to);
                    PsiElement target = KDocRenderer.access$getTargetElement(KDocRenderer.INSTANCE, subjectLink);
                    StringBuilder stringBuilder2 = $this$renderSection;
                    String tag$iv = "pre";
                    boolean $i$f$wrapTag = false;
                    void var17_17 = $this$wrapTag$iv2;
                    String string = '<' + tag$iv + '>';
                    String postfix$iv$iv = "</" + tag$iv + '>';
                    boolean $i$f$wrap = false;
                    $this$wrap$iv$iv2.append((String)prefix$iv$iv2);
                    boolean bl5 = false;
                    StringBuilder stringBuilder3 = $this$renderSection;
                    String tag$iv2 = "code";
                    boolean $i$f$wrapTag2 = false;
                    void var25_25 = $this$wrapTag$iv;
                    String string2 = '<' + tag$iv2 + '>';
                    String postfix$iv$iv2 = "</" + tag$iv2 + '>';
                    boolean $i$f$wrap2 = false;
                    $this$wrap$iv$iv.append((String)prefix$iv$iv);
                    boolean bl6 = false;
                    if (target == null) {
                        this.$to.append("// " + KotlinBundle.message("kdoc.comment.unresolved", new Object[0]));
                    } else {
                        String string3 = KDocRenderer.access$extractExampleText(KDocRenderer.INSTANCE, target);
                        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"target.extractExampleText()");
                        this.$to.append(KDocRenderer.access$htmlEscape(KDocRenderer.INSTANCE, KDocRenderer.access$trimCommonIndent(KDocRenderer.INSTANCE, string3)));
                    }
                    $this$wrap$iv$iv.append(postfix$iv$iv2);
                    $this$wrap$iv$iv2.append(postfix$iv$iv);
                }
            }
            {
                this.$sampleTags = list2;
                this.$to = stringBuilder2;
                super(1);
            }
        }));
    }

    private final void renderSeeAlso(KDocSection docComment, StringBuilder to) {
        List<KDocTag> seeTags = docComment.findTagsByName("see");
        if (seeTags.isEmpty()) {
            return;
        }
        this.renderSection(to, KotlinBundle.message("kdoc.section.title.see.also", new Object[0]), (Function1<? super StringBuilder, Unit>)((Function1)new Function1<StringBuilder, Unit>(seeTags){
            final /* synthetic */ List $seeTags;

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull StringBuilder $this$renderSection) {
                Intrinsics.checkParameterIsNotNull((Object)$this$renderSection, (String)"$receiver");
                Iterable $this$forEachIndexed$iv = this.$seeTags;
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (T item$iv : $this$forEachIndexed$iv) {
                    void tag;
                    int n = index$iv++;
                    boolean bl = false;
                    if (n < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    int n2 = n;
                    KDocTag kDocTag = (KDocTag)item$iv;
                    int index2 = n2;
                    boolean bl2 = false;
                    String subjectName = tag.getSubjectName();
                    if (subjectName != null) {
                        DocumentationManagerUtil.createHyperlink((StringBuilder)$this$renderSection, (String)subjectName, (String)subjectName, (boolean)false);
                    } else {
                        $this$renderSection.append(tag.getContent());
                    }
                    if (index2 >= this.$seeTags.size() - 1) continue;
                    $this$renderSection.append(", ");
                }
            }
            {
                this.$seeTags = list2;
                super(1);
            }
        }));
    }

    private final void renderTagList(List<? extends KDocTag> tags, String title, StringBuilder to) {
        if (tags.isEmpty()) {
            return;
        }
        this.renderSection(to, title, (Function1<? super StringBuilder, Unit>)((Function1)new Function1<StringBuilder, Unit>(tags){
            final /* synthetic */ List $tags;

            public final void invoke(@NotNull StringBuilder $this$renderSection) {
                Intrinsics.checkParameterIsNotNull((Object)$this$renderSection, (String)"$receiver");
                Iterable $this$forEach$iv = this.$tags;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    KDocTag it = (KDocTag)element$iv;
                    boolean bl = false;
                    String string = it.getContent();
                    KDocRenderer kDocRenderer = KDocRenderer.INSTANCE;
                    StringBuilder stringBuilder2 = new StringBuilder().append("<p><code>").append(it.getSubjectName()).append("</code> - ");
                    StringBuilder stringBuilder3 = $this$renderSection;
                    boolean bl2 = false;
                    String string2 = string;
                    if (string2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                    }
                    String string3 = ((Object)StringsKt.trimStart((CharSequence)string2)).toString();
                    stringBuilder3.append(stringBuilder2.append(KDocRenderer.markdownToHtml$default(kDocRenderer, string3, false, 2, null)).toString());
                }
            }
            {
                this.$tags = list2;
                super(1);
            }
        }));
    }

    private final void renderTag(KDocTag tag, String title, StringBuilder to) {
        if (tag != null) {
            this.renderSection(to, title, (Function1<? super StringBuilder, Unit>)((Function1)new Function1<StringBuilder, Unit>(tag){
                final /* synthetic */ KDocTag $tag;

                public final void invoke(@NotNull StringBuilder $this$renderSection) {
                    Intrinsics.checkParameterIsNotNull((Object)$this$renderSection, (String)"$receiver");
                    $this$renderSection.append(KDocRenderer.markdownToHtml$default(KDocRenderer.INSTANCE, this.$tag.getContent(), false, 2, null));
                }
                {
                    this.$tag = kDocTag;
                    super(1);
                }
            }));
        }
    }

    @NotNull
    public final String markdownToHtml(@NotNull String markdown, boolean allowSingleParagraph) {
        Object v0;
        MarkdownNode markdownNode;
        block2: {
            Intrinsics.checkParameterIsNotNull((Object)markdown, (String)"markdown");
            ASTNode markdownTree = new MarkdownParser((MarkdownFlavourDescriptor)new CommonMarkFlavourDescriptor()).buildMarkdownTreeFromString(markdown);
            markdownNode = new MarkdownNode(markdownTree, null, markdown);
            Iterable $this$singleOrNull$iv = markdownNode.getChildren();
            boolean $i$f$singleOrNull = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$singleOrNull$iv) {
                MarkdownNode it = (MarkdownNode)element$iv;
                boolean bl = false;
                if (!(Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.EOL) ^ true)) continue;
                if (found$iv) {
                    v0 = null;
                    break block2;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            v0 = !found$iv ? null : single$iv;
        }
        MarkdownNode maybeSingleParagraph = v0;
        return maybeSingleParagraph != null && !allowSingleParagraph ? CollectionsKt.joinToString$default((Iterable)maybeSingleParagraph.getChildren(), (CharSequence)"", null, null, (int)0, null, (Function1)markdownToHtml.1.INSTANCE, (int)30, null) : this.toHtml(markdownNode);
    }

    public static /* synthetic */ String markdownToHtml$default(KDocRenderer kDocRenderer, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return kDocRenderer.markdownToHtml(string, bl);
    }

    private final void visit(@NotNull MarkdownNode $this$visit, Function2<? super MarkdownNode, ? super Function0<Unit>, Unit> action2) {
        action2.invoke((Object)$this$visit, (Object)new Function0<Unit>($this$visit, action2){
            final /* synthetic */ MarkdownNode $this_visit;
            final /* synthetic */ Function2 $action;

            public final void invoke() {
                for (MarkdownNode child : this.$this_visit.getChildren()) {
                    KDocRenderer.access$visit(KDocRenderer.INSTANCE, child, this.$action);
                }
            }
            {
                this.$this_visit = markdownNode;
                this.$action = function2;
                super(0);
            }
        });
    }

    private final String toHtml(@NotNull MarkdownNode $this$toHtml) {
        if (Intrinsics.areEqual((Object)$this$toHtml.getNode().getType(), (Object)MarkdownTokenTypes.WHITE_SPACE)) {
            return $this$toHtml.getText();
        }
        StringBuilder sb = new StringBuilder();
        this.visit($this$toHtml, (Function2<? super MarkdownNode, ? super Function0<Unit>, Unit>)((Function2)new Function2<MarkdownNode, Function0<? extends Unit>, Unit>(sb){
            final /* synthetic */ StringBuilder $sb;

            public final void invoke(@NotNull MarkdownNode node2, @NotNull Function0<Unit> processChildren) {
                Intrinsics.checkParameterIsNotNull((Object)node2, (String)"node");
                Intrinsics.checkParameterIsNotNull(processChildren, (String)"processChildren");
                Function2<String, Boolean, Unit> $fun$wrapChildren$1 = new Function2<String, Boolean, Unit>(this, processChildren){
                    final /* synthetic */ toHtml.1 this$0;
                    final /* synthetic */ Function0 $processChildren;

                    public final void invoke(@NotNull String tag, boolean newline) {
                        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
                        this.this$0.$sb.append('<' + tag + '>');
                        this.$processChildren.invoke();
                        this.this$0.$sb.append("</" + tag + '>');
                        if (newline) {
                            StringsKt.appendln((StringBuilder)this.this$0.$sb);
                        }
                    }

                    public static /* synthetic */ void invoke$default(toHtml.1 var0, String string, boolean bl, int n, Object object) {
                        if ((n & 2) != 0) {
                            bl = false;
                        }
                        var0.invoke(string, bl);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$processChildren = function0;
                        super(2);
                    }
                };
                IElementType nodeType = node2.getType();
                String nodeText = node2.getText();
                IElementType iElementType = nodeType;
                if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.UNORDERED_LIST)) {
                    $fun$wrapChildren$1.invoke("ul", true);
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.ORDERED_LIST)) {
                    $fun$wrapChildren$1.invoke("ol", true);
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.LIST_ITEM)) {
                    toHtml.1.invoke$default($fun$wrapChildren$1, "li", false, 2, null);
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.EMPH)) {
                    toHtml.1.invoke$default($fun$wrapChildren$1, "em", false, 2, null);
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.STRONG)) {
                    toHtml.1.invoke$default($fun$wrapChildren$1, "strong", false, 2, null);
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.ATX_1)) {
                    toHtml.1.invoke$default($fun$wrapChildren$1, "h1", false, 2, null);
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.ATX_2)) {
                    toHtml.1.invoke$default($fun$wrapChildren$1, "h2", false, 2, null);
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.ATX_3)) {
                    toHtml.1.invoke$default($fun$wrapChildren$1, "h3", false, 2, null);
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.ATX_4)) {
                    toHtml.1.invoke$default($fun$wrapChildren$1, "h4", false, 2, null);
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.ATX_5)) {
                    toHtml.1.invoke$default($fun$wrapChildren$1, "h5", false, 2, null);
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.ATX_6)) {
                    toHtml.1.invoke$default($fun$wrapChildren$1, "h6", false, 2, null);
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.BLOCK_QUOTE)) {
                    toHtml.1.invoke$default($fun$wrapChildren$1, "blockquote", false, 2, null);
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.PARAGRAPH)) {
                    KDocRenderer.access$trimEnd(KDocRenderer.INSTANCE, this.$sb);
                    $fun$wrapChildren$1.invoke("p", true);
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.CODE_SPAN)) {
                    String startDelimiter;
                    MarkdownNode markdownNode = node2.child(MarkdownTokenTypes.BACKTICK);
                    String string = startDelimiter = markdownNode != null ? markdownNode.getText() : null;
                    if (startDelimiter != null) {
                        String string2 = node2.getText();
                        int n = startDelimiter.length();
                        boolean bl = false;
                        String string3 = string2;
                        if (string3 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                        }
                        String string4 = string3.substring(n);
                        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
                        String text2 = StringsKt.removeSuffix((String)string4, (CharSequence)startDelimiter);
                        this.$sb.append("<code>").append(KDocRenderer.access$htmlEscape(KDocRenderer.INSTANCE, text2)).append("</code>");
                    }
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.CODE_BLOCK) || Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.CODE_FENCE)) {
                    KDocRenderer.access$trimEnd(KDocRenderer.INSTANCE, this.$sb);
                    this.$sb.append("<pre><code>");
                    processChildren.invoke();
                    this.$sb.append("</code></pre>");
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.SHORT_REFERENCE_LINK) || Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.FULL_REFERENCE_LINK)) {
                    List linkLabelContent;
                    List list2;
                    MarkdownNode linkLabelNode = node2.child(MarkdownElementTypes.LINK_LABEL);
                    Object object = linkLabelNode;
                    if (object != null && (object = ((MarkdownNode)object).getChildren()) != null) {
                        Iterable $this$dropWhile$iv = (Iterable)object;
                        boolean $i$f$dropWhile = false;
                        boolean yielding$iv = false;
                        ArrayList<T> list$iv = new ArrayList<T>();
                        for (T item$iv : $this$dropWhile$iv) {
                            if (yielding$iv) {
                                list$iv.add(item$iv);
                                continue;
                            }
                            MarkdownNode it = (MarkdownNode)item$iv;
                            boolean bl = false;
                            if (Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.LBRACKET)) continue;
                            list$iv.add(item$iv);
                            yielding$iv = true;
                        }
                        List $this$dropLastWhile$iv = list$iv;
                        boolean $i$f$dropLastWhile = false;
                        if (!$this$dropLastWhile$iv.isEmpty()) {
                            ListIterator<E> iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                            while (iterator$iv.hasPrevious()) {
                                MarkdownNode it = (MarkdownNode)iterator$iv.previous();
                                boolean bl = false;
                                if (Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.RBRACKET)) continue;
                                list2 = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                                break;
                            }
                        } else {
                            list2 = CollectionsKt.emptyList();
                        }
                    } else {
                        list2 = linkLabelContent = null;
                    }
                    if (linkLabelContent != null) {
                        String label2 = CollectionsKt.joinToString$default((Iterable)linkLabelContent, (CharSequence)"", null, null, (int)0, null, (Function1)toHtml.label.1.INSTANCE, (int)30, null);
                        Object object2 = node2.child(MarkdownElementTypes.LINK_TEXT);
                        if (object2 == null || (object2 = KDocRenderer.access$toHtml(KDocRenderer.INSTANCE, (MarkdownNode)object2)) == null) {
                            object2 = label2;
                        }
                        Object linkText = object2;
                        DocumentationManagerUtil.createHyperlink((StringBuilder)this.$sb, (String)label2, (String)linkText, (boolean)true);
                    } else {
                        this.$sb.append(node2.getText());
                    }
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.INLINE_LINK)) {
                    String destination;
                    MarkdownNode markdownNode = node2.child(MarkdownElementTypes.LINK_TEXT);
                    String label3 = markdownNode != null ? KDocRenderer.access$toHtml(KDocRenderer.INSTANCE, markdownNode) : null;
                    MarkdownNode markdownNode2 = node2.child(MarkdownElementTypes.LINK_DESTINATION);
                    String string = destination = markdownNode2 != null ? markdownNode2.getText() : null;
                    if (label3 != null && destination != null) {
                        this.$sb.append("<a href=\"" + destination + "\">" + label3 + "</a>");
                    } else {
                        this.$sb.append(node2.getText());
                    }
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.TEXT) || Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.WHITE_SPACE) || Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.COLON) || Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.SINGLE_QUOTE) || Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.DOUBLE_QUOTE) || Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.LPAREN) || Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.RPAREN) || Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.LBRACKET) || Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.RBRACKET) || Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.EXCLAMATION_MARK)) {
                    this.$sb.append(nodeText);
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.CODE_LINE)) {
                    this.$sb.append(KDocRenderer.access$htmlEscape(KDocRenderer.INSTANCE, StringsKt.removePrefix((String)nodeText, (CharSequence)KDocTag.Companion.getIndentationWhiteSpaces())));
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.CODE_FENCE_CONTENT)) {
                    this.$sb.append(KDocRenderer.access$htmlEscape(KDocRenderer.INSTANCE, nodeText));
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.EOL)) {
                    IElementType parentType;
                    MarkdownNode markdownNode = node2.getParent();
                    Object object = parentType = markdownNode != null ? markdownNode.getType() : null;
                    if (Intrinsics.areEqual((Object)parentType, (Object)MarkdownElementTypes.CODE_BLOCK) || Intrinsics.areEqual((Object)parentType, (Object)MarkdownElementTypes.CODE_FENCE)) {
                        this.$sb.append("\n");
                    } else {
                        this.$sb.append(" ");
                    }
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.GT)) {
                    this.$sb.append("&gt;");
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.LT)) {
                    this.$sb.append("&lt;");
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.LINK_TEXT)) {
                    List childrenWithoutBrackets = CollectionsKt.dropLast((List)CollectionsKt.drop((Iterable)node2.getChildren(), (int)1), (int)1);
                    for (MarkdownNode child : childrenWithoutBrackets) {
                        this.$sb.append(KDocRenderer.access$toHtml(KDocRenderer.INSTANCE, child));
                    }
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.EMPH)) {
                    IElementType parentNodeType;
                    MarkdownNode markdownNode = node2.getParent();
                    Object object = parentNodeType = markdownNode != null ? markdownNode.getType() : null;
                    if (Intrinsics.areEqual((Object)parentNodeType, (Object)MarkdownElementTypes.EMPH) ^ true && Intrinsics.areEqual((Object)parentNodeType, (Object)MarkdownElementTypes.STRONG) ^ true) {
                        this.$sb.append(node2.getText());
                    }
                } else {
                    processChildren.invoke();
                }
            }
            {
                this.$sb = stringBuilder2;
                super(2);
            }
        }));
        String string = sb.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sb.toString()");
        String string2 = string;
        boolean bl = false;
        String string3 = string2;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        return ((Object)StringsKt.trimEnd((CharSequence)string3)).toString();
    }

    private final void trimEnd(@NotNull StringBuilder $this$trimEnd) {
        while ($this$trimEnd.length() > 0 && $this$trimEnd.charAt($this$trimEnd.length() - 1) == ' ') {
            $this$trimEnd.deleteCharAt($this$trimEnd.length() - 1);
        }
    }

    private final String htmlEscape(@NotNull String $this$htmlEscape) {
        return StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)$this$htmlEscape, (String)"&", (String)"&amp;", (boolean)false, (int)4, null), (String)"<", (String)"&lt;", (boolean)false, (int)4, null), (String)">", (String)"&gt;", (boolean)false, (int)4, null);
    }

    private KDocRenderer() {
    }

    static {
        KDocRenderer kDocRenderer;
        INSTANCE = kDocRenderer = new KDocRenderer();
    }

    public static final /* synthetic */ void access$createHyperlink(KDocRenderer $this, KDocLink $this$access_u24createHyperlink, StringBuilder to) {
        $this.createHyperlink($this$access_u24createHyperlink, to);
    }

    public static final /* synthetic */ PsiElement access$getTargetElement(KDocRenderer $this, KDocLink $this$access_u24getTargetElement) {
        return $this.getTargetElement($this$access_u24getTargetElement);
    }

    public static final /* synthetic */ String access$htmlEscape(KDocRenderer $this, String $this$access_u24htmlEscape) {
        return $this.htmlEscape($this$access_u24htmlEscape);
    }

    public static final /* synthetic */ String access$trimCommonIndent(KDocRenderer $this, String text2) {
        return $this.trimCommonIndent(text2);
    }

    public static final /* synthetic */ String access$extractExampleText(KDocRenderer $this, PsiElement $this$access_u24extractExampleText) {
        return $this.extractExampleText($this$access_u24extractExampleText);
    }

    public static final /* synthetic */ String access$toHtml(KDocRenderer $this, MarkdownNode $this$access_u24toHtml) {
        return $this.toHtml($this$access_u24toHtml);
    }

    public static final /* synthetic */ void access$visit(KDocRenderer $this, MarkdownNode $this$access_u24visit, Function2 action2) {
        $this.visit($this$access_u24visit, (Function2<? super MarkdownNode, ? super Function0<Unit>, Unit>)action2);
    }

    public static final /* synthetic */ void access$trimEnd(KDocRenderer $this, StringBuilder $this$access_u24trimEnd) {
        $this.trimEnd($this$access_u24trimEnd);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u00002\u0006\u0010\u001a\u001a\u00020\u001bR\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00000\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u000fR\u0011\u0010\u0018\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0011R\u0011\u0010\u001a\u001a\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/idea/kdoc/KDocRenderer$MarkdownNode;", "", "node", "Lorg/intellij/markdown/ast/ASTNode;", "parent", "markdown", "", "(Lorg/intellij/markdown/ast/ASTNode;Lorg/jetbrains/kotlin/idea/kdoc/KDocRenderer$MarkdownNode;Ljava/lang/String;)V", "children", "", "getChildren", "()Ljava/util/List;", "endOffset", "", "getEndOffset", "()I", "getMarkdown", "()Ljava/lang/String;", "getNode", "()Lorg/intellij/markdown/ast/ASTNode;", "getParent", "()Lorg/jetbrains/kotlin/idea/kdoc/KDocRenderer$MarkdownNode;", "startOffset", "getStartOffset", "text", "getText", "type", "Lorg/intellij/markdown/IElementType;", "getType", "()Lorg/intellij/markdown/IElementType;", "child", "idea"})
    public static final class MarkdownNode {
        @NotNull
        private final List<MarkdownNode> children;
        @NotNull
        private final ASTNode node;
        @Nullable
        private final MarkdownNode parent;
        @NotNull
        private final String markdown;

        @NotNull
        public final List<MarkdownNode> getChildren() {
            return this.children;
        }

        public final int getEndOffset() {
            return this.node.getEndOffset();
        }

        public final int getStartOffset() {
            return this.node.getStartOffset();
        }

        @NotNull
        public final IElementType getType() {
            return this.node.getType();
        }

        @NotNull
        public final String getText() {
            String string = this.markdown;
            int n = this.getStartOffset();
            int n2 = this.getEndOffset();
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n, n2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            return string3;
        }

        @Nullable
        public final MarkdownNode child(@NotNull IElementType type2) {
            Object v0;
            block1: {
                Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
                Iterable $this$firstOrNull$iv = this.children;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    MarkdownNode it = (MarkdownNode)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getType(), (Object)type2)) continue;
                    v0 = element$iv;
                    break block1;
                }
                v0 = null;
            }
            return v0;
        }

        @NotNull
        public final ASTNode getNode() {
            return this.node;
        }

        @Nullable
        public final MarkdownNode getParent() {
            return this.parent;
        }

        @NotNull
        public final String getMarkdown() {
            return this.markdown;
        }

        /*
         * WARNING - void declaration
         */
        public MarkdownNode(@NotNull ASTNode node2, @Nullable MarkdownNode parent2, @NotNull String markdown) {
            Collection<MarkdownNode> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkParameterIsNotNull((Object)node2, (String)"node");
            Intrinsics.checkParameterIsNotNull((Object)markdown, (String)"markdown");
            this.node = node2;
            this.parent = parent2;
            this.markdown = markdown;
            Iterable iterable = this.node.getChildren();
            MarkdownNode markdownNode = this;
            boolean $i$f$map = false;
            void var6_7 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ASTNode aSTNode = (ASTNode)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                MarkdownNode markdownNode2 = new MarkdownNode((ASTNode)it, this, this.markdown);
                collection.add(markdownNode2);
            }
            collection = (List)destination$iv$iv;
            markdownNode.children = collection;
        }
    }
}

