/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring;

import com.intellij.codeInsight.unwrap.ScopeHighlighter;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.ui.popup.JBPopupAdapter;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.components.JBList;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.util.CodeInsightUtils;
import org.jetbrains.kotlin.idea.refactoring.ElementRenderingUtilsKt;
import org.jetbrains.kotlin.idea.refactoring.ElementSelectionUtilsKt;
import org.jetbrains.kotlin.idea.refactoring.ElementSelectionUtilsKt$WhenMappings;
import org.jetbrains.kotlin.idea.refactoring.IntroduceRefactoringException;
import org.jetbrains.kotlin.idea.refactoring.introduce.IntroduceUtilKt;
import org.jetbrains.kotlin.kdoc.psi.api.KDoc;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallElement;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtEscapeStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLiteralStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtOperationExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtStatementExpression;
import org.jetbrains.kotlin.psi.KtSuperExpression;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtUserType;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000V\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a2\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e\u001a$\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00102\u0006\u0010\u0002\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n\u001aB\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\b2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\n0\u00192\u0014\u0010\u001a\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0012\u0004\u0012\u00020\u00140\u001b\u001a:\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\n0\u00192\u0014\u0010\u001a\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0012\u0004\u0012\u00020\u00140\u001b\u001aL\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0002\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\b2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\n0\u00192\u0014\u0010\u001a\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0012\u0004\u0012\u00020\u00140\u001bH\u0002\u00a8\u0006\u001d"}, d2={"findElement", "Lcom/intellij/psi/PsiElement;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "startOffset", "", "endOffset", "failOnNoExpression", "", "elementKind", "Lorg/jetbrains/kotlin/idea/core/util/CodeInsightUtils$ElementKind;", "getExpressionShortText", "", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "getSmartSelectSuggestions", "", "Lcom/intellij/psi/PsiFile;", "offset", "selectElement", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "failOnEmptySuggestion", "elementKinds", "", "callback", "Lkotlin/Function1;", "smartSelectElement", "idea"})
public final class ElementSelectionUtilsKt {
    public static final void selectElement(@NotNull Editor editor2, @NotNull KtFile file2, @NotNull Collection<? extends CodeInsightUtils.ElementKind> elementKinds, @NotNull Function1<? super PsiElement, Unit> callback2) throws IntroduceRefactoringException {
        Intrinsics.checkParameterIsNotNull((Object)editor2, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Intrinsics.checkParameterIsNotNull(elementKinds, (String)"elementKinds");
        Intrinsics.checkParameterIsNotNull(callback2, (String)"callback");
        ElementSelectionUtilsKt.selectElement(editor2, file2, true, elementKinds, callback2);
    }

    /*
     * WARNING - void declaration
     */
    public static final void selectElement(@NotNull Editor editor2, @NotNull KtFile file2, boolean failOnEmptySuggestion, @NotNull Collection<? extends CodeInsightUtils.ElementKind> elementKinds, @NotNull Function1<? super PsiElement, Unit> callback2) throws IntroduceRefactoringException {
        Intrinsics.checkParameterIsNotNull((Object)editor2, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Intrinsics.checkParameterIsNotNull(elementKinds, (String)"elementKinds");
        Intrinsics.checkParameterIsNotNull(callback2, (String)"callback");
        if (editor2.getSelectionModel().hasSelection()) {
            void selectionEnd;
            void selectionStart;
            Ref.IntRef intRef = new Ref.IntRef();
            SelectionModel selectionModel = editor2.getSelectionModel();
            Intrinsics.checkExpressionValueIsNotNull((Object)selectionModel, (String)"editor.selectionModel");
            intRef.element = selectionModel.getSelectionStart();
            Ref.IntRef intRef2 = new Ref.IntRef();
            SelectionModel selectionModel2 = editor2.getSelectionModel();
            Intrinsics.checkExpressionValueIsNotNull((Object)selectionModel2, (String)"editor.selectionModel");
            intRef2.element = selectionModel2.getSelectionEnd();
            PsiElement psiElement2 = file2.findElementAt(selectionStart.element);
            if (psiElement2 == null) {
                Intrinsics.throwNpe();
            }
            PsiElement firstElement = psiElement2;
            PsiElement psiElement3 = file2.findElementAt(selectionEnd.element - 1);
            if (psiElement3 == null) {
                Intrinsics.throwNpe();
            }
            PsiElement lastElement = psiElement3;
            if (PsiTreeUtil.getParentOfType((PsiElement)firstElement, (Class[])new Class[]{KtLiteralStringTemplateEntry.class, KtEscapeStringTemplateEntry.class}) == null && PsiTreeUtil.getParentOfType((PsiElement)lastElement, (Class[])new Class[]{KtLiteralStringTemplateEntry.class, KtEscapeStringTemplateEntry.class}) == null) {
                PsiElement psiElement4 = PsiUtilsKt.getNextSiblingIgnoringWhitespaceAndComments(firstElement, true);
                if (psiElement4 == null) {
                    Intrinsics.throwNpe();
                }
                firstElement = psiElement4;
                PsiElement psiElement5 = PsiUtilsKt.getPrevSiblingIgnoringWhitespaceAndComments(lastElement, true);
                if (psiElement5 == null) {
                    Intrinsics.throwNpe();
                }
                lastElement = psiElement5;
                TextRange textRange = firstElement.getTextRange();
                Intrinsics.checkExpressionValueIsNotNull((Object)textRange, (String)"firstElement.textRange");
                selectionStart.element = textRange.getStartOffset();
                TextRange textRange2 = lastElement.getTextRange();
                Intrinsics.checkExpressionValueIsNotNull((Object)textRange2, (String)"lastElement.textRange");
                selectionEnd.element = textRange2.getEndOffset();
            }
            PsiElement element3 = (PsiElement)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)elementKinds), (Function1)((Function1)new Function1<CodeInsightUtils.ElementKind, PsiElement>(file2, (Ref.IntRef)selectionStart, (Ref.IntRef)selectionEnd, failOnEmptySuggestion){
                final /* synthetic */ KtFile $file;
                final /* synthetic */ Ref.IntRef $selectionStart;
                final /* synthetic */ Ref.IntRef $selectionEnd;
                final /* synthetic */ boolean $failOnEmptySuggestion;

                @Nullable
                public final PsiElement invoke(@NotNull CodeInsightUtils.ElementKind it) {
                    Intrinsics.checkParameterIsNotNull((Object)((Object)it), (String)"it");
                    return ElementSelectionUtilsKt.access$findElement(this.$file, this.$selectionStart.element, this.$selectionEnd.element, this.$failOnEmptySuggestion, it);
                }
                {
                    this.$file = ktFile;
                    this.$selectionStart = intRef;
                    this.$selectionEnd = intRef2;
                    this.$failOnEmptySuggestion = bl;
                    super(1);
                }
            })));
            callback2.invoke((Object)element3);
        } else {
            CaretModel caretModel = editor2.getCaretModel();
            Intrinsics.checkExpressionValueIsNotNull((Object)caretModel, (String)"editor.caretModel");
            int offset2 = caretModel.getOffset();
            ElementSelectionUtilsKt.smartSelectElement(editor2, (PsiFile)file2, offset2, failOnEmptySuggestion, elementKinds, callback2);
        }
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public static final List<KtElement> getSmartSelectSuggestions(@NotNull PsiFile file, int offset, @NotNull CodeInsightUtils.ElementKind elementKind) throws IntroduceRefactoringException {
        block31: {
            block30: {
                Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
                Intrinsics.checkParameterIsNotNull((Object)elementKind, (String)"elementKind");
                if (offset < 0) {
                    return CollectionsKt.emptyList();
                }
                v0 = file.findElementAt(offset);
                if (v0 == null) {
                    return CollectionsKt.emptyList();
                }
                element = v0;
                if (element instanceof PsiWhiteSpace || Intrinsics.areEqual((Object)((v1 = element) != null && (v1 = v1.getNode()) != null ? v1.getElementType() : null), (Object)KtTokens.RPAR) || element instanceof PsiComment) break block30;
                v2 = element;
                if (v2 != null) {
                    $this$getStrictParentOfType$iv = v2;
                    $i$f$getStrictParentOfType = false;
                    v3 = (KDoc)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KDoc.class, (boolean)true);
                } else {
                    v3 = null;
                }
                if (v3 == null) break block31;
            }
            return ElementSelectionUtilsKt.getSmartSelectSuggestions(file, offset - 1, elementKind);
        }
        elements = new ArrayList<KtElement>();
        while (!(element == null || element instanceof KtBlockExpression && !(((KtBlockExpression)element).getParent() instanceof KtFunctionLiteral) || element instanceof KtNamedFunction || element instanceof KtClassBody)) {
            block33: {
                block32: {
                    addElement = false;
                    keepPrevious = true;
                    if (!(element instanceof KtTypeElement)) break block32;
                    if (elementKind != CodeInsightUtils.ElementKind.TYPE_ELEMENT) ** GOTO lbl-1000
                    var7_7 = element;
                    var8_8 = true;
                    branch$iv = getSmartSelectSuggestions.1.INSTANCE;
                    $i$f$getParentOfTypeAndBranch = false;
                    $this$getParentOfType$iv$iv = $this$getParentOfTypeAndBranch$iv;
                    $i$f$getParentOfType = false;
                    v4 = PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv$iv, KtUserType.class, (boolean)strict$iv);
                    if ((v4 != null ? PsiUtilsKt.getIfChildIsInBranch(v4, (PsiElement)$this$getParentOfTypeAndBranch$iv, branch$iv) : null) == null) {
                        v5 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v5 = addElement = false;
                    }
                    if (!addElement) {
                        keepPrevious = false;
                    }
                    break block33;
                }
                if (element instanceof KtExpression && !(element instanceof KtStatementExpression)) {
                    v6 = addElement = elementKind == CodeInsightUtils.ElementKind.EXPRESSION;
                    if (addElement) {
                        if (element instanceof KtParenthesizedExpression) {
                            addElement = false;
                        } else if (KtPsiUtil.isLabelIdentifierExpression(element)) {
                            addElement = false;
                        } else if (((KtExpression)element).getParent() instanceof KtQualifiedExpression) {
                            v7 = ((KtExpression)element).getParent();
                            if (v7 == null) {
                                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtQualifiedExpression");
                            }
                            qualifiedExpression = (KtQualifiedExpression)v7;
                            if (qualifiedExpression.getReceiverExpression() != element) {
                                addElement = false;
                            }
                        } else if (((KtExpression)element).getParent() instanceof KtCallElement || ((KtExpression)element).getParent() instanceof KtThisExpression || PsiTreeUtil.getParentOfType((PsiElement)element, KtSuperExpression.class) != null) {
                            addElement = false;
                        } else if (((KtExpression)element).getParent() instanceof KtOperationExpression) {
                            v8 = ((KtExpression)element).getParent();
                            if (v8 == null) {
                                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtOperationExpression");
                            }
                            operationExpression = (KtOperationExpression)v8;
                            if (operationExpression.getOperationReference() == element) {
                                addElement = false;
                            }
                        }
                        if (addElement && ((expressionType = (bindingContext = ResolutionUtils.analyze((KtElement)((KtElement)element), (BodyResolveMode)BodyResolveMode.FULL)).getType((KtExpression)element)) == null || KotlinBuiltIns.isUnit(expressionType))) {
                            addElement = false;
                        }
                    }
                }
            }
            if (addElement) {
                elements.add((KtElement)element);
            }
            if (!keepPrevious) {
                elements.clear();
            }
            element = element.getParent();
        }
        return elements;
    }

    /*
     * WARNING - void declaration
     */
    private static final void smartSelectElement(Editor editor2, PsiFile file2, int offset2, boolean failOnEmptySuggestion, Collection<? extends CodeInsightUtils.ElementKind> elementKinds, Function1<? super PsiElement, Unit> callback2) throws IntroduceRefactoringException {
        List elements2;
        block13: {
            block12: {
                void $this$flatMapTo$iv$iv;
                Iterable $this$flatMap$iv = elementKinds;
                boolean $i$f$flatMap = false;
                Iterable iterable = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                    CodeInsightUtils.ElementKind it = (CodeInsightUtils.ElementKind)((Object)element$iv$iv);
                    boolean bl = false;
                    Iterable list$iv$iv = ElementSelectionUtilsKt.getSmartSelectSuggestions(file2, offset2, it);
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                elements2 = (List)destination$iv$iv;
                if (elements2.isEmpty()) {
                    if (failOnEmptySuggestion) {
                        throw (Throwable)new IntroduceRefactoringException(KotlinBundle.message("cannot.refactor.not.expression", new Object[0]));
                    }
                    callback2.invoke(null);
                    return;
                }
                if (elements2.size() == 1) break block12;
                Application application = ApplicationManager.getApplication();
                Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
                if (!application.isUnitTestMode()) break block13;
            }
            callback2.invoke(CollectionsKt.first((List)elements2));
            return;
        }
        DefaultListModel<KtElement> model2 = new DefaultListModel<KtElement>();
        Iterable $this$forEach$iv = elements2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KtElement it = (KtElement)element$iv;
            boolean bl = false;
            model2.addElement(it);
        }
        ScopeHighlighter highlighter = new ScopeHighlighter(editor2);
        JBList list2 = new JBList((ListModel)model2);
        list2.setCellRenderer((ListCellRenderer)new DefaultListCellRenderer(){

            @NotNull
            public Component getListCellRendererComponent(@NotNull JList<?> list2, @Nullable Object value2, int index2, boolean isSelected, boolean cellHasFocus) {
                KtElement element3;
                Intrinsics.checkParameterIsNotNull(list2, (String)"list");
                Component rendererComponent = super.getListCellRendererComponent(list2, value2, index2, isSelected, cellHasFocus);
                KtElement ktElement = element3 = (KtElement)value2;
                if (ktElement == null) {
                    Intrinsics.throwNpe();
                }
                if (ktElement.isValid()) {
                    this.setText(ElementSelectionUtilsKt.getExpressionShortText(element3));
                }
                Component component2 = rendererComponent;
                Intrinsics.checkExpressionValueIsNotNull((Object)component2, (String)"rendererComponent");
                return component2;
            }
        });
        list2.addListSelectionListener(new ListSelectionListener(highlighter, list2, model2){
            final /* synthetic */ ScopeHighlighter $highlighter;
            final /* synthetic */ JBList $list;
            final /* synthetic */ DefaultListModel $model;

            public final void valueChanged(ListSelectionEvent it) {
                this.$highlighter.dropHighlight();
                int selectedIndex = this.$list.getSelectedIndex();
                if (selectedIndex < 0) {
                    return;
                }
                ArrayList<E> toExtract = new ArrayList<E>();
                toExtract.add(this.$model.get(selectedIndex));
                this.$highlighter.highlight((PsiElement)this.$model.get(selectedIndex), (List)toExtract);
            }
            {
                this.$highlighter = scopeHighlighter;
                this.$list = jBList;
                this.$model = defaultListModel;
            }
        });
        String title = "Elements";
        if (elementKinds.size() == 1) {
            String string;
            switch (ElementSelectionUtilsKt$WhenMappings.$EnumSwitchMapping$0[elementKinds.iterator().next().ordinal()]) {
                case 1: {
                    string = "Expressions";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Types";
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            title = string;
        }
        JBPopupFactory.getInstance().createListPopupBuilder((JList)list2).setTitle(title).setMovable(false).setResizable(false).setRequestFocus(true).setItemChoosenCallback(new Runnable(callback2, list2){
            final /* synthetic */ Function1 $callback;
            final /* synthetic */ JBList $list;

            public final void run() {
                Object object = this.$list.getSelectedValue();
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtElement");
                }
                this.$callback.invoke((Object)((KtElement)object));
            }
            {
                this.$callback = function1;
                this.$list = jBList;
            }
        }).addListener((JBPopupListener)new JBPopupAdapter(highlighter){
            final /* synthetic */ ScopeHighlighter $highlighter;

            public void onClosed(@NotNull LightweightWindowEvent event) {
                Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                this.$highlighter.dropHighlight();
            }
            {
                this.$highlighter = $captured_local_variable$0;
            }
        }).createPopup().showInBestPositionFor(editor2);
    }

    @NotNull
    public static final String getExpressionShortText(@NotNull KtElement element3) {
        int n;
        int n2;
        int n3;
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        String string = ElementRenderingUtilsKt.renderTrimmed(element3);
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        String text2 = ((Object)StringsKt.trimStart((CharSequence)string2)).toString();
        int firstNewLinePos = StringsKt.indexOf$default((CharSequence)text2, (char)'\n', (int)0, (boolean)false, (int)6, null);
        String string3 = text2;
        int n4 = 0;
        if (firstNewLinePos != -1) {
            n3 = firstNewLinePos;
        } else {
            n2 = 100;
            n = text2.length();
            boolean bl2 = false;
            n3 = Math.min(n2, n);
        }
        n2 = n3;
        n = 0;
        String string4 = string3;
        if (string4 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string5 = string4.substring(n4, n2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String trimmedText = string5;
        if (trimmedText.length() != text2.length()) {
            trimmedText = trimmedText + " ...";
        }
        return trimmedText;
    }

    private static final PsiElement findElement(KtFile file2, int startOffset, int endOffset, boolean failOnNoExpression, CodeInsightUtils.ElementKind elementKind) throws IntroduceRefactoringException {
        PsiElement element3 = CodeInsightUtils.findElement((PsiFile)file2, startOffset, endOffset, elementKind);
        if (element3 == null && elementKind == CodeInsightUtils.ElementKind.EXPRESSION) {
            element3 = (PsiElement)IntroduceUtilKt.findExpressionOrStringFragment(file2, startOffset, endOffset);
        }
        if (element3 == null) {
            if (failOnNoExpression) {
                throw (Throwable)new IntroduceRefactoringException(KotlinBundle.message("cannot.refactor.not.expression", new Object[0]));
            }
            return null;
        }
        return element3;
    }

    public static final /* synthetic */ PsiElement access$findElement(KtFile file2, int startOffset, int endOffset, boolean failOnNoExpression, CodeInsightUtils.ElementKind elementKind) {
        return ElementSelectionUtilsKt.findElement(file2, startOffset, endOffset, failOnNoExpression, elementKind);
    }
}

