/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.tools.projectWizard.wizard;

import com.intellij.ide.projectWizard.ProjectSettingsStep;
import com.intellij.ide.util.projectWizard.EmptyModuleBuilder;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.ide.util.projectWizard.ModuleNameLocationSettings;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.ProjectWizardUtil;
import com.intellij.ide.util.projectWizard.SettingsStep;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.ui.Messages;
import com.intellij.util.SystemProperties;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.configuration.ExperimentalFeatures;
import org.jetbrains.kotlin.idea.framework.KotlinModuleSettingStep;
import org.jetbrains.kotlin.idea.framework.KotlinTemplatesFactory;
import org.jetbrains.kotlin.idea.projectWizard.ProjectCreationStats;
import org.jetbrains.kotlin.idea.projectWizard.UiEditorUsageStats;
import org.jetbrains.kotlin.idea.projectWizard.WizardStatsService;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.platform.jvm.JvmPlatforms;
import org.jetbrains.kotlin.tools.projectWizard.core.Error;
import org.jetbrains.kotlin.tools.projectWizard.core.Failure;
import org.jetbrains.kotlin.tools.projectWizard.core.TaskResult;
import org.jetbrains.kotlin.tools.projectWizard.core.TaskResultKt;
import org.jetbrains.kotlin.tools.projectWizard.core.ValuesReadingContext;
import org.jetbrains.kotlin.tools.projectWizard.core.entity.PluginSettingReference;
import org.jetbrains.kotlin.tools.projectWizard.core.entity.SettingReference;
import org.jetbrains.kotlin.tools.projectWizard.core.entity.SettingType;
import org.jetbrains.kotlin.tools.projectWizard.core.entity.StringValidators;
import org.jetbrains.kotlin.tools.projectWizard.core.entity.ValidationResult;
import org.jetbrains.kotlin.tools.projectWizard.phases.GenerationPhase;
import org.jetbrains.kotlin.tools.projectWizard.plugins.Plugins;
import org.jetbrains.kotlin.tools.projectWizard.plugins.buildSystem.BuildSystemType;
import org.jetbrains.kotlin.tools.projectWizard.projectTemplates.ProjectTemplate;
import org.jetbrains.kotlin.tools.projectWizard.wizard.IdeWizard;
import org.jetbrains.kotlin.tools.projectWizard.wizard.KotlinNewProjectWizardBundle;
import org.jetbrains.kotlin.tools.projectWizard.wizard.ModuleNewWizardFirstStep;
import org.jetbrains.kotlin.tools.projectWizard.wizard.ModuleNewWizardSecondStep;
import org.jetbrains.kotlin.tools.projectWizard.wizard.NewProjectWizardModuleBuilder;
import org.jetbrains.kotlin.tools.projectWizard.wizard.NewProjectWizardModuleBuilder$WhenMappings;
import org.jetbrains.kotlin.tools.projectWizard.wizard.NewProjectWizardModuleBuilder$updateProjectNameAndPomDate$suggestedProjectName$1$1;
import org.jetbrains.kotlin.tools.projectWizard.wizard.NewProjectWizardModuleType;
import org.jetbrains.kotlin.tools.projectWizard.wizard.PomWizardStep;
import org.jetbrains.kotlin.tools.projectWizard.wizard.Wizard;
import org.jetbrains.kotlin.tools.projectWizard.wizard.service.IdeaServices;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000b\u0018\u0000 52\u00020\u0001:\u00015B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u00020\nH\u0016J,\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J#\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016\u00a2\u0006\u0002\u0010\u0017J\u001c\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\b2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016J\n\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0016J\n\u0010\u001f\u001a\u0004\u0018\u00010\u001eH\u0016J\f\u0010 \u001a\u0006\u0012\u0002\b\u00030!H\u0016J\b\u0010\"\u001a\u00020\u001eH\u0016J\b\u0010#\u001a\u00020\u001eH\u0016J\b\u0010$\u001a\u00020\nH\u0014J\b\u0010%\u001a\u00020\nH\u0016J\b\u0010&\u001a\u00020\nH\u0016J\u0010\u0010'\u001a\u00020\u00162\u0006\u0010(\u001a\u00020)H\u0016J\u0010\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u001eH\u0016J\u0010\u0010-\u001a\u00020+2\u0006\u0010.\u001a\u00020\u001eH\u0016J\u0010\u0010/\u001a\u00020+2\u0006\u00100\u001a\u00020\u001eH\u0016J\b\u00101\u001a\u00020\u001eH\u0002J\u0010\u00102\u001a\u00020+2\u0006\u0010(\u001a\u00020)H\u0002J\u0010\u00103\u001a\u00020\n2\u0006\u00104\u001a\u00020\u001eH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u00066"}, d2={"Lorg/jetbrains/kotlin/tools/projectWizard/wizard/NewProjectWizardModuleBuilder;", "Lcom/intellij/ide/util/projectWizard/EmptyModuleBuilder;", "()V", "uiEditorUsagesStats", "Lorg/jetbrains/kotlin/idea/projectWizard/UiEditorUsageStats;", "wizard", "Lorg/jetbrains/kotlin/tools/projectWizard/wizard/IdeWizard;", "wizardContext", "Lcom/intellij/ide/util/projectWizard/WizardContext;", "canCreateModule", "", "commit", "", "Lcom/intellij/openapi/module/Module;", "project", "Lcom/intellij/openapi/project/Project;", "model", "Lcom/intellij/openapi/module/ModifiableModuleModel;", "modulesProvider", "Lcom/intellij/openapi/roots/ui/configuration/ModulesProvider;", "createWizardSteps", "", "Lcom/intellij/ide/util/projectWizard/ModuleWizardStep;", "(Lcom/intellij/ide/util/projectWizard/WizardContext;Lcom/intellij/openapi/roots/ui/configuration/ModulesProvider;)[Lcom/intellij/ide/util/projectWizard/ModuleWizardStep;", "getCustomOptionsStep", "Lorg/jetbrains/kotlin/tools/projectWizard/wizard/ModuleNewWizardFirstStep;", "context", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "getDescription", "", "getGroupName", "getModuleType", "Lcom/intellij/openapi/module/ModuleType;", "getParentGroup", "getPresentableName", "isAvailable", "isOpenProjectSettingsAfter", "isTemplateBased", "modifySettingsStep", "settingsStep", "Lcom/intellij/ide/util/projectWizard/SettingsStep;", "setContentEntryPath", "", "moduleRootPath", "setModuleFilePath", "path", "setName", "name", "suggestGroupId", "updateProjectNameAndPomDate", "validateModuleName", "moduleName", "Companion", "idea-new-project-wizard"})
public final class NewProjectWizardModuleBuilder
extends EmptyModuleBuilder {
    private final IdeWizard wizard = new IdeWizard(Plugins.INSTANCE.getAllPlugins(), IdeaServices.INSTANCE.getPROJECT_INDEPENDENT(), false);
    private final UiEditorUsageStats uiEditorUsagesStats = new UiEditorUsageStats(0, 0, 0, 0, 15, null);
    private WizardContext wizardContext;
    @NotNull
    public static final String MODULE_BUILDER_ID = "kotlin.newProjectWizard.builder";
    private static final String DEFAULT_GROUP_ID = "me.user";
    private static final Function2<ValuesReadingContext, String, ValidationResult> projectNameValidator;
    private static final String INVALID_PROJECT_NAME_MESSAGE;
    public static final Companion Companion;

    public boolean isOpenProjectSettingsAfter() {
        return false;
    }

    public boolean canCreateModule() {
        return false;
    }

    @NotNull
    public String getPresentableName() {
        String string = this.getModuleType().getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"moduleType.name");
        return string;
    }

    @Nullable
    public String getDescription() {
        return this.getModuleType().getDescription();
    }

    @Nullable
    public String getGroupName() {
        return this.getModuleType().getName();
    }

    public boolean isTemplateBased() {
        return false;
    }

    protected boolean isAvailable() {
        return ExperimentalFeatures.INSTANCE.getNewWizard().isEnabled();
    }

    @NotNull
    public ModuleType<?> getModuleType() {
        return new NewProjectWizardModuleType();
    }

    @NotNull
    public String getParentGroup() {
        return KotlinTemplatesFactory.Companion.getKOTLIN_PARENT_GROUP_NAME();
    }

    @NotNull
    public ModuleWizardStep[] createWizardSteps(@NotNull WizardContext wizardContext, @NotNull ModulesProvider modulesProvider) {
        Intrinsics.checkParameterIsNotNull((Object)wizardContext, (String)"wizardContext");
        Intrinsics.checkParameterIsNotNull((Object)modulesProvider, (String)"modulesProvider");
        this.wizardContext = wizardContext;
        return new ModuleWizardStep[]{new ModuleNewWizardSecondStep(this.wizard, this.uiEditorUsagesStats)};
    }

    @Nullable
    public List<Module> commit(@NotNull Project project2, @Nullable ModifiableModuleModel model2, @Nullable ModulesProvider modulesProvider) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        ModifiableModuleModel modifiableModuleModel = model2;
        if (modifiableModuleModel == null) {
            ModuleManager moduleManager = ModuleManager.getInstance((Project)project2);
            Intrinsics.checkExpressionValueIsNotNull((Object)moduleManager, (String)"ModuleManager.getInstance(project)");
            ModifiableModuleModel modifiableModuleModel2 = moduleManager.getModifiableModel();
            modifiableModuleModel = modifiableModuleModel2;
            Intrinsics.checkExpressionValueIsNotNull((Object)modifiableModuleModel2, (String)"ModuleManager.getInstance(project).modifiableModel");
        }
        ModifiableModuleModel modulesModel = modifiableModuleModel;
        TaskResult $this$onFailure$iv = Wizard.apply$default(this.wizard, CollectionsKt.plus((Collection)IdeaServices.INSTANCE.createScopeDependent(project2, modulesModel), (Iterable)IdeaServices.INSTANCE.getPROJECT_INDEPENDENT()), GenerationPhase.Companion.startingFrom(GenerationPhase.FIRST_STEP), null, 4, null);
        boolean $i$f$onFailure = false;
        TaskResult taskResult = $this$onFailure$iv;
        boolean bl = false;
        boolean bl2 = false;
        TaskResult $this$apply$iv = taskResult;
        boolean bl3 = false;
        if ($this$apply$iv instanceof Failure) {
            List<Error> errors = ((Failure)$this$apply$iv).getErrors();
            boolean bl4 = false;
            String errorMessages2 = CollectionsKt.joinToString$default((Iterable)errors, (CharSequence)"\n", null, null, (int)0, null, (Function1)commit.success.1.errorMessages.1.INSTANCE, (int)30, null);
            Messages.showErrorDialog((Project)project2, (String)errorMessages2, (String)KotlinNewProjectWizardBundle.message("error.following", new Object[0]));
        }
        boolean success2 = TaskResultKt.isSuccess(taskResult);
        if (success2) {
            ProjectTemplate projectTemplate2 = this.wizard.getProjectTemplate();
            if (projectTemplate2 == null) {
                Intrinsics.throwNpe();
            }
            String string = projectTemplate2.getTitle();
            BuildSystemType buildSystemType2 = this.wizard.getBuildSystemType();
            if (buildSystemType2 == null) {
                Intrinsics.throwNpe();
            }
            ProjectCreationStats projectCreationStats = new ProjectCreationStats(string, buildSystemType2.getText());
            WizardStatsService.INSTANCE.logDataOnProjectGenerated(projectCreationStats, this.uiEditorUsagesStats);
        }
        return !success2 ? null : (this.wizard.getBuildSystemType() == BuildSystemType.Jps ? (List)ApplicationUtilsKt.runWriteAction((Function0)new Function0<List<? extends Module>>(this, modulesModel){
            final /* synthetic */ NewProjectWizardModuleBuilder this$0;
            final /* synthetic */ ModifiableModuleModel $modulesModel;

            @NotNull
            public final List<Module> invoke() {
                Object[] objectArray = this.$modulesModel.getModules();
                Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"modulesModel.modules");
                Iterable $this$onEach$iv = ArraysKt.toList((Object[])objectArray);
                boolean $i$f$onEach = false;
                Iterable iterable = $this$onEach$iv;
                boolean bl = false;
                boolean bl2 = false;
                Iterable $this$apply$iv = iterable;
                boolean bl3 = false;
                for (T element$iv : $this$apply$iv) {
                    Module it = (Module)element$iv;
                    boolean bl4 = false;
                    NewProjectWizardModuleBuilder.access$setupModule(this.this$0, it);
                }
                return (List)iterable;
            }
            {
                this.this$0 = newProjectWizardModuleBuilder;
                this.$modulesModel = modifiableModuleModel;
                super(0);
            }
        }) : CollectionsKt.emptyList());
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public ModuleWizardStep modifySettingsStep(@NotNull SettingsStep settingsStep) {
        ModuleWizardStep moduleWizardStep;
        Intrinsics.checkParameterIsNotNull((Object)settingsStep, (String)"settingsStep");
        this.updateProjectNameAndPomDate(settingsStep);
        BuildSystemType buildSystemType2 = this.wizard.getBuildSystemType();
        if (buildSystemType2 != null) {
            switch (NewProjectWizardModuleBuilder$WhenMappings.$EnumSwitchMapping$0[buildSystemType2.ordinal()]) {
                case 1: {
                    moduleWizardStep = new KotlinModuleSettingStep(JvmPlatforms.INSTANCE.getDefaultJvmPlatform(), (ModuleBuilder)this, settingsStep, this.wizardContext);
                    return moduleWizardStep;
                }
            }
        }
        moduleWizardStep = new PomWizardStep(settingsStep, this.wizard);
        return moduleWizardStep;
    }

    public boolean validateModuleName(@NotNull String moduleName2) {
        Intrinsics.checkParameterIsNotNull((Object)moduleName2, (String)"moduleName");
        ValidationResult validationResult = (ValidationResult)projectNameValidator.invoke((Object)this.wizard.getValuesReadingContext(), (Object)moduleName2);
        if (Intrinsics.areEqual((Object)validationResult, (Object)ValidationResult.OK.INSTANCE)) {
            return true;
        }
        if (validationResult instanceof ValidationResult.ValidationError) {
            String string = (String)CollectionsKt.firstOrNull(((ValidationResult.ValidationError)validationResult).getMessages());
            if (string == null) {
                string = INVALID_PROJECT_NAME_MESSAGE;
            }
            String message2 = string;
            throw (Throwable)new ConfigurationException(message2, INVALID_PROJECT_NAME_MESSAGE);
        }
        throw new NoWhenBranchMatchedException();
    }

    /*
     * WARNING - void declaration
     */
    private final void updateProjectNameAndPomDate(SettingsStep settingsStep) {
        void $this$settingValue$iv$iv;
        void $this$reference$iv$iv;
        void $this$settingValue$iv;
        if (this.wizard.getArtifactId() != null || this.wizard.getGroupId() != null) {
            return;
        }
        ValuesReadingContext valuesReadingContext = this.wizard.getValuesReadingContext();
        boolean bl = false;
        boolean bl2 = false;
        ValuesReadingContext $this$with = valuesReadingContext;
        boolean bl3 = false;
        Object object = NewProjectWizardModuleBuilder$updateProjectNameAndPomDate$suggestedProjectName$1$1.INSTANCE;
        ValuesReadingContext this_$iv = $this$with;
        boolean $i$f$getSettingValue = false;
        void var11_11 = $this$settingValue$iv;
        ValuesReadingContext valuesReadingContext2 = this_$iv;
        boolean $i$f$getReference22 = false;
        PluginSettingReference pluginSettingReference = new PluginSettingReference($this$reference$iv$iv, Reflection.getOrCreateKotlinClass(SettingType.class));
        SettingReference $i$f$getReference22 = pluginSettingReference;
        ValuesReadingContext this_$iv$iv = valuesReadingContext2;
        boolean $i$f$getSettingValue2 = false;
        Object v = this_$iv$iv.getContext().getSettingContext().get($this$settingValue$iv$iv);
        if (v == null) {
            String string = "No value is present for setting `" + $this$settingValue$iv$iv + '`';
            boolean bl4 = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        String suggestedProjectName2 = StringsKt.decapitalize((String)((ProjectTemplate)v).getSuggestedProjectName());
        ModuleNameLocationSettings moduleNameLocationSettings = settingsStep.getModuleNameLocationSettings();
        if (moduleNameLocationSettings != null) {
            valuesReadingContext = moduleNameLocationSettings;
            bl = false;
            bl2 = false;
            ValuesReadingContext $this$apply = valuesReadingContext;
            boolean bl5 = false;
            object = $this$apply.getModuleContentRoot();
            boolean bl6 = false;
            boolean bl7 = false;
            Object it = object;
            boolean bl8 = false;
            Path path2 = Paths.get((String)it, new String[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"Paths.get(it)");
            String projectParentDirectory = ((Object)path2.getParent()).toString();
            $this$apply.setModuleName(ProjectWizardUtil.findNonExistingFileName((String)projectParentDirectory, (String)suggestedProjectName2, (String)""));
        }
        SettingsStep $this$safeAs$iv = settingsStep;
        boolean $i$f$safeAs = false;
        SettingsStep settingsStep2 = $this$safeAs$iv;
        if (!(settingsStep2 instanceof ProjectSettingsStep)) {
            settingsStep2 = null;
        }
        ProjectSettingsStep projectSettingsStep = (ProjectSettingsStep)settingsStep2;
        if (projectSettingsStep != null) {
            projectSettingsStep.bindModuleSettings();
        }
        this.wizard.setArtifactId(suggestedProjectName2);
        this.wizard.setGroupId(this.suggestGroupId());
    }

    private final String suggestGroupId() {
        String string = SystemProperties.getUserName();
        if (string == null) {
            return DEFAULT_GROUP_ID;
        }
        String username = string;
        CharSequence charSequence = username;
        CharSequence charSequence2 = "[\\w\\s]+";
        boolean bl = false;
        charSequence2 = new Regex(charSequence2);
        bl = false;
        if (!charSequence2.matches(charSequence)) {
            return DEFAULT_GROUP_ID;
        }
        charSequence2 = username;
        bl = false;
        String string2 = charSequence2;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        charSequence2 = ((Object)StringsKt.trim((CharSequence)string2)).toString();
        bl = false;
        String string3 = charSequence2;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).toLowerCase()");
        charSequence2 = string4;
        String string5 = "\\s+";
        int n = 0;
        string5 = new Regex(string5);
        n = 0;
        boolean bl2 = false;
        String usernameAsGroupId = CollectionsKt.joinToString$default((Iterable)string5.split(charSequence2, n), (CharSequence)".", null, null, (int)0, null, null, (int)62, null);
        return "me." + usernameAsGroupId;
    }

    @NotNull
    public ModuleNewWizardFirstStep getCustomOptionsStep(@Nullable WizardContext context2, @Nullable Disposable parentDisposable) {
        return new ModuleNewWizardFirstStep(this.wizard);
    }

    public void setName(@NotNull String name2) {
        Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
        this.wizard.setProjectName(name2);
    }

    public void setModuleFilePath(@NotNull String path2) {
        Intrinsics.checkParameterIsNotNull((Object)path2, (String)"path");
    }

    public void setContentEntryPath(@NotNull String moduleRootPath) {
        Intrinsics.checkParameterIsNotNull((Object)moduleRootPath, (String)"moduleRootPath");
        this.wizard.setProjectPath(Paths.get(moduleRootPath, new String[0]));
    }

    static {
        Companion = new Companion(null);
        projectNameValidator = StringValidators.INSTANCE.shouldBeValidIdentifier(KotlinNewProjectWizardBundle.message("editor.entity.project.name", new Object[0]), SetsKt.setOf((Object[])new Character[]{Character.valueOf('-'), Character.valueOf('_')}));
        INVALID_PROJECT_NAME_MESSAGE = KotlinNewProjectWizardBundle.message("error.invalid.project.name", new Object[0]);
    }

    public static final /* synthetic */ void access$setupModule(NewProjectWizardModuleBuilder $this, Module p0) {
        $this.setupModule(p0);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\bX\u0082\u0004\u00f8\u0001\u0000\u00a2\u0006\u0004\n\u0002\u0010\t\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/tools/projectWizard/wizard/NewProjectWizardModuleBuilder$Companion;", "", "()V", "DEFAULT_GROUP_ID", "", "INVALID_PROJECT_NAME_MESSAGE", "MODULE_BUILDER_ID", "projectNameValidator", "Lorg/jetbrains/kotlin/tools/projectWizard/core/entity/SettingValidator;", "Lkotlin/jvm/functions/Function2;", "idea-new-project-wizard"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

