/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.ivyresolve;

import java.util.Set;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.RepositoryBlacklister;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.impldep.com.google.common.collect.Sets;
import org.gradle.internal.resolve.ResolveExceptionAnalyzer;

public class ConnectionFailureRepositoryBlacklister
implements RepositoryBlacklister {
    private static final Logger LOGGER = Logging.getLogger(ConnectionFailureRepositoryBlacklister.class);
    private final Set<String> blacklistedRepositories = Sets.newConcurrentHashSet();

    @Override
    public boolean isBlacklisted(String repositoryId) {
        return this.blacklistedRepositories.contains(repositoryId);
    }

    @Override
    public boolean blacklistRepository(String repositoryId, Throwable throwable) {
        boolean blacklisted = this.isBlacklisted(repositoryId);
        if (blacklisted) {
            return true;
        }
        if (ResolveExceptionAnalyzer.isCriticalFailure(throwable)) {
            LOGGER.debug("Repository {} has been blacklisted for this build due to connectivity issues", repositoryId);
            this.blacklistedRepositories.add(repositoryId);
            return true;
        }
        return false;
    }

    @Override
    public Set<String> getBlacklistedRepositories() {
        return this.blacklistedRepositories;
    }
}

