/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.scala;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.Callable;
import org.gradle.api.internal.tasks.scala.AnalysisStoreProvider;
import org.gradle.api.internal.tasks.scala.GuavaBackedClassLoaderCache;
import org.gradle.api.internal.tasks.scala.HashedClasspath;
import org.gradle.api.internal.tasks.scala.SbtLoggerAdapter;
import org.gradle.api.internal.tasks.scala.ZincScalaCompiler;
import org.gradle.api.logging.Logging;
import org.gradle.cache.CacheRepository;
import org.gradle.cache.FileLockManager;
import org.gradle.cache.PersistentCache;
import org.gradle.cache.internal.filelock.LockOptionsBuilder;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.classpath.DefaultClassPath;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.impldep.com.google.common.collect.Iterables;
import org.gradle.internal.jvm.Jvm;
import org.gradle.internal.time.Time;
import org.gradle.internal.time.Timer;
import sbt.internal.inc.AnalyzingCompiler;
import sbt.internal.inc.AnalyzingCompiler$;
import sbt.internal.inc.RawCompiler;
import sbt.internal.inc.ScalaInstance;
import sbt.internal.inc.ZincUtil;
import sbt.internal.inc.classpath.ClassLoaderCache;
import sbt.util.Logger;
import scala.Option;
import scala.collection.Iterable;
import scala.collection.JavaConverters;
import scala.runtime.BoxedUnit;
import xsbti.compile.ClasspathOptionsUtil;
import xsbti.compile.ScalaCompiler;
import xsbti.compile.ZincCompilerUtil;

public class ZincScalaCompilerFactory {
    private static final org.gradle.api.logging.Logger LOGGER;
    private static final int CLASSLOADER_CACHE_SIZE = 4;
    private static final int COMPILER_CLASSLOADER_CACHE_SIZE = 4;
    private static final GuavaBackedClassLoaderCache<HashCode> CLASSLOADER_CACHE;
    private static final ClassLoaderCache COMPILER_CLASSLOADER_CACHE;

    static ZincScalaCompiler getCompiler(CacheRepository cacheRepository, HashedClasspath hashedScalaClasspath) {
        ScalaInstance scalaInstance = ZincScalaCompilerFactory.getScalaInstance(hashedScalaClasspath);
        String zincVersion = ZincCompilerUtil.class.getPackage().getImplementationVersion();
        String scalaVersion = scalaInstance.actualVersion();
        String javaVersion = Jvm.current().getJavaVersion().getMajorVersion();
        String zincCacheKey = String.format("zinc-%s_%s_%s", zincVersion, scalaVersion, javaVersion);
        String zincCacheName = String.format("%s compiler cache", zincCacheKey);
        PersistentCache zincCache = cacheRepository.cache(zincCacheKey).withDisplayName(zincCacheName).withLockOptions(LockOptionsBuilder.mode(FileLockManager.LockMode.OnDemand)).open();
        File compilerBridgeSourceJar = ZincScalaCompilerFactory.findFile("compiler-bridge", hashedScalaClasspath.getClasspath());
        File bridgeJar = ZincScalaCompilerFactory.getBridgeJar(zincCache, scalaInstance, compilerBridgeSourceJar, Logger.xlog2Log((xsbti.Logger)new SbtLoggerAdapter()));
        AnalyzingCompiler scalaCompiler = new AnalyzingCompiler((xsbti.compile.ScalaInstance)scalaInstance, ZincUtil.constantBridgeProvider((xsbti.compile.ScalaInstance)scalaInstance, (File)bridgeJar), ClasspathOptionsUtil.auto(), k -> BoxedUnit.UNIT, Option.apply((Object)COMPILER_CLASSLOADER_CACHE));
        return new ZincScalaCompiler(scalaInstance, (ScalaCompiler)scalaCompiler, new AnalysisStoreProvider());
    }

    private static ClassLoader getClassLoader(ClassPath classpath) {
        try {
            ArrayList<URL> urls = new ArrayList<URL>();
            for (File file : classpath.getAsFiles()) {
                urls.add(file.toURI().toURL());
            }
            return new URLClassLoader(urls.toArray(new URL[0]));
        }
        catch (Exception ee) {
            throw new RuntimeException(ee);
        }
    }

    private static ClassLoader getCachedClassLoader(final HashedClasspath classpath) {
        try {
            return CLASSLOADER_CACHE.get(classpath.getHash(), new Callable<ClassLoader>(){

                @Override
                public ClassLoader call() throws Exception {
                    return ZincScalaCompilerFactory.getClassLoader(classpath.getClasspath());
                }
            });
        }
        catch (Exception ee) {
            throw new RuntimeException(ee);
        }
    }

    private static ScalaInstance getScalaInstance(HashedClasspath hashedScalaClasspath) {
        ClassLoader scalaClassLoader = ZincScalaCompilerFactory.getCachedClassLoader(hashedScalaClasspath);
        String scalaVersion = ZincScalaCompilerFactory.getScalaVersion(scalaClassLoader);
        ClassPath scalaClasspath = hashedScalaClasspath.getClasspath();
        File libraryJar = ZincScalaCompilerFactory.findFile("scala-library", scalaClasspath);
        File compilerJar = ZincScalaCompilerFactory.findFile("scala-compiler", scalaClasspath);
        return new ScalaInstance(scalaVersion, scalaClassLoader, ZincScalaCompilerFactory.getClassLoader(DefaultClassPath.of(libraryJar)), libraryJar, compilerJar, (File[])Iterables.toArray(scalaClasspath.getAsFiles(), File.class), Option.empty());
    }

    private static File getBridgeJar(PersistentCache zincCache, ScalaInstance scalaInstance, File compilerBridgeSourceJar, Logger logger) {
        return zincCache.useCache(() -> {
            File bridgeJar = new File(zincCache.getBaseDir(), "compiler-bridge.jar");
            if (bridgeJar.exists()) {
                return bridgeJar;
            }
            Timer timer = Time.startTimer();
            RawCompiler rawCompiler = new RawCompiler((xsbti.compile.ScalaInstance)scalaInstance, ClasspathOptionsUtil.manual(), logger);
            Iterable sourceJars = JavaConverters.collectionAsScalaIterable(Collections.singletonList(compilerBridgeSourceJar));
            Iterable xsbtiJars = JavaConverters.collectionAsScalaIterable(Arrays.asList(scalaInstance.allJars()));
            AnalyzingCompiler$.MODULE$.compileSources(sourceJars, bridgeJar, xsbtiJars, "compiler-bridge", rawCompiler, logger);
            String interfaceCompletedMessage = String.format("Scala Compiler interface compilation took %s", timer.getElapsed());
            if (timer.getElapsedMillis() > 30000L) {
                LOGGER.warn(interfaceCompletedMessage);
            } else {
                LOGGER.debug(interfaceCompletedMessage);
            }
            return bridgeJar;
        });
    }

    private static File findFile(String prefix, ClassPath classpath) {
        for (File f : classpath.getAsFiles()) {
            if (!f.getName().startsWith(prefix)) continue;
            return f;
        }
        throw new IllegalStateException(String.format("Cannot find any files starting with %s in %s", prefix, classpath.getAsFiles()));
    }

    private static String getScalaVersion(ClassLoader scalaClassLoader) {
        try {
            Properties props = new Properties();
            props.load(scalaClassLoader.getResourceAsStream("library.properties"));
            return props.getProperty("version.number");
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to determine scala version");
        }
    }

    static {
        Class<?> checkingClass;
        Class<?> abstractCacheClass;
        LOGGER = Logging.getLogger(ZincScalaCompilerFactory.class);
        CLASSLOADER_CACHE = new GuavaBackedClassLoaderCache(4);
        try {
            abstractCacheClass = ZincScalaCompilerFactory.class.getClassLoader().loadClass("sbt.internal.classpath.inc.AbstractClassLoaderCache");
            checkingClass = ZincScalaCompilerFactory.class.getClassLoader().loadClass("org.gradle.api.internal.tasks.scala.TimeCheckingClassLoaderCache");
        }
        catch (ClassNotFoundException ex) {
            abstractCacheClass = null;
            checkingClass = null;
        }
        if (checkingClass != null) {
            try {
                Constructor constructor = ClassLoaderCache.class.getConstructor(abstractCacheClass);
                Object cache = checkingClass.getConstructors()[0].newInstance(4);
                COMPILER_CLASSLOADER_CACHE = (ClassLoaderCache)constructor.newInstance(cache);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to instantiate ClassLoaderCache", e);
            }
        } else {
            COMPILER_CLASSLOADER_CACHE = new ClassLoaderCache((ClassLoader)new URLClassLoader(new URL[0]));
        }
    }
}

