/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.buildinit.plugins.internal;

import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.buildinit.plugins.internal.BuildScriptBuilder;
import org.gradle.buildinit.plugins.internal.InitSettings;
import org.gradle.buildinit.plugins.internal.ScriptBlockBuilder;
import org.gradle.buildinit.plugins.internal.SwiftProjectInitDescriptor;
import org.gradle.buildinit.plugins.internal.TemplateOperation;
import org.gradle.buildinit.plugins.internal.TemplateOperationFactory;
import org.gradle.buildinit.plugins.internal.modifiers.ComponentType;

public class SwiftLibraryProjectInitDescriptor
extends SwiftProjectInitDescriptor {
    public SwiftLibraryProjectInitDescriptor(TemplateOperationFactory templateOperationFactory, DocumentationRegistry documentationRegistry) {
        super(templateOperationFactory, documentationRegistry);
    }

    @Override
    public String getId() {
        return "swift-library";
    }

    @Override
    public ComponentType getComponentType() {
        return ComponentType.LIBRARY;
    }

    @Override
    protected TemplateOperation sourceTemplateOperation(InitSettings settings) {
        return this.fromSwiftTemplate("swiftlibrary/Hello.swift.template", settings, "main", "swift");
    }

    @Override
    protected TemplateOperation testTemplateOperation(InitSettings settings) {
        return this.fromSwiftTemplate("swiftlibrary/HelloTests.swift.template", settings, "test", "swift");
    }

    @Override
    protected TemplateOperation testEntryPointTemplateOperation(InitSettings settings) {
        return this.fromSwiftTemplate("swiftlibrary/LinuxMain.swift.template", settings, "test", "swift");
    }

    @Override
    protected void configureBuildScript(InitSettings settings, BuildScriptBuilder buildScriptBuilder) {
        buildScriptBuilder.plugin("Apply the swift-library plugin to add support for building Swift libraries", "swift-library").plugin("Apply the xctest plugin to add support for building and running Swift test executables (Linux) or bundles (macOS)", "xctest").block("Set the target operating system and architecture for this library", "library", b -> this.configureTargetMachineDefinition((ScriptBlockBuilder)b));
    }
}

