/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.classpath;

import java.io.File;
import java.util.List;
import org.gradle.internal.classpath.ClasspathFileTransformer;
import org.gradle.internal.file.FileType;
import org.gradle.internal.snapshot.CompleteFileSystemLocationSnapshot;
import org.gradle.internal.vfs.AdditiveCache;
import org.gradle.util.GFileUtils;

public class CopyingClasspathFileTransformer
implements ClasspathFileTransformer {
    private final List<AdditiveCache> additiveCaches;

    public CopyingClasspathFileTransformer(List<AdditiveCache> additiveCaches) {
        this.additiveCaches = additiveCaches;
    }

    @Override
    public File transform(File source, CompleteFileSystemLocationSnapshot sourceSnapshot, File cacheDir) {
        if (sourceSnapshot.getType() != FileType.RegularFile) {
            return source;
        }
        for (AdditiveCache cache : this.additiveCaches) {
            for (File root : cache.getAdditiveCacheRoots()) {
                if (!source.toPath().startsWith(root.toPath())) continue;
                return source;
            }
        }
        File cachedFile = new File(cacheDir, "o_" + sourceSnapshot.getHash().toString() + '/' + source.getName());
        if (!cachedFile.isFile()) {
            GFileUtils.copyFile(source, cachedFile);
        }
        return cachedFile;
    }
}

