/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.deprecation;

import java.util.HashSet;
import java.util.Set;
import org.gradle.internal.deprecation.Deprecatable;
import org.gradle.internal.deprecation.DeprecationLogger;

public class LoggingDeprecatable
implements Deprecatable {
    private final Set<String> deprecations = new HashSet<String>();

    @Override
    public void addDeprecation(String deprecation) {
        this.deprecations.add(deprecation);
    }

    @Override
    public Set<String> getDeprecations() {
        return this.deprecations;
    }

    @Override
    public void checkDeprecation() {
        for (String deprecation : this.deprecations) {
            DeprecationLogger.deprecateBuildInvocationFeature(deprecation).willBeRemovedInGradle7().undocumented().nagUser();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LoggingDeprecatable that = (LoggingDeprecatable)o;
        return this.deprecations.equals(that.deprecations);
    }

    public int hashCode() {
        return this.deprecations.hashCode();
    }
}

