/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.watch.registry.impl;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import net.rubygrapefruit.platform.file.FileWatchEvent;
import net.rubygrapefruit.platform.file.FileWatcher;
import org.gradle.internal.watch.registry.FileWatcherRegistry;
import org.gradle.internal.watch.registry.FileWatcherUpdater;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFileWatcherRegistry
implements FileWatcherRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultFileWatcherRegistry.class);
    private final FileWatcher watcher;
    private final BlockingQueue<FileWatchEvent> fileEvents;
    private final Thread eventConsumerThread;
    private final AtomicReference<MutableFileWatchingStatistics> fileWatchingStatistics = new AtomicReference<MutableFileWatchingStatistics>(new MutableFileWatchingStatistics());
    private final FileWatcherUpdater fileWatcherUpdater;
    private volatile boolean consumeEvents = true;
    private volatile boolean stopping = false;

    public DefaultFileWatcherRegistry(FileWatcher watcher, FileWatcherRegistry.ChangeHandler handler, FileWatcherUpdater fileWatcherUpdater, BlockingQueue<FileWatchEvent> fileEvents) {
        this.watcher = watcher;
        this.fileEvents = fileEvents;
        this.fileWatcherUpdater = fileWatcherUpdater;
        this.eventConsumerThread = this.createAndStartEventConsumerThread(handler);
    }

    private Thread createAndStartEventConsumerThread(final FileWatcherRegistry.ChangeHandler handler) {
        Thread thread = new Thread(() -> {
            try {
                while (this.consumeEvents) {
                    FileWatchEvent nextEvent = this.fileEvents.take();
                    if (this.stopping) continue;
                    nextEvent.handleEvent(new FileWatchEvent.Handler(){

                        @Override
                        public void handleChangeEvent(FileWatchEvent.ChangeType type, String absolutePath) {
                            DefaultFileWatcherRegistry.this.fileWatchingStatistics.updateAndGet(MutableFileWatchingStatistics::eventReceived);
                            handler.handleChange(DefaultFileWatcherRegistry.convertType(type), Paths.get(absolutePath, new String[0]));
                        }

                        @Override
                        public void handleUnknownEvent(String absolutePath) {
                            DefaultFileWatcherRegistry.this.fileWatchingStatistics.updateAndGet(MutableFileWatchingStatistics::unknownEventEncountered);
                            handler.handleLostState();
                        }

                        @Override
                        public void handleOverflow(FileWatchEvent.OverflowType type, @Nullable String absolutePath) {
                            if (absolutePath == null) {
                                handler.handleLostState();
                            } else {
                                handler.handleChange(FileWatcherRegistry.Type.INVALIDATED, Paths.get(absolutePath, new String[0]));
                            }
                        }

                        @Override
                        public void handleFailure(Throwable failure) {
                            LOGGER.error("Error while receiving file changes", failure);
                            DefaultFileWatcherRegistry.this.fileWatchingStatistics.updateAndGet(statistics -> statistics.errorWhileReceivingFileChanges(failure));
                            handler.handleLostState();
                        }

                        @Override
                        public void handleTerminated() {
                            DefaultFileWatcherRegistry.this.consumeEvents = false;
                        }
                    });
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        });
        thread.setDaemon(true);
        thread.setName("File watcher consumer");
        thread.start();
        return thread;
    }

    @Override
    public FileWatcherUpdater getFileWatcherUpdater() {
        return this.fileWatcherUpdater;
    }

    private static FileWatcherRegistry.Type convertType(FileWatchEvent.ChangeType type) {
        switch (type) {
            case CREATED: {
                return FileWatcherRegistry.Type.CREATED;
            }
            case MODIFIED: {
                return FileWatcherRegistry.Type.MODIFIED;
            }
            case REMOVED: {
                return FileWatcherRegistry.Type.REMOVED;
            }
            case INVALIDATED: {
                return FileWatcherRegistry.Type.INVALIDATED;
            }
        }
        throw new AssertionError();
    }

    @Override
    public FileWatcherRegistry.FileWatchingStatistics getAndResetStatistics() {
        return this.fileWatchingStatistics.getAndSet(new MutableFileWatchingStatistics());
    }

    @Override
    public void close() throws IOException {
        this.stopping = true;
        try {
            this.watcher.shutdown();
            if (!this.watcher.awaitTermination(5L, TimeUnit.SECONDS)) {
                throw new RuntimeException("Watcher did not terminate withing 5 seconds");
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new InterruptedIOException("Awaiting termination of watcher was interrupted");
        }
        finally {
            this.consumeEvents = false;
            this.eventConsumerThread.interrupt();
        }
    }

    private static class MutableFileWatchingStatistics
    implements FileWatcherRegistry.FileWatchingStatistics {
        private boolean unknownEventEncountered;
        private int numberOfReceivedEvents;
        private Throwable errorWhileReceivingFileChanges;

        private MutableFileWatchingStatistics() {
        }

        @Override
        public Optional<Throwable> getErrorWhileReceivingFileChanges() {
            return Optional.ofNullable(this.errorWhileReceivingFileChanges);
        }

        @Override
        public boolean isUnknownEventEncountered() {
            return this.unknownEventEncountered;
        }

        @Override
        public int getNumberOfReceivedEvents() {
            return this.numberOfReceivedEvents;
        }

        public MutableFileWatchingStatistics eventReceived() {
            ++this.numberOfReceivedEvents;
            return this;
        }

        public MutableFileWatchingStatistics errorWhileReceivingFileChanges(Throwable error) {
            if (this.errorWhileReceivingFileChanges != null) {
                this.errorWhileReceivingFileChanges = error;
            }
            return this;
        }

        public MutableFileWatchingStatistics unknownEventEncountered() {
            this.unknownEventEncountered = true;
            return this;
        }
    }
}

