/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.client;

import java.io.InputStream;
import javax.annotation.Nullable;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.dispatch.Dispatch;
import org.gradle.internal.io.TextStream;
import org.gradle.launcher.daemon.client.InputForwarder;
import org.gradle.launcher.daemon.protocol.CloseInput;
import org.gradle.launcher.daemon.protocol.ForwardInput;
import org.gradle.launcher.daemon.protocol.InputMessage;

public class DaemonClientInputForwarder
implements Stoppable {
    private static final Logger LOGGER = Logging.getLogger(DaemonClientInputForwarder.class);
    public static final int DEFAULT_BUFFER_SIZE = 8192;
    private final InputForwarder forwarder;

    public DaemonClientInputForwarder(InputStream inputStream, Dispatch<? super InputMessage> dispatch, ExecutorFactory executorFactory) {
        this(inputStream, dispatch, executorFactory, 8192);
    }

    public DaemonClientInputForwarder(InputStream inputStream, Dispatch<? super InputMessage> dispatch, ExecutorFactory executorFactory, int bufferSize) {
        ForwardTextStreamToConnection handler = new ForwardTextStreamToConnection(dispatch);
        this.forwarder = new InputForwarder(inputStream, handler, executorFactory, bufferSize);
    }

    public void start() {
        this.forwarder.start();
    }

    @Override
    public void stop() {
        this.forwarder.stop();
    }

    private static class ForwardTextStreamToConnection
    implements TextStream {
        private final Dispatch<? super InputMessage> dispatch;

        public ForwardTextStreamToConnection(Dispatch<? super InputMessage> dispatch) {
            this.dispatch = dispatch;
        }

        @Override
        public void text(String input) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Forwarding input to daemon: '{}'", input.replace("\n", "\\n"));
            }
            this.dispatch.dispatch(new ForwardInput(input.getBytes()));
        }

        @Override
        public void endOfStream(@Nullable Throwable failure) {
            CloseInput message = new CloseInput();
            LOGGER.debug("Dispatching close input message: {}", message);
            this.dispatch.dispatch(message);
        }
    }
}

