/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.CommonBundle;
import com.intellij.ProjectTopics;
import com.intellij.codeInsight.ExternalAnnotation;
import com.intellij.codeInsight.ExternalAnnotationsListener;
import com.intellij.codeInsight.ExternalAnnotationsManager;
import com.intellij.codeInsight.ReadableExternalAnnotationsManager;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.diagnostic.AttachmentFactory;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.ide.plugins.DynamicPluginListener;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.roots.AnnotationOrderRootType;
import com.intellij.openapi.roots.JavaModuleExternalPaths;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.OptionsMessageDialog;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import one.util.streamex.EntryStream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ExternalAnnotationsManagerImpl
extends ReadableExternalAnnotationsManager {
    private static final Logger LOG = Logger.getInstance(ExternalAnnotationsManagerImpl.class);
    private final MessageBus myBus;

    public ExternalAnnotationsManagerImpl(@NotNull Project project) {
        if (project == null) {
            ExternalAnnotationsManagerImpl.$$$reportNull$$$0(0);
        }
        super(PsiManager.getInstance((Project)project));
        this.myBus = project.getMessageBus();
        MessageBusConnection connection = this.myBus.connect();
        connection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void rootsChanged(@NotNull ModuleRootEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                ExternalAnnotationsManagerImpl.this.dropAnnotationsCache();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/codeInsight/ExternalAnnotationsManagerImpl$1", "rootsChanged"));
            }
        });
        connection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            public void after(@NotNull List<? extends VFileEvent> events) {
                if (events == null) {
                    2.$$$reportNull$$$0(0);
                }
                for (VFileEvent vFileEvent : events) {
                    String name2;
                    if (!vFileEvent.isFromRefresh()) continue;
                    if (vFileEvent instanceof VFileCreateEvent) {
                        String name22 = ((VFileCreateEvent)vFileEvent).getChildName();
                    } else {
                        VirtualFile file = vFileEvent.getFile();
                        if (file == null) continue;
                        name2 = file.getName();
                    }
                    if (!vFileEvent.isFromRefresh() || !"annotations.xml".equals(name2)) continue;
                    ExternalAnnotationsManagerImpl.this.dropAnnotationsCache();
                    ExternalAnnotationsManagerImpl.this.notifyChangedExternally();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/codeInsight/ExternalAnnotationsManagerImpl$2", "after"));
            }
        });
        connection.subscribe(DynamicPluginListener.TOPIC, (Object)new DynamicPluginListener(){

            public void beforePluginUnload(@NotNull IdeaPluginDescriptor pluginDescriptor, boolean isUpdate) {
                if (pluginDescriptor == null) {
                    3.$$$reportNull$$$0(0);
                }
                ExternalAnnotationsManagerImpl.this.dropAnnotationsCache();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginDescriptor", "com/intellij/codeInsight/ExternalAnnotationsManagerImpl$3", "beforePluginUnload"));
            }
        });
        EditorFactory.getInstance().getEventMulticaster().addDocumentListener((DocumentListener)new MyDocumentListener(), (Disposable)project);
    }

    private void notifyAfterAnnotationChanging(@NotNull PsiModifierListOwner owner2, @NotNull String annotationFQName, boolean successful) {
        if (owner2 == null) {
            ExternalAnnotationsManagerImpl.$$$reportNull$$$0(1);
        }
        if (annotationFQName == null) {
            ExternalAnnotationsManagerImpl.$$$reportNull$$$0(2);
        }
        ((ExternalAnnotationsListener)this.myBus.syncPublisher(TOPIC)).afterExternalAnnotationChanging(owner2, annotationFQName, successful);
        this.myPsiManager.dropPsiCaches();
    }

    private void notifyChangedExternally() {
        ((ExternalAnnotationsListener)this.myBus.syncPublisher(TOPIC)).externalAnnotationsChangedExternally();
        this.myPsiManager.dropPsiCaches();
    }

    @Override
    public void annotateExternally(@NotNull PsiModifierListOwner listOwner, @NotNull String annotationFQName, @NotNull PsiFile fromFile, PsiNameValuePair @Nullable [] value2) throws ExternalAnnotationsManager.CanceledConfigurationException {
        if (listOwner == null) {
            ExternalAnnotationsManagerImpl.$$$reportNull$$$0(3);
        }
        if (annotationFQName == null) {
            ExternalAnnotationsManagerImpl.$$$reportNull$$$0(4);
        }
        if (fromFile == null) {
            ExternalAnnotationsManagerImpl.$$$reportNull$$$0(5);
        }
        Application application = ApplicationManager.getApplication();
        application.assertIsDispatchThread();
        LOG.assertTrue(!application.isWriteAccessAllowed());
        Project project = this.myPsiManager.getProject();
        PsiFile containingFile = listOwner.getOriginalElement().getContainingFile();
        if (!(containingFile instanceof PsiJavaFile)) {
            this.notifyAfterAnnotationChanging(listOwner, annotationFQName, false);
            return;
        }
        VirtualFile containingVirtualFile = containingFile.getVirtualFile();
        LOG.assertTrue(containingVirtualFile != null);
        List entries = ProjectRootManager.getInstance((Project)project).getFileIndex().getOrderEntriesForFile(containingVirtualFile);
        if (entries.isEmpty()) {
            this.notifyAfterAnnotationChanging(listOwner, annotationFQName, false);
            return;
        }
        ExternalAnnotation annotation = new ExternalAnnotation(listOwner, annotationFQName, value2);
        for (OrderEntry entry : entries) {
            if (entry instanceof ModuleOrderEntry) continue;
            VirtualFile[] roots = AnnotationOrderRootType.getFiles((OrderEntry)entry);
            if ((roots = ExternalAnnotationsManagerImpl.filterByReadOnliness(roots)).length > 0) {
                this.chooseRootAndAnnotateExternally(roots, annotation);
                break;
            }
            if (application.isUnitTestMode() || application.isHeadlessEnvironment()) {
                this.notifyAfterAnnotationChanging(listOwner, annotationFQName, false);
                return;
            }
            DumbService.getInstance((Project)project).runWithAlternativeResolveEnabled(() -> {
                if (!this.setupRootAndAnnotateExternally(entry, project, annotation)) {
                    throw new ExternalAnnotationsManager.CanceledConfigurationException();
                }
            });
            break;
        }
    }

    private void annotateExternally(@NotNull VirtualFile root, @NotNull ExternalAnnotation annotation) {
        if (root == null) {
            ExternalAnnotationsManagerImpl.$$$reportNull$$$0(6);
        }
        if (annotation == null) {
            ExternalAnnotationsManagerImpl.$$$reportNull$$$0(7);
        }
        this.annotateExternally(root, Collections.singletonList(annotation));
    }

    private void annotateExternally(@NotNull VirtualFile root, @NotNull List<? extends ExternalAnnotation> annotations) {
        if (root == null) {
            ExternalAnnotationsManagerImpl.$$$reportNull$$$0(8);
        }
        if (annotations == null) {
            ExternalAnnotationsManagerImpl.$$$reportNull$$$0(9);
        }
        final Project project = this.myPsiManager.getProject();
        final Map<Optional, List<ExternalAnnotation>> annotationsByFiles = annotations.stream().collect(Collectors.groupingBy(annotation -> Optional.ofNullable(this.getFileForAnnotations(root, annotation.getOwner(), project))));
        List files = StreamEx.ofKeys(annotationsByFiles).flatMap(StreamEx::of).map(PsiFile::getVirtualFile).nonNull().toList();
        ReadonlyStatusHandler.OperationStatus status = ReadonlyStatusHandler.getInstance((Project)project).ensureFilesWritable((Collection)files);
        if (status.hasReadonlyFiles()) {
            VirtualFile[] readonlyFiles = status.getReadonlyFiles();
            annotationsByFiles.keySet().removeIf(opt -> opt.map(PsiFile::getVirtualFile).filter(f -> ArrayUtil.contains((Object)f, (Object[])readonlyFiles)).isPresent());
        }
        if (annotationsByFiles.isEmpty()) {
            return;
        }
        WriteCommandAction.writeCommandAction((Project)project).run((ThrowableRunnable)new ThrowableRunnable<RuntimeException>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() throws RuntimeException {
                if (project.isDisposed()) {
                    return;
                }
                if (DumbService.isDumb((Project)project)) {
                    DumbService.getInstance((Project)project).runWhenSmart(() -> WriteCommandAction.writeCommandAction((Project)project).run((ThrowableRunnable)this));
                    return;
                }
                try {
                    for (Map.Entry entry : annotationsByFiles.entrySet()) {
                        XmlFile annotationsFile = ((Optional)entry.getKey()).orElse(null);
                        List fileAnnotations = (List)entry.getValue();
                        ExternalAnnotationsManagerImpl.this.annotateExternally(annotationsFile, fileAnnotations);
                    }
                    UndoManager.getInstance((Project)project).undoableActionPerformed((UndoableAction)new BasicUndoableAction(){

                        public void undo() {
                            ExternalAnnotationsManagerImpl.this.dropAnnotationsCache();
                            ExternalAnnotationsManagerImpl.this.notifyChangedExternally();
                        }

                        public void redo() {
                            ExternalAnnotationsManagerImpl.this.dropAnnotationsCache();
                            ExternalAnnotationsManagerImpl.this.notifyChangedExternally();
                        }
                    });
                }
                finally {
                    ExternalAnnotationsManagerImpl.this.dropAnnotationsCache();
                }
            }
        });
    }

    private void dropAnnotationsCache() {
        this.dropCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void annotateExternally(@Nullable XmlFile annotationsFile, @NotNull List<ExternalAnnotation> annotations) {
        if (annotations == null) {
            ExternalAnnotationsManagerImpl.$$$reportNull$$$0(10);
        }
        XmlTag rootTag = ExternalAnnotationsManagerImpl.extractRootTag(annotationsFile);
        TreeMap ownerToAnnotations = (TreeMap)((EntryStream)StreamEx.of(annotations).mapToEntry(annotation -> StringUtil.escapeXmlEntities((String)ExternalAnnotationsManagerImpl.getExternalName(annotation.getOwner())), Function.identity()).distinct()).grouping(() -> new TreeMap(Comparator.nullsFirst(Comparator.naturalOrder())));
        if (rootTag == null) {
            ownerToAnnotations.values().stream().flatMap(Collection::stream).forEach(annotation -> this.notifyAfterAnnotationChanging(annotation.getOwner(), annotation.getAnnotationFQName(), false));
            return;
        }
        ArrayList<ExternalAnnotation> savedAnnotations = new ArrayList<ExternalAnnotation>();
        XmlTag startTag = null;
        for (Map.Entry entry : ownerToAnnotations.entrySet()) {
            String ownerName = (String)entry.getKey();
            List annotationList = (List)entry.getValue();
            for (ExternalAnnotation annotation2 : annotationList) {
                if (ownerName == null) {
                    this.notifyAfterAnnotationChanging(annotation2.getOwner(), annotation2.getAnnotationFQName(), false);
                    continue;
                }
                try {
                    startTag = this.addAnnotation(rootTag, ownerName, annotation2, startTag);
                    savedAnnotations.add(annotation2);
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                    this.notifyAfterAnnotationChanging(annotation2.getOwner(), annotation2.getAnnotationFQName(), false);
                }
                finally {
                    this.dropAnnotationsCache();
                    ExternalAnnotationsManagerImpl.markForUndo(annotation2.getOwner().getContainingFile());
                }
            }
        }
        this.commitChanges(annotationsFile);
        savedAnnotations.forEach(annotation -> this.notifyAfterAnnotationChanging(annotation.getOwner(), annotation.getAnnotationFQName(), true));
    }

    @Contract(value="null -> null")
    private static XmlTag extractRootTag(XmlFile annotationsFile) {
        if (annotationsFile == null) {
            return null;
        }
        XmlDocument document = annotationsFile.getDocument();
        if (document == null) {
            return null;
        }
        return document.getRootTag();
    }

    private static void markForUndo(@Nullable PsiFile containingFile) {
        if (containingFile == null) {
            return;
        }
        VirtualFile virtualFile = containingFile.getVirtualFile();
        if (virtualFile != null && virtualFile.isInLocalFileSystem()) {
            UndoUtil.markPsiFileForUndo((PsiFile)containingFile);
        }
    }

    @NotNull
    private XmlTag addAnnotation(@NotNull XmlTag rootTag, @NotNull String ownerName, @NotNull ExternalAnnotation annotation, @Nullable XmlTag startTag) {
        if (rootTag == null) {
            ExternalAnnotationsManagerImpl.$$$reportNull$$$0(11);
        }
        if (ownerName == null) {
            ExternalAnnotationsManagerImpl.$$$reportNull$$$0(12);
        }
        if (annotation == null) {
            ExternalAnnotationsManagerImpl.$$$reportNull$$$0(13);
        }
        if (startTag == null) {
            startTag = (XmlTag)PsiTreeUtil.findChildOfType((PsiElement)rootTag, XmlTag.class);
        }
        XmlTag prevItem = null;
        XmlTag curItem = startTag;
        while (curItem != null) {
            XmlTag addedItem = this.addAnnotation(rootTag, ownerName, annotation, curItem, prevItem);
            if (addedItem != null) {
                XmlTag xmlTag = addedItem;
                if (xmlTag == null) {
                    ExternalAnnotationsManagerImpl.$$$reportNull$$$0(14);
                }
                return xmlTag;
            }
            prevItem = curItem;
            curItem = (XmlTag)PsiTreeUtil.getNextSiblingOfType((PsiElement)curItem, XmlTag.class);
        }
        return this.addItemTag(rootTag, prevItem, ownerName, annotation);
    }

    @Nullable
    private XmlTag addAnnotation(@NotNull XmlTag rootTag, @NotNull String ownerName, @NotNull ExternalAnnotation annotation, @NotNull XmlTag curItem, @Nullable XmlTag prevItem) {
        String curItemName;
        if (rootTag == null) {
            ExternalAnnotationsManagerImpl.$$$reportNull$$$0(15);
        }
        if (ownerName == null) {
            ExternalAnnotationsManagerImpl.$$$reportNull$$$0(16);
        }
        if (annotation == null) {
            ExternalAnnotationsManagerImpl.$$$reportNull$$$0(17);
        }
        if (curItem == null) {
            ExternalAnnotationsManagerImpl.$$$reportNull$$$0(18);
        }
        if ((curItemName = curItem.getAttributeValue("name")) == null) {
            curItem.delete();
            return null;
        }
        int compare = ownerName.compareTo(curItemName);
        if (compare == 0) {
            return this.appendItemAnnotation(curItem, annotation);
        }
        if (compare < 0) {
            return this.addItemTag(rootTag, prevItem, ownerName, annotation);
        }
        return null;
    }

    @NotNull
    private XmlTag addItemTag(@NotNull XmlTag rootTag, @Nullable XmlTag anchor, @NotNull String ownerName, @NotNull ExternalAnnotation annotation) {
        if (rootTag == null) {
            ExternalAnnotationsManagerImpl.$$$reportNull$$$0(19);
        }
        if (ownerName == null) {
            ExternalAnnotationsManagerImpl.$$$reportNull$$$0(20);
        }
        if (annotation == null) {
            ExternalAnnotationsManagerImpl.$$$reportNull$$$0(21);
        }
        XmlElementFactory elementFactory = XmlElementFactory.getInstance((Project)this.myPsiManager.getProject());
        XmlTag newItemTag = elementFactory.createTagFromText((CharSequence)ExternalAnnotationsManagerImpl.createItemTag(ownerName, annotation));
        Object addedElement = anchor != null ? rootTag.addAfter((PsiElement)newItemTag, (PsiElement)anchor) : rootTag.addSubTag(newItemTag, true);
        if (!(addedElement instanceof XmlTag)) {
            throw new IncorrectOperationException("Failed to add annotation " + annotation + " after " + anchor);
        }
        XmlTag xmlTag = (XmlTag)addedElement;
        if (xmlTag == null) {
            ExternalAnnotationsManagerImpl.$$$reportNull$$$0(22);
        }
        return xmlTag;
    }

    private XmlTag appendItemAnnotation(@NotNull XmlTag itemTag, @NotNull ExternalAnnotation annotation) {
        XmlTag newAnnotationTag;
        PsiElement addedElement;
        if (itemTag == null) {
            ExternalAnnotationsManagerImpl.$$$reportNull$$$0(23);
        }
        if (annotation == null) {
            ExternalAnnotationsManagerImpl.$$$reportNull$$$0(24);
        }
        String annotationFQName = annotation.getAnnotationFQName();
        PsiNameValuePair[] values = annotation.getValues();
        XmlElementFactory elementFactory = XmlElementFactory.getInstance((Project)this.myPsiManager.getProject());
        XmlTag anchor = null;
        for (XmlTag itemAnnotation : itemTag.getSubTags()) {
            String curAnnotationName = itemAnnotation.getAttributeValue("name");
            if (curAnnotationName == null) {
                itemAnnotation.delete();
                continue;
            }
            if (annotationFQName.equals(curAnnotationName)) {
                itemAnnotation.delete();
                break;
            }
            anchor = itemAnnotation;
        }
        if (!((addedElement = itemTag.addAfter((PsiElement)(newAnnotationTag = elementFactory.createTagFromText((CharSequence)ExternalAnnotationsManagerImpl.createAnnotationTag(annotationFQName, values))), anchor)) instanceof XmlTag)) {
            throw new IncorrectOperationException("Failed to add annotation " + annotation + " after " + anchor);
        }
        return itemTag;
    }

    @Nullable
    private List<XmlFile> findExternalAnnotationsXmlFiles(@NotNull PsiModifierListOwner listOwner) {
        List<PsiFile> psiFiles;
        if (listOwner == null) {
            ExternalAnnotationsManagerImpl.$$$reportNull$$$0(25);
        }
        if ((psiFiles = this.findExternalAnnotationsFiles(listOwner)) == null) {
            return null;
        }
        ArrayList<XmlFile> xmlFiles = new ArrayList<XmlFile>();
        for (PsiFile psiFile : psiFiles) {
            if (!(psiFile instanceof XmlFile)) continue;
            xmlFiles.add((XmlFile)psiFile);
        }
        return xmlFiles;
    }

    private boolean setupRootAndAnnotateExternally(@NotNull OrderEntry entry, @NotNull Project project, @NotNull ExternalAnnotation annotation) {
        if (entry == null) {
            ExternalAnnotationsManagerImpl.$$$reportNull$$$0(26);
        }
        if (project == null) {
            ExternalAnnotationsManagerImpl.$$$reportNull$$$0(27);
        }
        if (annotation == null) {
            ExternalAnnotationsManagerImpl.$$$reportNull$$$0(28);
        }
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        descriptor.setTitle(JavaBundle.message((String)"external.annotations.root.chooser.title", (Object[])new Object[]{entry.getPresentableName()}));
        descriptor.setDescription(JavaBundle.message((String)"external.annotations.root.chooser.description", (Object[])new Object[0]));
        VirtualFile newRoot = FileChooser.chooseFile((FileChooserDescriptor)descriptor, (Project)project, null);
        if (newRoot == null) {
            this.notifyAfterAnnotationChanging(annotation.getOwner(), annotation.getAnnotationFQName(), false);
            return false;
        }
        WriteCommandAction.writeCommandAction((Project)project).run(() -> this.appendChosenAnnotationsRoot(entry, newRoot));
        this.annotateExternally(newRoot, annotation);
        return true;
    }

    @Nullable
    private static XmlFile findXmlFileInRoot(@Nullable List<? extends XmlFile> xmlFiles, @NotNull VirtualFile root) {
        if (root == null) {
            ExternalAnnotationsManagerImpl.$$$reportNull$$$0(29);
        }
        if (xmlFiles != null) {
            for (XmlFile xmlFile : xmlFiles) {
                VirtualFile vf = xmlFile.getVirtualFile();
                if (vf == null || !VfsUtilCore.isAncestor((VirtualFile)root, (VirtualFile)vf, (boolean)false)) continue;
                return xmlFile;
            }
        }
        return null;
    }

    private void chooseRootAndAnnotateExternally(VirtualFile @NotNull [] roots, final @NotNull ExternalAnnotation annotation) {
        if (annotation == null) {
            ExternalAnnotationsManagerImpl.$$$reportNull$$$0(30);
        }
        if (roots == null) {
            ExternalAnnotationsManagerImpl.$$$reportNull$$$0(31);
        }
        if (roots.length > 1) {
            JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<VirtualFile>(JavaBundle.message((String)"external.annotations.roots", (Object[])new Object[0]), roots){

                public void canceled() {
                    ExternalAnnotationsManagerImpl.this.notifyAfterAnnotationChanging(annotation.getOwner(), annotation.getAnnotationFQName(), false);
                }

                public PopupStep onChosen(@NotNull VirtualFile file, boolean finalChoice) {
                    if (file == null) {
                        5.$$$reportNull$$$0(0);
                    }
                    ExternalAnnotationsManagerImpl.this.annotateExternally(file, annotation);
                    return FINAL_CHOICE;
                }

                @NotNull
                public String getTextFor(@NotNull VirtualFile value2) {
                    if (value2 == null) {
                        5.$$$reportNull$$$0(1);
                    }
                    String string = value2.getPresentableUrl();
                    if (string == null) {
                        5.$$$reportNull$$$0(2);
                    }
                    return string;
                }

                public Icon getIconFor(VirtualFile aValue) {
                    return AllIcons.Modules.Annotation;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 2: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 3;
                            break;
                        }
                        case 2: {
                            n2 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "file";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "value";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/codeInsight/ExternalAnnotationsManagerImpl$5";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/codeInsight/ExternalAnnotationsManagerImpl$5";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getTextFor";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "onChosen";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray;
                            objectArray[2] = "getTextFor";
                            break;
                        }
                        case 2: {
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                        case 2: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            }).showInBestPositionFor(DataManager.getInstance().getDataContext());
        } else {
            this.annotateExternally(roots[0], annotation);
        }
    }

    private static VirtualFile @NotNull [] filterByReadOnliness(VirtualFile @NotNull [] files) {
        if (files == null) {
            ExternalAnnotationsManagerImpl.$$$reportNull$$$0(32);
        }
        List result = ContainerUtil.filter((Object[])files, VirtualFile::isInLocalFileSystem);
        VirtualFile[] virtualFileArray = VfsUtilCore.toVirtualFileArray((Collection)result);
        if (virtualFileArray == null) {
            ExternalAnnotationsManagerImpl.$$$reportNull$$$0(33);
        }
        return virtualFileArray;
    }

    @Override
    public boolean deannotate(@NotNull PsiModifierListOwner listOwner, @NotNull String annotationFQN) {
        if (listOwner == null) {
            ExternalAnnotationsManagerImpl.$$$reportNull$$$0(34);
        }
        if (annotationFQN == null) {
            ExternalAnnotationsManagerImpl.$$$reportNull$$$0(35);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        return this.processExistingExternalAnnotations(listOwner, annotationFQN, (Processor<? super XmlTag>)((Processor)annotationTag -> {
            PsiElement parent = annotationTag.getParent();
            annotationTag.delete();
            if (parent instanceof XmlTag && ((XmlTag)parent).getSubTags().length == 0) {
                parent.delete();
            }
            return true;
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void elementRenamedOrMoved(@NotNull PsiModifierListOwner element, @NotNull String oldExternalName) {
        if (element == null) {
            ExternalAnnotationsManagerImpl.$$$reportNull$$$0(36);
        }
        if (oldExternalName == null) {
            ExternalAnnotationsManagerImpl.$$$reportNull$$$0(37);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        try {
            List<XmlFile> files = this.findExternalAnnotationsXmlFiles(element);
            if (files == null) {
                return;
            }
            for (XmlFile file : files) {
                XmlTag rootTag;
                XmlDocument document;
                if (!file.isValid() || (document = file.getDocument()) == null || (rootTag = document.getRootTag()) == null) continue;
                for (XmlTag tag : rootTag.getSubTags()) {
                    String className2;
                    String nameValue = tag.getAttributeValue("name");
                    String string = className2 = nameValue == null ? null : StringUtil.unescapeXmlEntities((String)nameValue);
                    if (!Comparing.strEqual((String)className2, (String)oldExternalName)) continue;
                    WriteCommandAction.runWriteCommandAction((Project)this.myPsiManager.getProject(), (String)ExternalAnnotationsManagerImpl.class.getName(), null, () -> {
                        PsiDocumentManager.getInstance((Project)this.myPsiManager.getProject()).commitAllDocuments();
                        try {
                            String name2 = ExternalAnnotationsManagerImpl.getExternalName(element);
                            tag.setAttribute("name", name2 == null ? null : StringUtil.escapeXmlEntities((String)name2));
                            this.commitChanges(file);
                        }
                        catch (IncorrectOperationException e) {
                            LOG.error((Throwable)e);
                        }
                    }, (PsiFile[])new PsiFile[]{file});
                }
            }
        }
        finally {
            this.dropAnnotationsCache();
        }
    }

    @Override
    public boolean editExternalAnnotation(@NotNull PsiModifierListOwner listOwner, @NotNull String annotationFQN, PsiNameValuePair @Nullable [] value2) {
        if (listOwner == null) {
            ExternalAnnotationsManagerImpl.$$$reportNull$$$0(38);
        }
        if (annotationFQN == null) {
            ExternalAnnotationsManagerImpl.$$$reportNull$$$0(39);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        return this.processExistingExternalAnnotations(listOwner, annotationFQN, (Processor<? super XmlTag>)((Processor)annotationTag -> {
            annotationTag.replace((PsiElement)XmlElementFactory.getInstance((Project)this.myPsiManager.getProject()).createTagFromText((CharSequence)ExternalAnnotationsManagerImpl.createAnnotationTag(annotationFQN, value2)));
            return true;
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processExistingExternalAnnotations(@NotNull PsiModifierListOwner listOwner, @NotNull String annotationFQN, @NotNull Processor<? super XmlTag> annotationTagProcessor) {
        if (listOwner == null) {
            ExternalAnnotationsManagerImpl.$$$reportNull$$$0(40);
        }
        if (annotationFQN == null) {
            ExternalAnnotationsManagerImpl.$$$reportNull$$$0(41);
        }
        if (annotationTagProcessor == null) {
            ExternalAnnotationsManagerImpl.$$$reportNull$$$0(42);
        }
        try {
            List<XmlFile> files = this.findExternalAnnotationsXmlFiles(listOwner);
            if (files == null) {
                this.notifyAfterAnnotationChanging(listOwner, annotationFQN, false);
                boolean bl = false;
                return bl;
            }
            boolean processedAnything = false;
            for (XmlFile file : files) {
                XmlTag rootTag;
                XmlDocument document;
                if (!file.isValid() || (document = file.getDocument()) == null || (rootTag = document.getRootTag()) == null) continue;
                String externalName = ExternalAnnotationsManagerImpl.getExternalName(listOwner);
                ArrayList<XmlTag> tagsToProcess = new ArrayList<XmlTag>();
                for (XmlTag tag : rootTag.getSubTags()) {
                    String className2;
                    String nameValue = tag.getAttributeValue("name");
                    String string = className2 = nameValue == null ? null : StringUtil.unescapeXmlEntities((String)nameValue);
                    if (!Comparing.strEqual((String)className2, (String)externalName)) continue;
                    for (XmlTag annotationTag : tag.getSubTags()) {
                        if (!Comparing.strEqual((String)annotationTag.getAttributeValue("name"), (String)annotationFQN)) continue;
                        tagsToProcess.add(annotationTag);
                        processedAnything = true;
                    }
                }
                if (tagsToProcess.isEmpty() || ReadonlyStatusHandler.getInstance((Project)this.myPsiManager.getProject()).ensureFilesWritable(Collections.singletonList(file.getVirtualFile())).hasReadonlyFiles()) continue;
                WriteCommandAction.runWriteCommandAction((Project)this.myPsiManager.getProject(), (String)ExternalAnnotationsManagerImpl.class.getName(), null, () -> {
                    PsiDocumentManager.getInstance((Project)this.myPsiManager.getProject()).commitAllDocuments();
                    try {
                        for (XmlTag annotationTag : tagsToProcess) {
                            annotationTagProcessor.process((Object)annotationTag);
                        }
                        this.commitChanges(file);
                    }
                    catch (IncorrectOperationException e) {
                        LOG.error((Throwable)e);
                    }
                }, (PsiFile[])new PsiFile[0]);
            }
            this.notifyAfterAnnotationChanging(listOwner, annotationFQN, processedAnything);
            boolean bl = processedAnything;
            return bl;
        }
        finally {
            this.dropAnnotationsCache();
        }
    }

    @Override
    @NotNull
    public ExternalAnnotationsManager.AnnotationPlace chooseAnnotationsPlaceNoUi(@NotNull PsiElement element) {
        if (element == null) {
            ExternalAnnotationsManagerImpl.$$$reportNull$$$0(43);
        }
        return this.chooseAnnotationsPlace(element, () -> ExternalAnnotationsManager.AnnotationPlace.NEED_ASK_USER);
    }

    @Override
    @NotNull
    public ExternalAnnotationsManager.AnnotationPlace chooseAnnotationsPlace(@NotNull PsiElement element) {
        if (element == null) {
            ExternalAnnotationsManagerImpl.$$$reportNull$$$0(44);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        return this.chooseAnnotationsPlace(element, () -> ExternalAnnotationsManagerImpl.confirmNewExternalAnnotationRoot(element));
    }

    @NotNull
    private ExternalAnnotationsManager.AnnotationPlace chooseAnnotationsPlace(@NotNull PsiElement element, @NotNull Supplier<ExternalAnnotationsManager.AnnotationPlace> confirmNewExternalAnnotationRoot) {
        if (element == null) {
            ExternalAnnotationsManagerImpl.$$$reportNull$$$0(45);
        }
        if (confirmNewExternalAnnotationRoot == null) {
            ExternalAnnotationsManagerImpl.$$$reportNull$$$0(46);
        }
        if (!element.isPhysical() && !(element.getOriginalElement() instanceof PsiCompiledElement)) {
            ExternalAnnotationsManager.AnnotationPlace annotationPlace = ExternalAnnotationsManager.AnnotationPlace.IN_CODE;
            if (annotationPlace == null) {
                ExternalAnnotationsManagerImpl.$$$reportNull$$$0(47);
            }
            return annotationPlace;
        }
        if (!element.getManager().isInProject(element)) {
            ExternalAnnotationsManager.AnnotationPlace annotationPlace = ExternalAnnotationsManager.AnnotationPlace.EXTERNAL;
            if (annotationPlace == null) {
                ExternalAnnotationsManagerImpl.$$$reportNull$$$0(48);
            }
            return annotationPlace;
        }
        Project project = this.myPsiManager.getProject();
        PsiFile containingFile = element.getContainingFile();
        if (containingFile != null && JavaCodeStyleSettings.getInstance((PsiFile)containingFile).USE_EXTERNAL_ANNOTATIONS) {
            VirtualFile virtualFile = containingFile.getVirtualFile();
            LOG.assertTrue(virtualFile != null);
            List entries = ProjectRootManager.getInstance((Project)project).getFileIndex().getOrderEntriesForFile(virtualFile);
            if (!entries.isEmpty()) {
                for (OrderEntry entry : entries) {
                    if (entry instanceof ModuleOrderEntry) continue;
                    if (AnnotationOrderRootType.getUrls((OrderEntry)entry).length <= 0) break;
                    ExternalAnnotationsManager.AnnotationPlace annotationPlace = ExternalAnnotationsManager.AnnotationPlace.EXTERNAL;
                    if (annotationPlace == null) {
                        ExternalAnnotationsManagerImpl.$$$reportNull$$$0(49);
                    }
                    return annotationPlace;
                }
            }
            ExternalAnnotationsManager.AnnotationPlace annotationPlace = confirmNewExternalAnnotationRoot.get();
            if (annotationPlace == null) {
                ExternalAnnotationsManagerImpl.$$$reportNull$$$0(50);
            }
            return annotationPlace;
        }
        ExternalAnnotationsManager.AnnotationPlace annotationPlace = ExternalAnnotationsManager.AnnotationPlace.IN_CODE;
        if (annotationPlace == null) {
            ExternalAnnotationsManagerImpl.$$$reportNull$$$0(51);
        }
        return annotationPlace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private static ExternalAnnotationsManager.AnnotationPlace confirmNewExternalAnnotationRoot(@NotNull PsiElement element) {
        block13: {
            MyExternalPromptDialog dialog;
            if (element == null) {
                ExternalAnnotationsManagerImpl.$$$reportNull$$$0(52);
            }
            PsiFile containingFile = element.getContainingFile();
            Project project = containingFile.getProject();
            MyExternalPromptDialog myExternalPromptDialog = dialog = ApplicationManager.getApplication().isUnitTestMode() || ApplicationManager.getApplication().isHeadlessEnvironment() ? null : new MyExternalPromptDialog(project);
            if (dialog != null && dialog.isToBeShown()) {
                ExternalAnnotationsManager.AnnotationPlace annotationPlace;
                PsiElement highlightElement = element instanceof PsiNameIdentifierOwner ? ((PsiNameIdentifierOwner)element).getNameIdentifier() : element.getNavigationElement();
                LOG.assertTrue(highlightElement != null);
                Editor editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
                ArrayList highlighters = new ArrayList();
                boolean highlight = editor != null && editor.getDocument() == PsiDocumentManager.getInstance((Project)project).getDocument(containingFile);
                if (highlight) {
                    TextRange textRange = highlightElement.getTextRange();
                    HighlightManager.getInstance((Project)project).addRangeHighlight(editor, textRange.getStartOffset(), textRange.getEndOffset(), EditorColors.SEARCH_RESULT_ATTRIBUTES, true, highlighters);
                    LogicalPosition logicalPosition = editor.offsetToLogicalPosition(textRange.getStartOffset());
                    editor.getScrollingModel().scrollTo(logicalPosition, ScrollType.CENTER);
                }
                dialog.show();
                if (dialog.getExitCode() == 2) {
                    annotationPlace = ExternalAnnotationsManager.AnnotationPlace.EXTERNAL;
                    ExternalAnnotationsManager.AnnotationPlace annotationPlace2 = annotationPlace;
                    if (annotationPlace2 == null) {
                        ExternalAnnotationsManagerImpl.$$$reportNull$$$0(53);
                    }
                    return annotationPlace2;
                }
                if (dialog.getExitCode() != 1) break block13;
                annotationPlace = ExternalAnnotationsManager.AnnotationPlace.NOWHERE;
                ExternalAnnotationsManager.AnnotationPlace annotationPlace3 = annotationPlace;
                if (annotationPlace3 == null) {
                    ExternalAnnotationsManagerImpl.$$$reportNull$$$0(54);
                }
                return annotationPlace3;
                finally {
                    if (highlight) {
                        HighlightManager.getInstance((Project)project).removeSegmentHighlighter(editor, (RangeHighlighter)highlighters.get(0));
                    }
                }
            }
            if (dialog != null) {
                dialog.close(0);
            }
        }
        ExternalAnnotationsManager.AnnotationPlace annotationPlace = ExternalAnnotationsManager.AnnotationPlace.IN_CODE;
        if (annotationPlace == null) {
            ExternalAnnotationsManagerImpl.$$$reportNull$$$0(55);
        }
        return annotationPlace;
    }

    private void appendChosenAnnotationsRoot(@NotNull OrderEntry entry, @NotNull VirtualFile vFile) {
        if (entry == null) {
            ExternalAnnotationsManagerImpl.$$$reportNull$$$0(56);
        }
        if (vFile == null) {
            ExternalAnnotationsManagerImpl.$$$reportNull$$$0(57);
        }
        if (entry instanceof LibraryOrderEntry) {
            Library library = ((LibraryOrderEntry)entry).getLibrary();
            LOG.assertTrue(library != null);
            Library.ModifiableModel model = library.getModifiableModel();
            model.addRoot(vFile, AnnotationOrderRootType.getInstance());
            model.commit();
        } else if (entry instanceof ModuleSourceOrderEntry) {
            ModifiableRootModel model = ModuleRootManager.getInstance((Module)entry.getOwnerModule()).getModifiableModel();
            JavaModuleExternalPaths extension = (JavaModuleExternalPaths)model.getModuleExtension(JavaModuleExternalPaths.class);
            extension.setExternalAnnotationUrls(ArrayUtil.mergeArrays((String[])extension.getExternalAnnotationsUrls(), (String[])new String[]{vFile.getUrl()}));
            model.commit();
        } else if (entry instanceof JdkOrderEntry) {
            SdkModificator sdkModificator = ((JdkOrderEntry)entry).getJdk().getSdkModificator();
            sdkModificator.addRoot(vFile, AnnotationOrderRootType.getInstance());
            sdkModificator.commitChanges();
        }
        this.dropAnnotationsCache();
    }

    private static void sortItems(@NotNull XmlFile xmlFile) {
        XmlDocument document;
        if (xmlFile == null) {
            ExternalAnnotationsManagerImpl.$$$reportNull$$$0(58);
        }
        if ((document = xmlFile.getDocument()) == null) {
            return;
        }
        XmlTag rootTag = document.getRootTag();
        if (rootTag == null) {
            return;
        }
        ArrayList<XmlTag> itemTags = new ArrayList<XmlTag>();
        for (XmlTag item : rootTag.getSubTags()) {
            if (item.getAttributeValue("name") != null) {
                itemTags.add(item);
                continue;
            }
            item.delete();
        }
        ArrayList sorted = new ArrayList(itemTags);
        sorted.sort((item1, item2) -> {
            String externalName1 = item1.getAttributeValue("name");
            String externalName2 = item2.getAttributeValue("name");
            assert (externalName1 != null && externalName2 != null);
            return externalName1.compareTo(externalName2);
        });
        if (!sorted.equals(itemTags)) {
            for (XmlTag item : sorted) {
                rootTag.addAfter((PsiElement)item, null);
                item.delete();
            }
        }
    }

    private void commitChanges(XmlFile xmlFile) {
        ExternalAnnotationsManagerImpl.sortItems(xmlFile);
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)this.myPsiManager.getProject());
        Document doc = documentManager.getDocument((PsiFile)xmlFile);
        assert (doc != null);
        documentManager.doPostponedOperationsAndUnblockDocument(doc);
        FileDocumentManager.getInstance().saveDocument(doc);
    }

    @NonNls
    @NotNull
    private static String createItemTag(@NotNull String ownerName, @NotNull ExternalAnnotation annotation) {
        if (ownerName == null) {
            ExternalAnnotationsManagerImpl.$$$reportNull$$$0(59);
        }
        if (annotation == null) {
            ExternalAnnotationsManagerImpl.$$$reportNull$$$0(60);
        }
        String annotationTag = ExternalAnnotationsManagerImpl.createAnnotationTag(annotation.getAnnotationFQName(), annotation.getValues());
        String string = String.format("<item name='%s'>%s</item>", ownerName, annotationTag);
        if (string == null) {
            ExternalAnnotationsManagerImpl.$$$reportNull$$$0(61);
        }
        return string;
    }

    @NonNls
    @VisibleForTesting
    @NotNull
    public static String createAnnotationTag(@NotNull String annotationFQName, PsiNameValuePair @Nullable [] values) {
        String text2;
        if (annotationFQName == null) {
            ExternalAnnotationsManagerImpl.$$$reportNull$$$0(62);
        }
        if (values != null && values.length != 0) {
            text2 = "  <annotation name='" + annotationFQName + "'>\n";
            text2 = text2 + StringUtil.join((Object[])values, pair2 -> "<val" + (pair2.getName() != null ? " name=\"" + pair2.getName() + "\"" : "") + " val=\"" + StringUtil.escapeXmlEntities((String)pair2.getValue().getText()) + "\"/>", (String)"    \n");
            text2 = text2 + "  </annotation>";
        } else {
            text2 = "  <annotation name='" + annotationFQName + "'/>\n";
        }
        String string = text2;
        if (string == null) {
            ExternalAnnotationsManagerImpl.$$$reportNull$$$0(63);
        }
        return string;
    }

    @Nullable
    private XmlFile createAnnotationsXml(@NotNull VirtualFile root, @NonNls @NotNull String packageName) {
        if (root == null) {
            ExternalAnnotationsManagerImpl.$$$reportNull$$$0(64);
        }
        if (packageName == null) {
            ExternalAnnotationsManagerImpl.$$$reportNull$$$0(65);
        }
        return ExternalAnnotationsManagerImpl.createAnnotationsXml(root, packageName, this.myPsiManager);
    }

    @VisibleForTesting
    @Nullable
    public static XmlFile createAnnotationsXml(@NotNull VirtualFile root, @NonNls @NotNull String packageName, PsiManager manager) {
        String[] dirs;
        if (root == null) {
            ExternalAnnotationsManagerImpl.$$$reportNull$$$0(66);
        }
        if (packageName == null) {
            ExternalAnnotationsManagerImpl.$$$reportNull$$$0(67);
        }
        for (String dir : dirs = packageName.split("\\.")) {
            if (dir.isEmpty()) break;
            VirtualFile subdir = root.findChild(dir);
            if (subdir == null) {
                try {
                    subdir = root.createChildDirectory(null, dir);
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                    return null;
                }
            }
            root = subdir;
        }
        PsiDirectory directory = manager.findDirectory(root);
        if (directory == null) {
            return null;
        }
        PsiFile psiFile = directory.findFile("annotations.xml");
        if (psiFile instanceof XmlFile) {
            return (XmlFile)psiFile;
        }
        try {
            PsiFileFactory factory = PsiFileFactory.getInstance((Project)manager.getProject());
            return (XmlFile)directory.add((PsiElement)factory.createFileFromText("annotations.xml", (FileType)XmlFileType.INSTANCE, (CharSequence)"<root></root>"));
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    @Nullable
    private XmlFile getFileForAnnotations(@NotNull VirtualFile root, @NotNull PsiModifierListOwner owner2, Project project) {
        String packageName;
        if (root == null) {
            ExternalAnnotationsManagerImpl.$$$reportNull$$$0(68);
        }
        if (owner2 == null) {
            ExternalAnnotationsManagerImpl.$$$reportNull$$$0(69);
        }
        PsiFile containingFile = owner2.getOriginalElement().getContainingFile();
        String string = owner2 instanceof PsiPackage ? ((PsiPackage)owner2).getQualifiedName() : (packageName = containingFile instanceof PsiJavaFile ? ((PsiJavaFile)containingFile).getPackageName() : null);
        if (packageName == null) {
            return null;
        }
        List<XmlFile> annotationsFiles = this.findExternalAnnotationsXmlFiles(owner2);
        XmlFile fileInRoot = ExternalAnnotationsManagerImpl.findXmlFileInRoot(annotationsFiles, root);
        if (fileInRoot != null) {
            return fileInRoot;
        }
        return (XmlFile)WriteCommandAction.writeCommandAction((Project)project).compute(() -> {
            PsiModifierListOwner key2;
            XmlFile newAnnotationsFile = this.createAnnotationsXml(root, packageName);
            if (newAnnotationsFile == null) {
                return null;
            }
            Object object = key2 = owner2 instanceof PsiPackage ? owner2 : containingFile.getVirtualFile();
            if (key2 != null) {
                this.registerExternalAnnotations(key2, (PsiFile)newAnnotationsFile);
            }
            return newAnnotationsFile;
        });
    }

    @Override
    public boolean hasAnnotationRootsForFile(@NotNull VirtualFile file) {
        if (file == null) {
            ExternalAnnotationsManagerImpl.$$$reportNull$$$0(70);
        }
        if (this.hasAnyAnnotationsRoots()) {
            ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)this.myPsiManager.getProject()).getFileIndex();
            for (OrderEntry entry : fileIndex.getOrderEntriesForFile(file)) {
                if (entry instanceof ModuleOrderEntry || AnnotationOrderRootType.getUrls((OrderEntry)entry).length <= 0) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected void duplicateError(@NotNull PsiFile file, @NotNull String externalName, @NotNull String text2) {
        if (file == null) {
            ExternalAnnotationsManagerImpl.$$$reportNull$$$0(71);
        }
        if (externalName == null) {
            ExternalAnnotationsManagerImpl.$$$reportNull$$$0(72);
        }
        if (text2 == null) {
            ExternalAnnotationsManagerImpl.$$$reportNull$$$0(73);
        }
        String message2 = text2 + "; for signature: '" + externalName + "' in the file " + file.getName();
        LOG.error(message2, new Throwable(), new Attachment[]{AttachmentFactory.createAttachment((VirtualFile)file.getVirtualFile())});
    }

    public static boolean areExternalAnnotationsApplicable(@NotNull PsiModifierListOwner owner2) {
        PsiElement parent;
        PsiElement originalElement;
        if (owner2 == null) {
            ExternalAnnotationsManagerImpl.$$$reportNull$$$0(74);
        }
        if (!owner2.isPhysical() && !((originalElement = owner2.getOriginalElement()) instanceof PsiCompiledElement)) {
            return false;
        }
        if (owner2 instanceof PsiLocalVariable) {
            return false;
        }
        if (owner2 instanceof PsiParameter && ((parent = owner2.getParent()) == null || !(parent.getParent() instanceof PsiMethod))) {
            return false;
        }
        if (!owner2.getManager().isInProject((PsiElement)owner2)) {
            return true;
        }
        return JavaCodeStyleSettings.getInstance((PsiFile)owner2.getContainingFile()).USE_EXTERNAL_ANNOTATIONS;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 14: 
            case 22: 
            case 33: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 53: 
            case 54: 
            case 55: 
            case 61: 
            case 63: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 14: 
            case 22: 
            case 33: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 53: 
            case 54: 
            case 55: 
            case 61: 
            case 63: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 69: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 2: 
            case 4: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationFQName";
                break;
            }
            case 3: 
            case 25: 
            case 34: 
            case 38: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listOwner";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromFile";
                break;
            }
            case 6: 
            case 8: 
            case 29: 
            case 64: 
            case 66: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 7: 
            case 13: 
            case 17: 
            case 21: 
            case 24: 
            case 28: 
            case 30: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotations";
                break;
            }
            case 11: 
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootTag";
                break;
            }
            case 12: 
            case 16: 
            case 20: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ownerName";
                break;
            }
            case 14: 
            case 22: 
            case 33: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 53: 
            case 54: 
            case 55: 
            case 61: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/ExternalAnnotationsManagerImpl";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "curItem";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "itemTag";
                break;
            }
            case 26: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 35: 
            case 39: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationFQN";
                break;
            }
            case 36: 
            case 43: 
            case 44: 
            case 45: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldExternalName";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationTagProcessor";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "confirmNewExternalAnnotationRoot";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xmlFile";
                break;
            }
            case 65: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 70: 
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalName";
                break;
            }
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/ExternalAnnotationsManagerImpl";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "addAnnotation";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "addItemTag";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "filterByReadOnliness";
                break;
            }
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "chooseAnnotationsPlace";
                break;
            }
            case 53: 
            case 54: 
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "confirmNewExternalAnnotationRoot";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "createItemTag";
                break;
            }
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "createAnnotationTag";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "notifyAfterAnnotationChanging";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "annotateExternally";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addAnnotation";
                break;
            }
            case 14: 
            case 22: 
            case 33: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 53: 
            case 54: 
            case 55: 
            case 61: 
            case 63: {
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "addItemTag";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "appendItemAnnotation";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "findExternalAnnotationsXmlFiles";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "setupRootAndAnnotateExternally";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "findXmlFileInRoot";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "chooseRootAndAnnotateExternally";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "filterByReadOnliness";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "deannotate";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "elementRenamedOrMoved";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "editExternalAnnotation";
                break;
            }
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "processExistingExternalAnnotations";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "chooseAnnotationsPlaceNoUi";
                break;
            }
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "chooseAnnotationsPlace";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "confirmNewExternalAnnotationRoot";
                break;
            }
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "appendChosenAnnotationsRoot";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "sortItems";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "createItemTag";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "createAnnotationTag";
                break;
            }
            case 64: 
            case 65: 
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "createAnnotationsXml";
                break;
            }
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "getFileForAnnotations";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "hasAnnotationRootsForFile";
                break;
            }
            case 71: 
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "duplicateError";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "areExternalAnnotationsApplicable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 14: 
            case 22: 
            case 33: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 53: 
            case 54: 
            case 55: 
            case 61: 
            case 63: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyDocumentListener
    implements DocumentListener {
        final FileDocumentManager myFileDocumentManager = FileDocumentManager.getInstance();

        private MyDocumentListener() {
        }

        public void documentChanged(@NotNull DocumentEvent event) {
            VirtualFile file;
            if (event == null) {
                MyDocumentListener.$$$reportNull$$$0(0);
            }
            if ((file = this.myFileDocumentManager.getFile(event.getDocument())) != null && "annotations.xml".equals(file.getName()) && ExternalAnnotationsManagerImpl.this.isUnderAnnotationRoot(file)) {
                ExternalAnnotationsManagerImpl.this.dropAnnotationsCache();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/codeInsight/ExternalAnnotationsManagerImpl$MyDocumentListener", "documentChanged"));
        }
    }

    private static class MyExternalPromptDialog
    extends OptionsMessageDialog {
        private final Project myProject;

        MyExternalPromptDialog(Project project) {
            super(project, MyExternalPromptDialog.getMessage(), JavaBundle.message((String)"external.annotation.prompt", (Object[])new Object[0]), Messages.getQuestionIcon());
            this.myProject = project;
            this.init();
        }

        protected String getOkActionName() {
            return MyExternalPromptDialog.getAddInCode();
        }

        @NotNull
        protected String getCancelActionName() {
            String string = CommonBundle.getCancelButtonText();
            if (string == null) {
                MyExternalPromptDialog.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected Action @NotNull [] createActions() {
            Action okAction = this.getOKAction();
            MyExternalPromptDialog.assignMnemonic((String)MyExternalPromptDialog.getAddInCode(), (Action)okAction);
            final String externalName = JavaBundle.message((String)"external.annotations.external.option", (Object[])new Object[0]);
            Action[] actionArray = new Action[]{okAction, new AbstractAction(externalName){
                {
                    super(arg0);
                    MyExternalPromptDialog.assignMnemonic((String)externalName, (Action)this);
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (this.canBeHidden()) {
                        this.setToBeShown(this.toBeShown(), true);
                    }
                    this.close(2);
                }
            }, this.getCancelAction()};
            if (actionArray == null) {
                MyExternalPromptDialog.$$$reportNull$$$0(1);
            }
            return actionArray;
        }

        protected boolean isToBeShown() {
            return ((JavaCodeStyleSettings)CodeStyleSettingsManager.getSettings((Project)this.myProject).getCustomSettings(JavaCodeStyleSettings.class)).USE_EXTERNAL_ANNOTATIONS;
        }

        protected void setToBeShown(boolean value2, boolean onOk) {
            ((JavaCodeStyleSettings)CodeStyleSettingsManager.getSettings((Project)this.myProject).getCustomSettings(JavaCodeStyleSettings.class)).USE_EXTERNAL_ANNOTATIONS = value2;
        }

        @NotNull
        protected JComponent createNorthPanel() {
            JPanel northPanel = (JPanel)super.createNorthPanel();
            northPanel.add((Component)new JLabel(MyExternalPromptDialog.getMessage()), "Center");
            JPanel jPanel = northPanel;
            if (jPanel == null) {
                MyExternalPromptDialog.$$$reportNull$$$0(2);
            }
            return jPanel;
        }

        protected boolean shouldSaveOptionsOnCancel() {
            return true;
        }

        private static String getAddInCode() {
            return JavaBundle.message((String)"external.annotations.in.code.option", (Object[])new Object[0]);
        }

        private static String getMessage() {
            return JavaBundle.message((String)"external.annotations.suggestion.message", (Object[])new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/codeInsight/ExternalAnnotationsManagerImpl$MyExternalPromptDialog";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCancelActionName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createActions";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createNorthPanel";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

