/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInspection.java15api.Java15APIUsageInspection;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiMethodReferenceUtil;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AnnotatedMembersSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FunctionalInterfaceSuggester {
    public static final String[] FUNCTIONAL_INTERFACES = new String[]{"java.lang.Runnable", "java.util.concurrent.Callable", "java.util.Comparator", "com.intellij.util.Function", "com.intellij.util.Consumer", "com.intellij.openapi.util.Computable", "com.intellij.openapi.util.Condition", "com.intellij.util.Processor", "com.intellij.util.Producer", "com.google.common.base.Function", "com.google.common.base.Predicate", "com.google.common.base.Supplier", "org.apache.commons.collections.Closure", "org.apache.commons.collections.Factory", "org.apache.commons.collections.Predicate", "org.apache.commons.collections.Transformer", "gnu.trove.TObjectFunction", "gnu.trove.TObjectProcedure", "gnu.trove.TObjectObjectProcedure"};

    public static Collection<? extends PsiType> suggestFunctionalInterfaces(@NotNull PsiFunctionalExpression expression2) {
        if (expression2 == null) {
            FunctionalInterfaceSuggester.$$$reportNull$$$0(0);
        }
        PsiType qualifierType = expression2 instanceof PsiMethodReferenceExpression ? PsiMethodReferenceUtil.getQualifierType((PsiMethodReferenceExpression)((PsiMethodReferenceExpression)expression2)) : null;
        return FunctionalInterfaceSuggester.suggestFunctionalInterfaces(expression2, aClass -> FunctionalInterfaceSuggester.composeAcceptableType(aClass, expression2, qualifierType));
    }

    public static Collection<? extends PsiType> suggestFunctionalInterfaces(@NotNull PsiMethod method) {
        if (method == null) {
            FunctionalInterfaceSuggester.$$$reportNull$$$0(1);
        }
        return FunctionalInterfaceSuggester.suggestFunctionalInterfaces(method, false);
    }

    public static Collection<? extends PsiType> suggestFunctionalInterfaces(@NotNull PsiMethod method, boolean suggestUnhandledThrowables) {
        if (method == null) {
            FunctionalInterfaceSuggester.$$$reportNull$$$0(2);
        }
        if (method.isConstructor()) {
            return Collections.emptyList();
        }
        return FunctionalInterfaceSuggester.suggestFunctionalInterfaces(method, aClass -> {
            PsiMethod interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiClass)aClass);
            if (interfaceMethod != null) {
                PsiClassType[] thrownTypes;
                PsiParameter[] interfaceMethodParameters;
                PsiParameter[] parameters2 = method.getParameterList().getParameters();
                if (parameters2.length != (interfaceMethodParameters = interfaceMethod.getParameterList().getParameters()).length) {
                    return Collections.emptyList();
                }
                PsiType[] left = new PsiType[parameters2.length + 1];
                PsiType[] right = new PsiType[parameters2.length + 1];
                for (int i = 0; i < parameters2.length; ++i) {
                    left[i] = interfaceMethodParameters[i].getType();
                    right[i] = parameters2[i].getType();
                }
                left[parameters2.length] = method.getReturnType();
                right[parameters2.length] = interfaceMethod.getReturnType();
                PsiTypeParameter[] typeParameters = aClass.getTypeParameters();
                PsiSubstitutor substitutor = PsiResolveHelper.SERVICE.getInstance((Project)aClass.getProject()).inferTypeArguments(typeParameters, left, right, PsiUtil.getLanguageLevel((PsiElement)method));
                if (PsiUtil.isRawSubstitutor((PsiTypeParameterListOwner)aClass, (PsiSubstitutor)substitutor)) {
                    return Collections.emptyList();
                }
                for (int i = 0; i < interfaceMethodParameters.length; ++i) {
                    PsiType paramType = parameters2[i].getType();
                    PsiType interfaceParamType = substitutor.substitute(interfaceMethodParameters[i].getType());
                    if (!(interfaceParamType instanceof PsiPrimitiveType) ? TypeConversionUtil.isAssignable((PsiType)paramType, (PsiType)interfaceParamType) : paramType.equals(interfaceParamType)) continue;
                    return Collections.emptyList();
                }
                PsiType returnType = method.getReturnType();
                PsiType interfaceMethodReturnType = substitutor.substitute(interfaceMethod.getReturnType());
                if (returnType != null && !TypeConversionUtil.isAssignable((PsiType)returnType, (PsiType)interfaceMethodReturnType)) {
                    return Collections.emptyList();
                }
                if (interfaceMethodReturnType instanceof PsiPrimitiveType && !interfaceMethodReturnType.equals(returnType)) {
                    return Collections.emptyList();
                }
                PsiClassType[] interfaceThrownTypes = interfaceMethod.getThrowsList().getReferencedTypes();
                for (PsiClassType thrownType : thrownTypes = method.getThrowsList().getReferencedTypes()) {
                    if (ExceptionUtil.isHandledBy(thrownType, interfaceThrownTypes, substitutor)) continue;
                    return Collections.emptyList();
                }
                if (!suggestUnhandledThrowables) {
                    for (PsiClassType thrownType : interfaceThrownTypes) {
                        PsiCodeBlock codeBlock = (PsiCodeBlock)PsiTreeUtil.getContextOfType((PsiElement)method, (Class[])new Class[]{PsiCodeBlock.class});
                        PsiType substitutedThrowable = substitutor.substitute((PsiType)thrownType);
                        if (codeBlock != null && substitutedThrowable instanceof PsiClassType && ExceptionUtil.isHandled((PsiClassType)substitutedThrowable, (PsiElement)codeBlock)) continue;
                        return Collections.emptyList();
                    }
                }
                PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)aClass.getProject());
                return Collections.singletonList(elementFactory.createType(aClass, substitutor));
            }
            return Collections.emptyList();
        });
    }

    private static <T extends PsiElement> Collection<? extends PsiType> suggestFunctionalInterfaces(@NotNull T element, Function<? super PsiClass, ? extends List<? extends PsiType>> acceptanceChecker) {
        GlobalSearchScope allScope;
        if (element == null) {
            FunctionalInterfaceSuggester.$$$reportNull$$$0(3);
        }
        Project project = element.getProject();
        HashSet types = new HashSet();
        Processor consumer = member -> {
            if (member instanceof PsiClass && Java15APIUsageInspection.getLastIncompatibleLanguageLevel(member, PsiUtil.getLanguageLevel((PsiElement)element)) == null) {
                if (!JavaPsiFacade.getInstance((Project)project).getResolveHelper().isAccessible(member, element, null)) {
                    return true;
                }
                types.addAll((Collection)acceptanceChecker.apply((PsiClass)member));
            }
            return true;
        };
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
        PsiClass functionalInterfaceClass = psiFacade.findClass("java.lang.FunctionalInterface", allScope = GlobalSearchScope.allScope((Project)project));
        if (functionalInterfaceClass != null) {
            AnnotatedMembersSearch.search((PsiClass)functionalInterfaceClass, (SearchScope)element.getResolveScope()).forEach(consumer);
        }
        for (String functionalInterface : FUNCTIONAL_INTERFACES) {
            PsiClass aClass = psiFacade.findClass(functionalInterface, element.getResolveScope());
            if (aClass == null) continue;
            consumer.process((Object)aClass);
        }
        ArrayList<PsiType> typesToSuggest = new ArrayList<PsiType>(types);
        typesToSuggest.sort(Comparator.comparing(PsiType::getCanonicalText));
        return typesToSuggest;
    }

    private static List<? extends PsiType> composeAcceptableType(@NotNull PsiClass interface2Consider, @NotNull PsiFunctionalExpression expression2, PsiType qualifierType) {
        PsiClassType type2;
        if (interface2Consider == null) {
            FunctionalInterfaceSuggester.$$$reportNull$$$0(4);
        }
        if (expression2 == null) {
            FunctionalInterfaceSuggester.$$$reportNull$$$0(5);
        }
        if (expression2.isAcceptable((PsiType)(type2 = JavaPsiFacade.getElementFactory((Project)interface2Consider.getProject()).createType(interface2Consider, PsiSubstitutor.EMPTY)))) {
            return Collections.singletonList(type2);
        }
        return FunctionalInterfaceSuggester.composeAcceptableType1(interface2Consider, expression2, qualifierType);
    }

    @NotNull
    private static List<? extends PsiType> composeAcceptableType1(PsiClass interface2Consider, PsiFunctionalExpression expression2, PsiType qualifierType) {
        PsiMethod interfaceMethod;
        if (interface2Consider.hasTypeParameters() && (interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiClass)interface2Consider)) != null) {
            PsiParameter[] parameters2 = interfaceMethod.getParameterList().getParameters();
            Project project = interface2Consider.getProject();
            PsiType returnType = interfaceMethod.getReturnType();
            if (expression2 instanceof PsiLambdaExpression && ((PsiLambdaExpression)expression2).hasFormalParameterTypes()) {
                PsiParameter[] functionalExprParameters = ((PsiLambdaExpression)expression2).getParameterList().getParameters();
                if (parameters2.length != functionalExprParameters.length) {
                    List list = Collections.emptyList();
                    if (list == null) {
                        FunctionalInterfaceSuggester.$$$reportNull$$$0(6);
                    }
                    return list;
                }
                PsiType[] left = new PsiType[parameters2.length + 1];
                PsiType[] right = new PsiType[parameters2.length + 1];
                for (int i = 0; i < functionalExprParameters.length; ++i) {
                    left[i] = parameters2[i].getType();
                    right[i] = functionalExprParameters[i].getType();
                }
                List returnExpressions = LambdaUtil.getReturnExpressions((PsiLambdaExpression)((PsiLambdaExpression)expression2));
                left[parameters2.length] = returnExpressions.isEmpty() ? PsiType.VOID : ((PsiExpression)returnExpressions.get(0)).getType();
                right[parameters2.length] = returnType;
                PsiSubstitutor substitutor = PsiResolveHelper.SERVICE.getInstance((Project)project).inferTypeArguments(interface2Consider.getTypeParameters(), left, right, PsiUtil.getLanguageLevel((PsiElement)expression2));
                PsiClassType type2 = JavaPsiFacade.getElementFactory((Project)project).createType(interface2Consider, substitutor);
                if (expression2.isAcceptable((PsiType)type2)) {
                    List<PsiClassType> list = Collections.singletonList(type2);
                    if (list == null) {
                        FunctionalInterfaceSuggester.$$$reportNull$$$0(7);
                    }
                    return list;
                }
            } else if (expression2 instanceof PsiMethodReferenceExpression) {
                ArrayList types = new ArrayList();
                PsiMethodReferenceExpression referenceExpression = (PsiMethodReferenceExpression)expression2;
                for (JavaResolveResult result : referenceExpression.multiResolve(true)) {
                    PsiElement element = result.getElement();
                    if (element == null) continue;
                    if (element instanceof PsiMethod) {
                        PsiMethod method = (PsiMethod)element;
                        int offset = FunctionalInterfaceSuggester.hasOffset(referenceExpression, method) ? 1 : 0;
                        PsiParameter[] targetMethodParameters = method.getParameterList().getParameters();
                        if (targetMethodParameters.length + offset != parameters2.length) continue;
                        PsiType[] left = new PsiType[parameters2.length + 1];
                        PsiType[] right = new PsiType[parameters2.length + 1];
                        if (offset > 0) {
                            if (qualifierType == null) continue;
                            left[0] = parameters2[0].getType();
                            right[0] = qualifierType;
                        }
                        PsiSubstitutor partialSubstitutor = FunctionalInterfaceSuggester.getPartialSubstitutor(referenceExpression, method);
                        for (int i = 0; i < targetMethodParameters.length; ++i) {
                            left[i + offset] = parameters2[i + offset].getType();
                            right[i + offset] = partialSubstitutor.substitute(targetMethodParameters[i].getType());
                        }
                        left[parameters2.length] = method.isConstructor() ? qualifierType : partialSubstitutor.substitute(method.getReturnType());
                        right[parameters2.length] = returnType;
                        ContainerUtil.addIfNotNull(types, (Object)FunctionalInterfaceSuggester.getAcceptableType(interface2Consider, expression2, left, right));
                        continue;
                    }
                    if (!FunctionalInterfaceSuggester.maybeDefaultConstructorRef(referenceExpression, interfaceMethod, element)) continue;
                    PsiType[] left = new PsiType[]{qualifierType};
                    PsiType[] right = new PsiType[]{returnType};
                    ContainerUtil.addIfNotNull(types, (Object)FunctionalInterfaceSuggester.getAcceptableType(interface2Consider, expression2, left, right));
                }
                ArrayList arrayList = types;
                if (arrayList == null) {
                    FunctionalInterfaceSuggester.$$$reportNull$$$0(8);
                }
                return arrayList;
            }
        }
        List list = Collections.emptyList();
        if (list == null) {
            FunctionalInterfaceSuggester.$$$reportNull$$$0(9);
        }
        return list;
    }

    private static boolean maybeDefaultConstructorRef(@NotNull PsiMethodReferenceExpression expression2, @NotNull PsiMethod interfaceMethod, @NotNull PsiElement element) {
        if (expression2 == null) {
            FunctionalInterfaceSuggester.$$$reportNull$$$0(10);
        }
        if (interfaceMethod == null) {
            FunctionalInterfaceSuggester.$$$reportNull$$$0(11);
        }
        if (element == null) {
            FunctionalInterfaceSuggester.$$$reportNull$$$0(12);
        }
        return element instanceof PsiClass && ((PsiClass)element).getConstructors().length == 0 && expression2.isConstructor() && !interfaceMethod.hasParameters();
    }

    @Nullable
    private static PsiType getAcceptableType(@NotNull PsiClass interface2Consider, @NotNull PsiFunctionalExpression expression2, @NotNull PsiType[] left, @NotNull PsiType[] right) {
        if (interface2Consider == null) {
            FunctionalInterfaceSuggester.$$$reportNull$$$0(13);
        }
        if (expression2 == null) {
            FunctionalInterfaceSuggester.$$$reportNull$$$0(14);
        }
        if (left == null) {
            FunctionalInterfaceSuggester.$$$reportNull$$$0(15);
        }
        if (right == null) {
            FunctionalInterfaceSuggester.$$$reportNull$$$0(16);
        }
        Project project = interface2Consider.getProject();
        PsiSubstitutor substitutor = PsiResolveHelper.SERVICE.getInstance((Project)project).inferTypeArguments(interface2Consider.getTypeParameters(), left, right, PsiUtil.getLanguageLevel((PsiElement)expression2));
        PsiClassType type2 = JavaPsiFacade.getElementFactory((Project)project).createType(interface2Consider, substitutor);
        return expression2.isAcceptable((PsiType)type2) ? type2 : null;
    }

    @NotNull
    private static PsiSubstitutor getPartialSubstitutor(@NotNull PsiMethodReferenceExpression expression2, @NotNull PsiMethod method) {
        PsiTypeParameter[] typeParameters;
        PsiType[] typeArguments;
        if (expression2 == null) {
            FunctionalInterfaceSuggester.$$$reportNull$$$0(17);
        }
        if (method == null) {
            FunctionalInterfaceSuggester.$$$reportNull$$$0(18);
        }
        if ((typeArguments = expression2.getTypeParameters()).length > 0 && (typeParameters = method.getTypeParameters()).length == typeArguments.length) {
            List<PsiTypeParameter> arguments = Arrays.asList(typeParameters);
            List<PsiType> values = Arrays.asList(typeArguments);
            Map substitutorMap = ContainerUtil.newHashMap(arguments, values);
            PsiSubstitutor psiSubstitutor = PsiSubstitutor.createSubstitutor((Map)substitutorMap);
            if (psiSubstitutor == null) {
                FunctionalInterfaceSuggester.$$$reportNull$$$0(19);
            }
            return psiSubstitutor;
        }
        PsiSubstitutor psiSubstitutor = PsiSubstitutor.EMPTY;
        if (psiSubstitutor == null) {
            FunctionalInterfaceSuggester.$$$reportNull$$$0(20);
        }
        return psiSubstitutor;
    }

    private static boolean hasOffset(PsiMethodReferenceExpression expression2, PsiMethod method) {
        return PsiMethodReferenceUtil.isStaticallyReferenced((PsiMethodReferenceExpression)expression2) && !method.hasModifierProperty("static") && !method.isConstructor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 19: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 19: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: 
            case 2: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 3: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interface2Consider";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/FunctionalInterfaceSuggester";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interfaceMethod";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "left";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "right";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/FunctionalInterfaceSuggester";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "composeAcceptableType1";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getPartialSubstitutor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "suggestFunctionalInterfaces";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "composeAcceptableType";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 19: 
            case 20: {
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "maybeDefaultConstructorRef";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getAcceptableType";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getPartialSubstitutor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 19: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

