/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.JavaSmartCompletionContributor;
import com.intellij.codeInsight.completion.MethodReferenceCompletion;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.generation.GenerateMembersUtil;
import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JVMElementFactories;
import com.intellij.psi.JVMElementFactory;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.source.resolve.graphInference.FunctionalInterfaceParameterizationUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Consumer;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class FunctionalExpressionCompletionProvider {
    static final Key<Boolean> LAMBDA_ITEM = Key.create((String)"LAMBDA_ITEM");
    static final Key<Boolean> METHOD_REF_PREFERRED = Key.create((String)"METHOD_REF_ITEM");

    private static boolean isLambdaContext(@NotNull PsiElement element) {
        PsiElement rulezzRef;
        if (element == null) {
            FunctionalExpressionCompletionProvider.$$$reportNull$$$0(0);
        }
        return (rulezzRef = element.getParent()) instanceof PsiReferenceExpression && ((PsiReferenceExpression)rulezzRef).getQualifier() == null && LambdaUtil.isValidLambdaContext((PsiElement)rulezzRef.getParent());
    }

    static boolean isFunExprItem(LookupElement item) {
        return item.getUserData(LAMBDA_ITEM) != null || item.getUserData(METHOD_REF_PREFERRED) != null;
    }

    static void addFunctionalVariants(@NotNull CompletionParameters parameters2, boolean addInheritors, PrefixMatcher matcher, Consumer<? super LookupElement> result) {
        ExpectedTypeInfo[] expectedTypes;
        if (parameters2 == null) {
            FunctionalExpressionCompletionProvider.$$$reportNull$$$0(1);
        }
        if (!PsiUtil.isLanguageLevel8OrHigher((PsiElement)parameters2.getOriginalFile()) || !FunctionalExpressionCompletionProvider.isLambdaContext(parameters2.getPosition())) {
            return;
        }
        for (ExpectedTypeInfo expectedType : expectedTypes = JavaSmartCompletionContributor.getExpectedTypes(parameters2)) {
            PsiType expectedReturnType;
            PsiType functionalInterfaceType;
            PsiMethod functionalInterfaceMethod;
            PsiType defaultType = expectedType.getDefaultType();
            if (!LambdaUtil.isFunctionalType((PsiType)defaultType) || (functionalInterfaceMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiType)(functionalInterfaceType = FunctionalInterfaceParameterizationUtil.getGroundTargetType(defaultType)))) == null) continue;
            Object[] params = PsiParameter.EMPTY_ARRAY;
            PsiElement originalPosition = parameters2.getPosition();
            PsiSubstitutor substitutor = LambdaUtil.getSubstitutor((PsiMethod)functionalInterfaceMethod, (PsiClassType.ClassResolveResult)PsiUtil.resolveGenericsClassInType((PsiType)functionalInterfaceType));
            if (!functionalInterfaceMethod.hasTypeParameters()) {
                params = functionalInterfaceMethod.getParameterList().getParameters();
                Project project = functionalInterfaceMethod.getProject();
                JVMElementFactory jvmElementFactory = JVMElementFactories.getFactory((Language)originalPosition.getLanguage(), (Project)project);
                JavaCodeStyleManager javaCodeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
                if (jvmElementFactory != null) {
                    params = GenerateMembersUtil.overriddenParameters((PsiParameter[])params, jvmElementFactory, javaCodeStyleManager, substitutor, originalPosition);
                }
                String paramsString = params.length == 1 ? FunctionalExpressionCompletionProvider.getParamName(params[0], originalPosition) : "(" + StringUtil.join((Object[])params, parameter2 -> FunctionalExpressionCompletionProvider.getParamName(parameter2, originalPosition), (String)",") + ")";
                CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
                PsiLambdaExpression lambdaExpression = (PsiLambdaExpression)JavaPsiFacade.getElementFactory((Project)project).createExpressionFromText(paramsString + " -> {}", null);
                lambdaExpression = (PsiLambdaExpression)codeStyleManager.reformat((PsiElement)lambdaExpression);
                paramsString = lambdaExpression.getParameterList().getText();
                LookupElementBuilder builder = LookupElementBuilder.create((Object)functionalInterfaceMethod, (String)(paramsString + " -> ")).withPresentableText(paramsString + " -> {}").withTypeText(functionalInterfaceType.getPresentableText()).withIcon(AllIcons.Nodes.Lambda);
                builder.putUserData(LAMBDA_ITEM, (Object)true);
                result.consume((Object)builder.withAutoCompletionPolicy(AutoCompletionPolicy.NEVER_AUTOCOMPLETE));
            }
            if ((expectedReturnType = substitutor.substitute(functionalInterfaceMethod.getReturnType())) == null) continue;
            MethodReferenceCompletion completion = new MethodReferenceCompletion(addInheritors, parameters2, matcher, functionalInterfaceType, (PsiParameter[])params, originalPosition, substitutor, expectedReturnType);
            completion.suggestMethodReferences((Consumer<? super LookupElement>)((Consumer)element -> {
                Object object = element.getObject();
                element.putUserData(METHOD_REF_PREFERRED, (Object)(object instanceof PsiMethod && completion.hasExactReturnType((PsiMethod)object) ? 1 : 0));
                result.consume((Object)(parameters2.getCompletionType() == CompletionType.SMART ? JavaSmartCompletionContributor.decorate(element, Arrays.asList(expectedTypes)) : element));
            }));
        }
    }

    private static String getParamName(PsiParameter param, PsiElement originalPosition) {
        return JavaCodeStyleManager.getInstance((Project)originalPosition.getProject()).suggestUniqueVariableName(param.getName(), originalPosition, false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/completion/FunctionalExpressionCompletionProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isLambdaContext";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "addFunctionalVariants";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

