/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.ExpectedTypeInfoImpl;
import com.intellij.codeInsight.ExpectedTypesProvider;
import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.ConstructorInsertHandler;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.completion.JavaConstructorCallElement;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.SmartCompletionDecorator;
import com.intellij.codeInsight.completion.scope.JavaCompletionProcessor;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.openapi.project.Project;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaReference;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.filters.ElementExtractorFilter;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.filters.OrFilter;
import com.intellij.psi.filters.getters.ExpectedTypesGetter;
import com.intellij.psi.filters.types.AssignableFromFilter;
import com.intellij.psi.filters.types.AssignableToFilter;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.proximity.ReferenceListWeigher;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TObjectHashingStrategy;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaSmartCompletionContributor {
    static final TObjectHashingStrategy<ExpectedTypeInfo> EXPECTED_TYPE_INFO_STRATEGY = new TObjectHashingStrategy<ExpectedTypeInfo>(){

        public int computeHashCode(ExpectedTypeInfo object) {
            return object.getType().hashCode();
        }

        public boolean equals(ExpectedTypeInfo o1, ExpectedTypeInfo o2) {
            return o1.getType().equals(o2.getType());
        }
    };
    private static final ElementExtractorFilter THROWABLES_FILTER = new ElementExtractorFilter(new AssignableFromFilter("java.lang.Throwable"));
    static final ElementPattern<PsiElement> AFTER_NEW = PlatformPatterns.psiElement().afterLeaf((ElementPattern)PlatformPatterns.psiElement().withText("new"));
    static final ElementPattern<PsiElement> AFTER_THROW_NEW = PlatformPatterns.psiElement().afterLeaf((ElementPattern)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withText("new")).afterLeaf(new String[]{"throw"}));
    public static final ElementPattern<PsiElement> INSIDE_EXPRESSION = StandardPatterns.or((ElementPattern[])new ElementPattern[]{((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withParent(PsiExpression.class)).andNot((ElementPattern)PlatformPatterns.psiElement().withParent(PsiLiteralExpression.class))).andNot((ElementPattern)PlatformPatterns.psiElement().withParent(PsiMethodReferenceExpression.class)), PlatformPatterns.psiElement().inside(PsiClassObjectAccessExpression.class), PlatformPatterns.psiElement().inside(PsiThisExpression.class), PlatformPatterns.psiElement().inside(PsiSuperExpression.class)});
    static final ElementPattern<PsiElement> INSIDE_TYPECAST_EXPRESSION = PlatformPatterns.psiElement().withParent((ElementPattern)PlatformPatterns.psiElement(PsiReferenceExpression.class).afterLeaf((ElementPattern)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withText(")")).withParent(PsiTypeCastExpression.class)));

    @Nullable
    private static ElementFilter getClassReferenceFilter(final PsiElement element, boolean inRefList) {
        if (AFTER_THROW_NEW.accepts((Object)element)) {
            return THROWABLES_FILTER;
        }
        if (((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement().afterLeaf((ElementPattern)PlatformPatterns.psiElement().withText("."))).withSuperParent(2, (ElementPattern)PlatformPatterns.psiElement(PsiNewExpression.class))).accepts((Object)element) && ((PsiNewExpression)element.getParent().getParent()).getClassReference() == element.getParent()) {
            Object[] types = ExpectedTypesGetter.getExpectedTypes(element, false);
            return new OrFilter((ElementFilter[])ContainerUtil.map2Array((Object[])types, ElementFilter.class, type2 -> new AssignableFromFilter((PsiType)type2)));
        }
        if (inRefList) {
            return new ElementExtractorFilter(new ElementFilter(){

                public boolean isAcceptable(Object aClass, @Nullable PsiElement context) {
                    return aClass instanceof PsiClass && ReferenceListWeigher.INSTANCE.getApplicability((PsiClass)aClass, element) != ReferenceListWeigher.ReferenceListApplicability.inapplicable;
                }

                public boolean isClassAcceptable(Class hintClass) {
                    return true;
                }
            });
        }
        return null;
    }

    static void addClassReferenceSuggestions(@NotNull CompletionParameters parameters2, @NotNull CompletionResultSet result, @NotNull PsiElement element, @NotNull PsiJavaCodeReferenceElement reference) {
        block8: {
            PsiTypeCastExpression cast;
            ElementFilter filter;
            block7: {
                boolean inRefList;
                if (parameters2 == null) {
                    JavaSmartCompletionContributor.$$$reportNull$$$0(0);
                }
                if (result == null) {
                    JavaSmartCompletionContributor.$$$reportNull$$$0(1);
                }
                if (element == null) {
                    JavaSmartCompletionContributor.$$$reportNull$$$0(2);
                }
                if (reference == null) {
                    JavaSmartCompletionContributor.$$$reportNull$$$0(3);
                }
                if ((filter = JavaSmartCompletionContributor.getClassReferenceFilter(element, inRefList = ReferenceListWeigher.INSIDE_REFERENCE_LIST.accepts((Object)element))) == null) break block7;
                List<ExpectedTypeInfo> infos = Arrays.asList(JavaSmartCompletionContributor.getExpectedTypes(parameters2));
                for (LookupElement item : JavaSmartCompletionContributor.completeReference(element, reference, filter, true, false, parameters2, result.getPrefixMatcher())) {
                    Object o = item.getObject();
                    if (!(o instanceof PsiClass) && (!CodeInsightSettings.getInstance().SHOW_PARAMETER_NAME_HINTS_ON_COMPLETION || !JavaConstructorCallElement.isConstructorCallPlace(element) || !(o instanceof PsiMethod) || !((PsiMethod)o).isConstructor())) continue;
                    if (!inRefList && o instanceof PsiClass) {
                        item = LookupElementDecorator.withInsertHandler((LookupElement)item, (InsertHandler)ConstructorInsertHandler.SMART_INSTANCE);
                    }
                    result.addElement((LookupElement)JavaSmartCompletionContributor.decorate(item, infos));
                }
                break block8;
            }
            if (!INSIDE_TYPECAST_EXPRESSION.accepts((Object)element) || (cast = (PsiTypeCastExpression)PsiTreeUtil.getContextOfType((PsiElement)element, PsiTypeCastExpression.class, (boolean)true)) == null || cast.getCastType() == null) break block8;
            filter = new AssignableToFilter(cast.getCastType().getType());
            for (LookupElement item : JavaSmartCompletionContributor.completeReference(element, reference, filter, false, true, parameters2, result.getPrefixMatcher())) {
                result.addElement(item);
            }
        }
    }

    public static SmartCompletionDecorator decorate(LookupElement lookupElement, Collection<? extends ExpectedTypeInfo> infos) {
        return new SmartCompletionDecorator(lookupElement, infos);
    }

    public static ExpectedTypeInfo @NotNull [] getExpectedTypes(CompletionParameters parameters2) {
        return JavaSmartCompletionContributor.getExpectedTypes(parameters2.getPosition(), parameters2.getCompletionType() == CompletionType.SMART);
    }

    public static ExpectedTypeInfo @NotNull [] getExpectedTypes(PsiElement position, boolean voidable) {
        if (((PsiElementPattern.Capture)PlatformPatterns.psiElement().withParent((ElementPattern)PlatformPatterns.psiElement(PsiReferenceExpression.class).withParent(PsiThrowStatement.class))).accepts((Object)position)) {
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)position.getProject());
            PsiClassType classType = factory.createTypeByFQClassName("java.lang.RuntimeException", position.getResolveScope());
            SmartList result = new SmartList();
            result.add(new ExpectedTypeInfoImpl((PsiType)classType, 1, (PsiType)classType, TailType.SEMICOLON, null, ExpectedTypeInfoImpl.NULL));
            PsiMethod method = (PsiMethod)PsiTreeUtil.getContextOfType((PsiElement)position, PsiMethod.class, (boolean)true);
            if (method != null) {
                for (PsiClassType type2 : method.getThrowsList().getReferencedTypes()) {
                    result.add(new ExpectedTypeInfoImpl((PsiType)type2, 1, (PsiType)type2, TailType.SEMICOLON, null, ExpectedTypeInfoImpl.NULL));
                }
            }
            ExpectedTypeInfo[] expectedTypeInfoArray = result.toArray(ExpectedTypeInfo.EMPTY_ARRAY);
            if (expectedTypeInfoArray == null) {
                JavaSmartCompletionContributor.$$$reportNull$$$0(4);
            }
            return expectedTypeInfoArray;
        }
        PsiExpression expression2 = (PsiExpression)PsiTreeUtil.getContextOfType((PsiElement)position, PsiExpression.class, (boolean)true);
        if (expression2 == null) {
            if (ExpectedTypeInfo.EMPTY_ARRAY == null) {
                JavaSmartCompletionContributor.$$$reportNull$$$0(5);
            }
            return ExpectedTypeInfo.EMPTY_ARRAY;
        }
        ExpectedTypeInfo[] expectedTypeInfoArray = ExpectedTypesProvider.getExpectedTypes(expression2, true, voidable, false);
        if (expectedTypeInfoArray == null) {
            JavaSmartCompletionContributor.$$$reportNull$$$0(6);
        }
        return expectedTypeInfoArray;
    }

    static Set<LookupElement> completeReference(PsiElement element, PsiJavaCodeReferenceElement reference, final ElementFilter filter, final boolean acceptClasses, final boolean acceptMembers, CompletionParameters parameters2, PrefixMatcher matcher) {
        ElementFilter checkClass2 = new ElementFilter(){

            public boolean isAcceptable(Object element, PsiElement context) {
                return filter.isAcceptable(element, context);
            }

            public boolean isClassAcceptable(Class hintClass) {
                if (ReflectionUtil.isAssignable(PsiClass.class, (Class)hintClass)) {
                    return acceptClasses;
                }
                if (ReflectionUtil.isAssignable(PsiVariable.class, (Class)hintClass) || ReflectionUtil.isAssignable(PsiMethod.class, (Class)hintClass) || ReflectionUtil.isAssignable(CandidateInfo.class, (Class)hintClass)) {
                    return acceptMembers;
                }
                return false;
            }
        };
        JavaCompletionProcessor.Options options = JavaCompletionProcessor.Options.DEFAULT_OPTIONS.withFilterStaticAfterInstance(parameters2.getInvocationCount() <= 1);
        return JavaCompletionUtil.processJavaReference(element, (PsiJavaReference)reference, checkClass2, options, matcher, parameters2);
    }

    static void beforeSmartCompletion(@NotNull CompletionInitializationContext context) {
        PsiElement lastElement;
        PsiFile file;
        PsiElement element;
        if (context == null) {
            JavaSmartCompletionContributor.$$$reportNull$$$0(7);
        }
        if (!context.getEditor().getSelectionModel().hasSelection() && (element = (file = context.getFile()).findElementAt(context.getStartOffset())) instanceof PsiIdentifier) {
            element = element.getParent();
            while (element instanceof PsiJavaCodeReferenceElement || element instanceof PsiCall || element instanceof PsiThisExpression || element instanceof PsiSuperExpression || element instanceof PsiTypeElement || element instanceof PsiClassObjectAccessExpression) {
                PsiJavaCodeReferenceElement classReference2;
                int newEnd = element.getTextRange().getEndOffset();
                if (element instanceof PsiMethodCallExpression) {
                    newEnd = ((PsiMethodCallExpression)element).getMethodExpression().getTextRange().getEndOffset();
                } else if (element instanceof PsiNewExpression && (classReference2 = ((PsiNewExpression)element).getClassReference()) != null) {
                    newEnd = classReference2.getTextRange().getEndOffset();
                }
                context.setReplacementOffset(newEnd);
                element = element.getParent();
            }
        }
        if ((lastElement = context.getFile().findElementAt(context.getStartOffset() - 1)) != null && lastElement.getText().equals("(") && lastElement.getParent() instanceof PsiParenthesizedExpression) {
            return;
        }
        context.setDummyIdentifier(CompletionUtil.DUMMY_IDENTIFIER_TRIMMED);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/completion/JavaSmartCompletionContributor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/completion/JavaSmartCompletionContributor";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpectedTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addClassReferenceSuggestions";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "beforeSmartCompletion";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

