/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.PlainTextSymbolCompletionContributor;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.SyntheticElement;
import com.intellij.util.ObjectUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JvmPlainTextSymbolCompletionContributor
implements PlainTextSymbolCompletionContributor {
    @NotNull
    public Collection<LookupElement> getLookupElements(@NotNull PsiFile file, int invocationCount, @NotNull String prefix) {
        PsiClassOwner jvmFile;
        if (file == null) {
            JvmPlainTextSymbolCompletionContributor.$$$reportNull$$$0(0);
        }
        if (prefix == null) {
            JvmPlainTextSymbolCompletionContributor.$$$reportNull$$$0(1);
        }
        if ((jvmFile = (PsiClassOwner)ObjectUtils.tryCast((Object)file, PsiClassOwner.class)) == null) {
            List<LookupElement> list = Collections.emptyList();
            if (list == null) {
                JvmPlainTextSymbolCompletionContributor.$$$reportNull$$$0(2);
            }
            return list;
        }
        ArrayList<LookupElement> result = new ArrayList<LookupElement>();
        for (PsiClass aClass : jvmFile.getClasses()) {
            String name2 = aClass.getName();
            if (name2 == null) continue;
            if (aClass instanceof SyntheticElement) {
                JvmPlainTextSymbolCompletionContributor.processSyntheticClass(result, aClass);
                continue;
            }
            result.add((LookupElement)LookupElementBuilder.create((String)name2).withIcon(aClass.getIcon(0)));
            String infix = JvmPlainTextSymbolCompletionContributor.getInfix(prefix, name2);
            String memberPrefix = null;
            String rest = null;
            if (infix != null) {
                int offset = name2.length() + infix.length();
                memberPrefix = prefix.substring(0, offset);
                rest = prefix.substring(offset);
            } else if (invocationCount <= 0) continue;
            JvmPlainTextSymbolCompletionContributor.processClassBody(invocationCount, result, aClass, infix, memberPrefix, rest);
        }
        ArrayList<LookupElement> arrayList = result;
        if (arrayList == null) {
            JvmPlainTextSymbolCompletionContributor.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    private static void processSyntheticClass(List<LookupElement> result, PsiClass aClass) {
        PsiMember[][] psiMemberArrayArray = new PsiMember[][]{aClass.getMethods(), aClass.getFields(), aClass.getInnerClasses()};
        int n = psiMemberArrayArray.length;
        for (int i = 0; i < n; ++i) {
            PsiMember[] members;
            for (PsiMember member : members = psiMemberArrayArray[i]) {
                String memberName;
                if (!member.isPhysical() || (memberName = member.getName()) == null) continue;
                Icon icon = member.getIcon(0);
                LookupElementBuilder element = LookupElementBuilder.create((String)memberName).withIcon(icon);
                result.add((LookupElement)element.withTailText(" in " + aClass.getContainingFile().getName(), true));
            }
        }
    }

    private static void processClassBody(int invocationCount, List<LookupElement> result, PsiClass aClass, String infix, String memberPrefix, String rest) {
        PsiMember[][] psiMemberArrayArray = new PsiMember[][]{aClass.getMethods(), aClass.getFields(), aClass.getInnerClasses()};
        int n = psiMemberArrayArray.length;
        for (int i = 0; i < n; ++i) {
            PsiMember[] members;
            for (PsiMember member : members = psiMemberArrayArray[i]) {
                String nestedInfix;
                String memberName;
                if (!member.isPhysical() || (memberName = member.getName()) == null) continue;
                Icon icon = member.getIcon(0);
                LookupElementBuilder element = LookupElementBuilder.create((String)memberName).withIcon(icon);
                if (invocationCount > 0) {
                    result.add((LookupElement)element);
                }
                if (memberPrefix == null || !(member instanceof PsiMethod) && (!(member instanceof PsiField) || infix.equals("::")) && !infix.equals(".")) continue;
                result.add((LookupElement)LookupElementBuilder.create((String)(memberPrefix + memberName)).withIcon(icon));
                if (!(member instanceof PsiClass) || (nestedInfix = JvmPlainTextSymbolCompletionContributor.getInfix(rest, memberName)) == null) continue;
                int index = memberName.length() + nestedInfix.length();
                String nestedPrefix = memberPrefix + rest.substring(0, index);
                JvmPlainTextSymbolCompletionContributor.processClassBody(0, result, (PsiClass)member, nestedInfix, nestedPrefix, rest.substring(index));
            }
        }
    }

    @Nullable
    private static String getInfix(String currentPrefix, String className2) {
        if (!currentPrefix.startsWith(className2)) {
            return null;
        }
        for (String infix : new String[]{".", "#", "::"}) {
            if (!currentPrefix.startsWith(infix, className2.length())) continue;
            return infix;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/completion/JvmPlainTextSymbolCompletionContributor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/completion/JvmPlainTextSymbolCompletionContributor";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLookupElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLookupElements";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

