/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.completion.JavaInheritorsGetter;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.tree.java.MethodReferenceResolver;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.Consumer;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class MethodReferenceCompletion {
    private static final InsertHandler<LookupElement> CONSTRUCTOR_REF_INSERT_HANDLER = (context, item) -> {
        int start = context.getStartOffset();
        PsiClass psiClass = PsiUtil.resolveClassInType((PsiType)((PsiType)item.getObject()));
        if (psiClass != null) {
            String insertedName = StringUtil.trimEnd((String)item.getLookupString(), (String)"::new");
            while (insertedName.endsWith("[]")) {
                insertedName = insertedName.substring(0, insertedName.length() - 2);
            }
            JavaCompletionUtil.insertClassReference(psiClass, context.getFile(), start, start + insertedName.length());
        }
    };
    private final boolean myAddInheritors;
    private final CompletionParameters myParameters;
    private final PrefixMatcher myMatcher;
    private final PsiType myFunctionalInterfaceType;
    private final PsiParameter[] myParams;
    private final PsiElement myPosition;
    private final PsiSubstitutor mySubstitutor;
    private final PsiType myExpectedReturnType;

    MethodReferenceCompletion(boolean addInheritors, CompletionParameters parameters2, PrefixMatcher matcher, PsiType functionalInterfaceType, PsiParameter[] params, PsiElement originalPosition, PsiSubstitutor substitutor, PsiType expectedReturnType) {
        this.myAddInheritors = addInheritors;
        this.myParameters = parameters2;
        this.myMatcher = matcher;
        this.myFunctionalInterfaceType = functionalInterfaceType;
        this.myParams = params;
        this.myPosition = originalPosition;
        this.mySubstitutor = substitutor;
        this.myExpectedReturnType = expectedReturnType;
    }

    void suggestMethodReferences(Consumer<? super LookupElement> result) {
        if (this.myParams.length > 0) {
            for (LookupElement element : this.collectVariantsByReceiver()) {
                result.consume((Object)element);
            }
        }
        for (LookupElement element : this.collectThisVariants()) {
            result.consume((Object)element);
        }
        for (LookupElement element : this.collectStaticVariants()) {
            result.consume((Object)element);
        }
        Consumer consumer = eachReturnType -> {
            PsiClass psiClass = PsiUtil.resolveClassInType((PsiType)eachReturnType);
            if (psiClass == null) {
                return;
            }
            if (eachReturnType.getArrayDimensions() == 0) {
                PsiMethod[] constructors;
                if (!MethodReferenceResolver.canBeConstructed(psiClass)) {
                    return;
                }
                for (PsiMethod psiMethod : constructors = psiClass.getConstructors()) {
                    if (!this.isSignatureAppropriate(psiMethod, 0, null)) continue;
                    result.consume((Object)this.createConstructorReferenceLookup((PsiType)eachReturnType));
                }
                if (constructors.length == 0 && this.myParams.length == 0) {
                    result.consume((Object)this.createConstructorReferenceLookup((PsiType)eachReturnType));
                }
            } else if (this.myParams.length == 1 && PsiType.INT.equals((Object)this.myParams[0].getType())) {
                result.consume((Object)this.createConstructorReferenceLookup((PsiType)eachReturnType));
            }
        };
        if (this.myAddInheritors && this.myExpectedReturnType instanceof PsiClassType) {
            JavaInheritorsGetter.processInheritors(this.myParameters, Collections.singletonList((PsiClassType)this.myExpectedReturnType), this.myMatcher, (Consumer<? super PsiType>)consumer);
        } else {
            consumer.consume((Object)this.myExpectedReturnType);
        }
    }

    private LookupElement createConstructorReferenceLookup(@NotNull PsiType constructedType) {
        if (constructedType == null) {
            MethodReferenceCompletion.$$$reportNull$$$0(0);
        }
        constructedType = TypeConversionUtil.erasure((PsiType)constructedType);
        PsiClass psiClass = PsiUtil.resolveClassInType((PsiType)constructedType);
        return LookupElementBuilder.create((Object)constructedType, (String)(constructedType.getPresentableText() + "::new")).withTypeText(this.myFunctionalInterfaceType.getPresentableText()).withTailText(psiClass != null ? " (" + PsiFormatUtil.getPackageDisplayName((PsiClass)psiClass) + ")" : null, true).withPsiElement((PsiElement)psiClass).withIcon(AllIcons.Nodes.MethodReference).withInsertHandler(CONSTRUCTOR_REF_INSERT_HANDLER).withAutoCompletionPolicy(AutoCompletionPolicy.NEVER_AUTOCOMPLETE);
    }

    @NotNull
    private LookupElement createMethodRefOnThis(PsiMethod psiMethod, @Nullable PsiClass outerClass) {
        String fullString = (outerClass == null ? "" : outerClass.getName() + ".") + "this::" + psiMethod.getName();
        LookupElement lookupElement = LookupElementBuilder.create((Object)psiMethod, (String)fullString).withLookupString(psiMethod.getName()).withPresentableText(fullString).withTypeText(this.myFunctionalInterfaceType.getPresentableText()).withIcon(AllIcons.Nodes.MethodReference).withAutoCompletionPolicy(AutoCompletionPolicy.NEVER_AUTOCOMPLETE);
        if (lookupElement == null) {
            MethodReferenceCompletion.$$$reportNull$$$0(1);
        }
        return lookupElement;
    }

    @NotNull
    private LookupElement createMethodRefOnClass(PsiMethod psiMethod, PsiClass qualifierClass) {
        String presentableText = qualifierClass.getName() + "::" + psiMethod.getName();
        LookupElement lookupElement = LookupElementBuilder.create((PsiNamedElement)psiMethod).withLookupString(presentableText).withPresentableText(presentableText).withInsertHandler((context, item) -> {
            context.getDocument().insertString(context.getStartOffset(), (CharSequence)"::");
            JavaCompletionUtil.insertClassReference(qualifierClass, context.getFile(), context.getStartOffset());
        }).withTypeText(this.myFunctionalInterfaceType.getPresentableText()).withIcon(AllIcons.Nodes.MethodReference).withAutoCompletionPolicy(AutoCompletionPolicy.NEVER_AUTOCOMPLETE);
        if (lookupElement == null) {
            MethodReferenceCompletion.$$$reportNull$$$0(2);
        }
        return lookupElement;
    }

    private List<LookupElement> collectThisVariants() {
        ArrayList<LookupElement> result = new ArrayList<LookupElement>();
        JBIterable instanceClasses = JBIterable.generate((Object)this.myPosition, PsiElement::getParent).filter(PsiMember.class).takeWhile(m -> !m.hasModifierProperty("static")).filter(PsiClass.class);
        boolean first = true;
        for (PsiClass psiClass : instanceClasses) {
            if (!first && psiClass.getName() == null) continue;
            for (PsiMethod psiMethod : psiClass.getMethods()) {
                if (psiMethod.hasModifierProperty("static") || !this.hasAppropriateReturnType(psiMethod) || !this.isSignatureAppropriate(psiMethod, 0, null)) continue;
                result.add(this.createMethodRefOnThis(psiMethod, first ? null : psiClass));
            }
            first = false;
        }
        return result;
    }

    private List<LookupElement> collectStaticVariants() {
        ArrayList<LookupElement> result = new ArrayList<LookupElement>();
        for (PsiClass psiClass : JBIterable.generate((Object)((PsiClass)PsiTreeUtil.getParentOfType((PsiElement)this.myPosition, PsiClass.class)), PsiClass::getContainingClass)) {
            PsiMethod[] psiMethodArray = psiClass.getMethods();
            int n = psiMethodArray.length;
            for (int i = 0; i < n; ++i) {
                PsiMethod psiMethod = psiMethodArray[i];
                if (!this.isMatchingStaticMethod(psiMethod)) continue;
                result.add(this.createMethodRefOnClass(psiMethod, psiClass));
            }
        }
        PsiClass objects = JavaPsiFacade.getInstance((Project)this.myPosition.getProject()).findClass("java.util.Objects", this.myPosition.getResolveScope());
        if (objects != null) {
            for (PsiMethod nonNull : objects.getMethods()) {
                if (!this.isMatchingStaticMethod(nonNull)) continue;
                result.add(this.createMethodRefOnClass(nonNull, objects));
            }
        }
        return result;
    }

    private boolean isMatchingStaticMethod(PsiMethod psiMethod) {
        return psiMethod.hasModifierProperty("static") && this.hasAppropriateReturnType(psiMethod) && this.isSignatureAppropriate(psiMethod, 0, null);
    }

    private List<LookupElement> collectVariantsByReceiver() {
        boolean prioritize = this.myParameters.getCompletionType() != CompletionType.SMART;
        ArrayList<LookupElement> result = new ArrayList<LookupElement>();
        PsiType functionalInterfaceParamType = this.mySubstitutor.substitute(this.myParams[0].getType());
        PsiClass paramClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)functionalInterfaceParamType);
        if (paramClass != null) {
            HashSet<String> visited = new HashSet<String>();
            for (PsiMethod psiMethod : paramClass.getAllMethods()) {
                PsiClass qualifierClass;
                PsiClass containingClass = psiMethod.getContainingClass();
                PsiClass psiClass = qualifierClass = containingClass != null ? containingClass : paramClass;
                if (psiMethod.hasModifierProperty("static") || !this.hasAppropriateReturnType(psiMethod) || !this.isSignatureAppropriate(psiMethod, 1, paramClass) || !visited.add(psiMethod.getName())) continue;
                LookupElement methodRefLookupElement = this.createMethodRefOnClass(psiMethod, qualifierClass);
                if (prioritize && containingClass == paramClass) {
                    methodRefLookupElement = PrioritizedLookupElement.withExplicitProximity((LookupElement)methodRefLookupElement, (int)1);
                }
                result.add(methodRefLookupElement);
            }
        }
        return result;
    }

    private boolean hasAppropriateReturnType(PsiMethod psiMethod) {
        PsiType returnType = psiMethod.getReturnType();
        return returnType != null && TypeConversionUtil.isAssignable((PsiType)this.myExpectedReturnType, (PsiType)this.mySubstitutor.substitute(returnType));
    }

    boolean hasExactReturnType(PsiMethod psiMethod) {
        return this.myExpectedReturnType.equals(this.mySubstitutor.substitute(psiMethod.getReturnType()));
    }

    private boolean isSignatureAppropriate(PsiMethod psiMethod, int offset, PsiClass accessObjectClass) {
        if (!PsiUtil.isAccessible((PsiMember)psiMethod, (PsiElement)this.myPosition, (PsiClass)accessObjectClass)) {
            return false;
        }
        PsiParameterList parameterList = psiMethod.getParameterList();
        if (parameterList.getParametersCount() == this.myParams.length - offset) {
            PsiParameter[] referenceMethodParams = parameterList.getParameters();
            for (int i = 0; i < this.myParams.length - offset; ++i) {
                if (TypeConversionUtil.isAssignable((PsiType)referenceMethodParams[i].getType(), (PsiType)this.mySubstitutor.substitute(this.myParams[i + offset].getType()))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constructedType";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/completion/MethodReferenceCompletion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/completion/MethodReferenceCompletion";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createMethodRefOnThis";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createMethodRefOnClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createConstructorReferenceLookup";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

