/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.AnnotationTargetUtil;
import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.completion.CastingLookupElementDecorator;
import com.intellij.codeInsight.completion.CheckInitialized;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.FunctionalExpressionCompletionProvider;
import com.intellij.codeInsight.completion.JavaChainLookupElement;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.completion.JavaConstructorCallElement;
import com.intellij.codeInsight.completion.JavaDocCompletionContributor;
import com.intellij.codeInsight.completion.JavaKeywordCompletion;
import com.intellij.codeInsight.completion.JavaSmartCompletionContributor;
import com.intellij.codeInsight.completion.StaticallyImportable;
import com.intellij.codeInsight.completion.TypeArgumentCompletionProvider;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementWeigher;
import com.intellij.codeInsight.lookup.TypedLookupItem;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiResourceExpression;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.filters.getters.MembersGetter;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.psi.util.proximity.KnownElementWeigher;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.text.CharArrayUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PreferByKindWeigher
extends LookupElementWeigher {
    public static final Key<Boolean> INTRODUCED_VARIABLE = Key.create((String)"INTRODUCED_VARIABLE");
    private static final ElementPattern<PsiElement> IN_CATCH_TYPE = PsiJavaPatterns.psiElement().withParent((ElementPattern)PsiJavaPatterns.psiElement(PsiJavaCodeReferenceElement.class).withParent((ElementPattern)PsiJavaPatterns.psiElement(PsiTypeElement.class).withParent(StandardPatterns.or((ElementPattern[])new ElementPattern[]{PsiJavaPatterns.psiElement(PsiCatchSection.class), PsiJavaPatterns.psiElement(PsiVariable.class).withParent(PsiCatchSection.class)}))));
    private static final ElementPattern<PsiElement> IN_MULTI_CATCH_TYPE = StandardPatterns.or((ElementPattern[])new ElementPattern[]{PsiJavaPatterns.psiElement().afterLeaf((ElementPattern)((PsiJavaElementPattern.Capture)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withText("|")).withParent(PsiTypeElement.class)).withSuperParent(2, PsiCatchSection.class)), PsiJavaPatterns.psiElement().afterLeaf((ElementPattern)((PsiJavaElementPattern.Capture)((PsiJavaElementPattern.Capture)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withText("|")).withParent(PsiTypeElement.class)).withSuperParent(2, PsiParameter.class)).withSuperParent(3, PsiCatchSection.class))});
    private static final ElementPattern<PsiElement> INSIDE_METHOD_THROWS_CLAUSE = ((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().afterLeaf(new String[]{"throws", ","})).inside((ElementPattern)PsiJavaPatterns.psiElement((IElementType)JavaElementType.THROWS_LIST));
    static final ElementPattern<PsiElement> IN_RESOURCE = PsiJavaPatterns.psiElement().withParent(StandardPatterns.or((ElementPattern[])new ElementPattern[]{((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement(PsiJavaCodeReferenceElement.class).withParent(PsiTypeElement.class)).withSuperParent(2, StandardPatterns.or((ElementPattern[])new ElementPattern[]{PsiJavaPatterns.psiElement(PsiResourceVariable.class), PsiJavaPatterns.psiElement(PsiResourceList.class)})), PsiJavaPatterns.psiElement(PsiReferenceExpression.class).withParent(PsiResourceExpression.class)}));
    private static final Function<PsiClass, MyResult> PREFER_THROWABLE = psiClass -> PreferByKindWeigher.preferClassIf(InheritanceUtil.isInheritor((PsiClass)psiClass, (String)"java.lang.Throwable"));
    private final CompletionType myCompletionType;
    private final PsiElement myPosition;
    private final Set<PsiField> myNonInitializedFields;
    private final Function<PsiClass, MyResult> myClassSuitability;
    private final ExpectedTypeInfo[] myExpectedTypes;

    public PreferByKindWeigher(CompletionType completionType, PsiElement position, ExpectedTypeInfo[] expectedTypes) {
        super("kind");
        this.myCompletionType = completionType;
        this.myPosition = position;
        this.myNonInitializedFields = CheckInitialized.getNonInitializedFields(position);
        this.myClassSuitability = PreferByKindWeigher.createSuitabilityCondition(position);
        this.myExpectedTypes = expectedTypes;
    }

    @NotNull
    private static Function<PsiClass, MyResult> createSuitabilityCondition(PsiElement position) {
        if (PreferByKindWeigher.isExceptionPosition(position)) {
            PsiElement container = PsiTreeUtil.getParentOfType((PsiElement)position, (Class[])new Class[]{PsiTryStatement.class, PsiMethod.class});
            ArrayList thrownExceptions = new ArrayList();
            if (container != null) {
                PsiElement block;
                Object object = block = container instanceof PsiTryStatement ? ((PsiTryStatement)container).getTryBlock() : container;
                if (block != null) {
                    for (PsiClassType type2 : ExceptionUtil.getThrownExceptions(block)) {
                        ContainerUtil.addIfNotNull(thrownExceptions, (Object)type2.resolve());
                    }
                }
            }
            Function<PsiClass, MyResult> function = psiClass -> {
                if (ContainerUtil.exists((Iterable)thrownExceptions, t -> InheritanceUtil.isInheritorOrSelf((PsiClass)psiClass, (PsiClass)t, (boolean)true))) {
                    return MyResult.verySuitableClass;
                }
                return PREFER_THROWABLE.apply((PsiClass)psiClass);
            };
            if (function == null) {
                PreferByKindWeigher.$$$reportNull$$$0(0);
            }
            return function;
        }
        if (JavaSmartCompletionContributor.AFTER_THROW_NEW.accepts((Object)position)) {
            Function<PsiClass, MyResult> function = PREFER_THROWABLE;
            if (function == null) {
                PreferByKindWeigher.$$$reportNull$$$0(1);
            }
            return function;
        }
        if (IN_RESOURCE.accepts((Object)position)) {
            Function<PsiClass, MyResult> function = psiClass -> PreferByKindWeigher.preferClassIf(InheritanceUtil.isInheritor((PsiClass)psiClass, (String)"java.lang.AutoCloseable"));
            if (function == null) {
                PreferByKindWeigher.$$$reportNull$$$0(2);
            }
            return function;
        }
        PsiElement parent = position.getParent();
        if (parent instanceof PsiJavaCodeReferenceElement) {
            PsiElement refParent = parent.getParent();
            if (refParent instanceof PsiAnnotation) {
                PsiAnnotation.TargetType[] targets = AnnotationTargetUtil.getTargetsForLocation((PsiAnnotationOwner)((PsiAnnotation)refParent).getOwner());
                Function<PsiClass, MyResult> function = psiClass -> PreferByKindWeigher.preferClassIf(psiClass.isAnnotationType() && AnnotationTargetUtil.findAnnotationTarget((PsiClass)psiClass, (PsiAnnotation.TargetType[])targets) != null);
                if (function == null) {
                    PreferByKindWeigher.$$$reportNull$$$0(3);
                }
                return function;
            }
            if (refParent instanceof PsiTypeElement) {
                List<PsiClass> bounds = PreferByKindWeigher.getTypeBounds((PsiTypeElement)refParent);
                Function<PsiClass, MyResult> function = psiClass -> PreferByKindWeigher.preferClassIf(ContainerUtil.exists((Iterable)bounds, bound -> InheritanceUtil.isInheritorOrSelf((PsiClass)psiClass, (PsiClass)bound, (boolean)true)));
                if (function == null) {
                    PreferByKindWeigher.$$$reportNull$$$0(4);
                }
                return function;
            }
        }
        Function<PsiClass, MyResult> function = aClass -> MyResult.classNameOrGlobalStatic;
        if (function == null) {
            PreferByKindWeigher.$$$reportNull$$$0(5);
        }
        return function;
    }

    private static List<PsiClass> getTypeBounds(PsiTypeElement typeElement) {
        PsiElement typeParent = typeElement.getParent();
        if (typeParent instanceof PsiReferenceParameterList) {
            PsiTypeParameter[] typeParameters;
            PsiElement target;
            int index = Arrays.asList(((PsiReferenceParameterList)typeParent).getTypeParameterElements()).indexOf(typeElement);
            PsiElement listParent = typeParent.getParent();
            if (index >= 0 && listParent instanceof PsiJavaCodeReferenceElement && (target = ((PsiJavaCodeReferenceElement)listParent).resolve()) instanceof PsiClass && index < (typeParameters = ((PsiClass)target).getTypeParameters()).length) {
                return ContainerUtil.mapNotNull((Object[])typeParameters[index].getExtendsListTypes(), PsiUtil::resolveClassInType);
            }
        }
        return Collections.emptyList();
    }

    static boolean isExceptionPosition(PsiElement position) {
        return IN_CATCH_TYPE.accepts((Object)position) || IN_MULTI_CATCH_TYPE.accepts((Object)position) || INSIDE_METHOD_THROWS_CLAUSE.accepts((Object)position) || JavaDocCompletionContributor.THROWS_TAG_EXCEPTION.accepts((Object)position);
    }

    @NotNull
    private static MyResult preferClassIf(boolean condition2) {
        MyResult myResult = condition2 ? MyResult.suitableClass : MyResult.classNameOrGlobalStatic;
        if (myResult == null) {
            PreferByKindWeigher.$$$reportNull$$$0(6);
        }
        return myResult;
    }

    static boolean isEnumClass(@NotNull ExpectedTypeInfo info) {
        PsiClass expectedClass;
        if (info == null) {
            PreferByKindWeigher.$$$reportNull$$$0(7);
        }
        return (expectedClass = PsiUtil.resolveClassInType((PsiType)info.getType())) != null && expectedClass.isEnum();
    }

    @NotNull
    public MyResult weigh(@NotNull LookupElement item) {
        PsiClass containingClass;
        Object object;
        if (item == null) {
            PreferByKindWeigher.$$$reportNull$$$0(8);
        }
        if ((object = item.getObject()) instanceof PsiKeyword) {
            ThreeState result = this.isProbableKeyword(((PsiKeyword)object).getText());
            if (result == ThreeState.YES) {
                MyResult myResult = MyResult.probableKeyword;
                if (myResult == null) {
                    PreferByKindWeigher.$$$reportNull$$$0(9);
                }
                return myResult;
            }
            if (result == ThreeState.NO) {
                MyResult myResult = MyResult.improbableKeyword;
                if (myResult == null) {
                    PreferByKindWeigher.$$$reportNull$$$0(10);
                }
                return myResult;
            }
        }
        if (item.as(CastingLookupElementDecorator.CLASS_CONDITION_KEY) != null) {
            MyResult myResult = MyResult.castVariable;
            if (myResult == null) {
                PreferByKindWeigher.$$$reportNull$$$0(11);
            }
            return myResult;
        }
        if ((object instanceof PsiLocalVariable || object instanceof PsiParameter || object instanceof PsiThisExpression || object instanceof PsiField && !((PsiField)object).hasModifierProperty("static")) && PsiTreeUtil.getParentOfType((PsiElement)this.myPosition, PsiDocComment.class) == null) {
            MyResult myResult = this.isComparisonWithItself((PsiElement)object) ? MyResult.unlikelyItem : (this.isExpectedTypeItem(item) ? MyResult.expectedTypeVariable : MyResult.variable);
            if (myResult == null) {
                PreferByKindWeigher.$$$reportNull$$$0(12);
            }
            return myResult;
        }
        if (object instanceof String && item.getUserData(JavaCompletionUtil.SUPER_METHOD_PARAMETERS) == Boolean.TRUE) {
            MyResult myResult = MyResult.superMethodParameters;
            if (myResult == null) {
                PreferByKindWeigher.$$$reportNull$$$0(13);
            }
            return myResult;
        }
        if (item.getUserData(FunctionalExpressionCompletionProvider.LAMBDA_ITEM) != null) {
            MyResult myResult = MyResult.lambda;
            if (myResult == null) {
                PreferByKindWeigher.$$$reportNull$$$0(14);
            }
            return myResult;
        }
        Boolean methodRefPreference = (Boolean)item.getUserData(FunctionalExpressionCompletionProvider.METHOD_REF_PREFERRED);
        if (methodRefPreference != null) {
            MyResult myResult = methodRefPreference != false ? MyResult.likelyMethodRef : MyResult.methodRef;
            if (myResult == null) {
                PreferByKindWeigher.$$$reportNull$$$0(15);
            }
            return myResult;
        }
        if (object instanceof PsiMethod && (containingClass = ((PsiMethod)object).getContainingClass()) != null && "java.util.Collections".equals(containingClass.getQualifiedName())) {
            MyResult myResult = MyResult.collectionFactory;
            if (myResult == null) {
                PreferByKindWeigher.$$$reportNull$$$0(16);
            }
            return myResult;
        }
        if (object instanceof PsiClass && "java.lang.String".equals(((PsiClass)object).getQualifiedName()) && JavaSmartCompletionContributor.AFTER_NEW.accepts((Object)this.myPosition)) {
            MyResult myResult = MyResult.unlikelyItem;
            if (myResult == null) {
                PreferByKindWeigher.$$$reportNull$$$0(17);
            }
            return myResult;
        }
        Boolean expectedTypeMember = (Boolean)item.getUserData(MembersGetter.EXPECTED_TYPE_MEMBER);
        if (expectedTypeMember != null) {
            MyResult myResult = expectedTypeMember.booleanValue() ? (object instanceof PsiField ? MyResult.expectedTypeConstant : MyResult.expectedTypeMethod) : MyResult.classNameOrGlobalStatic;
            if (myResult == null) {
                PreferByKindWeigher.$$$reportNull$$$0(18);
            }
            return myResult;
        }
        if (item instanceof TypeArgumentCompletionProvider.TypeArgsLookupElement) {
            MyResult myResult = MyResult.expectedTypeArgument;
            if (myResult == null) {
                PreferByKindWeigher.$$$reportNull$$$0(19);
            }
            return myResult;
        }
        JavaChainLookupElement chain = (JavaChainLookupElement)item.as(JavaChainLookupElement.CLASS_CONDITION_KEY);
        if (chain != null) {
            if (this.myCompletionType == CompletionType.BASIC) {
                MyResult myResult = MyResult.basicChain;
                if (myResult == null) {
                    PreferByKindWeigher.$$$reportNull$$$0(20);
                }
                return myResult;
            }
            Object qualifier = chain.getQualifier().getObject();
            if (qualifier instanceof PsiVariable && PsiUtil.isJvmLocalVariable((PsiElement)((PsiVariable)qualifier))) {
                MyResult myResult = MyResult.variable;
                if (myResult == null) {
                    PreferByKindWeigher.$$$reportNull$$$0(21);
                }
                return myResult;
            }
            if (qualifier instanceof PsiField) {
                MyResult myResult = MyResult.qualifiedWithField;
                if (myResult == null) {
                    PreferByKindWeigher.$$$reportNull$$$0(22);
                }
                return myResult;
            }
            if (PreferByKindWeigher.isGetter(qualifier)) {
                MyResult myResult = MyResult.qualifiedWithGetter;
                if (myResult == null) {
                    PreferByKindWeigher.$$$reportNull$$$0(23);
                }
                return myResult;
            }
            if (chain.getQualifier().getUserData(INTRODUCED_VARIABLE) == Boolean.TRUE) {
                MyResult myResult = MyResult.introducedVariable;
                if (myResult == null) {
                    PreferByKindWeigher.$$$reportNull$$$0(24);
                }
                return myResult;
            }
            if (this.myCompletionType == CompletionType.SMART && qualifier instanceof PsiMethod && PreferByKindWeigher.isGetter(object)) {
                MyResult myResult = MyResult.getterQualifiedByMethod;
                if (myResult == null) {
                    PreferByKindWeigher.$$$reportNull$$$0(25);
                }
                return myResult;
            }
        }
        if (this.myCompletionType == CompletionType.SMART) {
            if (PreferByKindWeigher.isGetter(object)) {
                MyResult myResult = chain == null && this.isAccessibleFieldGetter(object) ? MyResult.accessibleFieldGetter : MyResult.getter;
                if (myResult == null) {
                    PreferByKindWeigher.$$$reportNull$$$0(26);
                }
                return myResult;
            }
            MyResult myResult = MyResult.normal;
            if (myResult == null) {
                PreferByKindWeigher.$$$reportNull$$$0(27);
            }
            return myResult;
        }
        if (this.myCompletionType == CompletionType.BASIC) {
            StaticallyImportable callElement = (StaticallyImportable)item.as(StaticallyImportable.CLASS_CONDITION_KEY);
            if (callElement != null && callElement.canBeImported() && !callElement.willBeImported()) {
                MyResult myResult = MyResult.classNameOrGlobalStatic;
                if (myResult == null) {
                    PreferByKindWeigher.$$$reportNull$$$0(28);
                }
                return myResult;
            }
            JavaConstructorCallElement constructorCall = (JavaConstructorCallElement)item.as(JavaConstructorCallElement.class);
            if (constructorCall != null) {
                MyResult myResult = this.myClassSuitability.apply(constructorCall.getConstructedClass());
                if (myResult == null) {
                    PreferByKindWeigher.$$$reportNull$$$0(29);
                }
                return myResult;
            }
            if (object instanceof PsiMethod && PsiUtil.isAnnotationMethod((PsiElement)((PsiElement)object))) {
                MyResult myResult = MyResult.annoMethod;
                if (myResult == null) {
                    PreferByKindWeigher.$$$reportNull$$$0(30);
                }
                return myResult;
            }
            if (object instanceof PsiClass) {
                MyResult myResult = this.myClassSuitability.apply((PsiClass)object);
                if (myResult == null) {
                    PreferByKindWeigher.$$$reportNull$$$0(31);
                }
                return myResult;
            }
            if (object instanceof PsiField && this.myNonInitializedFields.contains(object)) {
                MyResult myResult = MyResult.nonInitialized;
                if (myResult == null) {
                    PreferByKindWeigher.$$$reportNull$$$0(32);
                }
                return myResult;
            }
        }
        MyResult myResult = MyResult.normal;
        if (myResult == null) {
            PreferByKindWeigher.$$$reportNull$$$0(33);
        }
        return myResult;
    }

    private boolean isComparisonWithItself(PsiElement itemObject) {
        PsiExpression[] operands2;
        return PreferByKindWeigher.isComparisonRhs(this.myPosition) && this.myPosition.getParent().getParent() instanceof PsiPolyadicExpression && (operands2 = ((PsiPolyadicExpression)this.myPosition.getParent().getParent()).getOperands())[0] instanceof PsiReferenceExpression && ((PsiReferenceExpression)operands2[0]).resolve() == itemObject;
    }

    private boolean isExpectedTypeItem(@NotNull LookupElement item) {
        TypedLookupItem typed;
        if (item == null) {
            PreferByKindWeigher.$$$reportNull$$$0(34);
        }
        PsiType itemType = (typed = (TypedLookupItem)item.as(TypedLookupItem.CLASS_CONDITION_KEY)) == null ? null : typed.getType();
        return itemType != null && Arrays.stream(this.myExpectedTypes).map(ExpectedTypeInfo::getType).anyMatch(type2 -> !PreferByKindWeigher.isTooGeneric(type2) && type2.isAssignableFrom(itemType));
    }

    private static boolean isTooGeneric(PsiType type2) {
        PsiType erasure = TypeConversionUtil.erasure((PsiType)type2);
        return erasure == null || erasure.equalsToText("java.lang.Object");
    }

    @NotNull
    private ThreeState isProbableKeyword(String keyword) {
        PsiStatement parentStatement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)this.myPosition, PsiStatement.class);
        if ("return".equals(keyword) && this.isLastStatement(parentStatement) && !PreferByKindWeigher.isOnTopLevelInVoidMethod(parentStatement) && !(parentStatement.getParent() instanceof PsiLoopStatement)) {
            ThreeState threeState = ThreeState.YES;
            if (threeState == null) {
                PreferByKindWeigher.$$$reportNull$$$0(35);
            }
            return threeState;
        }
        if (("break".equals(keyword) || "continue".equals(keyword)) && PsiTreeUtil.getParentOfType((PsiElement)this.myPosition, PsiLoopStatement.class) != null && this.isLastStatement(parentStatement)) {
            ThreeState threeState = ThreeState.YES;
            if (threeState == null) {
                PreferByKindWeigher.$$$reportNull$$$0(36);
            }
            return threeState;
        }
        if ("else".equals(keyword) || "finally".equals(keyword) || "catch".equals(keyword)) {
            ThreeState threeState = ThreeState.YES;
            if (threeState == null) {
                PreferByKindWeigher.$$$reportNull$$$0(37);
            }
            return threeState;
        }
        if ("true".equals(keyword) || "false".equals(keyword)) {
            if (this.myCompletionType == CompletionType.SMART) {
                boolean inReturn = ((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withParents(new Class[]{PsiReferenceExpression.class, PsiReturnStatement.class})).accepts((Object)this.myPosition);
                ThreeState threeState = inReturn ? ThreeState.YES : ThreeState.UNSURE;
                if (threeState == null) {
                    PreferByKindWeigher.$$$reportNull$$$0(38);
                }
                return threeState;
            }
            if (Arrays.stream(this.myExpectedTypes).anyMatch(info -> PsiType.BOOLEAN.isAssignableFrom(info.getDefaultType())) && !(this.myPosition.getParent() instanceof PsiIfStatement)) {
                ThreeState threeState = ThreeState.YES;
                if (threeState == null) {
                    PreferByKindWeigher.$$$reportNull$$$0(39);
                }
                return threeState;
            }
        }
        if ("interface".equals(keyword) && ((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().afterLeaf(new String[]{"@"})).accepts((Object)this.myPosition)) {
            ThreeState threeState = ThreeState.NO;
            if (threeState == null) {
                PreferByKindWeigher.$$$reportNull$$$0(40);
            }
            return threeState;
        }
        if ("null".equals(keyword) && PreferByKindWeigher.isComparisonRhs(this.myPosition)) {
            boolean expectsNotNull = Arrays.stream(this.myExpectedTypes).anyMatch(PreferByKindWeigher::isEnumClass);
            ThreeState threeState = expectsNotNull ? ThreeState.NO : ThreeState.YES;
            if (threeState == null) {
                PreferByKindWeigher.$$$reportNull$$$0(41);
            }
            return threeState;
        }
        if (JavaKeywordCompletion.PRIMITIVE_TYPES.contains(keyword) || "void".equals(keyword)) {
            boolean inCallArg = ((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withParents(new Class[]{PsiReferenceExpression.class, PsiExpressionList.class})).accepts((Object)this.myPosition);
            ThreeState threeState = inCallArg || PreferByKindWeigher.isInMethodTypeArg(this.myPosition) ? ThreeState.NO : ThreeState.UNSURE;
            if (threeState == null) {
                PreferByKindWeigher.$$$reportNull$$$0(42);
            }
            return threeState;
        }
        if ("final".equals(keyword) && this.isBeforeVariableOnSameLine(parentStatement)) {
            ThreeState threeState = ThreeState.YES;
            if (threeState == null) {
                PreferByKindWeigher.$$$reportNull$$$0(43);
            }
            return threeState;
        }
        ThreeState threeState = ThreeState.UNSURE;
        if (threeState == null) {
            PreferByKindWeigher.$$$reportNull$$$0(44);
        }
        return threeState;
    }

    static boolean isComparisonRhs(PsiElement position) {
        return ((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().afterLeaf((ElementPattern)PsiJavaPatterns.psiElement().withElementType((ElementPattern)PsiJavaPatterns.elementType().oneOf((Object[])new IElementType[]{JavaTokenType.EQEQ, JavaTokenType.NE})))).accepts((Object)position);
    }

    private boolean isBeforeVariableOnSameLine(@Nullable PsiStatement parentStatement) {
        return parentStatement != null && parentStatement.getTextRange().getStartOffset() == this.myPosition.getTextRange().getStartOffset() && JBIterable.generate((Object)parentStatement, PsiElement::getNextSibling).takeWhile(e -> !e.textContains('\n')).skip(1).filter(PsiStatement.class).isNotEmpty();
    }

    private boolean isAccessibleFieldGetter(Object object) {
        if (!(object instanceof PsiMethod)) {
            return false;
        }
        PsiField field = PropertyUtil.getFieldOfGetter((PsiMethod)object);
        return field != null && PsiResolveHelper.SERVICE.getInstance((Project)this.myPosition.getProject()).isAccessible((PsiMember)field, this.myPosition, null);
    }

    static boolean isInMethodTypeArg(PsiElement position) {
        return ((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().inside(PsiReferenceParameterList.class)).accepts((Object)position);
    }

    private static boolean isOnTopLevelInVoidMethod(@NotNull PsiStatement statement) {
        if (statement == null) {
            PreferByKindWeigher.$$$reportNull$$$0(45);
        }
        if (!(statement.getParent() instanceof PsiCodeBlock)) {
            return false;
        }
        PsiElement parent = statement.getParent().getParent();
        if (parent instanceof PsiMethod) {
            return ((PsiMethod)parent).isConstructor() || PsiType.VOID.equals((Object)((PsiMethod)parent).getReturnType());
        }
        if (parent instanceof PsiLambdaExpression) {
            PsiMethod method = LambdaUtil.getFunctionalInterfaceMethod((PsiType)((PsiLambdaExpression)parent).getFunctionalInterfaceType());
            return method != null && PsiType.VOID.equals((Object)method.getReturnType());
        }
        return false;
    }

    private static boolean isGetter(Object object) {
        if (!(object instanceof PsiMethod)) {
            return false;
        }
        PsiMethod method = (PsiMethod)object;
        if (!PropertyUtilBase.hasGetterName((PsiMethod)method)) {
            return false;
        }
        if (method.hasTypeParameters()) {
            return false;
        }
        return !KnownElementWeigher.isGetClass(method);
    }

    private boolean isLastStatement(PsiStatement statement) {
        if (statement == null) {
            return false;
        }
        if (!(statement.getParent() instanceof PsiCodeBlock)) {
            return true;
        }
        PsiCodeBlock codeBlock = (PsiCodeBlock)statement.getParent();
        PsiStatement[] siblings = codeBlock.getStatements();
        PsiStatement lastOne = siblings[siblings.length - 1];
        if (statement == lastOne) {
            return true;
        }
        int posEnd = this.myPosition.getTextRange().getEndOffset();
        int blockContentEnd = lastOne.getTextRange().getEndOffset();
        CharSequence fileText = this.myPosition.getContainingFile().getViewProvider().getContents();
        String afterPos = fileText.subSequence(posEnd, blockContentEnd).toString();
        int nonSpace = CharArrayUtil.shiftForward((CharSequence)afterPos, (int)0, (String)" \t");
        if (nonSpace < afterPos.length() && afterPos.charAt(nonSpace) == '\n') {
            return false;
        }
        try {
            PsiStatement asStatement = JavaPsiFacade.getElementFactory((Project)this.myPosition.getProject()).createStatementFromText(afterPos.trim(), null);
            return asStatement instanceof PsiExpressionStatement;
        }
        catch (IncorrectOperationException e) {
            return false;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 7: 
            case 8: 
            case 34: 
            case 45: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 7: 
            case 8: 
            case 34: 
            case 45: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/completion/PreferByKindWeigher";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 8: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createSuitabilityCondition";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "preferClassIf";
                break;
            }
            case 7: 
            case 8: 
            case 34: 
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/completion/PreferByKindWeigher";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "weigh";
                break;
            }
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "isProbableKeyword";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isEnumClass";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "weigh";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "isExpectedTypeItem";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "isOnTopLevelInVoidMethod";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 34: 
            case 45: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static enum MyResult {
        annoMethod,
        probableKeyword,
        castVariable,
        expectedTypeVariable,
        lambda,
        likelyMethodRef,
        methodRef,
        variable,
        getter,
        qualifiedWithField,
        qualifiedWithGetter,
        superMethodParameters,
        expectedTypeConstant,
        expectedTypeArgument,
        getterQualifiedByMethod,
        accessibleFieldGetter,
        normal,
        basicChain,
        collectionFactory,
        expectedTypeMethod,
        verySuitableClass,
        suitableClass,
        nonInitialized,
        classNameOrGlobalStatic,
        introducedVariable,
        unlikelyItem,
        improbableKeyword;

    }
}

