/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.daemon.JavaErrorBundle;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiMethodReferenceUtil;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import org.jetbrains.annotations.NotNull;

public class PsiMethodReferenceHighlightingUtil {
    static HighlightInfo checkRawConstructorReference(@NotNull PsiMethodReferenceExpression expression2) {
        PsiElement resolve2;
        PsiElement qualifier;
        PsiType[] typeParameters;
        if (expression2 == null) {
            PsiMethodReferenceHighlightingUtil.$$$reportNull$$$0(0);
        }
        if (expression2.isConstructor() && (typeParameters = expression2.getTypeParameters()).length > 0 && (qualifier = expression2.getQualifier()) instanceof PsiReferenceExpression && (resolve2 = ((PsiReferenceExpression)qualifier).resolve()) instanceof PsiClass && ((PsiClass)resolve2).hasTypeParameters()) {
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)expression2).descriptionAndTooltip("Raw constructor reference with explicit type parameters for constructor").create();
        }
        return null;
    }

    static String checkMethodReferenceContext(@NotNull PsiMethodReferenceExpression methodRef) {
        PsiElement resolve2;
        if (methodRef == null) {
            PsiMethodReferenceHighlightingUtil.$$$reportNull$$$0(1);
        }
        if ((resolve2 = methodRef.resolve()) == null) {
            return null;
        }
        return PsiMethodReferenceHighlightingUtil.checkMethodReferenceContext(methodRef, resolve2, methodRef.getFunctionalInterfaceType());
    }

    public static String checkMethodReferenceContext(@NotNull PsiMethodReferenceExpression methodRef, @NotNull PsiElement resolve2, PsiType functionalInterfaceType) {
        PsiClass outerClass;
        PsiReferenceParameterList parameterList;
        PsiJavaCodeReferenceElement referenceElement;
        if (methodRef == null) {
            PsiMethodReferenceHighlightingUtil.$$$reportNull$$$0(2);
        }
        if (resolve2 == null) {
            PsiMethodReferenceHighlightingUtil.$$$reportNull$$$0(3);
        }
        PsiClass containingClass = resolve2 instanceof PsiMethod ? ((PsiMethod)resolve2).getContainingClass() : (PsiClass)resolve2;
        boolean isStaticSelector = PsiMethodReferenceUtil.isStaticallyReferenced((PsiMethodReferenceExpression)methodRef);
        PsiElement qualifier = methodRef.getQualifier();
        boolean isMethodStatic = false;
        boolean receiverReferenced = false;
        boolean isConstructor = true;
        if (resolve2 instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)resolve2;
            isMethodStatic = method.hasModifierProperty("static");
            isConstructor = method.isConstructor();
            PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType((PsiType)functionalInterfaceType);
            PsiMethod interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiClassType.ClassResolveResult)resolveResult);
            receiverReferenced = PsiMethodReferenceUtil.isResolvedBySecondSearch((PsiMethodReferenceExpression)methodRef, (MethodSignature)(interfaceMethod != null ? interfaceMethod.getSignature(LambdaUtil.getSubstitutor((PsiMethod)interfaceMethod, (PsiClassType.ClassResolveResult)resolveResult)) : null), (boolean)method.isVarArgs(), (boolean)isMethodStatic, (int)method.getParameterList().getParametersCount());
            if (method.hasModifierProperty("abstract") && qualifier instanceof PsiSuperExpression) {
                return JavaErrorBundle.message("abstract.method.0.cannot.be.accessed.directly.method.reference.context", method.getName());
            }
        }
        if (!receiverReferenced) {
            if (isStaticSelector && !isMethodStatic && !isConstructor) {
                return JavaErrorBundle.message("non.static.method.cannot.be.referenced.from.a.static.context.method.reference.context", new Object[0]);
            }
            if (!isStaticSelector && isMethodStatic) {
                return JavaErrorBundle.message("static.method.referenced.through.non.static.qualifier.method.reference.context", new Object[0]);
            }
        } else if (isStaticSelector && isMethodStatic) {
            return JavaErrorBundle.message("static.method.referenced.through.receiver.method.reference.context", new Object[0]);
        }
        if (isMethodStatic && isStaticSelector && qualifier instanceof PsiTypeElement && (referenceElement = (PsiJavaCodeReferenceElement)PsiTreeUtil.getChildOfType((PsiElement)qualifier, PsiJavaCodeReferenceElement.class)) != null && (parameterList = referenceElement.getParameterList()) != null && parameterList.getTypeArguments().length > 0) {
            return JavaErrorBundle.message("parameterized.qualifier.on.static.method.reference.context", new Object[0]);
        }
        if (isConstructor && containingClass != null && PsiUtil.isInnerClass((PsiClass)containingClass) && containingClass.isPhysical() && (outerClass = containingClass.getContainingClass()) != null && !InheritanceUtil.hasEnclosingInstanceInScope((PsiClass)outerClass, (PsiElement)methodRef, (boolean)true, (boolean)false)) {
            return JavaErrorBundle.message("an.enclosing.instance.of.type.not.in.scope.method.reference.context", PsiFormatUtil.formatClass((PsiClass)outerClass, (int)1));
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodRef";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolve";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/daemon/impl/analysis/PsiMethodReferenceHighlightingUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkRawConstructorReference";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "checkMethodReferenceContext";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

