/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.daemon.impl.DaemonProgressIndicator;
import com.intellij.codeInsight.daemon.impl.FileStatusMap;
import com.intellij.codeInsight.daemon.impl.GlobalUsageHelper;
import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.codeInspection.deadCode.UnusedDeclarationInspectionBase;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiAnchor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiJavaReference;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiMatcherImpl;
import com.intellij.psi.util.PsiMatchers;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.reference.SoftReference;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashMap;
import java.lang.ref.Reference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class RefCountHolder {
    private final PsiFile myFile;
    private final MultiMap<PsiElement, PsiReference> myLocalRefsMap;
    private final Map<PsiAnchor, Boolean> myDclsUsedMap;
    private final Map<PsiReference, PsiImportStatementBase> myImportStatements;
    private final AtomicReference<ProgressIndicator> myState;
    private static final ProgressIndicator READY = new DaemonProgressIndicator(){
        {
            this.cancel();
        }

        public String toString() {
            return "READY";
        }
    };
    private static final ProgressIndicator EMPTY = new DaemonProgressIndicator(){
        {
            this.cancel();
        }

        public String toString() {
            return "EMPTY";
        }
    };
    private static final Key<Reference<RefCountHolder>> REF_COUNT_HOLDER_IN_FILE_KEY = Key.create((String)"REF_COUNT_HOLDER_IN_FILE_KEY");

    @NotNull
    static RefCountHolder get(@NotNull PsiFile file) {
        Reference ref;
        RefCountHolder holder;
        if (file == null) {
            RefCountHolder.$$$reportNull$$$0(0);
        }
        if ((holder = (RefCountHolder)SoftReference.dereference((Reference)(ref = (Reference)file.getUserData(REF_COUNT_HOLDER_IN_FILE_KEY)))) == null) {
            boolean replaced;
            holder = new RefCountHolder(file);
            java.lang.ref.SoftReference<RefCountHolder> newRef = new java.lang.ref.SoftReference<RefCountHolder>(holder);
            while (!(replaced = ((UserDataHolderEx)file).replace(REF_COUNT_HOLDER_IN_FILE_KEY, (Object)ref, newRef))) {
                ref = (Reference)file.getUserData(REF_COUNT_HOLDER_IN_FILE_KEY);
                RefCountHolder newHolder = (RefCountHolder)SoftReference.dereference((Reference)ref);
                if (newHolder == null) continue;
                holder = newHolder;
                break;
            }
        }
        RefCountHolder refCountHolder = holder;
        if (refCountHolder == null) {
            RefCountHolder.$$$reportNull$$$0(1);
        }
        return refCountHolder;
    }

    private RefCountHolder(@NotNull PsiFile file) {
        if (file == null) {
            RefCountHolder.$$$reportNull$$$0(2);
        }
        this.myLocalRefsMap = MultiMap.createSet();
        this.myDclsUsedMap = new THashMap();
        this.myImportStatements = new THashMap();
        this.myState = new AtomicReference<ProgressIndicator>(EMPTY);
        this.myFile = file;
        RefCountHolder.log("c: created for ", file);
    }

    @NotNull
    GlobalUsageHelper getGlobalUsageHelper(@NotNull PsiFile file, final @Nullable UnusedDeclarationInspectionBase deadCodeInspection, boolean isUnusedToolEnabled) {
        boolean isDeadCodeEnabled;
        if (file == null) {
            RefCountHolder.$$$reportNull$$$0(3);
        }
        FileViewProvider viewProvider = file.getViewProvider();
        Project project = file.getProject();
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        VirtualFile virtualFile = viewProvider.getVirtualFile();
        boolean inLibrary = fileIndex.isInLibrary(virtualFile);
        boolean bl = isDeadCodeEnabled = deadCodeInspection != null && isUnusedToolEnabled && deadCodeInspection.isGlobalEnabledInEditor();
        if (isDeadCodeEnabled && !inLibrary) {
            return new GlobalUsageHelperBase(){
                final Map<PsiMember, Boolean> myEntryPointCache = FactoryMap.create(member -> {
                    if (deadCodeInspection.isEntryPoint((PsiElement)member)) {
                        return true;
                    }
                    if (member instanceof PsiClass) {
                        return !((JBTreeTraverser)JBTreeTraverser.from(m -> m instanceof PsiClass ? JBIterable.from((Iterable)PsiTreeUtil.getStubChildrenOfTypeAsList((PsiElement)m, PsiMember.class)) : JBIterable.empty()).withRoot(member)).traverse().skip(1).processEach(this::shouldCheckUsages);
                    }
                    return false;
                });

                @Override
                public boolean shouldCheckUsages(@NotNull PsiMember member) {
                    if (member == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    return this.myEntryPointCache.get(member) == false;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/intellij/codeInsight/daemon/impl/analysis/RefCountHolder$3", "shouldCheckUsages"));
                }
            };
        }
        return new GlobalUsageHelperBase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clear() {
        MultiMap<PsiElement, PsiReference> multiMap = this.myLocalRefsMap;
        synchronized (multiMap) {
            this.myLocalRefsMap.clear();
        }
        this.myImportStatements.clear();
        this.myDclsUsedMap.clear();
    }

    void registerLocallyReferenced(@NotNull PsiNamedElement result) {
        if (result == null) {
            RefCountHolder.$$$reportNull$$$0(4);
        }
        this.myDclsUsedMap.put(PsiAnchor.create((PsiElement)result), Boolean.TRUE);
    }

    void registerReference(@NotNull PsiReference ref, @NotNull JavaResolveResult resolveResult) {
        PsiElement resolveScope;
        PsiElement refElement;
        PsiFile psiFile;
        if (ref == null) {
            RefCountHolder.$$$reportNull$$$0(5);
        }
        if (resolveResult == null) {
            RefCountHolder.$$$reportNull$$$0(6);
        }
        PsiFile psiFile2 = psiFile = (refElement = resolveResult.getElement()) == null ? null : refElement.getContainingFile();
        if (psiFile != null) {
            psiFile = (PsiFile)psiFile.getNavigationElement();
        }
        if (refElement != null && psiFile != null && this.myFile.getViewProvider().equals(psiFile.getViewProvider())) {
            this.registerLocalRef(ref, refElement.getNavigationElement());
        }
        if ((resolveScope = resolveResult.getCurrentFileResolveScope()) instanceof PsiImportStatementBase) {
            this.registerImportStatement(ref, (PsiImportStatementBase)resolveScope);
        } else if (refElement == null && ref instanceof PsiJavaReference) {
            for (JavaResolveResult result : ((PsiJavaReference)ref).multiResolve(true)) {
                resolveScope = result.getCurrentFileResolveScope();
                if (!(resolveScope instanceof PsiImportStatementBase)) continue;
                this.registerImportStatement(ref, (PsiImportStatementBase)resolveScope);
                break;
            }
        }
    }

    private void registerImportStatement(@NotNull PsiReference ref, @NotNull PsiImportStatementBase importStatement) {
        if (ref == null) {
            RefCountHolder.$$$reportNull$$$0(7);
        }
        if (importStatement == null) {
            RefCountHolder.$$$reportNull$$$0(8);
        }
        this.myImportStatements.put(ref, importStatement);
    }

    boolean isRedundant(@NotNull PsiImportStatementBase importStatement) {
        if (importStatement == null) {
            RefCountHolder.$$$reportNull$$$0(9);
        }
        return !this.myImportStatements.containsValue(importStatement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerLocalRef(@NotNull PsiReference ref, PsiElement refElement) {
        if (ref == null) {
            RefCountHolder.$$$reportNull$$$0(10);
        }
        PsiElement element = ref.getElement();
        if (refElement instanceof PsiMethod && PsiTreeUtil.isAncestor((PsiElement)refElement, (PsiElement)element, (boolean)true)) {
            return;
        }
        if (refElement instanceof PsiClass) {
            PsiElement resolve2;
            if (PsiTreeUtil.isAncestor((PsiElement)refElement, (PsiElement)element, (boolean)true)) {
                return;
            }
            PsiImportStatementBase importStmt = (PsiImportStatementBase)PsiTreeUtil.getParentOfType((PsiElement)element, PsiImportStatementBase.class);
            if (importStmt != null && (resolve2 = importStmt.resolve()) != null && PsiTreeUtil.isAncestor((PsiElement)refElement, (PsiElement)resolve2, (boolean)false)) {
                return;
            }
        }
        MultiMap<PsiElement, PsiReference> multiMap = this.myLocalRefsMap;
        synchronized (multiMap) {
            this.myLocalRefsMap.putValue((Object)refElement, (Object)ref);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeInvalidRefs() {
        MultiMap<PsiElement, PsiReference> multiMap = this.myLocalRefsMap;
        synchronized (multiMap) {
            ArrayList<Pair> toRemove2 = new ArrayList<Pair>();
            for (Map.Entry entry : this.myLocalRefsMap.entrySet()) {
                PsiElement element = (PsiElement)entry.getKey();
                for (PsiReference ref2 : (Collection)entry.getValue()) {
                    if (ref2.getElement().isValid()) continue;
                    toRemove2.add(Pair.create((Object)element, (Object)ref2));
                }
            }
            for (Pair pair2 : toRemove2) {
                this.myLocalRefsMap.remove((Object)((PsiElement)pair2.first), (Object)((PsiReference)pair2.second));
            }
        }
        this.myImportStatements.keySet().removeIf(ref -> !ref.getElement().isValid());
        RefCountHolder.removeInvalidFrom(this.myDclsUsedMap.keySet());
    }

    private static void removeInvalidFrom(@NotNull Collection<? extends PsiAnchor> collection) {
        if (collection == null) {
            RefCountHolder.$$$reportNull$$$0(11);
        }
        collection.removeIf(element -> element.retrieve() == null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isReferenced(@NotNull PsiElement element) {
        Boolean usedStatus;
        Collection array;
        if (element == null) {
            RefCountHolder.$$$reportNull$$$0(12);
        }
        MultiMap<PsiElement, PsiReference> multiMap = this.myLocalRefsMap;
        synchronized (multiMap) {
            array = this.myLocalRefsMap.get((Object)element);
        }
        if (!array.isEmpty() && !RefCountHolder.isParameterUsedRecursively(element, array)) {
            for (PsiReference reference : array) {
                if (!reference.isReferenceTo(element)) continue;
                return true;
            }
        }
        return (usedStatus = this.myDclsUsedMap.get(PsiAnchor.create((PsiElement)element))) == Boolean.TRUE;
    }

    private static boolean isParameterUsedRecursively(@NotNull PsiElement element, @NotNull Collection<? extends PsiReference> array) {
        if (element == null) {
            RefCountHolder.$$$reportNull$$$0(13);
        }
        if (array == null) {
            RefCountHolder.$$$reportNull$$$0(14);
        }
        if (!(element instanceof PsiParameter)) {
            return false;
        }
        PsiParameter parameter2 = (PsiParameter)element;
        PsiElement scope = parameter2.getDeclarationScope();
        if (!(scope instanceof PsiMethod)) {
            return false;
        }
        PsiMethod method = (PsiMethod)scope;
        int paramIndex = ArrayUtilRt.find((Object[])method.getParameterList().getParameters(), (Object)parameter2);
        for (PsiReference psiReference : array) {
            if (!(psiReference instanceof PsiElement)) {
                return false;
            }
            PsiElement argument = (PsiElement)psiReference;
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)new PsiMatcherImpl(argument).dot(PsiMatchers.hasClass(PsiReferenceExpression.class)).parent(PsiMatchers.hasClass(PsiExpressionList.class)).parent(PsiMatchers.hasClass(PsiMethodCallExpression.class)).getElement();
            if (methodCallExpression == null) {
                return false;
            }
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            if (method != methodExpression.resolve()) {
                return false;
            }
            PsiExpressionList argumentList = methodCallExpression.getArgumentList();
            Object[] arguments = argumentList.getExpressions();
            int argumentIndex = ArrayUtilRt.find((Object[])arguments, (Object)argument);
            if (paramIndex == argumentIndex) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isReferencedForRead(@NotNull PsiVariable variable) {
        Collection array;
        if (variable == null) {
            RefCountHolder.$$$reportNull$$$0(15);
        }
        MultiMap<PsiElement, PsiReference> multiMap = this.myLocalRefsMap;
        synchronized (multiMap) {
            array = this.myLocalRefsMap.get((Object)variable);
        }
        if (array.isEmpty()) {
            return false;
        }
        for (PsiReference ref : array) {
            ReadWriteAccessDetector.Access access;
            PsiElement refElement = ref.getElement();
            PsiElement resolved = ref.resolve();
            if (resolved == null || (access = RefCountHolder.getAccess(ref, resolved)) != ReadWriteAccessDetector.Access.Read && access != ReadWriteAccessDetector.Access.ReadWrite || RefCountHolder.isJustIncremented(access, refElement)) continue;
            return true;
        }
        return false;
    }

    private static ReadWriteAccessDetector.Access getAccess(@NotNull PsiReference ref, @NotNull PsiElement resolved) {
        PsiElement start;
        ReadWriteAccessDetector detector;
        if (ref == null) {
            RefCountHolder.$$$reportNull$$$0(16);
        }
        if (resolved == null) {
            RefCountHolder.$$$reportNull$$$0(17);
        }
        if ((detector = ReadWriteAccessDetector.findDetector((PsiElement)(start = resolved.getLanguage() == ref.getElement().getLanguage() ? resolved : ref.getElement()))) != null) {
            return detector.getReferenceAccess(resolved, ref);
        }
        return null;
    }

    private static boolean isJustIncremented(@NotNull ReadWriteAccessDetector.Access access, @NotNull PsiElement refElement) {
        if (access == null) {
            RefCountHolder.$$$reportNull$$$0(18);
        }
        if (refElement == null) {
            RefCountHolder.$$$reportNull$$$0(19);
        }
        return access == ReadWriteAccessDetector.Access.ReadWrite && refElement instanceof PsiExpression && refElement.getParent() instanceof PsiExpression && refElement.getParent().getParent() instanceof PsiExpressionStatement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isReferencedForWrite(@NotNull PsiVariable variable) {
        Collection array;
        if (variable == null) {
            RefCountHolder.$$$reportNull$$$0(20);
        }
        MultiMap<PsiElement, PsiReference> multiMap = this.myLocalRefsMap;
        synchronized (multiMap) {
            array = this.myLocalRefsMap.get((Object)variable);
        }
        if (array.isEmpty()) {
            return false;
        }
        for (PsiReference ref : array) {
            ReadWriteAccessDetector.Access access;
            PsiElement resolved = ref.resolve();
            if (resolved == null || (access = RefCountHolder.getAccess(ref, resolved)) != ReadWriteAccessDetector.Access.Write && access != ReadWriteAccessDetector.Access.ReadWrite) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean analyze(@NotNull PsiFile file, TextRange dirtyScope, @NotNull ProgressIndicator indicator, @NotNull Runnable analyze) {
        boolean bl;
        ProgressIndicator result;
        block14: {
            if (file == null) {
                RefCountHolder.$$$reportNull$$$0(21);
            }
            if (indicator == null) {
                RefCountHolder.$$$reportNull$$$0(22);
            }
            if (analyze == null) {
                RefCountHolder.$$$reportNull$$$0(23);
            }
            if (this.myState.compareAndSet(EMPTY, indicator)) {
                if (!file.getTextRange().equals((Object)dirtyScope)) {
                    RefCountHolder.log(" RefCountHolder: invalid scope " + dirtyScope);
                    this.myState.set(EMPTY);
                    return false;
                }
                result = EMPTY;
            } else if (this.myState.compareAndSet(READY, indicator)) {
                result = READY;
            } else {
                RefCountHolder.log("a: failed to change ", this.myState, "->", indicator);
                return false;
            }
            try {
                RefCountHolder.log("a: changed ", this.myState, "->", indicator);
                if (dirtyScope != null) {
                    if (dirtyScope.equals((Object)file.getTextRange())) {
                        this.clear();
                    } else {
                        this.removeInvalidRefs();
                    }
                }
                analyze.run();
                result = READY;
                bl = true;
                boolean set = this.myState.compareAndSet(indicator, result);
                if ($assertionsDisabled || set) break block14;
            }
            catch (Throwable throwable) {
                boolean set = this.myState.compareAndSet(indicator, result);
                assert (set) : this.myState.get();
                RefCountHolder.log("a: changed after analyze", indicator, "->", result);
                throw throwable;
            }
            throw new AssertionError(this.myState.get());
        }
        RefCountHolder.log("a: changed after analyze", indicator, "->", result);
        return bl;
    }

    private static void log(Object ... info) {
        if (info == null) {
            RefCountHolder.$$$reportNull$$$0(24);
        }
        FileStatusMap.log((Object[])info);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/analysis/RefCountHolder";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 5: 
            case 7: 
            case 10: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveResult";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importStatement";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "array";
                break;
            }
            case 15: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolved";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "access";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refElement";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "analyze";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/analysis/RefCountHolder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getGlobalUsageHelper";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "registerLocallyReferenced";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "registerReference";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "registerImportStatement";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isRedundant";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "registerLocalRef";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "removeInvalidFrom";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isReferenced";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isParameterUsedRecursively";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isReferencedForRead";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getAccess";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isJustIncremented";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isReferencedForWrite";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "analyze";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "log";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class GlobalUsageHelperBase
    extends GlobalUsageHelper {
        private GlobalUsageHelperBase() {
        }

        @Override
        public boolean shouldCheckUsages(@NotNull PsiMember member) {
            if (member == null) {
                GlobalUsageHelperBase.$$$reportNull$$$0(0);
            }
            return false;
        }

        @Override
        public boolean isCurrentFileAlreadyChecked() {
            return true;
        }

        @Override
        public boolean isLocallyUsed(@NotNull PsiNamedElement member) {
            if (member == null) {
                GlobalUsageHelperBase.$$$reportNull$$$0(1);
            }
            return RefCountHolder.this.isReferenced((PsiElement)member);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "member";
            objectArray2[1] = "com/intellij/codeInsight/daemon/impl/analysis/RefCountHolder$GlobalUsageHelperBase";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "shouldCheckUsages";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isLocallyUsed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

