/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddExceptionToThrowsFix
extends BaseIntentionAction {
    private final PsiElement myWrongElement;

    public AddExceptionToThrowsFix(@NotNull PsiElement wrongElement) {
        if (wrongElement == null) {
            AddExceptionToThrowsFix.$$$reportNull$$$0(0);
        }
        this.myWrongElement = wrongElement;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            AddExceptionToThrowsFix.$$$reportNull$$$0(1);
        }
        if (!FileModificationService.getInstance().prepareFileForWrite(file)) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        ArrayList exceptions = new ArrayList();
        PsiMethod targetMethod = this.collectExceptions(exceptions);
        if (targetMethod == null) {
            return;
        }
        THashSet unhandledExceptions = new THashSet(exceptions);
        AddExceptionToThrowsFix.addExceptionsToThrowsList(project, targetMethod, (Set<? extends PsiClassType>)unhandledExceptions);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void addExceptionsToThrowsList(@NotNull Project project, @NotNull PsiMethod targetMethod, @NotNull Set<? extends PsiClassType> unhandledExceptions) {
        boolean processSuperMethods;
        PsiMethod[] superMethods;
        boolean hasSuperMethodsWithoutExceptions;
        if (project == null) {
            AddExceptionToThrowsFix.$$$reportNull$$$0(2);
        }
        if (targetMethod == null) {
            AddExceptionToThrowsFix.$$$reportNull$$$0(3);
        }
        if (unhandledExceptions == null) {
            AddExceptionToThrowsFix.$$$reportNull$$$0(4);
        }
        if ((hasSuperMethodsWithoutExceptions = AddExceptionToThrowsFix.hasSuperMethodsWithoutExceptions(superMethods = AddExceptionToThrowsFix.getSuperMethods(targetMethod), unhandledExceptions)) && superMethods.length > 0) {
            int result;
            int n = result = ApplicationManager.getApplication().isUnitTestMode() ? 0 : Messages.showYesNoCancelDialog((String)QuickFixBundle.message("add.exception.to.throws.inherited.method.warning.text", targetMethod.getName()), (String)QuickFixBundle.message("method.is.inherited.warning.title", new Object[0]), (Icon)Messages.getQuestionIcon());
            if (result == 0) {
                processSuperMethods = true;
            } else {
                if (result != true) return;
                processSuperMethods = false;
            }
        } else {
            processSuperMethods = false;
        }
        ArrayList<PsiMethod> toModify = new ArrayList<PsiMethod>();
        toModify.add(targetMethod);
        if (processSuperMethods) {
            Collections.addAll(toModify, superMethods);
        }
        if (!FileModificationService.getInstance().preparePsiElementsForWrite(toModify)) {
            return;
        }
        WriteAction.run(() -> {
            AddExceptionToThrowsFix.processMethod(project, targetMethod, unhandledExceptions);
            if (processSuperMethods) {
                for (PsiMethod superMethod : superMethods) {
                    AddExceptionToThrowsFix.processMethod(project, superMethod, unhandledExceptions);
                }
            }
        });
    }

    private static PsiMethod @NotNull [] getSuperMethods(@NotNull PsiMethod targetMethod) {
        if (targetMethod == null) {
            AddExceptionToThrowsFix.$$$reportNull$$$0(5);
        }
        ArrayList result = new ArrayList();
        AddExceptionToThrowsFix.collectSuperMethods(targetMethod, result);
        PsiMethod[] psiMethodArray = result.toArray(PsiMethod.EMPTY_ARRAY);
        if (psiMethodArray == null) {
            AddExceptionToThrowsFix.$$$reportNull$$$0(6);
        }
        return psiMethodArray;
    }

    private static void collectSuperMethods(@NotNull PsiMethod method, @NotNull List<? super PsiMethod> result) {
        PsiMethod[] superMethods;
        if (method == null) {
            AddExceptionToThrowsFix.$$$reportNull$$$0(7);
        }
        if (result == null) {
            AddExceptionToThrowsFix.$$$reportNull$$$0(8);
        }
        for (PsiMethod superMethod : superMethods = method.findSuperMethods()) {
            result.add((PsiMethod)superMethod);
            AddExceptionToThrowsFix.collectSuperMethods(superMethod, result);
        }
    }

    private static boolean hasSuperMethodsWithoutExceptions(PsiMethod @NotNull [] superMethods, @NotNull Set<? extends PsiClassType> unhandledExceptions) {
        if (unhandledExceptions == null) {
            AddExceptionToThrowsFix.$$$reportNull$$$0(9);
        }
        if (superMethods == null) {
            AddExceptionToThrowsFix.$$$reportNull$$$0(10);
        }
        for (PsiMethod superMethod : superMethods) {
            PsiClassType[] referencedTypes = superMethod.getThrowsList().getReferencedTypes();
            HashSet<? extends PsiClassType> exceptions = new HashSet<PsiClassType>(unhandledExceptions);
            for (PsiClassType referencedType : referencedTypes) {
                for (PsiClassType psiClassType : unhandledExceptions) {
                    if (!referencedType.isAssignableFrom((PsiType)psiClassType)) continue;
                    exceptions.remove(psiClassType);
                }
            }
            if (exceptions.isEmpty()) continue;
            return true;
        }
        return false;
    }

    private static void processMethod(@NotNull Project project, @NotNull PsiMethod targetMethod, @NotNull Set<? extends PsiClassType> unhandledExceptions) throws IncorrectOperationException {
        if (project == null) {
            AddExceptionToThrowsFix.$$$reportNull$$$0(11);
        }
        if (targetMethod == null) {
            AddExceptionToThrowsFix.$$$reportNull$$$0(12);
        }
        if (unhandledExceptions == null) {
            AddExceptionToThrowsFix.$$$reportNull$$$0(13);
        }
        for (PsiClassType psiClassType : unhandledExceptions) {
            PsiClass exceptionClass = psiClassType.resolve();
            if (exceptionClass == null) continue;
            PsiUtil.addException((PsiMethod)targetMethod, (PsiClass)exceptionClass);
        }
        CodeStyleManager.getInstance((Project)project).reformat((PsiElement)targetMethod.getThrowsList());
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            AddExceptionToThrowsFix.$$$reportNull$$$0(14);
        }
        if (!(file instanceof PsiJavaFile)) {
            return false;
        }
        if (!this.myWrongElement.isValid()) {
            return false;
        }
        ArrayList unhandled = new ArrayList();
        if (this.collectExceptions(unhandled) == null) {
            return false;
        }
        this.setText(QuickFixBundle.message("add.exception.to.throws.text", unhandled.size()));
        return true;
    }

    @Nullable
    private PsiMethod collectExceptions(List<? super PsiClassType> unhandled) {
        PsiElement psiElement;
        PsiElement targetElement = null;
        PsiMethod targetMethod = null;
        if (this.myWrongElement instanceof PsiMethodReferenceExpression) {
            psiElement = this.myWrongElement;
        } else {
            PsiElement[] declaredElements;
            PsiElement parentStatement = RefactoringUtil.getParentStatement(this.myWrongElement, false);
            if (parentStatement instanceof PsiDeclarationStatement && (declaredElements = ((PsiDeclarationStatement)parentStatement).getDeclaredElements()).length > 0 && declaredElements[0] instanceof PsiClass) {
                return null;
            }
            psiElement = PsiTreeUtil.getParentOfType((PsiElement)this.myWrongElement, (Class[])new Class[]{PsiFunctionalExpression.class, PsiMethod.class});
        }
        if (psiElement instanceof PsiFunctionalExpression) {
            targetMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiElement)psiElement);
            targetElement = psiElement instanceof PsiLambdaExpression ? ((PsiLambdaExpression)psiElement).getBody() : psiElement;
        } else if (psiElement instanceof PsiMethod) {
            targetMethod = (PsiMethod)psiElement;
            targetElement = psiElement;
        }
        if (targetElement == null || targetMethod == null || !targetMethod.getThrowsList().isPhysical()) {
            return null;
        }
        if (!ExceptionUtil.canDeclareThrownExceptions(targetMethod)) {
            return null;
        }
        List<PsiClassType> exceptions = AddExceptionToThrowsFix.getUnhandledExceptions(this.myWrongElement, targetElement, targetMethod);
        if (exceptions == null || exceptions.isEmpty()) {
            return null;
        }
        unhandled.addAll(exceptions);
        return targetMethod;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("add.exception.to.throws.family", new Object[0]);
        if (string == null) {
            AddExceptionToThrowsFix.$$$reportNull$$$0(15);
        }
        return string;
    }

    @Nullable
    private static List<PsiClassType> getUnhandledExceptions(@Nullable PsiElement element, PsiElement topElement, PsiMethod targetMethod) {
        if (element == null || element == topElement && !(topElement instanceof PsiMethodReferenceExpression)) {
            return null;
        }
        List<PsiClassType> unhandledExceptions = ExceptionUtil.getUnhandledExceptions(element);
        if (!AddExceptionToThrowsFix.filterInProjectExceptions(targetMethod, unhandledExceptions).isEmpty()) {
            return unhandledExceptions;
        }
        if (topElement instanceof PsiMethodReferenceExpression) {
            return null;
        }
        return AddExceptionToThrowsFix.getUnhandledExceptions(element.getParent(), topElement, targetMethod);
    }

    @NotNull
    private static Set<PsiClassType> filterInProjectExceptions(@Nullable PsiMethod targetMethod, @NotNull List<? extends PsiClassType> unhandledExceptions) {
        if (unhandledExceptions == null) {
            AddExceptionToThrowsFix.$$$reportNull$$$0(16);
        }
        if (targetMethod == null) {
            Set<PsiClassType> set = Collections.emptySet();
            if (set == null) {
                AddExceptionToThrowsFix.$$$reportNull$$$0(17);
            }
            return set;
        }
        HashSet<PsiClassType> result = new HashSet<PsiClassType>();
        if (AddExceptionToThrowsFix.canModify((PsiElement)targetMethod)) {
            PsiMethod[] superMethods;
            for (PsiMethod superMethod : superMethods = targetMethod.findSuperMethods()) {
                Set<PsiClassType> classTypes = AddExceptionToThrowsFix.filterInProjectExceptions(superMethod, unhandledExceptions);
                result.addAll(classTypes);
            }
            if (superMethods.length == 0) {
                result.addAll(unhandledExceptions);
            }
        } else {
            PsiClassType[] referencedTypes;
            for (PsiClassType referencedType : referencedTypes = targetMethod.getThrowsList().getReferencedTypes()) {
                PsiClass psiClass = referencedType.resolve();
                if (psiClass == null) continue;
                for (PsiClassType psiClassType : unhandledExceptions) {
                    if (!referencedType.isAssignableFrom((PsiType)psiClassType)) continue;
                    result.add(psiClassType);
                }
            }
        }
        HashSet<PsiClassType> hashSet = result;
        if (hashSet == null) {
            AddExceptionToThrowsFix.$$$reportNull$$$0(18);
        }
        return hashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 15: 
            case 17: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 15: 
            case 17: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wrongElement";
                break;
            }
            case 1: 
            case 2: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 5: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetMethod";
                break;
            }
            case 4: 
            case 9: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unhandledExceptions";
                break;
            }
            case 6: 
            case 15: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/AddExceptionToThrowsFix";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superMethods";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/AddExceptionToThrowsFix";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuperMethods";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "filterInProjectExceptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addExceptionsToThrowsList";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getSuperMethods";
                break;
            }
            case 6: 
            case 15: 
            case 17: 
            case 18: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "collectSuperMethods";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "hasSuperMethodsWithoutExceptions";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "processMethod";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "filterInProjectExceptions";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 15: 
            case 17: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

