/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.TextExpression;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.TypeUtils;
import gnu.trove.TObjectIntHashMap;
import java.util.Collection;
import java.util.Comparator;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;

public final class AddMissingRequiredAnnotationParametersFix
implements IntentionAction {
    private static final Logger LOG = Logger.getInstance(AddMissingRequiredAnnotationParametersFix.class);
    private final PsiAnnotation myAnnotation;
    private final PsiMethod[] myAnnotationMethods;
    private final Collection<String> myMissedElements;

    public AddMissingRequiredAnnotationParametersFix(PsiAnnotation annotation, PsiMethod[] annotationMethods, Collection<String> missedElements) {
        if (missedElements.isEmpty()) {
            throw new IllegalArgumentException("missedElements can't be empty");
        }
        this.myAnnotation = annotation;
        this.myAnnotationMethods = annotationMethods;
        this.myMissedElements = missedElements;
    }

    @NotNull
    public String getText() {
        String string = this.myMissedElements.size() == 1 ? QuickFixBundle.message("add.missing.annotation.single.parameter.fix", ContainerUtil.getFirstItem(this.myMissedElements)) : QuickFixBundle.message("add.missing.annotation.parameters.fix", StringUtil.join(this.myMissedElements, (String)", "));
        if (string == null) {
            AddMissingRequiredAnnotationParametersFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("annotations.fix", new Object[0]);
        if (string == null) {
            AddMissingRequiredAnnotationParametersFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            AddMissingRequiredAnnotationParametersFix.$$$reportNull$$$0(2);
        }
        return this.myAnnotation.isValid();
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            AddMissingRequiredAnnotationParametersFix.$$$reportNull$$$0(3);
        }
        PsiNameValuePair[] addedParameters = this.myAnnotation.getParameterList().getAttributes();
        TObjectIntHashMap<String> annotationsOrderMap = this.getAnnotationsOrderMap();
        TreeSet<Pair> newParameters = new TreeSet<Pair>(Comparator.comparingInt(o -> annotationsOrderMap.get((Object)((String)o.getFirst()))));
        boolean order = AddMissingRequiredAnnotationParametersFix.isAlreadyAddedOrdered(annotationsOrderMap, addedParameters);
        if (order && addedParameters.length != 0) {
            PsiAnnotationParameterList parameterList = this.myAnnotation.getParameterList();
            parameterList.deleteChildRange((PsiElement)addedParameters[0], (PsiElement)addedParameters[addedParameters.length - 1]);
            for (PsiMethod psiMethod : addedParameters) {
                String name2 = psiMethod.getName();
                PsiAnnotationMemberValue value2 = psiMethod.getValue();
                if (name2 == null) {
                    name2 = "value";
                }
                if (value2 == null) {
                    LOG.error(String.format("Invalid annotation parameter name = %s, value = %s", name2, value2));
                    continue;
                }
                newParameters.add(Pair.create((Object)name2, (Object)value2));
            }
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
        for (PsiMethod psiMethod : this.myAnnotationMethods) {
            if (!this.myMissedElements.contains(psiMethod.getName())) continue;
            PsiType type2 = psiMethod.getReturnType();
            String defaultValue = TypeUtils.isJavaLangString(type2) ? "\"\"" : (type2 instanceof PsiArrayType ? "{}" : TypeUtils.getDefaultValue(type2));
            newParameters.add(Pair.create((Object)psiMethod.getName(), (Object)factory.createExpressionFromText(defaultValue, null)));
        }
        TemplateBuilderImpl builder = null;
        for (Pair newParameter : newParameters) {
            PsiAnnotationMemberValue psiAnnotationMemberValue = this.myAnnotation.setDeclaredAttributeValue((String)newParameter.getFirst(), (PsiAnnotationMemberValue)newParameter.getSecond());
            if (!this.myMissedElements.contains(newParameter.getFirst())) continue;
            if (builder == null) {
                builder = new TemplateBuilderImpl((PsiElement)this.myAnnotation.getParameterList());
            }
            builder.replaceElement((PsiElement)psiAnnotationMemberValue, (Expression)new TextExpression(((PsiAnnotationMemberValue)newParameter.getSecond()).getText()), true);
        }
        if (!file.isPhysical()) {
            return;
        }
        editor.getCaretModel().moveToOffset(this.myAnnotation.getParameterList().getTextRange().getStartOffset());
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
        Document document = documentManager.getDocument(file);
        if (document == null) {
            throw new IllegalStateException();
        }
        documentManager.doPostponedOperationsAndUnblockDocument(document);
        TemplateManager.getInstance((Project)project).startTemplate(editor, builder.buildInlineTemplate(), null);
    }

    public boolean startInWriteAction() {
        return true;
    }

    private TObjectIntHashMap<String> getAnnotationsOrderMap() {
        TObjectIntHashMap map2 = new TObjectIntHashMap();
        for (int i = 0; i < this.myAnnotationMethods.length; ++i) {
            map2.put((Object)this.myAnnotationMethods[i].getName(), i);
        }
        return map2;
    }

    private static boolean isAlreadyAddedOrdered(TObjectIntHashMap<String> orderMap, PsiNameValuePair[] addedParameters) {
        if (addedParameters.length <= 1) {
            return true;
        }
        int previousOrder = orderMap.get((Object)addedParameters[0].getName());
        for (int i = 1; i < addedParameters.length; ++i) {
            int currentOrder = orderMap.get((Object)addedParameters[i].getName());
            if (currentOrder < previousOrder) {
                return false;
            }
            previousOrder = currentOrder;
        }
        return true;
    }

    @NotNull
    public FileModifier getFileModifierForPreview(@NotNull PsiFile target) {
        if (target == null) {
            AddMissingRequiredAnnotationParametersFix.$$$reportNull$$$0(4);
        }
        return new AddMissingRequiredAnnotationParametersFix((PsiAnnotation)PsiTreeUtil.findSameElementInCopy((PsiElement)this.myAnnotation, (PsiFile)target), this.myAnnotationMethods, this.myMissedElements);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/AddMissingRequiredAnnotationParametersFix";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/AddMissingRequiredAnnotationParametersFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getFileModifierForPreview";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

