/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.AddTypeCastFix;
import com.intellij.codeInsight.daemon.impl.quickfix.ArgumentFixerActionFactory;
import com.intellij.codeInsight.daemon.impl.quickfix.MethodArgumentFix;
import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CastMethodArgumentFix
extends MethodArgumentFix
implements HighPriorityAction {
    private final String myText;
    public static final ArgumentFixerActionFactory REGISTRAR = new MyFixerActionFactory();

    private CastMethodArgumentFix(PsiExpressionList list, int i, PsiType toType, ArgumentFixerActionFactory factory) {
        super(list, i, toType, factory);
        this.myText = this.myArgList.getExpressionCount() == 1 ? QuickFixBundle.message("cast.single.parameter.text", JavaHighlightUtil.formatType(this.myToType)) : QuickFixBundle.message("cast.parameter.text", this.myIndex + 1, JavaHighlightUtil.formatType(this.myToType));
    }

    @NotNull
    public String getText() {
        String string = this.myText;
        if (string == null) {
            CastMethodArgumentFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nullable
    public FileModifier getFileModifierForPreview(@NotNull PsiFile target) {
        if (target == null) {
            CastMethodArgumentFix.$$$reportNull$$$0(1);
        }
        return new CastMethodArgumentFix((PsiExpressionList)PsiTreeUtil.findSameElementInCopy((PsiElement)this.myArgList, (PsiFile)target), this.myIndex, this.myToType, this.myArgumentFixerActionFactory);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/CastMethodArgumentFix";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/CastMethodArgumentFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getFileModifierForPreview";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyFixerActionFactory
    extends ArgumentFixerActionFactory {
        private MyFixerActionFactory() {
        }

        @Override
        public CastMethodArgumentFix createFix(PsiExpressionList list, int i, PsiType toType) {
            return new CastMethodArgumentFix(list, i, toType, this);
        }

        @Override
        protected PsiExpression getModifiedArgument(PsiExpression expression2, PsiType toType) throws IncorrectOperationException {
            PsiType exprType = expression2.getType();
            if (exprType instanceof PsiClassType && toType instanceof PsiPrimitiveType) {
                toType = ((PsiPrimitiveType)toType).getBoxedType((PsiElement)expression2);
                assert (toType != null);
            }
            return AddTypeCastFix.createCastExpression(expression2, expression2.getProject(), toType);
        }

        @Override
        public boolean areTypesConvertible(@NotNull PsiType exprType, @NotNull PsiType parameterType, @NotNull PsiElement context) {
            if (exprType == null) {
                MyFixerActionFactory.$$$reportNull$$$0(0);
            }
            if (parameterType == null) {
                MyFixerActionFactory.$$$reportNull$$$0(1);
            }
            if (context == null) {
                MyFixerActionFactory.$$$reportNull$$$0(2);
            }
            if (exprType instanceof PsiClassType && parameterType instanceof PsiPrimitiveType && (parameterType = ((PsiPrimitiveType)parameterType).getBoxedType(context)) == null) {
                return false;
            }
            if (exprType instanceof PsiPrimitiveType && parameterType instanceof PsiClassType) {
                if (PsiType.NULL.equals((Object)exprType)) {
                    return true;
                }
                if ((parameterType = PsiPrimitiveType.getUnboxedType((PsiType)parameterType)) == null) {
                    return false;
                }
            }
            if (parameterType.isConvertibleFrom(exprType)) {
                return true;
            }
            return parameterType instanceof PsiEllipsisType && this.areTypesConvertible(exprType, ((PsiEllipsisType)parameterType).getComponentType(), context);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "exprType";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameterType";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInsight/daemon/impl/quickfix/CastMethodArgumentFix$MyFixerActionFactory";
            objectArray[2] = "areTypesConvertible";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

