/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.codeInspection.util.ChangeToAppendUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class ChangeToAppendFix
implements IntentionAction {
    private final IElementType myTokenType;
    private final PsiType myLhsType;
    private final PsiAssignmentExpression myAssignmentExpression;
    private volatile TypeInfo myTypeInfo;

    public ChangeToAppendFix(@NotNull IElementType eqOpSign, @NotNull PsiType lType, @NotNull PsiAssignmentExpression assignmentExpression) {
        if (eqOpSign == null) {
            ChangeToAppendFix.$$$reportNull$$$0(0);
        }
        if (lType == null) {
            ChangeToAppendFix.$$$reportNull$$$0(1);
        }
        if (assignmentExpression == null) {
            ChangeToAppendFix.$$$reportNull$$$0(2);
        }
        this.myTokenType = eqOpSign;
        this.myLhsType = lType;
        this.myAssignmentExpression = assignmentExpression;
    }

    @NotNull
    public String getText() {
        String string = QuickFixBundle.message("change.to.append.text", ChangeToAppendUtil.buildAppendExpression(this.myAssignmentExpression.getRExpression(), this.getTypeInfo().myUseStringValueOf, new StringBuilder(this.myAssignmentExpression.getLExpression().getText())));
        if (string == null) {
            ChangeToAppendFix.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("change.to.append.family", new Object[0]);
        if (string == null) {
            ChangeToAppendFix.$$$reportNull$$$0(4);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            ChangeToAppendFix.$$$reportNull$$$0(5);
        }
        return JavaTokenType.PLUSEQ == this.myTokenType && this.myAssignmentExpression.isValid() && BaseIntentionAction.canModify((PsiElement)this.myAssignmentExpression) && this.getTypeInfo().myAppendable;
    }

    public boolean startInWriteAction() {
        return true;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        PsiExpression appendExpression;
        if (project == null) {
            ChangeToAppendFix.$$$reportNull$$$0(6);
        }
        if ((appendExpression = ChangeToAppendUtil.buildAppendExpression(this.myAssignmentExpression.getLExpression(), this.myAssignmentExpression.getRExpression())) == null) {
            return;
        }
        this.myAssignmentExpression.replace((PsiElement)appendExpression);
    }

    @NotNull
    private TypeInfo getTypeInfo() {
        if (this.myTypeInfo != null) {
            TypeInfo typeInfo = this.myTypeInfo;
            if (typeInfo == null) {
                ChangeToAppendFix.$$$reportNull$$$0(7);
            }
            return typeInfo;
        }
        TypeInfo typeInfo = this.myTypeInfo = this.calculateTypeInfo();
        if (typeInfo == null) {
            ChangeToAppendFix.$$$reportNull$$$0(8);
        }
        return typeInfo;
    }

    @NotNull
    private TypeInfo calculateTypeInfo() {
        if (this.myLhsType.equalsToText("java.lang.StringBuilder") || this.myLhsType.equalsToText("java.lang.StringBuffer")) {
            return new TypeInfo(true, false);
        }
        if (InheritanceUtil.isInheritor((PsiType)this.myLhsType, (String)"java.lang.Appendable")) {
            return new TypeInfo(true, true);
        }
        return new TypeInfo(false, false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eqOpSign";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignmentExpression";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/ChangeToAppendFix";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/ChangeToAppendFix";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class TypeInfo {
        private final boolean myAppendable;
        private final boolean myUseStringValueOf;

        TypeInfo(boolean appendable, boolean useStringValueOf) {
            this.myAppendable = appendable;
            this.myUseStringValueOf = useStringValueOf;
        }
    }
}

