/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.source.resolve.DefaultParameterTypeInferencePolicy;
import com.intellij.psi.impl.source.resolve.ParameterTypeInferencePolicy;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.TypeConversionUtil;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangeTypeArgumentsFix
implements IntentionAction,
HighPriorityAction {
    private static final Logger LOG = Logger.getInstance(ChangeTypeArgumentsFix.class);
    private final PsiMethod myTargetMethod;
    private final PsiClass myPsiClass;
    private final PsiExpression[] myExpressions;
    private final PsiNewExpression myNewExpression;

    ChangeTypeArgumentsFix(@NotNull PsiMethod targetMethod, PsiClass psiClass, PsiExpression @NotNull [] expressions2, @NotNull PsiElement context) {
        if (targetMethod == null) {
            ChangeTypeArgumentsFix.$$$reportNull$$$0(0);
        }
        if (context == null) {
            ChangeTypeArgumentsFix.$$$reportNull$$$0(1);
        }
        if (expressions2 == null) {
            ChangeTypeArgumentsFix.$$$reportNull$$$0(2);
        }
        this.myTargetMethod = targetMethod;
        this.myPsiClass = psiClass;
        this.myExpressions = expressions2;
        this.myNewExpression = (PsiNewExpression)PsiTreeUtil.getParentOfType((PsiElement)context, PsiNewExpression.class);
    }

    @NotNull
    public String getText() {
        PsiSubstitutor substitutor = this.inferTypeArguments();
        String string = JavaAnalysisBundle.message((String)"change.type.arguments.to.0", (Object[])new Object[]{StringUtil.join((Object[])this.myPsiClass.getTypeParameters(), typeParameter -> {
            PsiType substituted = substitutor.substitute(typeParameter);
            return substituted != null ? substituted.getPresentableText() : "java.lang.Object";
        }, (String)", ")});
        if (string == null) {
            ChangeTypeArgumentsFix.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = JavaAnalysisBundle.message((String)"change.type.arguments", (Object[])new Object[0]);
        if (string == null) {
            ChangeTypeArgumentsFix.$$$reportNull$$$0(4);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        PsiReferenceParameterList parameterList;
        PsiJavaCodeReferenceElement reference;
        if (project == null) {
            ChangeTypeArgumentsFix.$$$reportNull$$$0(5);
        }
        if (!this.myPsiClass.isValid() || !this.myTargetMethod.isValid()) {
            return false;
        }
        PsiTypeParameter[] typeParameters = this.myPsiClass.getTypeParameters();
        if (typeParameters.length > 0 && this.myNewExpression != null && this.myNewExpression.isValid() && this.myNewExpression.getArgumentList() != null && (reference = this.myNewExpression.getClassOrAnonymousClassReference()) != null && (parameterList = reference.getParameterList()) != null) {
            PsiSubstitutor substitutor = this.inferTypeArguments();
            PsiParameter[] parameters2 = this.myTargetMethod.getParameterList().getParameters();
            if (parameters2.length != this.myExpressions.length) {
                return false;
            }
            int length = parameters2.length;
            for (int i = 0; i < length; ++i) {
                PsiParameter parameter2 = parameters2[i];
                PsiType expectedType = substitutor.substitute(parameter2.getType());
                if (!this.myExpressions[i].isValid()) {
                    return false;
                }
                PsiType actualType = this.myExpressions[i].getType();
                if (expectedType != null && actualType != null && TypeConversionUtil.isAssignable((PsiType)expectedType, (PsiType)actualType)) continue;
                return false;
            }
            for (PsiTypeParameter parameter3 : typeParameters) {
                if (substitutor.substitute(parameter3) != null) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            ChangeTypeArgumentsFix.$$$reportNull$$$0(6);
        }
        PsiTypeParameter[] typeParameters = this.myPsiClass.getTypeParameters();
        PsiSubstitutor psiSubstitutor = this.inferTypeArguments();
        PsiJavaCodeReferenceElement reference = this.myNewExpression.getClassOrAnonymousClassReference();
        LOG.assertTrue(reference != null, (Object)this.myNewExpression);
        PsiReferenceParameterList parameterList = reference.getParameterList();
        LOG.assertTrue(parameterList != null, (Object)this.myNewExpression);
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
        PsiTypeElement[] elements = parameterList.getTypeParameterElements();
        for (int i = elements.length - 1; i >= 0; --i) {
            PsiType typeArg = Objects.requireNonNull(psiSubstitutor.substitute(typeParameters[i]));
            PsiElement replaced = elements[i].replace((PsiElement)factory.createTypeElement(typeArg));
            JavaCodeStyleManager.getInstance((Project)file.getProject()).shortenClassReferences(replaced);
        }
    }

    private PsiSubstitutor inferTypeArguments() {
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)this.myNewExpression.getProject());
        PsiResolveHelper resolveHelper = facade.getResolveHelper();
        PsiParameter[] parameters2 = this.myTargetMethod.getParameterList().getParameters();
        PsiExpressionList argumentList = this.myNewExpression.getArgumentList();
        LOG.assertTrue(argumentList != null);
        PsiExpression[] expressions2 = argumentList.getExpressions();
        return resolveHelper.inferTypeArguments(this.myPsiClass.getTypeParameters(), parameters2, expressions2, PsiSubstitutor.EMPTY, this.myNewExpression.getParent(), (ParameterTypeInferencePolicy)DefaultParameterTypeInferencePolicy.INSTANCE);
    }

    public static void registerIntentions(JavaResolveResult @NotNull [] candidates, @NotNull PsiExpressionList list, @Nullable HighlightInfo highlightInfo, PsiClass psiClass) {
        if (list == null) {
            ChangeTypeArgumentsFix.$$$reportNull$$$0(7);
        }
        if (candidates == null) {
            ChangeTypeArgumentsFix.$$$reportNull$$$0(8);
        }
        if (candidates.length == 0) {
            return;
        }
        PsiExpression[] expressions2 = list.getExpressions();
        for (JavaResolveResult candidate : candidates) {
            ChangeTypeArgumentsFix.registerIntention(expressions2, highlightInfo, psiClass, candidate, (PsiElement)list);
        }
    }

    private static void registerIntention(PsiExpression @NotNull [] expressions2, @Nullable HighlightInfo highlightInfo, PsiClass psiClass, @NotNull JavaResolveResult candidate, @NotNull PsiElement context) {
        if (candidate == null) {
            ChangeTypeArgumentsFix.$$$reportNull$$$0(9);
        }
        if (context == null) {
            ChangeTypeArgumentsFix.$$$reportNull$$$0(10);
        }
        if (expressions2 == null) {
            ChangeTypeArgumentsFix.$$$reportNull$$$0(11);
        }
        if (!candidate.isStaticsScopeCorrect()) {
            return;
        }
        PsiMethod method = (PsiMethod)candidate.getElement();
        if (method != null && BaseIntentionAction.canModify((PsiElement)method)) {
            ChangeTypeArgumentsFix fix = new ChangeTypeArgumentsFix(method, psiClass, expressions2, context);
            QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, null, (IntentionAction)fix);
        }
    }

    public boolean startInWriteAction() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetMethod";
                break;
            }
            case 1: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressions";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/ChangeTypeArgumentsFix";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidates";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/ChangeTypeArgumentsFix";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "registerIntentions";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "registerIntention";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

