/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixActionRegistrar;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightMethodUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightingFeature;
import com.intellij.codeInsight.daemon.impl.quickfix.AddTypeCastFix;
import com.intellij.codeInsight.daemon.impl.quickfix.BringVariableIntoScopeFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateClassFromNewFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateClassFromUsageFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateClassKind;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateInnerClassFromNewFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateInnerClassFromUsageFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateInnerRecordFromNewFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateLocalFromUsageFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateParameterFromUsageFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateRecordFromNewFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateServiceImplementationClassFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateServiceInterfaceOrClassFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateTypeParameterFromUsageFix;
import com.intellij.codeInsight.daemon.impl.quickfix.ImportClassFix;
import com.intellij.codeInsight.daemon.impl.quickfix.MoveClassToModuleFix;
import com.intellij.codeInsight.daemon.impl.quickfix.OrderEntryFix;
import com.intellij.codeInsight.daemon.impl.quickfix.QualifyStaticConstantFix;
import com.intellij.codeInsight.daemon.impl.quickfix.RenameWrongRefFix;
import com.intellij.codeInsight.daemon.impl.quickfix.StaticImportConstantFix;
import com.intellij.codeInsight.daemon.impl.quickfix.SurroundWithQuotesAnnotationParameterValueFix;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.impl.PriorityIntentionActionWrapper;
import com.intellij.codeInsight.quickfix.UnresolvedReferenceQuickFixProvider;
import com.intellij.lang.java.request.CreateFieldFromUsage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceCodeFragment;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultQuickFixProvider
extends UnresolvedReferenceQuickFixProvider<PsiJavaCodeReferenceElement> {
    public void registerFixes(@NotNull PsiJavaCodeReferenceElement ref, @NotNull QuickFixActionRegistrar registrar) {
        PsiFile containingFile;
        if (ref == null) {
            DefaultQuickFixProvider.$$$reportNull$$$0(0);
        }
        if (registrar == null) {
            DefaultQuickFixProvider.$$$reportNull$$$0(1);
        }
        if ((containingFile = ref.getContainingFile()) instanceof PsiJavaCodeReferenceCodeFragment && !((PsiJavaCodeReferenceCodeFragment)containingFile).isClassesAccepted()) {
            return;
        }
        if (PsiUtil.isModuleFile((PsiFile)containingFile)) {
            OrderEntryFix.registerFixes(registrar, (PsiReference)ref);
            registrar.register((IntentionAction)new CreateServiceImplementationClassFix(ref));
            registrar.register((IntentionAction)new CreateServiceInterfaceOrClassFix(ref));
            return;
        }
        registrar.register((IntentionAction)new ImportClassFix(ref));
        registrar.register((IntentionAction)new StaticImportConstantFix(containingFile, ref));
        registrar.register((IntentionAction)new QualifyStaticConstantFix(containingFile, ref));
        OrderEntryFix.registerFixes(registrar, (PsiReference)ref);
        MoveClassToModuleFix.registerFixes(registrar, ref);
        if (ref instanceof PsiReferenceExpression) {
            BringVariableIntoScopeFix bringToScope;
            TextRange fixRange = HighlightMethodUtil.getFixRange((PsiElement)ref);
            PsiReferenceExpression refExpr = (PsiReferenceExpression)ref;
            registrar.register(fixRange, (IntentionAction)new RenameWrongRefFix(refExpr), null);
            PsiExpression qualifier = ((PsiReferenceExpression)ref).getQualifierExpression();
            if (qualifier != null) {
                AddTypeCastFix.registerFix(registrar, qualifier, ref, fixRange);
            }
            if ((bringToScope = BringVariableIntoScopeFix.fromReference(refExpr)) != null) {
                registrar.register(fixRange, (IntentionAction)bringToScope, null);
            }
            for (IntentionAction action : DefaultQuickFixProvider.createVariableActions(refExpr)) {
                registrar.register(fixRange, action, null);
            }
        }
        registrar.register((IntentionAction)new CreateClassFromUsageFix(ref, CreateClassKind.INTERFACE));
        if (PsiUtil.isLanguageLevel5OrHigher((PsiElement)ref)) {
            registrar.register((IntentionAction)new CreateClassFromUsageFix(ref, CreateClassKind.ENUM));
            registrar.register((IntentionAction)new CreateClassFromUsageFix(ref, CreateClassKind.ANNOTATION));
            registrar.register((IntentionAction)new CreateTypeParameterFromUsageFix(ref));
        }
        if (HighlightingFeature.RECORDS.isAvailable((PsiElement)ref)) {
            registrar.register((IntentionAction)new CreateClassFromUsageFix(ref, CreateClassKind.RECORD));
        }
        PsiElement parent = PsiTreeUtil.getParentOfType((PsiElement)ref, (Class[])new Class[]{PsiNewExpression.class, PsiMethod.class});
        PsiExpressionList expressionList = (PsiExpressionList)PsiTreeUtil.getParentOfType((PsiElement)ref, PsiExpressionList.class);
        if (!(!(parent instanceof PsiNewExpression) || ref.getParent() instanceof PsiTypeElement || expressionList != null && PsiTreeUtil.isAncestor((PsiElement)parent, (PsiElement)expressionList, (boolean)false))) {
            registrar.register((IntentionAction)new CreateClassFromNewFix((PsiNewExpression)parent));
            registrar.register((IntentionAction)new CreateInnerClassFromNewFix((PsiNewExpression)parent));
            if (HighlightingFeature.RECORDS.isAvailable((PsiElement)ref)) {
                registrar.register((IntentionAction)new CreateRecordFromNewFix((PsiNewExpression)parent));
                if (((PsiNewExpression)parent).getQualifier() == null) {
                    registrar.register((IntentionAction)new CreateInnerRecordFromNewFix((PsiNewExpression)parent));
                }
            }
        } else {
            registrar.register((IntentionAction)new CreateClassFromUsageFix(ref, CreateClassKind.CLASS));
            registrar.register((IntentionAction)new CreateInnerClassFromUsageFix(ref, CreateClassKind.CLASS));
        }
        SurroundWithQuotesAnnotationParameterValueFix.register(registrar, ref);
    }

    @NotNull
    private static Collection<IntentionAction> createVariableActions(@NotNull PsiReferenceExpression refExpr) {
        if (refExpr == null) {
            DefaultQuickFixProvider.$$$reportNull$$$0(2);
        }
        ArrayList<IntentionAction> result = new ArrayList<IntentionAction>(CreateFieldFromUsage.generateActions(refExpr));
        if (!refExpr.isQualified()) {
            VariableKind kind2 = DefaultQuickFixProvider.getKind(refExpr);
            CreateLocalFromUsageFix createLocalFix = new CreateLocalFromUsageFix(refExpr);
            result.add((IntentionAction)(kind2 == VariableKind.LOCAL_VARIABLE ? PriorityIntentionActionWrapper.highPriority((IntentionAction)createLocalFix) : createLocalFix));
            CreateParameterFromUsageFix createParameterFix = new CreateParameterFromUsageFix(refExpr);
            result.add((IntentionAction)(kind2 == VariableKind.PARAMETER ? PriorityIntentionActionWrapper.highPriority((IntentionAction)createParameterFix) : createParameterFix));
        }
        ArrayList<IntentionAction> arrayList = result;
        if (arrayList == null) {
            DefaultQuickFixProvider.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @Nullable
    private static VariableKind getKind(@NotNull PsiReferenceExpression refExpr) {
        if (refExpr == null) {
            DefaultQuickFixProvider.$$$reportNull$$$0(4);
        }
        JavaCodeStyleManager styleManager = JavaCodeStyleManager.getInstance((Project)refExpr.getProject());
        String reference = refExpr.getText();
        if (StringUtil.isUpperCase((CharSequence)reference)) {
            return VariableKind.STATIC_FINAL_FIELD;
        }
        for (VariableKind kind2 : VariableKind.values()) {
            String prefix = styleManager.getPrefixByVariableKind(kind2);
            String suffix = styleManager.getSuffixByVariableKind(kind2);
            if (prefix.isEmpty() && suffix.isEmpty() || !reference.startsWith(prefix) || !reference.endsWith(suffix)) continue;
            return kind2;
        }
        if (StringUtil.isCapitalized((String)reference)) {
            return null;
        }
        return VariableKind.LOCAL_VARIABLE;
    }

    @NotNull
    public Class<PsiJavaCodeReferenceElement> getReferenceClass() {
        return PsiJavaCodeReferenceElement.class;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refExpr";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/DefaultQuickFixProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/DefaultQuickFixProvider";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createVariableActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "registerFixes";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createVariableActions";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getKind";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

