/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.problems;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.search.LowLevelSearchUtil;
import com.intellij.util.Processor;
import com.intellij.util.text.StringSearcher;
import gnu.trove.TIntProcedure;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B1\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\u001a\u0010\u0006\u001a\u0016\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\t0\u0007\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u0002H\u0002J\u0010\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u0002H\u0016R\u0019\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0016\u0010\u000f\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u0006\u001a\u0016\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\t0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/codeInsight/daemon/problems/MemberUsageCollector;", "Lcom/intellij/util/Processor;", "Lcom/intellij/psi/PsiFile;", "targetName", "", "targetFile", "usageExtractor", "Lkotlin/Function2;", "", "Lcom/intellij/psi/PsiElement;", "(Ljava/lang/String;Lcom/intellij/psi/PsiFile;Lkotlin/jvm/functions/Function2;)V", "collectedUsages", "", "getCollectedUsages", "()Ljava/util/List;", "fileIndexFacade", "Lcom/intellij/openapi/roots/FileIndexFacade;", "kotlin.jvm.PlatformType", "filesSize", "", "filesVisited", "maxFilesSizeToProcess", "maxFilesToProcess", "searcher", "Lcom/intellij/util/text/StringSearcher;", "tooManyUsages", "", "usages", "isCheapEnoughToProcess", "psiFile", "process", "intellij.java.impl"})
public class MemberUsageCollector
implements Processor<PsiFile> {
    private final int maxFilesToProcess;
    private final int maxFilesSizeToProcess;
    private int filesVisited;
    private long filesSize;
    private final FileIndexFacade fileIndexFacade;
    private final StringSearcher searcher;
    private final List<PsiElement> usages;
    private boolean tooManyUsages;
    private final PsiFile targetFile;
    private final Function2<PsiFile, Integer, PsiElement> usageExtractor;

    @Nullable
    public final List<PsiElement> getCollectedUsages() {
        return this.tooManyUsages ? null : this.usages;
    }

    public boolean process(@NotNull PsiFile psiFile) {
        Intrinsics.checkParameterIsNotNull((Object)psiFile, (String)"psiFile");
        if (Intrinsics.areEqual((Object)psiFile, (Object)this.targetFile) || !this.fileIndexFacade.isInSource(psiFile.getVirtualFile())) {
            return true;
        }
        if (!this.isCheapEnoughToProcess(psiFile)) {
            this.tooManyUsages = true;
            return false;
        }
        FileViewProvider fileViewProvider = psiFile.getViewProvider();
        Intrinsics.checkExpressionValueIsNotNull((Object)fileViewProvider, (String)"psiFile.viewProvider");
        CharSequence charSequence = fileViewProvider.getContents();
        Intrinsics.checkExpressionValueIsNotNull((Object)charSequence, (String)"psiFile.viewProvider.contents");
        CharSequence text2 = charSequence;
        TIntProcedure occurenceProcedure2 = new TIntProcedure(this, psiFile){
            final /* synthetic */ MemberUsageCollector this$0;
            final /* synthetic */ PsiFile $psiFile;

            public final boolean execute(int index) {
                PsiElement usage = (PsiElement)MemberUsageCollector.access$getUsageExtractor$p(this.this$0).invoke((Object)this.$psiFile, (Object)index);
                if (usage != null) {
                    MemberUsageCollector.access$getUsages$p(this.this$0).add(usage);
                }
                return true;
            }
            {
                this.this$0 = memberUsageCollector;
                this.$psiFile = psiFile;
            }
        };
        LowLevelSearchUtil.processTextOccurrences((CharSequence)text2, (int)0, (int)text2.length(), (StringSearcher)this.searcher, (TIntProcedure)occurenceProcedure2);
        return true;
    }

    private final boolean isCheapEnoughToProcess(PsiFile psiFile) {
        int n = this.filesVisited;
        this.filesVisited = n + 1;
        if (this.filesVisited >= this.maxFilesToProcess) {
            return false;
        }
        this.filesSize += (long)psiFile.getTextLength();
        return this.filesSize < (long)this.maxFilesSizeToProcess;
    }

    public MemberUsageCollector(@NotNull String targetName, @NotNull PsiFile targetFile, @NotNull Function2<? super PsiFile, ? super Integer, ? extends PsiElement> usageExtractor2) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)targetName, (String)"targetName");
        Intrinsics.checkParameterIsNotNull((Object)targetFile, (String)"targetFile");
        Intrinsics.checkParameterIsNotNull(usageExtractor2, (String)"usageExtractor");
        this.targetFile = targetFile;
        this.usageExtractor = usageExtractor2;
        this.maxFilesToProcess = Registry.intValue((String)"ide.unused.symbol.calculation.maxFilesToSearchUsagesIn", (int)10);
        this.maxFilesSizeToProcess = Registry.intValue((String)"ide.unused.symbol.calculation.maxFilesSizeToSearchUsagesIn", (int)524288);
        this.fileIndexFacade = FileIndexFacade.getInstance((Project)this.targetFile.getProject());
        this.searcher = new StringSearcher(targetName, true, true, false);
        MemberUsageCollector memberUsageCollector = this;
        boolean bl = false;
        memberUsageCollector.usages = list = (List)new ArrayList();
    }

    public static final /* synthetic */ Function2 access$getUsageExtractor$p(MemberUsageCollector $this) {
        return $this.usageExtractor;
    }

    public static final /* synthetic */ List access$getUsages$p(MemberUsageCollector $this) {
        return $this.usages;
    }
}

