/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.problems.pass;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.JavaLensProvider;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.daemon.problems.Problem;
import com.intellij.codeInsight.daemon.problems.pass.BrokenUsage;
import com.intellij.codeInsight.daemon.problems.pass.RelatedProblemTargetAdapter;
import com.intellij.codeInsight.hints.BlockConstrainedPresentation;
import com.intellij.codeInsight.hints.BlockConstraints;
import com.intellij.codeInsight.hints.BlockInlayRenderer;
import com.intellij.codeInsight.hints.presentation.AttributesTransformerPresentation;
import com.intellij.codeInsight.hints.presentation.InlayPresentation;
import com.intellij.codeInsight.hints.presentation.MouseButton;
import com.intellij.codeInsight.hints.presentation.PresentationFactory;
import com.intellij.codeInsight.hints.presentation.PresentationListener;
import com.intellij.codeInsight.hints.presentation.RecursivelyUpdatingRootPresentation;
import com.intellij.codeInsight.hints.presentation.RootInlayPresentation;
import com.intellij.codeInsight.intention.BaseElementAtCaretIntentionAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.SmartHashMap;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.internal.statistic.service.fus.collectors.FUCounterUsageLogger;
import com.intellij.java.JavaBundle;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.InlayModel;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import kotlin.Unit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectProblemPassUtils {
    private static final Key<Map<SmartPsiElementPointer<PsiMember>, EditorInfo>> EDITOR_INFOS_KEY = Key.create((String)"ProjectProblemEditorInfoKey");
    private static final Key<Long> PREV_MODIFICATION_COUNT = Key.create((String)"ProjectProblemModificationCount");
    private static final String RELATED_PROBLEMS_CLICKED_EVENT_ID = "related.problems.clicked";

    @NotNull
    static InlayPresentation getPresentation(@NotNull Project project, @NotNull Editor editor, @NotNull Document document, @NotNull PresentationFactory factory, int offset, @NotNull PsiMember member, @NotNull Set<Problem> relatedProblems) {
        if (project == null) {
            ProjectProblemPassUtils.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            ProjectProblemPassUtils.$$$reportNull$$$0(1);
        }
        if (document == null) {
            ProjectProblemPassUtils.$$$reportNull$$$0(2);
        }
        if (factory == null) {
            ProjectProblemPassUtils.$$$reportNull$$$0(3);
        }
        if (member == null) {
            ProjectProblemPassUtils.$$$reportNull$$$0(4);
        }
        if (relatedProblems == null) {
            ProjectProblemPassUtils.$$$reportNull$$$0(5);
        }
        int column = offset - document.getLineStartOffset(document.getLineNumber(offset));
        InlayPresentation problemsOffset = factory.textSpacePlaceholder(column, true);
        InlayPresentation textPresentation = factory.smallText(JavaBundle.message((String)"project.problems.hint.text", (Object[])new Object[]{relatedProblems.size()}));
        AttributesTransformerPresentation errorTextPresentation = new AttributesTransformerPresentation(textPresentation, __ -> editor.getColorsScheme().getAttributes(CodeInsightColors.WRONG_REFERENCES_ATTRIBUTES));
        InlayPresentation problemsPresentation = factory.referenceOnHover((InlayPresentation)errorTextPresentation, (e, p) -> ProjectProblemPassUtils.showProblems(member, relatedProblems));
        JPopupMenu popupMenu = new JPopupMenu();
        JMenuItem item = new JMenuItem(JavaBundle.message((String)"project.problems.settings", (Object[])new Object[0]));
        item.addActionListener(e -> JavaLensProvider.openSettings((Language)JavaLanguage.INSTANCE, project));
        popupMenu.add(item);
        InlayPresentation withSettings = factory.onClick(problemsPresentation, MouseButton.Right, (e, __) -> {
            popupMenu.show(e.getComponent(), e.getX(), e.getY());
            return Unit.INSTANCE;
        });
        InlayPresentation inlayPresentation = factory.seq(new InlayPresentation[]{problemsOffset, withSettings});
        if (inlayPresentation == null) {
            ProjectProblemPassUtils.$$$reportNull$$$0(6);
        }
        return inlayPresentation;
    }

    private static void showProblems(@NotNull PsiMember member, @NotNull Set<Problem> relatedProblems) {
        if (member == null) {
            ProjectProblemPassUtils.$$$reportNull$$$0(7);
        }
        if (relatedProblems == null) {
            ProjectProblemPassUtils.$$$reportNull$$$0(8);
        }
        FUCounterUsageLogger.getInstance().logEvent(member.getProject(), "java.lens", RELATED_PROBLEMS_CLICKED_EVENT_ID);
        Project project = member.getProject();
        if (relatedProblems.size() == 1) {
            Problem problem = relatedProblems.iterator().next();
            PsiElement reportedElement = problem.getReportedElement();
            VirtualFile fileWithProblem = reportedElement.getContainingFile().getVirtualFile();
            TextRange elementRange = reportedElement.getTextRange();
            int offset = elementRange != null ? elementRange.getStartOffset() : -1;
            PsiNavigationSupport.getInstance().createNavigatable(project, fileWithProblem, offset).navigate(true);
        } else {
            String memberName = UsageViewUtil.getLongName((PsiElement)member);
            UsageViewPresentation presentation = new UsageViewPresentation();
            String title = JavaBundle.message((String)"project.problems.window.title", (Object[])new Object[]{memberName});
            presentation.setCodeUsagesString(JavaBundle.message((String)"project.problems.title", (Object[])new Object[0]));
            presentation.setTabName(title);
            presentation.setTabText(title);
            Usage[] usages = (Usage[])ContainerUtil.map2Array(relatedProblems, (Object[])new Usage[relatedProblems.size()], e -> {
                PsiElement reportedElement = e.getReportedElement();
                UsageInfo usageInfo = new UsageInfo(e.getContext());
                return new BrokenUsage(usageInfo, reportedElement);
            });
            UsageTarget[] usageTargets = new UsageTarget[]{new RelatedProblemTargetAdapter((PsiElement)member)};
            UsageViewManager usageViewManager = UsageViewManager.getInstance((Project)project);
            usageViewManager.showUsages(usageTargets, usages, presentation);
        }
    }

    @NotNull
    static BlockInlayRenderer createBlockRenderer(@NotNull InlayPresentation presentation) {
        if (presentation == null) {
            ProjectProblemPassUtils.$$$reportNull$$$0(9);
        }
        BlockConstraints constraints = new BlockConstraints(true, 100);
        RecursivelyUpdatingRootPresentation rootPresentation = new RecursivelyUpdatingRootPresentation(presentation);
        BlockConstrainedPresentation constrainedPresentation = new BlockConstrainedPresentation((RootInlayPresentation)rootPresentation, constraints);
        return new BlockInlayRenderer(Collections.singletonList(constrainedPresentation));
    }

    static void addListener(@NotNull BlockInlayRenderer renderer, final @NotNull Inlay<?> inlay) {
        if (renderer == null) {
            ProjectProblemPassUtils.$$$reportNull$$$0(10);
        }
        if (inlay == null) {
            ProjectProblemPassUtils.$$$reportNull$$$0(11);
        }
        renderer.setListener(new PresentationListener(){

            public void sizeChanged(@NotNull Dimension previous, @NotNull Dimension current) {
                if (previous == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (current == null) {
                    1.$$$reportNull$$$0(1);
                }
                inlay.repaint();
            }

            public void contentChanged(@NotNull Rectangle area) {
                if (area == null) {
                    1.$$$reportNull$$$0(2);
                }
                inlay.repaint();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "previous";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "current";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "area";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/codeInsight/daemon/problems/pass/ProjectProblemPassUtils$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "sizeChanged";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "contentChanged";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @NotNull
    static HighlightInfo createHighlightInfo(@NotNull Editor editor, @NotNull PsiMember member, @NotNull PsiElement identifier, @NotNull Set<Problem> relatedProblems) {
        if (editor == null) {
            ProjectProblemPassUtils.$$$reportNull$$$0(12);
        }
        if (member == null) {
            ProjectProblemPassUtils.$$$reportNull$$$0(13);
        }
        if (identifier == null) {
            ProjectProblemPassUtils.$$$reportNull$$$0(14);
        }
        if (relatedProblems == null) {
            ProjectProblemPassUtils.$$$reportNull$$$0(15);
        }
        ShowRelatedProblemsAction relatedProblemsAction = new ShowRelatedProblemsAction(relatedProblems);
        return ProjectProblemPassUtils.createHighlightInfo(editor, member, identifier, (IntentionAction)relatedProblemsAction);
    }

    @NotNull
    private static HighlightInfo createHighlightInfo(@NotNull Editor editor, @NotNull PsiMember member, @NotNull PsiElement identifier, @NotNull IntentionAction action) {
        if (editor == null) {
            ProjectProblemPassUtils.$$$reportNull$$$0(16);
        }
        if (member == null) {
            ProjectProblemPassUtils.$$$reportNull$$$0(17);
        }
        if (identifier == null) {
            ProjectProblemPassUtils.$$$reportNull$$$0(18);
        }
        if (action == null) {
            ProjectProblemPassUtils.$$$reportNull$$$0(19);
        }
        Color textColor = editor.getColorsScheme().getAttributes(CodeInsightColors.WEAK_WARNING_ATTRIBUTES).getEffectColor();
        TextAttributes attributes = new TextAttributes(null, null, textColor, null, 0);
        String memberName = UsageViewUtil.getLongName((PsiElement)member);
        HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.WARNING).range(identifier.getTextRange()).textAttributes(attributes).descriptionAndTooltip(JavaBundle.message((String)"project.problems.fix.description", (Object[])new Object[]{memberName})).createUnconditionally();
        QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)action);
        HighlightInfo highlightInfo = info;
        if (highlightInfo == null) {
            ProjectProblemPassUtils.$$$reportNull$$$0(20);
        }
        return highlightInfo;
    }

    static int getMemberOffset(@NotNull PsiMember psiMember) {
        if (psiMember == null) {
            ProjectProblemPassUtils.$$$reportNull$$$0(21);
        }
        return Arrays.stream(psiMember.getChildren()).filter(c -> !(c instanceof PsiDocComment) && !(c instanceof PsiWhiteSpace)).findFirst().orElse((PsiElement)psiMember).getTextRange().getStartOffset();
    }

    static boolean hasOtherElementsOnSameLine(@NotNull PsiMember psiMember) {
        if (psiMember == null) {
            ProjectProblemPassUtils.$$$reportNull$$$0(22);
        }
        for (PsiElement prevSibling = psiMember.getPrevSibling(); !(prevSibling == null || prevSibling instanceof PsiWhiteSpace && prevSibling.textContains('\n')); prevSibling = prevSibling.getPrevSibling()) {
            if (prevSibling instanceof PsiWhiteSpace || prevSibling.getText().isEmpty()) continue;
            return true;
        }
        return false;
    }

    static boolean hintsEnabled() {
        return JavaLensProvider.getSettings().isShowRelatedProblems();
    }

    @NotNull
    public static Map<PsiMember, Inlay<?>> getInlays(@NotNull Editor editor) {
        if (editor == null) {
            ProjectProblemPassUtils.$$$reportNull$$$0(23);
        }
        Map map2 = ContainerUtil.map2Map(ProjectProblemPassUtils.getEditorInfos(editor).entrySet(), e -> Pair.create((Object)((PsiMember)e.getKey()), ((EditorInfo)e.getValue()).myInlay));
        if (map2 == null) {
            ProjectProblemPassUtils.$$$reportNull$$$0(24);
        }
        return map2;
    }

    @NotNull
    static Map<PsiMember, EditorInfo> getEditorInfos(@NotNull Editor editor) {
        if (editor == null) {
            ProjectProblemPassUtils.$$$reportNull$$$0(25);
        }
        Map oldInfos = (Map)editor.getUserData(EDITOR_INFOS_KEY);
        SmartHashMap editorInfos = new SmartHashMap();
        if (oldInfos == null) {
            SmartHashMap smartHashMap = editorInfos;
            if (smartHashMap == null) {
                ProjectProblemPassUtils.$$$reportNull$$$0(26);
            }
            return smartHashMap;
        }
        InlayModel inlayModel = editor.getInlayModel();
        oldInfos.forEach((arg_0, arg_1) -> ProjectProblemPassUtils.lambda$getEditorInfos$7(inlayModel, editor, (Map)editorInfos, arg_0, arg_1));
        SmartHashMap smartHashMap = editorInfos;
        if (smartHashMap == null) {
            ProjectProblemPassUtils.$$$reportNull$$$0(27);
        }
        return smartHashMap;
    }

    @Nullable
    private static IntentionAction getRegisteredAction(@NotNull HighlightInfo highlightInfo) {
        List actionRanges;
        if (highlightInfo == null) {
            ProjectProblemPassUtils.$$$reportNull$$$0(28);
        }
        if ((actionRanges = highlightInfo.quickFixActionRanges) == null || actionRanges.size() != 1) {
            return null;
        }
        return ((HighlightInfo.IntentionActionDescriptor)((Pair)actionRanges.get((int)0)).first).getAction();
    }

    static void updateInfos(@NotNull Editor editor, @NotNull Map<PsiMember, EditorInfo> infos) {
        if (editor == null) {
            ProjectProblemPassUtils.$$$reportNull$$$0(29);
        }
        if (infos == null) {
            ProjectProblemPassUtils.$$$reportNull$$$0(30);
        }
        Map newInfos = ContainerUtil.map2Map(infos.entrySet(), e -> Pair.create((Object)SmartPointerManager.createPointer((PsiElement)((PsiMember)e.getKey())), (Object)((EditorInfo)e.getValue())));
        editor.putUserData(EDITOR_INFOS_KEY, (Object)newInfos);
    }

    static void removeInfos(@NotNull Editor editor) {
        Map infos;
        if (editor == null) {
            ProjectProblemPassUtils.$$$reportNull$$$0(31);
        }
        if ((infos = (Map)editor.getUserData(EDITOR_INFOS_KEY)) == null) {
            return;
        }
        infos.values().forEach(info -> Disposer.dispose(info.myInlay));
        editor.putUserData(EDITOR_INFOS_KEY, null);
    }

    static boolean isDocumentUpdated(@NotNull Editor editor) {
        if (editor == null) {
            ProjectProblemPassUtils.$$$reportNull$$$0(32);
        }
        Document document = editor.getDocument();
        long stamp = document.getModificationStamp();
        Long prevStamp = (Long)document.getUserData(PREV_MODIFICATION_COUNT);
        return prevStamp == null || prevStamp != stamp;
    }

    static void updateTimestamp(@NotNull Editor editor) {
        if (editor == null) {
            ProjectProblemPassUtils.$$$reportNull$$$0(33);
        }
        Document document = editor.getDocument();
        long timestamp = document.getModificationStamp();
        document.putUserData(PREV_MODIFICATION_COUNT, (Object)timestamp);
    }

    @Nullable
    static PsiElement getIdentifier(@NotNull PsiMember psiMember) {
        PsiNameIdentifierOwner identifierOwner;
        if (psiMember == null) {
            ProjectProblemPassUtils.$$$reportNull$$$0(34);
        }
        if ((identifierOwner = (PsiNameIdentifierOwner)ObjectUtils.tryCast((Object)psiMember, PsiNameIdentifierOwner.class)) == null) {
            return null;
        }
        return identifierOwner.getNameIdentifier();
    }

    private static /* synthetic */ void lambda$getEditorInfos$7(InlayModel inlayModel, Editor editor, Map editorInfos, SmartPsiElementPointer pointer, EditorInfo info) {
        PsiMember member = (PsiMember)pointer.getElement();
        Inlay<?> inlay = info.myInlay;
        if (member == null) {
            Disposer.dispose(inlay);
        } else {
            PsiElement identifier;
            int memberOffset;
            int curOffset = inlay.getOffset();
            if (curOffset != (memberOffset = ProjectProblemPassUtils.getMemberOffset(member))) {
                EditorCustomElementRenderer renderer = inlay.getRenderer();
                info.myInlay = inlayModel.addBlockElement(memberOffset, true, true, 100, renderer);
                Disposer.dispose(inlay);
            }
            if ((identifier = ProjectProblemPassUtils.getIdentifier(member)) != null) {
                IntentionAction action;
                HighlightInfo oldHighlightInfo = info.myHighlightInfo;
                if (!identifier.getTextRange().equalsToRange(oldHighlightInfo.getActualStartOffset(), oldHighlightInfo.getActualEndOffset()) && (action = ProjectProblemPassUtils.getRegisteredAction(oldHighlightInfo)) != null) {
                    HighlightInfo newHighlightInfo = ProjectProblemPassUtils.createHighlightInfo(editor, member, identifier, action);
                    UpdateHighlightersUtil.setHighlightersToEditor((Project)member.getProject(), (Document)editor.getDocument(), (int)0, (int)member.getContainingFile().getTextLength(), Collections.singletonList(newHighlightInfo), (EditorColorsScheme)editor.getColorsScheme(), (int)-1);
                    info.myHighlightInfo = newHighlightInfo;
                }
            }
            editorInfos.put(member, info);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 20: 
            case 24: 
            case 26: 
            case 27: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 20: 
            case 24: 
            case 26: 
            case 27: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 12: 
            case 16: 
            case 23: 
            case 25: 
            case 29: 
            case 31: 
            case 32: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 4: 
            case 7: 
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 5: 
            case 8: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relatedProblems";
                break;
            }
            case 6: 
            case 20: 
            case 24: 
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/problems/pass/ProjectProblemPassUtils";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inlay";
                break;
            }
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 21: 
            case 22: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMember";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightInfo";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infos";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/problems/pass/ProjectProblemPassUtils";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentation";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "createHighlightInfo";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getInlays";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditorInfos";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPresentation";
                break;
            }
            case 6: 
            case 20: 
            case 24: 
            case 26: 
            case 27: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "showProblems";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createBlockRenderer";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createHighlightInfo";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getMemberOffset";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "hasOtherElementsOnSameLine";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getInlays";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getEditorInfos";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getRegisteredAction";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "updateInfos";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "removeInfos";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "isDocumentUpdated";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "updateTimestamp";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getIdentifier";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 20: 
            case 24: 
            case 26: 
            case 27: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ShowRelatedProblemsAction
    extends BaseElementAtCaretIntentionAction {
        private final Set<Problem> myRelatedProblems;

        private ShowRelatedProblemsAction(Set<Problem> relatedProblems) {
            this.myRelatedProblems = relatedProblems;
        }

        public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
            if (project == null) {
                ShowRelatedProblemsAction.$$$reportNull$$$0(0);
            }
            if (element == null) {
                ShowRelatedProblemsAction.$$$reportNull$$$0(1);
            }
            return ProjectProblemPassUtils.hintsEnabled();
        }

        public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
            PsiMember member;
            if (project == null) {
                ShowRelatedProblemsAction.$$$reportNull$$$0(2);
            }
            if (element == null) {
                ShowRelatedProblemsAction.$$$reportNull$$$0(3);
            }
            if ((member = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMember.class)) == null) {
                return;
            }
            ProjectProblemPassUtils.showProblems(member, this.myRelatedProblems);
        }

        @NotNull
        public String getText() {
            String string = this.getFamilyName();
            if (string == null) {
                ShowRelatedProblemsAction.$$$reportNull$$$0(4);
            }
            return string;
        }

        public boolean startInWriteAction() {
            return false;
        }

        @NotNull
        public String getFamilyName() {
            String string = JavaBundle.message((String)"project.problems.fix.text", (Object[])new Object[0]);
            if (string == null) {
                ShowRelatedProblemsAction.$$$reportNull$$$0(5);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/daemon/problems/pass/ProjectProblemPassUtils$ShowRelatedProblemsAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/daemon/problems/pass/ProjectProblemPassUtils$ShowRelatedProblemsAction";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "isAvailable";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class EditorInfo {
        Inlay<?> myInlay;
        HighlightInfo myHighlightInfo;

        EditorInfo(@NotNull Inlay<?> inlay, @NotNull HighlightInfo info) {
            if (inlay == null) {
                EditorInfo.$$$reportNull$$$0(0);
            }
            if (info == null) {
                EditorInfo.$$$reportNull$$$0(1);
            }
            this.myInlay = inlay;
            this.myHighlightInfo = info;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EditorInfo info = (EditorInfo)o;
            return this.myInlay.equals(info.myInlay) && this.myHighlightInfo.equals((Object)info.myHighlightInfo);
        }

        public int hashCode() {
            return Objects.hash(this.myInlay, this.myHighlightInfo);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "inlay";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "info";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInsight/daemon/problems/pass/ProjectProblemPassUtils$EditorInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

