/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.daemon.impl.analysis.HighlightingFeature;
import com.intellij.codeInsight.editorActions.JavaLikeQuoteHandler;
import com.intellij.codeInsight.editorActions.MultiCharQuoteHandler;
import com.intellij.codeInsight.editorActions.SimpleTokenSetQuoteHandler;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.StringEscapesTokenTypes;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaQuoteHandler
extends SimpleTokenSetQuoteHandler
implements JavaLikeQuoteHandler,
MultiCharQuoteHandler {
    private final TokenSet myConcatenableStrings = TokenSet.create((IElementType[])new IElementType[]{JavaTokenType.STRING_LITERAL});
    private final TokenSet myAppropriateElementTypeForLiteral = TokenSet.orSet((TokenSet[])new TokenSet[]{ElementType.JAVA_COMMENT_OR_WHITESPACE_BIT_SET, ElementType.TEXT_LITERALS, TokenSet.create((IElementType[])new IElementType[]{JavaTokenType.SEMICOLON, JavaTokenType.COMMA, JavaTokenType.RPARENTH, JavaTokenType.RBRACKET, JavaTokenType.RBRACE})});

    public JavaQuoteHandler() {
        super(ElementType.TEXT_LITERALS);
    }

    public boolean isOpeningQuote(HighlighterIterator iterator, int offset) {
        boolean openingQuote = super.isOpeningQuote(iterator, offset);
        if (openingQuote && !iterator.atEnd()) {
            iterator.retreat();
            if (!iterator.atEnd() && StringEscapesTokenTypes.STRING_LITERAL_ESCAPES.contains(iterator.getTokenType())) {
                openingQuote = false;
            }
            iterator.advance();
        }
        return openingQuote;
    }

    public boolean isClosingQuote(HighlighterIterator iterator, int offset) {
        if (iterator.getTokenType() == JavaTokenType.TEXT_BLOCK_LITERAL) {
            int start = iterator.getStart();
            int end = iterator.getEnd();
            return end - start >= 5 && offset >= end - 3;
        }
        boolean closingQuote = super.isClosingQuote(iterator, offset);
        if (closingQuote && !iterator.atEnd()) {
            iterator.advance();
            if (!iterator.atEnd() && StringEscapesTokenTypes.STRING_LITERAL_ESCAPES.contains(iterator.getTokenType())) {
                closingQuote = false;
            }
            iterator.retreat();
        }
        return closingQuote;
    }

    @NotNull
    public TokenSet getConcatenatableStringTokenTypes() {
        TokenSet tokenSet = this.myConcatenableStrings;
        if (tokenSet == null) {
            JavaQuoteHandler.$$$reportNull$$$0(0);
        }
        return tokenSet;
    }

    public String getStringConcatenationOperatorRepresentation() {
        return "+";
    }

    public TokenSet getStringTokenTypes() {
        return this.myLiteralTokenSet;
    }

    public boolean isAppropriateElementTypeForLiteral(@NotNull IElementType tokenType) {
        if (tokenType == null) {
            JavaQuoteHandler.$$$reportNull$$$0(1);
        }
        return this.myAppropriateElementTypeForLiteral.contains(tokenType);
    }

    public boolean needParenthesesAroundConcatenation(PsiElement element) {
        return element.getParent() instanceof PsiLiteralExpression && element.getParent().getParent() instanceof PsiReferenceExpression;
    }

    @Nullable
    public CharSequence getClosingQuote(@NotNull HighlighterIterator iterator, int offset) {
        if (iterator == null) {
            JavaQuoteHandler.$$$reportNull$$$0(2);
        }
        return iterator.getTokenType() == JavaTokenType.TEXT_BLOCK_LITERAL && offset == iterator.getStart() + 3 ? "\"\"\"" : null;
    }

    public boolean hasNonClosedLiteral(Editor editor, HighlighterIterator iterator, int offset) {
        if (iterator.getTokenType() == JavaTokenType.TEXT_BLOCK_LITERAL) {
            PsiFile file;
            Document document = editor.getDocument();
            Project project = editor.getProject();
            PsiFile psiFile = file = project == null ? null : PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
            if (file == null || !HighlightingFeature.TEXT_BLOCKS.isAvailable((PsiElement)file)) {
                return false;
            }
            String text2 = document.getText();
            boolean hasOpenQuotes = StringUtil.equals((CharSequence)text2.substring(iterator.getStart(), offset + 1), (CharSequence)"\"\"\"");
            if (hasOpenQuotes) {
                boolean hasCloseQuotes = StringUtil.contains((CharSequence)text2.substring(offset + 1, iterator.getEnd()), (CharSequence)"\"\"\"");
                if (!hasCloseQuotes) {
                    return true;
                }
                int nTextBlockQuotes = StringUtil.getOccurrenceCount((String)text2.substring(iterator.getEnd()), (String)"\"\"\"");
                return nTextBlockQuotes % 2 != 0;
            }
        }
        return super.hasNonClosedLiteral(editor, iterator, offset);
    }

    public void insertClosingQuote(@NotNull Editor editor, int offset, @NotNull PsiFile file, @NotNull CharSequence closingQuote) {
        if (editor == null) {
            JavaQuoteHandler.$$$reportNull$$$0(3);
        }
        if (file == null) {
            JavaQuoteHandler.$$$reportNull$$$0(4);
        }
        if (closingQuote == null) {
            JavaQuoteHandler.$$$reportNull$$$0(5);
        }
        editor.getDocument().insertString(offset, (CharSequence)"\n\"\"\"");
        Project project = file.getProject();
        PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
        PsiJavaToken token = (PsiJavaToken)ObjectUtils.tryCast((Object)file.findElementAt(offset), PsiJavaToken.class);
        if (token == null) {
            return;
        }
        PsiLiteralExpression textBlock = (PsiLiteralExpression)ObjectUtils.tryCast((Object)token.getParent(), PsiLiteralExpression.class);
        if (textBlock == null) {
            return;
        }
        CodeStyleManager.getInstance((Project)project).reformat((PsiElement)textBlock);
        editor.getCaretModel().moveToOffset(textBlock.getTextRange().getEndOffset() - 3);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/editorActions/JavaQuoteHandler";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterator";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "closingQuote";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getConcatenatableStringTokenTypes";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/editorActions/JavaQuoteHandler";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isAppropriateElementTypeForLiteral";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getClosingQuote";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "insertClosingQuote";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

