/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.wordSelection;

import com.intellij.codeInsight.editorActions.SelectWordUtil;
import com.intellij.codeInsight.editorActions.wordSelection.BasicSelectioner;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.StringLiteralLexer;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiLiteralUtil;
import com.intellij.util.ObjectUtils;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class LiteralSelectioner
extends BasicSelectioner {
    @Override
    public boolean canSelect(@NotNull PsiElement e) {
        if (e == null) {
            LiteralSelectioner.$$$reportNull$$$0(0);
        }
        PsiElement parent = e.getParent();
        return LiteralSelectioner.isStringLiteral(e) || LiteralSelectioner.isStringLiteral(parent);
    }

    private static boolean isStringLiteral(PsiElement element) {
        PsiType type2 = element instanceof PsiLiteralExpression ? ((PsiLiteralExpression)element).getType() : null;
        return type2 != null && type2.equalsToText("java.lang.String") && element.getText().startsWith("\"") && element.getText().endsWith("\"");
    }

    public List<TextRange> select(@NotNull PsiElement e, @NotNull CharSequence editorText, int cursorOffset, @NotNull Editor editor) {
        if (e == null) {
            LiteralSelectioner.$$$reportNull$$$0(1);
        }
        if (editorText == null) {
            LiteralSelectioner.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            LiteralSelectioner.$$$reportNull$$$0(3);
        }
        List result = super.select(e, editorText, cursorOffset, editor);
        TextRange range = e.getTextRange();
        SelectWordUtil.addWordHonoringEscapeSequences((CharSequence)editorText, (TextRange)range, (int)cursorOffset, (Lexer)new StringLiteralLexer('\"', JavaTokenType.STRING_LITERAL), (List)result);
        PsiLiteralExpression literalExpression = (PsiLiteralExpression)ObjectUtils.tryCast((Object)e, PsiLiteralExpression.class);
        if (literalExpression == null) {
            literalExpression = (PsiLiteralExpression)ObjectUtils.tryCast((Object)e.getParent(), PsiLiteralExpression.class);
        }
        if (literalExpression != null && literalExpression.isTextBlock()) {
            char c;
            int end;
            int contentStart = StringUtil.indexOf((CharSequence)editorText, (char)'\n', (int)range.getStartOffset());
            if (contentStart == -1) {
                return result;
            }
            ++contentStart;
            int indent = PsiLiteralUtil.getTextBlockIndent((PsiLiteralExpression)literalExpression);
            if (indent == -1) {
                return result;
            }
            for (int i = 0; i < indent; ++i) {
                if (editorText.charAt(contentStart + i) != '\n') continue;
                return result;
            }
            int start = contentStart + indent;
            for (end = range.getEndOffset() - 4; end >= start && (c = editorText.charAt(end)) != '\n'; --end) {
                if (Character.isWhitespace(c)) continue;
                ++end;
                break;
            }
            if (start < end) {
                result.add(new TextRange(start, end));
            }
        } else {
            result.add(new TextRange(range.getStartOffset() + 1, range.getEndOffset() - 1));
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorText";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/editorActions/wordSelection/LiteralSelectioner";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "canSelect";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "select";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

