/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.guess.impl;

import com.intellij.codeInsight.guess.GuessManager;
import com.intellij.codeInsight.guess.impl.AssignmentFilteringMemoryState;
import com.intellij.codeInsight.guess.impl.ExpressionVariableDescriptor;
import com.intellij.codeInsight.guess.impl.MethodPattern;
import com.intellij.codeInsight.guess.impl.MethodPatternMap;
import com.intellij.codeInspection.dataFlow.ControlFlowAnalyzer;
import com.intellij.codeInspection.dataFlow.DataFlowRunner;
import com.intellij.codeInspection.dataFlow.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.DfaMemoryStateImpl;
import com.intellij.codeInspection.dataFlow.DfaPsiUtil;
import com.intellij.codeInspection.dataFlow.RunnerResult;
import com.intellij.codeInspection.dataFlow.StandardInstructionVisitor;
import com.intellij.codeInspection.dataFlow.TypeConstraint;
import com.intellij.codeInspection.dataFlow.TypeConstraints;
import com.intellij.codeInspection.dataFlow.instructions.InstanceofInstruction;
import com.intellij.codeInspection.dataFlow.instructions.TypeCastInstruction;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.PsiElementProcessorAdapter;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.BitUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.ExpressionUtils;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GuessManagerImpl
extends GuessManager {
    private final MethodPatternMap myMethodPatternMap = new MethodPatternMap();
    private final Project myProject;
    private static final int CHECK_USAGE = 1;
    private static final int CHECK_UP = 2;
    private static final int CHECK_DOWN = 4;

    private void initMethodPatterns() {
        this.myMethodPatternMap.addPattern(new MethodPattern("add", 1, 0));
        this.myMethodPatternMap.addPattern(new MethodPattern("contains", 1, 0));
        this.myMethodPatternMap.addPattern(new MethodPattern("remove", 1, 0));
        this.myMethodPatternMap.addPattern(new MethodPattern("add", 2, 1));
        this.myMethodPatternMap.addPattern(new MethodPattern("addElement", 1, 0));
        this.myMethodPatternMap.addPattern(new MethodPattern("elementAt", 1, -1));
        this.myMethodPatternMap.addPattern(new MethodPattern("firstElement", 0, -1));
        this.myMethodPatternMap.addPattern(new MethodPattern("lastElement", 0, -1));
        this.myMethodPatternMap.addPattern(new MethodPattern("get", 1, -1));
        this.myMethodPatternMap.addPattern(new MethodPattern("indexOf", 1, 0));
        this.myMethodPatternMap.addPattern(new MethodPattern("indexOf", 2, 0));
        this.myMethodPatternMap.addPattern(new MethodPattern("lastIndexOf", 1, 0));
        this.myMethodPatternMap.addPattern(new MethodPattern("lastIndexOf", 2, 0));
        this.myMethodPatternMap.addPattern(new MethodPattern("insertElementAt", 2, 0));
        this.myMethodPatternMap.addPattern(new MethodPattern("removeElement", 1, 0));
        this.myMethodPatternMap.addPattern(new MethodPattern("set", 2, 1));
        this.myMethodPatternMap.addPattern(new MethodPattern("setElementAt", 2, 0));
    }

    public GuessManagerImpl(Project project) {
        this.initMethodPatterns();
        this.myProject = project;
    }

    @Override
    public PsiType @NotNull [] guessContainerElementType(PsiExpression containerExpr, TextRange rangeToIgnore) {
        PsiElement refElement;
        HashSet typesSet = new HashSet();
        PsiType type2 = containerExpr.getType();
        PsiType elemType = GuessManagerImpl.getGenericElementType(type2);
        if (elemType != null) {
            PsiType[] psiTypeArray = new PsiType[]{elemType};
            if (psiTypeArray == null) {
                GuessManagerImpl.$$$reportNull$$$0(0);
            }
            return psiTypeArray;
        }
        if (containerExpr instanceof PsiReferenceExpression && (refElement = ((PsiReferenceExpression)containerExpr).resolve()) instanceof PsiVariable) {
            PsiFile file = refElement.getContainingFile();
            if (file == null) {
                file = containerExpr.getContainingFile();
            }
            HashSet checkedVariables = new HashSet();
            this.addTypesByVariable(typesSet, (PsiVariable)refElement, file, checkedVariables, 5, rangeToIgnore);
            checkedVariables.clear();
            this.addTypesByVariable(typesSet, (PsiVariable)refElement, file, checkedVariables, 2, rangeToIgnore);
        }
        PsiType[] psiTypeArray = typesSet.toArray(PsiType.createArray((int)typesSet.size()));
        if (psiTypeArray == null) {
            GuessManagerImpl.$$$reportNull$$$0(1);
        }
        return psiTypeArray;
    }

    @Nullable
    private static PsiType getGenericElementType(PsiType collectionType) {
        PsiClassType classType;
        PsiType[] parameters2;
        if (collectionType instanceof PsiClassType && (parameters2 = (classType = (PsiClassType)collectionType).getParameters()).length == 1) {
            return parameters2[0];
        }
        return null;
    }

    @Override
    public PsiType @NotNull [] guessTypeToCast(PsiExpression expr2) {
        LinkedHashSet<PsiType> types = new LinkedHashSet<PsiType>(this.getControlFlowExpressionTypeConjuncts(expr2));
        this.addExprTypesWhenContainerElement(types, expr2);
        this.addExprTypesByDerivedClasses(types, expr2);
        PsiType[] psiTypeArray = types.toArray(PsiType.createArray((int)types.size()));
        if (psiTypeArray == null) {
            GuessManagerImpl.$$$reportNull$$$0(2);
        }
        return psiTypeArray;
    }

    @Override
    @NotNull
    public MultiMap<PsiExpression, PsiType> getControlFlowExpressionTypes(@NotNull PsiExpression forPlace, boolean honorAssignments) {
        ExpressionTypeInstructionVisitor visitor2;
        DataFlowRunner runner;
        PsiElement scope;
        if (forPlace == null) {
            GuessManagerImpl.$$$reportNull$$$0(3);
        }
        if ((scope = DfaPsiUtil.getTopmostBlockInSameClass((PsiElement)forPlace)) == null) {
            PsiFile file = forPlace.getContainingFile();
            if (!(file instanceof PsiCodeFragment)) {
                MultiMap multiMap = MultiMap.empty();
                if (multiMap == null) {
                    GuessManagerImpl.$$$reportNull$$$0(4);
                }
                return multiMap;
            }
            scope = file;
        }
        if ((runner = GuessManagerImpl.createRunner(honorAssignments, scope)).analyzeMethodWithInlining(scope, visitor2 = new ExpressionTypeInstructionVisitor((PsiElement)forPlace)) == RunnerResult.OK) {
            MultiMap<PsiExpression, PsiType> multiMap = visitor2.getResult();
            if (multiMap == null) {
                GuessManagerImpl.$$$reportNull$$$0(5);
            }
            return multiMap;
        }
        MultiMap multiMap = MultiMap.empty();
        if (multiMap == null) {
            GuessManagerImpl.$$$reportNull$$$0(6);
        }
        return multiMap;
    }

    @Nullable
    private static PsiType getTypeFromDataflow(final PsiExpression forPlace, boolean honorAssignments) {
        Visitor visitor2;
        DataFlowRunner runner;
        PsiType type2 = forPlace.getType();
        TypeConstraint initial = type2 == null ? TypeConstraints.TOP : TypeConstraints.instanceOf(type2);
        PsiElement scope = DfaPsiUtil.getTopmostBlockInSameClass((PsiElement)forPlace);
        if (scope == null) {
            PsiFile file = forPlace.getContainingFile();
            if (!(file instanceof PsiCodeFragment)) {
                return null;
            }
            scope = file;
        }
        class Visitor
        extends CastTrackingVisitor {
            TypeConstraint constraint = TypeConstraints.BOTTOM;

            Visitor() {
            }

            @Override
            protected void beforeExpressionPush(@NotNull DfaValue value2, @NotNull PsiExpression expression2, @Nullable TextRange range, @NotNull DfaMemoryState state) {
                if (value2 == null) {
                    Visitor.$$$reportNull$$$0(0);
                }
                if (expression2 == null) {
                    Visitor.$$$reportNull$$$0(1);
                }
                if (state == null) {
                    Visitor.$$$reportNull$$$0(2);
                }
                if (expression2 == forPlace && range == null) {
                    if (!(value2 instanceof DfaVariableValue) || ((DfaVariableValue)value2).isFlushableByCalls()) {
                        value2 = runner.getFactory().getVarFactory().createVariableValue(new ExpressionVariableDescriptor(expression2));
                    }
                    this.constraint = this.constraint.join(TypeConstraint.fromDfType(state.getDfType(value2)));
                }
                super.beforeExpressionPush(value2, expression2, range, state);
            }

            @Override
            boolean isInteresting(@NotNull DfaValue value2, @NotNull PsiExpression expression2) {
                if (value2 == null) {
                    Visitor.$$$reportNull$$$0(3);
                }
                if (expression2 == null) {
                    Visitor.$$$reportNull$$$0(4);
                }
                return (!(value2 instanceof DfaVariableValue) || ((DfaVariableValue)value2).isFlushableByCalls()) && ExpressionVariableDescriptor.EXPRESSION_HASHING_STRATEGY.equals((Object)expression2, (Object)forPlace);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "value";
                        break;
                    }
                    case 1: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "expression";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "state";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/codeInsight/guess/impl/GuessManagerImpl$1Visitor";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "beforeExpressionPush";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isInteresting";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
        if ((runner = GuessManagerImpl.createRunner(honorAssignments, scope)).analyzeMethodWithInlining(scope, visitor2 = new Visitor()) == RunnerResult.OK) {
            return visitor2.constraint.meet(initial).getPsiType(scope.getProject());
        }
        return null;
    }

    @NotNull
    private static DataFlowRunner createRunner(boolean honorAssignments, PsiElement scope) {
        return honorAssignments ? new DataFlowRunner(scope.getProject()) : new DataFlowRunner(scope.getProject()){

            @Override
            @NotNull
            protected DfaMemoryState createMemoryState() {
                return new AssignmentFilteringMemoryState(this.getFactory());
            }
        };
    }

    private static PsiElement getTopmostBlock(PsiElement scope) {
        PsiFile file;
        PsiCodeBlock lastCodeBlock;
        assert (scope.isValid());
        PsiElement lastScope = scope;
        while ((lastCodeBlock = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)lastScope, PsiCodeBlock.class, (boolean)true)) != null) {
            lastScope = lastCodeBlock;
        }
        if (lastScope == scope && (file = scope.getContainingFile()) instanceof PsiCodeFragment) {
            return file;
        }
        return lastScope;
    }

    private void addExprTypesByDerivedClasses(LinkedHashSet<? super PsiType> set, PsiExpression expr2) {
        PsiType type2 = expr2.getType();
        if (!(type2 instanceof PsiClassType)) {
            return;
        }
        PsiClass refClass = PsiUtil.resolveClassInType((PsiType)type2);
        if (refClass == null) {
            return;
        }
        PsiManager manager = PsiManager.getInstance((Project)this.myProject);
        PsiElementProcessor.CollectElementsWithLimit processor2 = new PsiElementProcessor.CollectElementsWithLimit(5);
        ClassInheritorsSearch.search((PsiClass)refClass).forEach((Processor)new PsiElementProcessorAdapter((PsiElementProcessor)processor2));
        if (processor2.isOverflow()) {
            return;
        }
        for (PsiClass derivedClass : processor2.getCollection()) {
            if (derivedClass instanceof PsiAnonymousClass) continue;
            PsiClassType derivedType = JavaPsiFacade.getElementFactory((Project)manager.getProject()).createType(derivedClass);
            set.add((PsiType)derivedType);
        }
    }

    private void addExprTypesWhenContainerElement(LinkedHashSet<? super PsiType> set, PsiExpression expr2) {
        PsiExpression qualifier;
        PsiMethodCallExpression callExpr;
        PsiReferenceExpression methodExpr;
        String methodName;
        MethodPattern pattern;
        if (expr2 instanceof PsiMethodCallExpression && (pattern = this.myMethodPatternMap.findPattern(methodName = (methodExpr = (callExpr = (PsiMethodCallExpression)expr2).getMethodExpression()).getReferenceName(), callExpr.getArgumentList().getExpressionCount())) != null && pattern.parameterIndex < 0 && (qualifier = methodExpr.getQualifierExpression()) != null) {
            PsiType[] types;
            for (PsiType type2 : types = this.guessContainerElementType(qualifier, null)) {
                if (type2 instanceof PsiClassType && ((PsiClassType)type2).resolve() instanceof PsiAnonymousClass) continue;
                set.add((PsiType)type2);
            }
        }
    }

    private void addTypesByVariable(HashSet<? super PsiType> typesSet, PsiVariable var, PsiFile scopeFile, HashSet<? super PsiVariable> checkedVariables, int flags, TextRange rangeToIgnore) {
        if (!checkedVariables.add((PsiVariable)var)) {
            return;
        }
        LocalSearchScope searchScope = new LocalSearchScope((PsiElement)scopeFile);
        if (BitUtil.isSet((int)flags, (int)1) || BitUtil.isSet((int)flags, (int)4)) {
            for (PsiReference varRef : ReferencesSearch.search((PsiElement)var, (SearchScope)searchScope, (boolean)false)) {
                PsiParameter[] parameters2;
                PsiType type2;
                PsiElement ref = varRef.getElement();
                if (BitUtil.isSet((int)flags, (int)1) && (type2 = GuessManagerImpl.guessElementTypeFromReference(this.myMethodPatternMap, ref, rangeToIgnore)) != null && !(type2 instanceof PsiPrimitiveType)) {
                    typesSet.add((PsiType)type2);
                }
                if (!BitUtil.isSet((int)flags, (int)4) || !(ref.getParent() instanceof PsiExpressionList) || !(ref.getParent().getParent() instanceof PsiMethodCallExpression)) continue;
                PsiExpressionList list = (PsiExpressionList)ref.getParent();
                int argIndex = ArrayUtil.indexOf((Object[])list.getExpressions(), (Object)ref);
                PsiMethodCallExpression methodCall = (PsiMethodCallExpression)list.getParent();
                PsiMethod method = (PsiMethod)methodCall.getMethodExpression().resolve();
                if (method == null || argIndex >= (parameters2 = method.getParameterList().getParameters()).length) continue;
                this.addTypesByVariable(typesSet, (PsiVariable)parameters2[argIndex], method.getContainingFile(), checkedVariables, flags | 1, rangeToIgnore);
            }
        }
        if (BitUtil.isSet((int)flags, (int)2) && var instanceof PsiParameter && var.getParent() instanceof PsiParameterList && var.getParent().getParent() instanceof PsiMethod) {
            PsiParameterList list = (PsiParameterList)var.getParent();
            PsiParameter[] parameters3 = list.getParameters();
            int argIndex = -1;
            for (int i = 0; i < parameters3.length; ++i) {
                PsiParameter parameter2 = parameters3[i];
                if (!parameter2.equals(var)) continue;
                argIndex = i;
                break;
            }
            PsiMethod method = (PsiMethod)var.getParent().getParent();
            for (PsiReference methodRef : ReferencesSearch.search((PsiElement)method, (SearchScope)searchScope, (boolean)false)) {
                PsiElement refElement;
                PsiExpression arg;
                PsiMethodCallExpression methodCall;
                PsiExpression[] args;
                PsiElement ref = methodRef.getElement();
                if (!(ref.getParent() instanceof PsiMethodCallExpression) || (args = (methodCall = (PsiMethodCallExpression)ref.getParent()).getArgumentList().getExpressions()).length <= argIndex || !((arg = args[argIndex]) instanceof PsiReferenceExpression) || !((refElement = ((PsiReferenceExpression)arg).resolve()) instanceof PsiVariable)) continue;
                this.addTypesByVariable(typesSet, (PsiVariable)refElement, scopeFile, checkedVariables, flags | 1, rangeToIgnore);
            }
        }
    }

    @Nullable
    private static PsiType guessElementTypeFromReference(MethodPatternMap methodPatternMap, PsiElement ref, TextRange rangeToIgnore) {
        PsiMethodCallExpression methodCall;
        PsiExpression[] args;
        String methodName;
        MethodPattern pattern;
        PsiReferenceExpression parentExpr;
        PsiElement refParent = ref.getParent();
        if (refParent instanceof PsiReferenceExpression && ref.equals((parentExpr = (PsiReferenceExpression)refParent).getQualifierExpression()) && parentExpr.getParent() instanceof PsiMethodCallExpression && (pattern = methodPatternMap.findPattern(methodName = parentExpr.getReferenceName(), (args = (methodCall = (PsiMethodCallExpression)parentExpr.getParent()).getArgumentList().getExpressions()).length)) != null) {
            if (pattern.parameterIndex < 0) {
                if (methodCall.getParent() instanceof PsiTypeCastExpression && (rangeToIgnore == null || !rangeToIgnore.contains(methodCall.getTextRange()))) {
                    return ((PsiTypeCastExpression)methodCall.getParent()).getType();
                }
            } else {
                return args[pattern.parameterIndex].getType();
            }
        }
        return null;
    }

    @Override
    @NotNull
    public List<PsiType> getControlFlowExpressionTypeConjuncts(@NotNull PsiExpression expr2, boolean honorAssignments) {
        GuessTypeVisitor visitor2;
        if (expr2 == null) {
            GuessManagerImpl.$$$reportNull$$$0(7);
        }
        if (expr2.getType() instanceof PsiPrimitiveType) {
            List<PsiType> list = Collections.emptyList();
            if (list == null) {
                GuessManagerImpl.$$$reportNull$$$0(8);
            }
            return list;
        }
        PsiExpression place = PsiUtil.skipParenthesizedExprDown((PsiExpression)expr2);
        if (place == null) {
            List<PsiType> list = Collections.emptyList();
            if (list == null) {
                GuessManagerImpl.$$$reportNull$$$0(9);
            }
            return list;
        }
        List<Object> result = null;
        if (!ControlFlowAnalyzer.inlinerMayInferPreciseType(place) && !(visitor2 = GuessManagerImpl.tryGuessingTypeWithoutDfa(place, honorAssignments)).isDfaNeeded()) {
            List<PsiType> list = result = visitor2.mySpecificType == null ? Collections.emptyList() : Collections.singletonList(DfaPsiUtil.tryGenerify(expr2, visitor2.mySpecificType));
        }
        if (result == null) {
            PsiType psiType = GuessManagerImpl.getTypeFromDataflow(expr2, honorAssignments);
            result = psiType instanceof PsiIntersectionType ? ContainerUtil.mapNotNull((Object[])((PsiIntersectionType)psiType).getConjuncts(), type2 -> DfaPsiUtil.tryGenerify(expr2, type2)) : (psiType != null ? Collections.singletonList(DfaPsiUtil.tryGenerify(expr2, psiType)) : Collections.emptyList());
        }
        if ((result = ContainerUtil.filter(result, t -> {
            PsiClass typeClass = PsiUtil.resolveClassInType((PsiType)t);
            return typeClass == null || PsiUtil.isAccessible((PsiMember)typeClass, (PsiElement)expr2, null);
        })).equals(Collections.singletonList(TypeConversionUtil.erasure((PsiType)expr2.getType())))) {
            List<PsiType> list = Collections.emptyList();
            if (list == null) {
                GuessManagerImpl.$$$reportNull$$$0(10);
            }
            return list;
        }
        List<PsiType> list = result;
        if (list == null) {
            GuessManagerImpl.$$$reportNull$$$0(11);
        }
        return list;
    }

    @NotNull
    private static GuessTypeVisitor tryGuessingTypeWithoutDfa(PsiExpression place, boolean honorAssignments) {
        List<PsiElement> exprsAndVars = GuessManagerImpl.getPotentiallyAffectingElements(place);
        GuessTypeVisitor visitor2 = new GuessTypeVisitor(place, honorAssignments);
        for (PsiElement e : exprsAndVars) {
            e.accept((PsiElementVisitor)visitor2);
            if (e != place && !visitor2.isDfaNeeded()) continue;
            break;
        }
        GuessTypeVisitor guessTypeVisitor = visitor2;
        if (guessTypeVisitor == null) {
            GuessManagerImpl.$$$reportNull$$$0(12);
        }
        return guessTypeVisitor;
    }

    private static List<PsiElement> getPotentiallyAffectingElements(PsiExpression place) {
        PsiElement topmostBlock = GuessManagerImpl.getTopmostBlock((PsiElement)place);
        return (List)CachedValuesManager.getCachedValue((PsiElement)topmostBlock, () -> {
            List list = ((SyntaxTraverser)SyntaxTraverser.psiTraverser((PsiElement)topmostBlock).filter(e -> e instanceof PsiExpression || e instanceof PsiLocalVariable)).toList();
            return new CachedValueProvider.Result((Object)list, new Object[]{topmostBlock});
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/guess/impl/GuessManagerImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "forPlace";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "guessContainerElementType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "guessTypeToCast";
                break;
            }
            case 3: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/guess/impl/GuessManagerImpl";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getControlFlowExpressionTypes";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getControlFlowExpressionTypeConjuncts";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "tryGuessingTypeWithoutDfa";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getControlFlowExpressionTypes";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getControlFlowExpressionTypeConjuncts";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class ExpressionTypeInstructionVisitor
    extends CastTrackingVisitor {
        private final Map<DfaVariableValue, TypeConstraint> myResult;
        private final PsiElement myForPlace;

        private ExpressionTypeInstructionVisitor(@NotNull PsiElement forPlace) {
            if (forPlace == null) {
                ExpressionTypeInstructionVisitor.$$$reportNull$$$0(0);
            }
            this.myResult = new HashMap<DfaVariableValue, TypeConstraint>();
            this.myForPlace = PsiUtil.skipParenthesizedExprUp((PsiElement)forPlace);
        }

        MultiMap<PsiExpression, PsiType> getResult() {
            MultiMap result = MultiMap.createSet((Map)new Object2ObjectOpenCustomHashMap(ExpressionVariableDescriptor.EXPRESSION_HASHING_STRATEGY));
            Project project = this.myForPlace.getProject();
            this.myResult.forEach((value2, constraint) -> {
                if (value2.getDescriptor() instanceof ExpressionVariableDescriptor) {
                    PsiExpression expression2 = ((ExpressionVariableDescriptor)value2.getDescriptor()).getExpression();
                    PsiType type2 = constraint.getPsiType(project);
                    if (type2 instanceof PsiIntersectionType) {
                        result.putValues((Object)expression2, Arrays.asList(((PsiIntersectionType)type2).getConjuncts()));
                    } else if (type2 != null) {
                        result.putValue((Object)expression2, (Object)type2);
                    }
                }
            });
            return result;
        }

        @Override
        protected void beforeExpressionPush(@NotNull DfaValue value2, @NotNull PsiExpression expression2, @Nullable TextRange range, @NotNull DfaMemoryState state) {
            if (value2 == null) {
                ExpressionTypeInstructionVisitor.$$$reportNull$$$0(1);
            }
            if (expression2 == null) {
                ExpressionTypeInstructionVisitor.$$$reportNull$$$0(2);
            }
            if (state == null) {
                ExpressionTypeInstructionVisitor.$$$reportNull$$$0(3);
            }
            if (range == null && this.myForPlace == expression2) {
                ((DfaMemoryStateImpl)state).forRecordedVariableTypes((var, dfType) -> this.myResult.merge((DfaVariableValue)var, TypeConstraint.fromDfType(dfType), TypeConstraint::join));
            }
            super.beforeExpressionPush(value2, expression2, range, state);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "forPlace";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInsight/guess/impl/GuessManagerImpl$ExpressionTypeInstructionVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeExpressionPush";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static abstract class CastTrackingVisitor
    extends StandardInstructionVisitor {
        CastTrackingVisitor() {
        }

        @Override
        public DfaInstructionState[] visitTypeCast(TypeCastInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
            DfaValue value2 = memState.pop();
            memState.push(this.adjustValue(runner, value2, instruction.getCasted()));
            return super.visitTypeCast(instruction, runner, memState);
        }

        @Override
        public DfaInstructionState[] visitInstanceof(InstanceofInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
            DfaValue dfaRight = memState.pop();
            DfaValue dfaLeft = memState.pop();
            memState.push(this.adjustValue(runner, dfaLeft, instruction.getLeft()));
            memState.push(dfaRight);
            return super.visitInstanceof(instruction, runner, memState);
        }

        private DfaValue adjustValue(DataFlowRunner runner, DfaValue value2, @Nullable PsiExpression expression2) {
            if (expression2 != null && this.isInteresting(value2, expression2)) {
                value2 = runner.getFactory().getVarFactory().createVariableValue(new ExpressionVariableDescriptor(expression2));
            }
            return value2;
        }

        boolean isInteresting(@NotNull DfaValue value2, @NotNull PsiExpression expression2) {
            if (value2 == null) {
                CastTrackingVisitor.$$$reportNull$$$0(0);
            }
            if (expression2 == null) {
                CastTrackingVisitor.$$$reportNull$$$0(1);
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "value";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "expression";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInsight/guess/impl/GuessManagerImpl$CastTrackingVisitor";
            objectArray[2] = "isInteresting";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class GuessTypeVisitor
    extends JavaElementVisitor {
        private static final CallMatcher OBJECT_GET_CLASS = CallMatcher.exactInstanceCall("java.lang.Object", "getClass").parameterCount(0);
        @NotNull
        private final PsiExpression myPlace;
        PsiType mySpecificType;
        private boolean myNeedDfa;
        private boolean myDeclared;
        private final boolean myHonorAssignments;

        GuessTypeVisitor(@NotNull PsiExpression place, boolean honorAssignments) {
            if (place == null) {
                GuessTypeVisitor.$$$reportNull$$$0(0);
            }
            this.myPlace = place;
            this.myHonorAssignments = honorAssignments;
        }

        protected void handleAssignment(@Nullable PsiExpression expression2) {
            PsiType rawType;
            if (!this.myHonorAssignments || expression2 == null) {
                return;
            }
            PsiType type2 = expression2.getType();
            if (type2 instanceof PsiPrimitiveType) {
                type2 = ((PsiPrimitiveType)type2).getBoxedType((PsiElement)expression2);
            }
            Object object = rawType = type2 instanceof PsiClassType ? ((PsiClassType)type2).rawType() : type2;
            if (rawType == null || rawType.equals(PsiType.NULL)) {
                return;
            }
            if (this.mySpecificType == null) {
                this.mySpecificType = rawType;
            } else if (!this.mySpecificType.equals(rawType)) {
                this.myNeedDfa = true;
            }
        }

        public void visitAssignmentExpression(PsiAssignmentExpression expression2) {
            if (ExpressionVariableDescriptor.EXPRESSION_HASHING_STRATEGY.equals((Object)expression2.getLExpression(), (Object)this.myPlace)) {
                this.handleAssignment(expression2.getRExpression());
            }
            super.visitAssignmentExpression(expression2);
        }

        public void visitLocalVariable(PsiLocalVariable variable) {
            if (ExpressionUtils.isReferenceTo(this.myPlace, (PsiVariable)variable)) {
                this.myDeclared = true;
                this.handleAssignment(variable.getInitializer());
            }
            super.visitLocalVariable(variable);
        }

        public void visitTypeCastExpression(PsiTypeCastExpression expression2) {
            PsiExpression operand2 = expression2.getOperand();
            if (operand2 != null && ExpressionVariableDescriptor.EXPRESSION_HASHING_STRATEGY.equals((Object)operand2, (Object)this.myPlace)) {
                this.myNeedDfa = true;
            }
            super.visitTypeCastExpression(expression2);
        }

        public void visitMethodCallExpression(PsiMethodCallExpression call) {
            PsiExpression qualifier;
            if (OBJECT_GET_CLASS.test(call) && (qualifier = ExpressionUtils.getEffectiveQualifier(call.getMethodExpression())) != null && ExpressionVariableDescriptor.EXPRESSION_HASHING_STRATEGY.equals((Object)qualifier, (Object)this.myPlace)) {
                this.myNeedDfa = true;
            }
            super.visitMethodCallExpression(call);
        }

        public void visitInstanceOfExpression(PsiInstanceOfExpression expression2) {
            if (ExpressionVariableDescriptor.EXPRESSION_HASHING_STRATEGY.equals((Object)expression2.getOperand(), (Object)this.myPlace)) {
                this.myNeedDfa = true;
            }
            super.visitInstanceOfExpression(expression2);
        }

        public boolean isDfaNeeded() {
            if (this.myNeedDfa) {
                return true;
            }
            if (this.myDeclared || this.mySpecificType == null) {
                return false;
            }
            PsiType type2 = this.myPlace.getType();
            PsiType rawType = type2 instanceof PsiClassType ? ((PsiClassType)type2).rawType() : type2;
            return !this.mySpecificType.equals(rawType);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/codeInsight/guess/impl/GuessManagerImpl$GuessTypeVisitor", "<init>"));
        }
    }
}

