/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.highlighting;

import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInsight.highlighting.HighlightExceptionsHandler;
import com.intellij.codeInsight.highlighting.HighlightThrowsClassesHandler;
import com.intellij.codeInsight.highlighting.HighlightUsagesHandlerBase;
import com.intellij.codeInsight.highlighting.HighlightUsagesHandlerFactoryBase;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import java.util.Collection;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HighlightExceptionsHandlerFactory
extends HighlightUsagesHandlerFactoryBase {
    public HighlightUsagesHandlerBase createHighlightUsagesHandler(@NotNull Editor editor, @NotNull PsiFile file, @NotNull PsiElement target) {
        PsiElement parent;
        if (editor == null) {
            HighlightExceptionsHandlerFactory.$$$reportNull$$$0(0);
        }
        if (file == null) {
            HighlightExceptionsHandlerFactory.$$$reportNull$$$0(1);
        }
        if (target == null) {
            HighlightExceptionsHandlerFactory.$$$reportNull$$$0(2);
        }
        if (target instanceof PsiKeyword) {
            parent = target.getParent();
            if ("try".equals(target.getText()) && parent instanceof PsiTryStatement) {
                return HighlightExceptionsHandlerFactory.createHighlightTryHandler(editor, file, target, parent);
            }
            if ("catch".equals(target.getText()) && parent instanceof PsiCatchSection) {
                return HighlightExceptionsHandlerFactory.createHighlightCatchHandler(editor, file, target, parent);
            }
            if ("throws".equals(target.getText())) {
                return HighlightExceptionsHandlerFactory.createThrowsHandler(editor, file, target);
            }
        }
        if (target instanceof PsiIdentifier && (parent = target.getParent()) instanceof PsiJavaCodeReferenceElement) {
            return HighlightExceptionsHandlerFactory.createHighlightExceptionUsagesFromThrowsHandler(editor, file, target, (PsiJavaCodeReferenceElement)parent);
        }
        return null;
    }

    @Nullable
    private static HighlightUsagesHandlerBase<PsiClass> createHighlightTryHandler(@NotNull Editor editor, @NotNull PsiFile file, @NotNull PsiElement target, @NotNull PsiElement parent) {
        if (editor == null) {
            HighlightExceptionsHandlerFactory.$$$reportNull$$$0(3);
        }
        if (file == null) {
            HighlightExceptionsHandlerFactory.$$$reportNull$$$0(4);
        }
        if (target == null) {
            HighlightExceptionsHandlerFactory.$$$reportNull$$$0(5);
        }
        if (parent == null) {
            HighlightExceptionsHandlerFactory.$$$reportNull$$$0(6);
        }
        FeatureUsageTracker.getInstance().triggerFeatureUsed("codeassists.highlight.throws");
        PsiCodeBlock tryBlock = ((PsiTryStatement)parent).getTryBlock();
        if (tryBlock == null) {
            return null;
        }
        Collection<PsiClassType> unhandled = ExceptionUtil.collectUnhandledExceptions((PsiElement)tryBlock, (PsiElement)tryBlock);
        PsiClassType[] types = unhandled.toArray(PsiClassType.EMPTY_ARRAY);
        return new HighlightExceptionsHandler(editor, file, target, types, (PsiElement)tryBlock, null, (Condition<? super PsiType>)Conditions.alwaysTrue());
    }

    @Nullable
    private static HighlightUsagesHandlerBase<PsiClass> createHighlightExceptionUsagesFromThrowsHandler(@NotNull Editor editor, @NotNull PsiFile file, @NotNull PsiElement target, @NotNull PsiJavaCodeReferenceElement parent) {
        PsiElement list;
        if (editor == null) {
            HighlightExceptionsHandlerFactory.$$$reportNull$$$0(7);
        }
        if (file == null) {
            HighlightExceptionsHandlerFactory.$$$reportNull$$$0(8);
        }
        if (target == null) {
            HighlightExceptionsHandlerFactory.$$$reportNull$$$0(9);
        }
        if (parent == null) {
            HighlightExceptionsHandlerFactory.$$$reportNull$$$0(10);
        }
        if (!((list = parent.getParent()) instanceof PsiReferenceList)) {
            return null;
        }
        PsiElement method = list.getParent();
        if (!(method instanceof PsiMethod)) {
            return null;
        }
        if (!file.getManager().areElementsEquivalent(list, (PsiElement)((PsiMethod)method).getThrowsList())) {
            return null;
        }
        PsiCodeBlock block = ((PsiMethod)method).getBody();
        if (block == null) {
            return null;
        }
        PsiElement resolved = parent.resolve();
        if (!(resolved instanceof PsiClass)) {
            return null;
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)file.getProject());
        PsiClassType type2 = factory.createType(parent);
        return new HighlightThrowsClassesHandler(editor, file, target, type2, (PsiElement)block, resolved);
    }

    @Nullable
    private static HighlightUsagesHandlerBase<PsiClass> createHighlightCatchHandler(@NotNull Editor editor, @NotNull PsiFile file, @NotNull PsiElement target, @NotNull PsiElement parent) {
        if (editor == null) {
            HighlightExceptionsHandlerFactory.$$$reportNull$$$0(11);
        }
        if (file == null) {
            HighlightExceptionsHandlerFactory.$$$reportNull$$$0(12);
        }
        if (target == null) {
            HighlightExceptionsHandlerFactory.$$$reportNull$$$0(13);
        }
        if (parent == null) {
            HighlightExceptionsHandlerFactory.$$$reportNull$$$0(14);
        }
        FeatureUsageTracker.getInstance().triggerFeatureUsed("codeassists.highlight.throws");
        PsiTryStatement tryStatement = ((PsiCatchSection)parent).getTryStatement();
        PsiParameter parameter2 = ((PsiCatchSection)parent).getParameter();
        PsiCodeBlock tryBlock = tryStatement.getTryBlock();
        PsiResourceList resourceList = tryStatement.getResourceList();
        if (parameter2 == null || tryBlock == null) {
            return null;
        }
        PsiParameter[] parameters2 = tryStatement.getCatchBlockParameters();
        Condition filter = type2 -> {
            for (PsiParameter p : parameters2) {
                boolean isAssignable = p.getType().isAssignableFrom(type2);
                if (p == parameter2) {
                    return isAssignable;
                }
                if (!isAssignable) continue;
                return false;
            }
            return false;
        };
        Stream<PsiClassType> unhandled = ExceptionUtil.collectUnhandledExceptions((PsiElement)tryBlock, (PsiElement)tryBlock).stream();
        if (resourceList != null) {
            unhandled = Stream.concat(unhandled, ExceptionUtil.collectUnhandledExceptions((PsiElement)resourceList, (PsiElement)resourceList).stream());
        }
        PsiClassType[] types = (PsiClassType[])unhandled.filter(arg_0 -> ((Condition)filter).value(arg_0)).toArray(PsiClassType[]::new);
        return new HighlightExceptionsHandler(editor, file, target, types, (PsiElement)tryBlock, (PsiElement)resourceList, (Condition<? super PsiType>)filter);
    }

    @Nullable
    private static HighlightUsagesHandlerBase<PsiClass> createThrowsHandler(@NotNull Editor editor, @NotNull PsiFile file, @NotNull PsiElement target) {
        if (editor == null) {
            HighlightExceptionsHandlerFactory.$$$reportNull$$$0(15);
        }
        if (file == null) {
            HighlightExceptionsHandlerFactory.$$$reportNull$$$0(16);
        }
        if (target == null) {
            HighlightExceptionsHandlerFactory.$$$reportNull$$$0(17);
        }
        FeatureUsageTracker.getInstance().triggerFeatureUsed("codeassists.highlight.throws");
        PsiElement grand = target.getParent().getParent();
        if (!(grand instanceof PsiMethod)) {
            return null;
        }
        PsiCodeBlock body2 = ((PsiMethod)grand).getBody();
        if (body2 == null) {
            return null;
        }
        Collection<PsiClassType> unhandled = ExceptionUtil.collectUnhandledExceptions((PsiElement)body2, (PsiElement)body2);
        PsiClassType[] types = unhandled.toArray(PsiClassType.EMPTY_ARRAY);
        return new HighlightExceptionsHandler(editor, file, target, types, (PsiElement)body2, null, (Condition<? super PsiType>)Conditions.alwaysTrue());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 5: 
            case 9: 
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 6: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/highlighting/HighlightExceptionsHandlerFactory";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createHighlightUsagesHandler";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "createHighlightTryHandler";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "createHighlightExceptionUsagesFromThrowsHandler";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "createHighlightCatchHandler";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "createThrowsHandler";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

