/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.highlighting;

import com.intellij.codeInsight.highlighting.ChooseClassAndDoHighlightRunnable;
import com.intellij.codeInsight.highlighting.HighlightUsagesHandler;
import com.intellij.codeInsight.highlighting.HighlightUsagesHandlerBase;
import com.intellij.java.JavaBundle;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.util.Consumer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HighlightOverridingMethodsHandler
extends HighlightUsagesHandlerBase<PsiClass> {
    private final PsiElement myTarget;
    private final PsiClass myClass;

    public HighlightOverridingMethodsHandler(Editor editor, PsiFile file, PsiElement target, PsiClass psiClass) {
        super(editor, file);
        this.myTarget = target;
        this.myClass = psiClass;
    }

    @NotNull
    public List<PsiClass> getTargets() {
        PsiReferenceList list;
        PsiReferenceList psiReferenceList = list = "extends".equals(this.myTarget.getText()) ? this.myClass.getExtendsList() : this.myClass.getImplementsList();
        if (list == null) {
            List<PsiClass> list2 = Collections.emptyList();
            if (list2 == null) {
                HighlightOverridingMethodsHandler.$$$reportNull$$$0(0);
            }
            return list2;
        }
        PsiClassType[] classTypes = list.getReferencedTypes();
        List<PsiClass> list3 = ChooseClassAndDoHighlightRunnable.resolveClasses(classTypes);
        if (list3 == null) {
            HighlightOverridingMethodsHandler.$$$reportNull$$$0(1);
        }
        return list3;
    }

    protected void selectTargets(@NotNull List<? extends PsiClass> targets, final @NotNull Consumer<? super List<? extends PsiClass>> selectionConsumer) {
        if (targets == null) {
            HighlightOverridingMethodsHandler.$$$reportNull$$$0(2);
        }
        if (selectionConsumer == null) {
            HighlightOverridingMethodsHandler.$$$reportNull$$$0(3);
        }
        new ChooseClassAndDoHighlightRunnable(targets, this.myEditor, JavaBundle.message((String)"highlight.overridden.classes.chooser.title", (Object[])new Object[0])){

            protected void selected(PsiClass ... classes2) {
                if (classes2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                selectionConsumer.consume(Arrays.asList(classes2));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classes", "com/intellij/codeInsight/highlighting/HighlightOverridingMethodsHandler$1", "selected"));
            }
        }.run();
    }

    public void computeUsages(@NotNull List<? extends PsiClass> classes2) {
        if (classes2 == null) {
            HighlightOverridingMethodsHandler.$$$reportNull$$$0(4);
        }
        for (PsiMethod method : this.myClass.getMethods()) {
            List superSignatures = method.getHierarchicalMethodSignature().getSuperSignatures();
            block1: for (HierarchicalMethodSignature superSignature : superSignatures) {
                PsiClass containingClass = superSignature.getMethod().getContainingClass();
                if (containingClass == null) continue;
                for (PsiClass psiClass : classes2) {
                    PsiIdentifier identifier;
                    if (!InheritanceUtil.isInheritorOrSelf((PsiClass)psiClass, (PsiClass)containingClass, (boolean)true) || (identifier = method.getNameIdentifier()) == null) continue;
                    this.addOccurrence((PsiElement)identifier);
                    continue block1;
                }
            }
        }
        if (this.myReadUsages.isEmpty()) {
            String name2;
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                return;
            }
            if (classes2.size() == 1) {
                ItemPresentation presentation = classes2.get(0).getPresentation();
                String name3 = presentation != null ? presentation.getPresentableText() : "";
            } else {
                name2 = "";
            }
            this.myHintText = JavaBundle.message((String)"no.methods.overriding.0.are.found", (Object[])new Object[]{classes2.size(), name2});
        } else {
            this.addOccurrence(this.myTarget);
            int methodCount = this.myReadUsages.size() - 1;
            this.myStatusText = JavaBundle.message((String)"status.bar.overridden.methods.highlighted.message", (Object[])new Object[]{methodCount, HighlightUsagesHandler.getShortcutText()});
        }
    }

    @Nullable
    public String getFeatureId() {
        return "codeassists.highlight.implements";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/highlighting/HighlightOverridingMethodsHandler";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targets";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectionConsumer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargets";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/highlighting/HighlightOverridingMethodsHandler";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "selectTargets";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "computeUsages";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

