/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiJavaToken;
import com.intellij.util.IncorrectOperationException;
import java.util.Arrays;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class BreakStringOnLineBreaksIntentionAction
extends PsiElementBaseIntentionAction {
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            BreakStringOnLineBreaksIntentionAction.$$$reportNull$$$0(0);
        }
        if (element == null) {
            BreakStringOnLineBreaksIntentionAction.$$$reportNull$$$0(1);
        }
        if (!(element instanceof PsiJavaToken)) {
            return false;
        }
        PsiJavaToken token = (PsiJavaToken)element;
        if (token.getTokenType() != JavaTokenType.STRING_LITERAL) {
            return false;
        }
        String text2 = token.getText();
        if (text2 == null) {
            return false;
        }
        int indexOfSlashN = text2.indexOf("\\n");
        if (indexOfSlashN == -1 || Objects.equals(text2.substring(indexOfSlashN), "\\n\"")) {
            return false;
        }
        int indexOfSlashNSlashR = text2.indexOf("\\n\\r");
        return indexOfSlashNSlashR == -1 || !Objects.equals(text2.substring(indexOfSlashNSlashR), "\\n\\r\"");
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            BreakStringOnLineBreaksIntentionAction.$$$reportNull$$$0(2);
        }
        if (element == null) {
            BreakStringOnLineBreaksIntentionAction.$$$reportNull$$$0(3);
        }
        if (!(element instanceof PsiJavaToken)) {
            return;
        }
        PsiJavaToken token = (PsiJavaToken)element;
        if (token.getTokenType() != JavaTokenType.STRING_LITERAL) {
            return;
        }
        String text2 = token.getText();
        if (text2 == null) {
            return;
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
        token.getParent().replace((PsiElement)factory.createExpressionFromText(BreakStringOnLineBreaksIntentionAction.breakOnLineBreaks(text2), element));
    }

    @NotNull
    private static String breakOnLineBreaks(@NotNull String string) {
        if (string == null) {
            BreakStringOnLineBreaksIntentionAction.$$$reportNull$$$0(4);
        }
        String result = StringUtil.replace((String)string, Arrays.asList("\\n\\r", "\\n"), Arrays.asList("\\n\\r\" + \n\"", "\\n\" + \n\""));
        String redundantSuffix = " + \n\"\"";
        String string2 = result.endsWith(" + \n\"\"") ? result.substring(0, result.length() - " + \n\"\"".length()) : result;
        if (string2 == null) {
            BreakStringOnLineBreaksIntentionAction.$$$reportNull$$$0(5);
        }
        return string2;
    }

    @NotNull
    public String getText() {
        String string = JavaBundle.message((String)"intention.break.string.on.line.breaks.text", (Object[])new Object[0]);
        if (string == null) {
            BreakStringOnLineBreaksIntentionAction.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            BreakStringOnLineBreaksIntentionAction.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/intention/impl/BreakStringOnLineBreaksIntentionAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/intention/impl/BreakStringOnLineBreaksIntentionAction";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "breakOnLineBreaks";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "breakOnLineBreaks";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

