/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.codeInspection.dataFlow.JavaMethodContractUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FieldFromParameterUtils {
    @Nullable
    public static PsiParameter findParameterAtCursor(@NotNull PsiFile file, @NotNull Editor editor) {
        PsiParameter[] parameters2;
        int offset;
        PsiParameterList parameterList;
        if (file == null) {
            FieldFromParameterUtils.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            FieldFromParameterUtils.$$$reportNull$$$0(1);
        }
        if ((parameterList = (PsiParameterList)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)(offset = editor.getCaretModel().getOffset()), PsiParameterList.class, (boolean)false)) == null) {
            return null;
        }
        for (PsiParameter parameter2 : parameters2 = parameterList.getParameters()) {
            TextRange range = parameter2.getTextRange();
            if (range.getStartOffset() > offset || offset > range.getEndOffset()) continue;
            return parameter2;
        }
        return null;
    }

    @NotNull
    public static PsiType getType(@NotNull PsiParameter myParameter) {
        PsiType type2;
        if (myParameter == null) {
            FieldFromParameterUtils.$$$reportNull$$$0(2);
        }
        PsiType psiType = (type2 = myParameter.getType()) instanceof PsiEllipsisType ? ((PsiEllipsisType)type2).toArrayType() : type2;
        if (psiType == null) {
            FieldFromParameterUtils.$$$reportNull$$$0(3);
        }
        return psiType;
    }

    @Nullable
    public static PsiType getSubstitutedType(@NotNull PsiParameter parameter2) {
        PsiType type2;
        if (parameter2 == null) {
            FieldFromParameterUtils.$$$reportNull$$$0(4);
        }
        if ((type2 = FieldFromParameterUtils.getType(parameter2)) instanceof PsiArrayType) {
            return type2;
        }
        PsiClassType.ClassResolveResult result = PsiUtil.resolveGenericsClassInType((PsiType)type2);
        PsiClass psiClass = result.getElement();
        if (psiClass == null) {
            return type2;
        }
        HashSet<PsiTypeParameter> usedTypeParameters = new HashSet<PsiTypeParameter>();
        RefactoringUtil.collectTypeParameters(usedTypeParameters, (PsiElement)parameter2);
        usedTypeParameters.removeIf(usedTypeParameter -> parameter2.getDeclarationScope() != usedTypeParameter.getOwner());
        PsiSubstitutor subst = PsiSubstitutor.EMPTY;
        for (PsiTypeParameter usedTypeParameter2 : usedTypeParameters) {
            PsiType bound = TypeConversionUtil.typeParameterErasure((PsiTypeParameter)usedTypeParameter2);
            PsiManager manager = usedTypeParameter2.getManager();
            subst = subst.put(usedTypeParameter2, (PsiType)(bound == null ? PsiWildcardType.createUnbounded((PsiManager)manager) : (bound.equalsToText("java.lang.Object") ? bound : PsiWildcardType.createExtends((PsiManager)manager, (PsiType)bound))));
        }
        PsiSubstitutor substitutor = PsiSubstitutor.EMPTY;
        Map typeMap = result.getSubstitutor().getSubstitutionMap();
        Iterator iterator = typeMap.keySet().iterator();
        while (iterator.hasNext()) {
            PsiTypeParameter typeParameter;
            PsiType psiType = (PsiType)typeMap.get(typeParameter = (PsiTypeParameter)iterator.next());
            substitutor = substitutor.put(typeParameter, psiType != null ? subst.substitute(psiType) : null);
        }
        if (psiClass instanceof PsiTypeParameter) {
            return GenericsUtil.getVariableTypeByExpressionType((PsiType)subst.substitute((PsiTypeParameter)psiClass));
        }
        return JavaPsiFacade.getElementFactory((Project)parameter2.getProject()).createType(psiClass, substitutor);
    }

    @Nullable
    public static PsiField getParameterAssignedToField(@NotNull PsiParameter parameter2) {
        if (parameter2 == null) {
            FieldFromParameterUtils.$$$reportNull$$$0(5);
        }
        return FieldFromParameterUtils.getParameterAssignedToField(parameter2, true);
    }

    @Nullable
    public static PsiField getParameterAssignedToField(@NotNull PsiParameter parameter2, boolean findIndirectAssignments) {
        if (parameter2 == null) {
            FieldFromParameterUtils.$$$reportNull$$$0(6);
        }
        for (PsiReference reference : ReferencesSearch.search((PsiElement)parameter2, (SearchScope)new LocalSearchScope(parameter2.getDeclarationScope()), (boolean)false)) {
            PsiElement element;
            PsiExpression lExpression;
            PsiAssignmentExpression assignmentExpression;
            if (!(reference instanceof PsiReferenceExpression)) continue;
            PsiReferenceExpression expression2 = (PsiReferenceExpression)reference;
            if (findIndirectAssignments) {
                assignmentExpression = (PsiAssignmentExpression)PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiAssignmentExpression.class, (boolean)true, (Class[])new Class[]{PsiClass.class});
            } else {
                PsiMethodCallExpression call;
                PsiExpression returnedValue;
                PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)expression2.getParent());
                if (parent instanceof PsiExpressionList && (returnedValue = PsiUtil.skipParenthesizedExprDown((PsiExpression)JavaMethodContractUtil.findReturnedValue(call = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)parent.getParent(), PsiMethodCallExpression.class)))) == expression2) {
                    parent = PsiUtil.skipParenthesizedExprUp((PsiElement)call.getParent());
                }
                PsiAssignmentExpression psiAssignmentExpression = assignmentExpression = parent instanceof PsiAssignmentExpression ? (PsiAssignmentExpression)parent : null;
            }
            if (assignmentExpression == null || !PsiTreeUtil.isAncestor((PsiElement)assignmentExpression.getRExpression(), (PsiElement)expression2, (boolean)false) || !((lExpression = assignmentExpression.getLExpression()) instanceof PsiReferenceExpression) || !((element = ((PsiReferenceExpression)lExpression).resolve()) instanceof PsiField)) continue;
            return (PsiField)element;
        }
        return null;
    }

    public static int findFieldAssignmentAnchor(PsiStatement @NotNull [] statements, @Nullable Ref<? super PsiField> outAnchor, @Nullable AtomicBoolean outBefore, @NotNull PsiClass targetClass, @NotNull PsiParameter myParameter) {
        PsiStatement psiStatement;
        int i;
        if (targetClass == null) {
            FieldFromParameterUtils.$$$reportNull$$$0(7);
        }
        if (myParameter == null) {
            FieldFromParameterUtils.$$$reportNull$$$0(8);
        }
        if (statements == null) {
            FieldFromParameterUtils.$$$reportNull$$$0(9);
        }
        for (i = 0; i < statements.length && (psiStatement = statements[i]) instanceof PsiExpressionStatement; ++i) {
            PsiElement lElement;
            PsiAssignmentExpression assignmentExpression;
            PsiExpression lExpression;
            PsiExpressionStatement expressionStatement = (PsiExpressionStatement)psiStatement;
            PsiExpression expression2 = expressionStatement.getExpression();
            if (expression2 instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression2;
                String text2 = methodCallExpression.getMethodExpression().getText();
                if (!text2.equals("super") && !text2.equals("this")) break;
                continue;
            }
            if (!(expression2 instanceof PsiAssignmentExpression) || !((lExpression = (assignmentExpression = (PsiAssignmentExpression)expression2).getLExpression()) instanceof PsiReferenceExpression) || !((lElement = ((PsiReferenceExpression)lExpression).resolve()) instanceof PsiField) || ((PsiField)lElement).getContainingClass() != targetClass) break;
            HashSet parameters2 = new HashSet();
            ((SyntaxTraverser)SyntaxTraverser.psiTraverser().withRoot((Object)assignmentExpression.getRExpression())).filter(PsiReferenceExpression.class).forEach(expr2 -> {
                PsiElement resolve2 = expr2.resolve();
                if (resolve2 instanceof PsiParameter && ((PsiParameter)resolve2).getDeclarationScope() == myParameter.getDeclarationScope()) {
                    parameters2.add((PsiParameter)resolve2);
                }
            });
            if (parameters2.size() != 1) break;
            PsiElement rElement = (PsiElement)parameters2.iterator().next();
            if (myParameter.getTextRange().getStartOffset() < rElement.getTextRange().getStartOffset()) {
                if (outAnchor != null) {
                    outAnchor.set((Object)((PsiField)lElement));
                }
                if (outBefore == null) break;
                outBefore.set(true);
                break;
            }
            if (outAnchor != null) {
                outAnchor.set((Object)((PsiField)lElement));
            }
            if (outBefore == null) continue;
            outBefore.set(false);
        }
        return i;
    }

    public static void createFieldAndAddAssignment(@NotNull Project project, @NotNull PsiClass targetClass, @NotNull PsiMethod method, @NotNull PsiParameter parameter2, @NotNull PsiType fieldType, @NotNull String fieldName, boolean isStatic, boolean isFinal) throws IncorrectOperationException {
        PsiCodeBlock methodBody2;
        PsiManager psiManager;
        JavaPsiFacade psiFacade;
        PsiElementFactory factory;
        PsiField field;
        PsiModifierList modifierList;
        if (project == null) {
            FieldFromParameterUtils.$$$reportNull$$$0(10);
        }
        if (targetClass == null) {
            FieldFromParameterUtils.$$$reportNull$$$0(11);
        }
        if (method == null) {
            FieldFromParameterUtils.$$$reportNull$$$0(12);
        }
        if (parameter2 == null) {
            FieldFromParameterUtils.$$$reportNull$$$0(13);
        }
        if (fieldType == null) {
            FieldFromParameterUtils.$$$reportNull$$$0(14);
        }
        if (fieldName == null) {
            FieldFromParameterUtils.$$$reportNull$$$0(15);
        }
        if ((modifierList = (field = (factory = (psiFacade = JavaPsiFacade.getInstance((Project)(psiManager = PsiManager.getInstance((Project)project)).getProject())).getElementFactory()).createField(fieldName, fieldType)).getModifierList()) == null) {
            return;
        }
        modifierList.setModifierProperty("static", isStatic);
        modifierList.setModifierProperty("final", isFinal);
        NullableNotNullManager manager = NullableNotNullManager.getInstance((Project)project);
        if (manager.copyNullableAnnotation((PsiModifierListOwner)parameter2, (PsiModifierListOwner)field) == null && isFinal) {
            manager.copyNotNullAnnotation((PsiModifierListOwner)parameter2, (PsiModifierListOwner)field);
        }
        if ((methodBody2 = method.getBody()) == null) {
            return;
        }
        PsiStatement[] statements = methodBody2.getStatements();
        Ref anchor = new Ref();
        AtomicBoolean isBefore = new AtomicBoolean();
        int i = FieldFromParameterUtils.findFieldAssignmentAnchor(statements, (Ref<? super PsiField>)anchor, isBefore, targetClass, parameter2);
        String stmtText = fieldName + " = " + parameter2.getName() + ";";
        PsiVariable variable = psiFacade.getResolveHelper().resolveReferencedVariable(fieldName, (PsiElement)methodBody2);
        if (variable != null && !(variable instanceof PsiField)) {
            String prefix = isStatic ? (targetClass.getName() == null ? "" : targetClass.getName() + ".") : "this.";
            stmtText = prefix + stmtText;
        }
        PsiStatement assignmentStmt = factory.createStatementFromText(stmtText, (PsiElement)methodBody2);
        assignmentStmt = (PsiStatement)CodeStyleManager.getInstance((Project)project).reformat((PsiElement)assignmentStmt);
        if (i == statements.length) {
            methodBody2.add((PsiElement)assignmentStmt);
        } else {
            methodBody2.addAfter((PsiElement)assignmentStmt, i > 0 ? statements[i - 1] : null);
        }
        if (!anchor.isNull()) {
            PsiVariable psiVariable = (PsiVariable)anchor.get();
            psiVariable.normalizeDeclaration();
        }
        if (targetClass.findFieldByName(fieldName, false) == null) {
            if (!anchor.isNull()) {
                PsiField inField = (PsiField)anchor.get();
                if (isBefore.get()) {
                    targetClass.addBefore((PsiElement)field, (PsiElement)inField);
                } else {
                    targetClass.addAfter((PsiElement)field, (PsiElement)inField);
                }
            } else {
                targetClass.add((PsiElement)field);
            }
        }
    }

    public static boolean isAvailable(@NotNull PsiParameter myParameter, @Nullable PsiType type2, @Nullable PsiClass targetClass) {
        if (myParameter == null) {
            FieldFromParameterUtils.$$$reportNull$$$0(16);
        }
        return FieldFromParameterUtils.isAvailable(myParameter, type2, targetClass, true);
    }

    public static boolean isAvailable(@NotNull PsiParameter myParameter, @Nullable PsiType type2, @Nullable PsiClass targetClass, boolean findIndirectAssignments) {
        if (myParameter == null) {
            FieldFromParameterUtils.$$$reportNull$$$0(17);
        }
        return myParameter.isValid() && BaseIntentionAction.canModify((PsiElement)myParameter) && myParameter.getDeclarationScope() instanceof PsiMethod && ((PsiMethod)myParameter.getDeclarationScope()).getBody() != null && type2 != null && type2.isValid() && targetClass != null && !targetClass.isInterface() && FieldFromParameterUtils.getParameterAssignedToField(myParameter, findIndirectAssignments) == null;
    }

    private FieldFromParameterUtils() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 8: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "myParameter";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/intention/impl/FieldFromParameterUtils";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetClass";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statements";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldType";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/intention/impl/FieldFromParameterUtils";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findParameterAtCursor";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getSubstitutedType";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getParameterAssignedToField";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findFieldAssignmentAnchor";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createFieldAndAddAssignment";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

