/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl.singlereturn;

import com.intellij.codeInsight.BlockUtils;
import com.intellij.codeInsight.intention.impl.singlereturn.ExitContext;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.RuntimeExceptionWithAttachments;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.controlFlow.LocalsControlFlowPolicy;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.SideEffectChecker;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ReturnReplacementContext {
    private final Project myProject;
    private final PsiElementFactory myFactory;
    private final PsiCodeBlock myBlock;
    private final ExitContext myExitContext;
    private PsiReturnStatement myReturnStatement;
    private final List<String> myReplacements = new ArrayList<String>(3);

    private ReturnReplacementContext(Project project, PsiCodeBlock block, ExitContext context, PsiReturnStatement statement) {
        this.myProject = project;
        this.myFactory = JavaPsiFacade.getElementFactory((Project)project);
        this.myBlock = block;
        this.myExitContext = context;
        this.myReturnStatement = statement;
    }

    private void process() {
        PsiExpression value2 = this.myReturnStatement.getReturnValue();
        PsiStatement currentContext = this.goUp();
        if (currentContext == null) {
            return;
        }
        if (value2 != null) {
            this.myExitContext.registerReturnValue(value2, this.myReplacements);
        }
        while (currentContext != null) {
            currentContext = this.advance(currentContext);
        }
        this.replace();
    }

    @Nullable
    private PsiStatement goUp() {
        PsiElement parent = this.myReturnStatement.getParent();
        while (parent instanceof PsiCodeBlock) {
            PsiElement grandParent = parent.getParent();
            if (!(grandParent instanceof PsiSwitchStatement)) {
                PsiStatement[] statements = ((PsiCodeBlock)parent).getStatements();
                boolean afterReturn = false;
                for (PsiStatement statement : statements) {
                    if (statement == this.myReturnStatement) {
                        afterReturn = true;
                        continue;
                    }
                    if (!afterReturn) continue;
                    new CommentTracker().deleteAndRestoreComments((PsiElement)statement);
                }
            }
            if (grandParent instanceof PsiBlockStatement) {
                parent = grandParent.getParent();
                continue;
            }
            if (grandParent instanceof PsiCatchSection) {
                parent = grandParent.getParent();
                break;
            }
            if (grandParent instanceof PsiStatement) {
                parent = grandParent;
                break;
            }
            if (parent == this.myBlock) {
                return null;
            }
            throw new RuntimeExceptionWithAttachments("Unexpected structure: " + grandParent.getClass(), new Attachment[]{new Attachment("body.txt", this.myBlock.getText()), new Attachment("context.txt", grandParent.getText())});
        }
        if (!(parent instanceof PsiStatement)) {
            throw new RuntimeExceptionWithAttachments("Unexpected structure: " + parent.getClass(), new Attachment[]{new Attachment("body.txt", this.myBlock.getText()), new Attachment("context.txt", parent.getText())});
        }
        PsiStatement currentContext = (PsiStatement)parent;
        PsiStatement loopOrSwitch = (PsiStatement)PsiTreeUtil.getNonStrictParentOfType((PsiElement)currentContext, (Class[])new Class[]{PsiLoopStatement.class, PsiSwitchStatement.class});
        if (loopOrSwitch != null && PsiTreeUtil.isAncestor((PsiElement)this.myBlock, (PsiElement)loopOrSwitch, (boolean)true)) {
            this.myReplacements.add("break;");
            return loopOrSwitch;
        }
        while (currentContext instanceof PsiIfStatement) {
            PsiCodeBlock resultBlock;
            PsiIfStatement ifStatement = (PsiIfStatement)currentContext;
            boolean inThen = PsiTreeUtil.isAncestor((PsiElement)ifStatement.getThenBranch(), (PsiElement)this.myReturnStatement, (boolean)false);
            PsiElement ifParent = currentContext.getParent();
            if (!(ifParent instanceof PsiCodeBlock) || (resultBlock = this.swallowTail(currentContext, ifStatement, inThen, (PsiCodeBlock)ifParent)) == null || ControlFlowUtils.codeBlockMayCompleteNormally(resultBlock) || !(ifParent.getParent() instanceof PsiBlockStatement) || !(ifParent.getParent().getParent() instanceof PsiIfStatement)) break;
            currentContext = (PsiStatement)ifParent.getParent().getParent();
        }
        return currentContext;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    private PsiStatement advance(PsiStatement currentContext) {
        PsiElement contextParent = currentContext.getParent();
        if (contextParent instanceof PsiLoopStatement) {
            Object mark = new Object();
            PsiTreeUtil.mark((PsiElement)this.myReturnStatement, (Object)mark);
            currentContext = BlockUtils.expandSingleStatementToBlockStatement(currentContext);
            contextParent = currentContext.getParent();
            this.myReturnStatement = (PsiReturnStatement)Objects.requireNonNull(PsiTreeUtil.releaseMark((PsiElement)currentContext, (Object)mark));
        }
        if (contextParent instanceof PsiCodeBlock) {
            Object[] tail = ReturnReplacementContext.extractTail(currentContext, (PsiCodeBlock)contextParent);
            PsiStatement loopOrSwitch = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)currentContext, (Class[])new Class[]{PsiLoopStatement.class, PsiSwitchStatement.class});
            if (loopOrSwitch != null && PsiTreeUtil.isAncestor((PsiElement)this.myBlock, (PsiElement)loopOrSwitch, (boolean)true)) {
                this.myExitContext.register(this.myReplacements);
                String exitStatement = "if(" + this.myExitContext.generateExitCondition() + ") break;";
                contextParent.addAfter((PsiElement)this.myFactory.createStatementFromText(exitStatement, (PsiElement)currentContext), (PsiElement)currentContext);
                return loopOrSwitch;
            }
            List statements = StreamEx.of((Object[])tail).select(PsiStatement.class).toList();
            if (!statements.isEmpty()) {
                PsiStatement statement = (PsiStatement)statements.get(0);
                if (statements.size() == 1 && this.myExitContext.isDefaultReturn(statement)) {
                    new CommentTracker().deleteAndRestoreComments((PsiElement)statement);
                } else {
                    this.myExitContext.register(this.myReplacements);
                    if (!this.myExitContext.isFinishCondition(statement)) {
                        String conditionalBlock = "if(" + this.myExitContext.getNonExitCondition() + ") {}";
                        PsiIfStatement ifStatement = (PsiIfStatement)this.myFactory.createStatementFromText(conditionalBlock, (PsiElement)currentContext);
                        PsiCodeBlock ifBlock = Objects.requireNonNull(((PsiBlockStatement)Objects.requireNonNull(ifStatement.getThenBranch())).getCodeBlock());
                        PsiJavaToken lBrace = Objects.requireNonNull(ifBlock.getLBrace());
                        PsiElement tailStart = (PsiElement)ArrayUtil.getFirstElement((Object[])tail);
                        PsiElement tailEnd = (PsiElement)ArrayUtil.getLastElement((Object[])tail);
                        ifBlock.addRangeAfter(tailStart, tailEnd, (PsiElement)lBrace);
                        contextParent.deleteChildRange(tailStart, tailEnd);
                        PsiElement insertedIf = contextParent.addAfter((PsiElement)ifStatement, (PsiElement)currentContext);
                        this.fixNonInitializedVars(insertedIf);
                    }
                }
            }
            if (contextParent == this.myBlock) {
                return null;
            }
            if (contextParent.getParent() instanceof PsiStatement) {
                return (PsiStatement)contextParent.getParent();
            }
            if (!(contextParent.getParent() instanceof PsiCatchSection)) throw new RuntimeExceptionWithAttachments("Unexpected structure: " + contextParent.getParent().getClass(), new Attachment[]{new Attachment("body.txt", this.myBlock.getText()), new Attachment("context.txt", contextParent.getText())});
            return (PsiStatement)contextParent.getParent().getParent();
        }
        if (contextParent instanceof PsiIfStatement) return (PsiStatement)contextParent;
        if (!(contextParent instanceof PsiLabeledStatement)) throw new RuntimeExceptionWithAttachments("Unexpected structure: " + contextParent.getClass(), new Attachment[]{new Attachment("body.txt", this.myBlock.getText()), new Attachment("context.txt", contextParent.getText())});
        return (PsiStatement)contextParent;
    }

    private void fixNonInitializedVars(PsiElement element) {
        HashSet locals = new HashSet();
        PsiTreeUtil.processElements((PsiElement)element, e -> {
            PsiLocalVariable variable;
            if (e instanceof PsiReferenceExpression && (variable = ExpressionUtils.resolveLocalVariable((PsiExpression)e)) != null && variable.getInitializer() == null && PsiTreeUtil.isAncestor((PsiElement)this.myBlock, (PsiElement)variable, (boolean)true)) {
                locals.add(variable);
            }
            return true;
        });
        if (!locals.isEmpty()) {
            ControlFlow flow;
            try {
                flow = ControlFlowFactory.getInstance(this.myProject).getControlFlow((PsiElement)this.myBlock, new LocalsControlFlowPolicy((PsiElement)this.myBlock), false, false);
            }
            catch (AnalysisCanceledException ignored) {
                return;
            }
            int offset = flow.getStartOffset(element);
            if (offset == -1) {
                return;
            }
            for (PsiLocalVariable local : locals) {
                if (!ControlFlowUtil.getVariablePossiblyUnassignedOffsets((PsiVariable)local, flow)[offset]) continue;
                local.setInitializer(this.myFactory.createExpressionFromText(PsiTypesUtil.getDefaultValueOfType((PsiType)local.getType()), null));
            }
        }
    }

    private static PsiElement @NotNull [] extractTail(PsiStatement current, PsiCodeBlock block) {
        int endPos;
        Object[] children = block.getChildren();
        int pos = ArrayUtil.indexOf((Object[])children, (Object)current);
        assert (pos >= 0);
        PsiJavaToken rBrace = block.getRBrace();
        int n = endPos = rBrace == null ? children.length : ArrayUtil.lastIndexOf((Object[])children, (Object)rBrace);
        assert (endPos >= pos);
        if (pos + 1 < children.length && children[pos + 1] instanceof PsiWhiteSpace) {
            ++pos;
        }
        PsiElement[] psiElementArray = (PsiElement[])Arrays.copyOfRange(children, pos + 1, endPos);
        if (psiElementArray == null) {
            ReturnReplacementContext.$$$reportNull$$$0(0);
        }
        return psiElementArray;
    }

    private PsiCodeBlock swallowTail(PsiStatement currentContext, PsiIfStatement ifStatement, boolean inThen, PsiCodeBlock ifParent) {
        PsiElement[] tail = ReturnReplacementContext.extractTail(currentContext, ifParent);
        if (Arrays.stream(tail).noneMatch(PsiStatement.class::isInstance)) {
            return null;
        }
        PsiBlockStatement blockForTail = this.getBlockFromIf(ifStatement, inThen);
        PsiCodeBlock codeBlock = blockForTail.getCodeBlock();
        PsiJavaToken brace = Objects.requireNonNull(codeBlock.getRBrace());
        for (PsiElement element : tail) {
            if (!element.isValid()) continue;
            codeBlock.addBefore(element, (PsiElement)brace);
            element.delete();
        }
        return codeBlock;
    }

    @NotNull
    private PsiBlockStatement getBlockFromIf(PsiIfStatement ifStatement, boolean inThen) {
        if (inThen) {
            PsiStatement elseBranch = ifStatement.getElseBranch();
            if (elseBranch == null) {
                ifStatement.setElseBranch((PsiStatement)BlockUtils.createBlockStatement(this.myProject));
                PsiBlockStatement psiBlockStatement = (PsiBlockStatement)ifStatement.getElseBranch();
                if (psiBlockStatement == null) {
                    ReturnReplacementContext.$$$reportNull$$$0(1);
                }
                return psiBlockStatement;
            }
            if (!(elseBranch instanceof PsiBlockStatement)) {
                PsiBlockStatement psiBlockStatement = (PsiBlockStatement)BlockUtils.expandSingleStatementToBlockStatement(elseBranch).getParent().getParent();
                if (psiBlockStatement == null) {
                    ReturnReplacementContext.$$$reportNull$$$0(2);
                }
                return psiBlockStatement;
            }
            PsiBlockStatement psiBlockStatement = (PsiBlockStatement)elseBranch;
            if (psiBlockStatement == null) {
                ReturnReplacementContext.$$$reportNull$$$0(3);
            }
            return psiBlockStatement;
        }
        PsiStatement thenBranch = ifStatement.getThenBranch();
        if (thenBranch == null) {
            ifStatement.setThenBranch((PsiStatement)BlockUtils.createBlockStatement(this.myProject));
            PsiBlockStatement psiBlockStatement = (PsiBlockStatement)ifStatement.getThenBranch();
            if (psiBlockStatement == null) {
                ReturnReplacementContext.$$$reportNull$$$0(4);
            }
            return psiBlockStatement;
        }
        if (!(thenBranch instanceof PsiBlockStatement)) {
            PsiBlockStatement psiBlockStatement = (PsiBlockStatement)BlockUtils.expandSingleStatementToBlockStatement(thenBranch).getParent().getParent();
            if (psiBlockStatement == null) {
                ReturnReplacementContext.$$$reportNull$$$0(5);
            }
            return psiBlockStatement;
        }
        PsiBlockStatement psiBlockStatement = (PsiBlockStatement)thenBranch;
        if (psiBlockStatement == null) {
            ReturnReplacementContext.$$$reportNull$$$0(6);
        }
        return psiBlockStatement;
    }

    private void replace() {
        PsiStatement[] newStatements;
        if (!(this.myReturnStatement.getParent() instanceof PsiCodeBlock)) {
            this.myReturnStatement = BlockUtils.expandSingleStatementToBlockStatement(this.myReturnStatement);
        }
        if ((newStatements = (PsiStatement[])ContainerUtil.map2Array(this.myReplacements, PsiStatement.class, text2 -> this.myFactory.createStatementFromText(text2, null))).length > 0) {
            BlockUtils.addBefore((PsiStatement)this.myReturnStatement, newStatements);
        }
        PsiCodeBlock block = (PsiCodeBlock)ObjectUtils.tryCast((Object)this.myReturnStatement.getParent(), PsiCodeBlock.class);
        new CommentTracker().deleteAndRestoreComments((PsiElement)this.myReturnStatement);
        PsiElement place = ReturnReplacementContext.cleanUpEmptyBlocks(block);
        this.stripUnnecessaryBlocks(place);
    }

    private void stripUnnecessaryBlocks(PsiElement place) {
        while (place != null && place != this.myBlock) {
            PsiIfStatement childIf;
            PsiIfStatement parentIf;
            if (place instanceof PsiBlockStatement && (parentIf = (PsiIfStatement)ObjectUtils.tryCast((Object)place.getParent(), PsiIfStatement.class)) != null && parentIf.getElseBranch() == place && (childIf = (PsiIfStatement)ObjectUtils.tryCast((Object)ControlFlowUtils.stripBraces((PsiStatement)place), PsiIfStatement.class)) != null) {
                place = place.replace((PsiElement)childIf);
            }
            place = place.getParent();
        }
    }

    private static PsiElement cleanUpEmptyBlocks(PsiCodeBlock block) {
        if (block == null || !block.isEmpty()) {
            return block;
        }
        PsiBlockStatement blockStatement = (PsiBlockStatement)ObjectUtils.tryCast((Object)block.getParent(), PsiBlockStatement.class);
        if (blockStatement == null) {
            return block;
        }
        PsiIfStatement parent = (PsiIfStatement)ObjectUtils.tryCast((Object)blockStatement.getParent(), PsiIfStatement.class);
        if (parent == null) {
            return block;
        }
        PsiExpression condition2 = parent.getCondition();
        if (condition2 == null) {
            return block;
        }
        if (blockStatement == parent.getElseBranch()) {
            new CommentTracker().deleteAndRestoreComments((PsiElement)blockStatement);
            return parent;
        }
        if (blockStatement == parent.getThenBranch()) {
            if (parent.getElseBranch() != null) {
                new CommentTracker().replaceAndRestoreComments((PsiElement)blockStatement, (PsiElement)parent.getElseBranch());
                parent.getElseBranch().delete();
                CommentTracker ct = new CommentTracker();
                String negatedCondition = BoolUtils.getNegatedExpressionText(condition2, ct);
                ct.replaceAndRestoreComments((PsiElement)condition2, negatedCondition);
                return parent;
            }
            if (!SideEffectChecker.mayHaveSideEffects(condition2)) {
                PsiCodeBlock parentBlock = (PsiCodeBlock)ObjectUtils.tryCast((Object)parent.getParent(), PsiCodeBlock.class);
                new CommentTracker().deleteAndRestoreComments((PsiElement)parent);
                return ReturnReplacementContext.cleanUpEmptyBlocks(parentBlock);
            }
        }
        return block;
    }

    static void replaceSingleReturn(@NotNull Project project, PsiCodeBlock block, ExitContext exitContext, PsiReturnStatement returnStatement) {
        if (project == null) {
            ReturnReplacementContext.$$$reportNull$$$0(7);
        }
        new ReturnReplacementContext(project, block, exitContext, returnStatement).process();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/intention/impl/singlereturn/ReturnReplacementContext";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "extractTail";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getBlockFromIf";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/intention/impl/singlereturn/ReturnReplacementContext";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "replaceSingleReturn";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

