/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.javadoc;

import com.intellij.codeInsight.AnnotationTargetUtil;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.javadoc.AnnotationFormat;
import com.intellij.codeInsight.javadoc.JavaDocInfoGenerator;
import com.intellij.codeInsight.javadoc.JavaDocUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiQualifiedReferenceElement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.intellij.lang.annotations.Flow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnnotationDocGenerator {
    private static final Logger LOG = Logger.getInstance(AnnotationDocGenerator.class);
    @NotNull
    private final PsiAnnotation myAnnotation;
    @NotNull
    private final PsiJavaCodeReferenceElement myNameReference;
    @NotNull
    private final PsiElement myContext;
    @Nullable
    private final PsiClass myTargetClass;
    private final boolean myResolveNotPossible;

    private AnnotationDocGenerator(@NotNull PsiAnnotation annotation, @NotNull PsiJavaCodeReferenceElement nameReference, @NotNull PsiElement context) {
        if (annotation == null) {
            AnnotationDocGenerator.$$$reportNull$$$0(0);
        }
        if (nameReference == null) {
            AnnotationDocGenerator.$$$reportNull$$$0(1);
        }
        if (context == null) {
            AnnotationDocGenerator.$$$reportNull$$$0(2);
        }
        this.myAnnotation = annotation;
        this.myNameReference = nameReference;
        this.myContext = context;
        boolean indexNotReady = false;
        PsiElement target = null;
        try {
            target = nameReference.resolve();
        }
        catch (IndexNotReadyException e) {
            LOG.debug((Throwable)e);
            indexNotReady = true;
        }
        this.myTargetClass = (PsiClass)ObjectUtils.tryCast((Object)target, PsiClass.class);
        this.myResolveNotPossible = indexNotReady;
    }

    boolean isNonDocumentedAnnotation() {
        return this.myTargetClass != null ? !JavaDocInfoGenerator.isDocumentedAnnotationType(this.myTargetClass) : AnnotationDocGenerator.isKnownNonDocumented(this.myAnnotation.getQualifiedName());
    }

    private static boolean isKnownNonDocumented(String annoQName) {
        return Flow.class.getName().equals(annoQName);
    }

    boolean isExternal() {
        return AnnotationUtil.isExternalAnnotation((PsiAnnotation)this.myAnnotation);
    }

    public String getAnnotationQualifiedName() {
        return this.myAnnotation.getQualifiedName();
    }

    public boolean isInferred() {
        return AnnotationUtil.isInferredAnnotation((PsiAnnotation)this.myAnnotation);
    }

    void generateAnnotation(StringBuilder buffer, AnnotationFormat format) {
        String name2;
        boolean highlightNonCodeAnnotations;
        String qualifiedName = this.myAnnotation.getQualifiedName();
        PsiClassType type2 = this.myTargetClass != null && qualifiedName != null && JavaDocUtil.findReferenceTarget(this.myContext.getManager(), qualifiedName, this.myContext) != null ? JavaPsiFacade.getElementFactory((Project)this.myContext.getProject()).createType(this.myTargetClass, PsiSubstitutor.EMPTY) : null;
        boolean red = type2 == null && !this.myResolveNotPossible && !this.isInferred() && !this.isExternal();
        boolean bl = highlightNonCodeAnnotations = format == AnnotationFormat.ToolTip && (this.isInferred() || this.isExternal());
        if (highlightNonCodeAnnotations) {
            buffer.append("<b>");
        }
        if (this.isInferred()) {
            buffer.append("<i>");
        }
        if (red) {
            buffer.append("<font color=red>");
        }
        boolean generateLink = format != AnnotationFormat.ToolTip;
        boolean forceShortNames = format != AnnotationFormat.JavaDocComplete;
        buffer.append("@");
        String string = name2 = forceShortNames ? this.myNameReference.getReferenceName() : this.myNameReference.getText();
        if (type2 != null && generateLink) {
            JavaDocInfoGenerator.generateLink(buffer, (PsiElement)this.myTargetClass, name2, format == AnnotationFormat.JavaDocComplete);
        } else {
            buffer.append(name2);
        }
        if (red) {
            buffer.append("</font>");
        }
        this.generateAnnotationAttributes(buffer, generateLink);
        if (this.isInferred()) {
            buffer.append("</i>");
        }
        if (highlightNonCodeAnnotations) {
            buffer.append("</b>");
        }
    }

    private void generateAnnotationAttributes(StringBuilder buffer, boolean generateLink) {
        PsiNameValuePair[] attributes = this.myAnnotation.getParameterList().getAttributes();
        if (attributes.length > 0) {
            buffer.append("(");
            boolean first = true;
            for (PsiNameValuePair pair2 : attributes) {
                if (!first) {
                    buffer.append(",&nbsp;");
                }
                first = false;
                AnnotationDocGenerator.generateAnnotationAttribute(buffer, generateLink, pair2);
            }
            buffer.append(")");
        }
    }

    private static void generateAnnotationAttribute(StringBuilder buffer, boolean generateLink, PsiNameValuePair pair2) {
        PsiAnnotationMemberValue value2;
        String name2 = pair2.getName();
        if (name2 != null) {
            buffer.append(name2);
            buffer.append(" = ");
        }
        if ((value2 = pair2.getValue()) != null) {
            if (value2 instanceof PsiArrayInitializerMemberValue) {
                buffer.append("{");
                boolean firstMember = true;
                for (PsiAnnotationMemberValue memberValue : ((PsiArrayInitializerMemberValue)value2).getInitializers()) {
                    if (!firstMember) {
                        buffer.append(",");
                    }
                    firstMember = false;
                    AnnotationDocGenerator.appendLinkOrText(buffer, memberValue, generateLink);
                }
                buffer.append("}");
            } else {
                AnnotationDocGenerator.appendLinkOrText(buffer, value2, generateLink);
            }
        }
    }

    private static void appendLinkOrText(StringBuilder buffer, PsiAnnotationMemberValue memberValue, boolean generateLink) {
        if (generateLink && memberValue instanceof PsiQualifiedReferenceElement) {
            String text2 = ((PsiQualifiedReferenceElement)memberValue).getCanonicalText();
            PsiElement resolve2 = null;
            try {
                resolve2 = ((PsiQualifiedReferenceElement)memberValue).resolve();
            }
            catch (Exception e) {
                LOG.debug((Throwable)e);
            }
            if (resolve2 instanceof PsiField) {
                PsiField field = (PsiField)resolve2;
                PsiClass aClass = field.getContainingClass();
                int startOfPropertyNamePosition = text2.lastIndexOf(46);
                if (startOfPropertyNamePosition != -1) {
                    text2 = text2.substring(0, startOfPropertyNamePosition) + '#' + text2.substring(startOfPropertyNamePosition + 1);
                } else if (aClass != null) {
                    text2 = aClass.getQualifiedName() + '#' + field.getName();
                }
                JavaDocInfoGenerator.generateLink(buffer, text2, aClass != null ? aClass.getName() + '.' + field.getName() : null, (PsiElement)memberValue, false);
                return;
            }
        }
        buffer.append(XmlStringUtil.escapeString((String)memberValue.getText()));
    }

    public static List<AnnotationDocGenerator> getAnnotationsToShow(@NotNull PsiAnnotationOwner owner2, @NotNull PsiElement context) {
        if (owner2 == null) {
            AnnotationDocGenerator.$$$reportNull$$$0(3);
        }
        if (context == null) {
            AnnotationDocGenerator.$$$reportNull$$$0(4);
        }
        if (owner2 instanceof PsiModifierList) {
            return AnnotationDocGenerator.getAnnotationsToShow((PsiModifierListOwner)((PsiModifierList)owner2).getParent());
        }
        HashSet shownAnnotations = new HashSet();
        return ContainerUtil.mapNotNull((Object[])owner2.getAnnotations(), annotation -> AnnotationDocGenerator.forAnnotation(context, shownAnnotations, annotation));
    }

    public static List<AnnotationDocGenerator> getAnnotationsToShow(@NotNull PsiModifierListOwner owner2) {
        if (owner2 == null) {
            AnnotationDocGenerator.$$$reportNull$$$0(5);
        }
        HashSet shownAnnotations = new HashSet();
        return ((StreamEx)StreamEx.of((Object[])AnnotationUtil.getAllAnnotations((PsiModifierListOwner)owner2, (boolean)false, null)).filter(owner2 instanceof PsiClass || owner2 instanceof PsiJavaModule ? anno -> true : anno -> !AnnotationTargetUtil.isTypeAnnotation((PsiAnnotation)anno))).map(annotation -> AnnotationDocGenerator.forAnnotation((PsiElement)owner2, shownAnnotations, annotation)).nonNull().toList();
    }

    @Nullable
    private static AnnotationDocGenerator forAnnotation(@NotNull PsiElement context, @NotNull Set<String> shownAnnotations, @NotNull PsiAnnotation annotation) {
        PsiJavaCodeReferenceElement nameReferenceElement;
        if (context == null) {
            AnnotationDocGenerator.$$$reportNull$$$0(6);
        }
        if (shownAnnotations == null) {
            AnnotationDocGenerator.$$$reportNull$$$0(7);
        }
        if (annotation == null) {
            AnnotationDocGenerator.$$$reportNull$$$0(8);
        }
        if ((nameReferenceElement = annotation.getNameReferenceElement()) == null) {
            return null;
        }
        AnnotationDocGenerator anno = new AnnotationDocGenerator(annotation, nameReferenceElement, context);
        if (anno.isNonDocumentedAnnotation()) {
            return null;
        }
        if (!shownAnnotations.add(annotation.getQualifiedName()) && !JavaDocInfoGenerator.isRepeatableAnnotationType((PsiElement)annotation)) {
            return null;
        }
        return anno;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameReference";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shownAnnotations";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/javadoc/AnnotationDocGenerator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getAnnotationsToShow";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "forAnnotation";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

