/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightingFeature;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.java.JavaBundle;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.util.PsiLiteralUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import java.util.StringJoiner;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class TextBlockBackwardMigrationInspection
extends AbstractBaseJavaLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            TextBlockBackwardMigrationInspection.$$$reportNull$$$0(0);
        }
        if (!HighlightingFeature.TEXT_BLOCKS.isAvailable((PsiElement)holder.getFile())) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                TextBlockBackwardMigrationInspection.$$$reportNull$$$0(1);
            }
            return psiElementVisitor;
        }
        return new JavaElementVisitor(){

            public void visitLiteralExpression(PsiLiteralExpression expression2) {
                if (!expression2.isTextBlock() || PsiLiteralUtil.getTextBlockText((PsiLiteralExpression)expression2) == null) {
                    return;
                }
                holder.registerProblem((PsiElement)expression2, JavaBundle.message((String)"inspection.text.block.backward.migration.message", (Object[])new Object[0]), new LocalQuickFix[]{new ReplaceWithRegularStringLiteralFix()});
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/TextBlockBackwardMigrationInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/TextBlockBackwardMigrationInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ReplaceWithRegularStringLiteralFix
    implements LocalQuickFix {
        private ReplaceWithRegularStringLiteralFix() {
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = JavaBundle.message((String)"inspection.replace.with.regular.string.literal.fix", (Object[])new Object[0]);
            if (string == null) {
                ReplaceWithRegularStringLiteralFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiLiteralExpression literalExpression;
            if (project == null) {
                ReplaceWithRegularStringLiteralFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                ReplaceWithRegularStringLiteralFix.$$$reportNull$$$0(2);
            }
            if ((literalExpression = (PsiLiteralExpression)ObjectUtils.tryCast((Object)descriptor.getPsiElement(), PsiLiteralExpression.class)) == null || !literalExpression.isTextBlock()) {
                return;
            }
            String text2 = PsiLiteralUtil.getTextBlockText((PsiLiteralExpression)literalExpression);
            if (text2 == null) {
                return;
            }
            String replacement = ReplaceWithRegularStringLiteralFix.convertToConcatenation(text2);
            PsiFile file = descriptor.getPsiElement().getContainingFile();
            if (file == null) {
                return;
            }
            CodeStyleSettings tempSettings = CodeStyle.getSettings((PsiFile)file);
            tempSettings.getCommonSettings((Language)JavaLanguage.INSTANCE).ALIGN_MULTILINE_BINARY_OPERATION = true;
            CodeStyleManager manager = CodeStyleManager.getInstance((Project)literalExpression.getProject());
            CodeStyle.doWithTemporarySettings((Project)project, (CodeStyleSettings)tempSettings, () -> {
                PsiElement result = new CommentTracker().replaceAndRestoreComments((PsiElement)literalExpression, replacement);
                manager.reformat(result);
            });
        }

        @NotNull
        private static String convertToConcatenation(@NotNull String text2) {
            if (text2 == null) {
                ReplaceWithRegularStringLiteralFix.$$$reportNull$$$0(3);
            }
            if (text2.isEmpty()) {
                return "\"\"";
            }
            StringJoiner joiner = new StringJoiner(" +\n");
            String[] lines = ReplaceWithRegularStringLiteralFix.getTextBlockLines(text2).split("\n", -1);
            for (int i = 0; i < lines.length; ++i) {
                boolean addNewLine;
                String line = lines[i];
                boolean bl = addNewLine = i != lines.length - 1;
                if (!addNewLine && line.isEmpty()) break;
                joiner.add("\"" + line + (addNewLine ? "\\n\"" : "\""));
            }
            String string = joiner.toString();
            if (string == null) {
                ReplaceWithRegularStringLiteralFix.$$$reportNull$$$0(4);
            }
            return string;
        }

        @NotNull
        private static String getTextBlockLines(@NotNull String text2) {
            if (text2 == null) {
                ReplaceWithRegularStringLiteralFix.$$$reportNull$$$0(5);
            }
            int length = text2.length();
            StringBuilder result = new StringBuilder(length);
            int i = 0;
            while (i < length) {
                int nSlashes = 0;
                int next = i;
                while (next < length && (next = PsiLiteralUtil.parseBackSlash((String)text2, (int)next)) != -1) {
                    ++nSlashes;
                    i = next;
                }
                if (i >= length) {
                    result.append(StringUtil.repeatSymbol((char)'\\', (int)nSlashes));
                    break;
                }
                next = ReplaceWithRegularStringLiteralFix.parseQuote(i, text2, nSlashes, result);
                if (next != -1) {
                    i = next;
                    continue;
                }
                if (nSlashes != 0) {
                    i = ReplaceWithRegularStringLiteralFix.parseEscapedChar(i, text2, nSlashes, result);
                    continue;
                }
                result.append(text2.charAt(i));
                ++i;
            }
            String string = result.toString();
            if (string == null) {
                ReplaceWithRegularStringLiteralFix.$$$reportNull$$$0(6);
            }
            return string;
        }

        private static int parseEscapedChar(int i, @NotNull String text2, int nSlashes, @NotNull StringBuilder result) {
            int next;
            if (text2 == null) {
                ReplaceWithRegularStringLiteralFix.$$$reportNull$$$0(7);
            }
            if (result == null) {
                ReplaceWithRegularStringLiteralFix.$$$reportNull$$$0(8);
            }
            if ((next = ReplaceWithRegularStringLiteralFix.parseEscapedSpace(i, text2, nSlashes, result)) != -1) {
                return next;
            }
            next = ReplaceWithRegularStringLiteralFix.parseEscapedLineBreak(i, text2, nSlashes, result);
            if (next != -1) {
                return next;
            }
            result.append(StringUtil.repeatSymbol((char)'\\', (int)nSlashes)).append(text2.charAt(i));
            return i + 1;
        }

        private static int parseEscapedSpace(int i, @NotNull String text2, int nSlashes, @NotNull StringBuilder result) {
            char c;
            if (text2 == null) {
                ReplaceWithRegularStringLiteralFix.$$$reportNull$$$0(9);
            }
            if (result == null) {
                ReplaceWithRegularStringLiteralFix.$$$reportNull$$$0(10);
            }
            if ((c = text2.charAt(i)) == 's' && nSlashes % 2 != 0) {
                result.append(StringUtil.repeatSymbol((char)'\\', (int)(nSlashes - 1))).append(' ');
                return i + 1;
            }
            if (StringUtil.startsWith((CharSequence)text2, (int)i, (CharSequence)"040") && nSlashes % 2 != 0) {
                result.append(StringUtil.repeatSymbol((char)'\\', (int)(nSlashes - 1))).append(' ');
                return i + 3;
            }
            return -1;
        }

        private static int parseEscapedLineBreak(int i, @NotNull String text2, int nSlashes, @NotNull StringBuilder result) {
            char c;
            if (text2 == null) {
                ReplaceWithRegularStringLiteralFix.$$$reportNull$$$0(11);
            }
            if (result == null) {
                ReplaceWithRegularStringLiteralFix.$$$reportNull$$$0(12);
            }
            if ((c = text2.charAt(i)) == '\n' && nSlashes % 2 != 0) {
                result.append(StringUtil.repeatSymbol((char)'\\', (int)(nSlashes - 1)));
                return i + 1;
            }
            return -1;
        }

        private static int parseQuote(int i, @NotNull String text2, int nSlashes, @NotNull StringBuilder result) {
            char c;
            if (text2 == null) {
                ReplaceWithRegularStringLiteralFix.$$$reportNull$$$0(13);
            }
            if (result == null) {
                ReplaceWithRegularStringLiteralFix.$$$reportNull$$$0(14);
            }
            if ((c = text2.charAt(i)) != '\"') {
                return -1;
            }
            if (nSlashes % 2 == 0) {
                ++nSlashes;
            }
            result.append(StringUtil.repeatSymbol((char)'\\', (int)nSlashes)).append(c);
            return i + 1;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/TextBlockBackwardMigrationInspection$ReplaceWithRegularStringLiteralFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 3: 
                case 5: 
                case 7: 
                case 9: 
                case 11: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 8: 
                case 10: 
                case 12: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/TextBlockBackwardMigrationInspection$ReplaceWithRegularStringLiteralFix";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "convertToConcatenation";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTextBlockLines";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "convertToConcatenation";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getTextBlockLines";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "parseEscapedChar";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "parseEscapedSpace";
                    break;
                }
                case 11: 
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "parseEscapedLineBreak";
                    break;
                }
                case 13: 
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "parseQuote";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

