/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInsight.Nullability;
import com.intellij.codeInspection.dataFlow.Mutability;
import com.intellij.codeInspection.dataFlow.TypeConstraints;
import com.intellij.codeInspection.dataFlow.types.DfNullConstantType;
import com.intellij.codeInspection.dataFlow.types.DfReferenceType;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum DfaNullability {
    NULL("Null", "null", Nullability.NULLABLE),
    NULLABLE("Nullable", "nullable", Nullability.NULLABLE),
    NOT_NULL("Not-null", "non-null", Nullability.NOT_NULL),
    UNKNOWN("Unknown", "", Nullability.UNKNOWN),
    FLUSHED("Flushed", "", Nullability.UNKNOWN);

    @NotNull
    private final String myInternalName;
    @NotNull
    private final String myPresentationalName;
    @NotNull
    private final Nullability myNullability;

    private DfaNullability(@NotNull String internalName, String presentationalName, Nullability nullability) {
        if (internalName == null) {
            DfaNullability.$$$reportNull$$$0(0);
        }
        if (presentationalName == null) {
            DfaNullability.$$$reportNull$$$0(1);
        }
        if (nullability == null) {
            DfaNullability.$$$reportNull$$$0(2);
        }
        this.myInternalName = internalName;
        this.myPresentationalName = presentationalName;
        this.myNullability = nullability;
    }

    @NotNull
    public String getInternalName() {
        String string = this.myInternalName;
        if (string == null) {
            DfaNullability.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public String getPresentationName() {
        String string = this.myPresentationalName;
        if (string == null) {
            DfaNullability.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public DfaNullability unite(@NotNull DfaNullability other) {
        if (other == null) {
            DfaNullability.$$$reportNull$$$0(5);
        }
        if (this == other) {
            DfaNullability dfaNullability = this;
            if (dfaNullability == null) {
                DfaNullability.$$$reportNull$$$0(6);
            }
            return dfaNullability;
        }
        if (this == NULL || other == NULL || this == NULLABLE || other == NULLABLE) {
            DfaNullability dfaNullability = NULLABLE;
            if (dfaNullability == null) {
                DfaNullability.$$$reportNull$$$0(7);
            }
            return dfaNullability;
        }
        if (this == FLUSHED || other == FLUSHED) {
            DfaNullability dfaNullability = FLUSHED;
            if (dfaNullability == null) {
                DfaNullability.$$$reportNull$$$0(8);
            }
            return dfaNullability;
        }
        DfaNullability dfaNullability = UNKNOWN;
        if (dfaNullability == null) {
            DfaNullability.$$$reportNull$$$0(9);
        }
        return dfaNullability;
    }

    @Nullable
    public DfaNullability intersect(@NotNull DfaNullability right) {
        if (right == null) {
            DfaNullability.$$$reportNull$$$0(10);
        }
        if (this == NOT_NULL) {
            return right == NULL ? null : NOT_NULL;
        }
        if (right == NOT_NULL) {
            return this == NULL ? null : NOT_NULL;
        }
        if (this == UNKNOWN) {
            return right;
        }
        if (right == UNKNOWN) {
            return this;
        }
        if (this == FLUSHED && DfaNullability.toNullability(right) == Nullability.NULLABLE || right == FLUSHED && DfaNullability.toNullability(this) == Nullability.NULLABLE) {
            return NULLABLE;
        }
        return this.equals((Object)right) ? this : null;
    }

    @NotNull
    public static Nullability toNullability(@Nullable DfaNullability dfaNullability) {
        Nullability nullability = dfaNullability == null ? Nullability.UNKNOWN : dfaNullability.myNullability;
        if (nullability == null) {
            DfaNullability.$$$reportNull$$$0(11);
        }
        return nullability;
    }

    @NotNull
    public static DfaNullability fromNullability(@NotNull Nullability nullability) {
        if (nullability == null) {
            DfaNullability.$$$reportNull$$$0(12);
        }
        switch (nullability) {
            case NOT_NULL: {
                DfaNullability dfaNullability = NOT_NULL;
                if (dfaNullability == null) {
                    DfaNullability.$$$reportNull$$$0(13);
                }
                return dfaNullability;
            }
            case NULLABLE: {
                DfaNullability dfaNullability = NULLABLE;
                if (dfaNullability == null) {
                    DfaNullability.$$$reportNull$$$0(14);
                }
                return dfaNullability;
            }
            case UNKNOWN: {
                DfaNullability dfaNullability = UNKNOWN;
                if (dfaNullability == null) {
                    DfaNullability.$$$reportNull$$$0(15);
                }
                return dfaNullability;
            }
        }
        throw new IllegalStateException("Unknown nullability: " + nullability);
    }

    @NotNull
    public DfReferenceType asDfType() {
        switch (this) {
            case NULL: {
                DfNullConstantType dfNullConstantType = DfTypes.NULL;
                if (dfNullConstantType == null) {
                    DfaNullability.$$$reportNull$$$0(16);
                }
                return dfNullConstantType;
            }
            case NOT_NULL: {
                DfReferenceType dfReferenceType = DfTypes.NOT_NULL_OBJECT;
                if (dfReferenceType == null) {
                    DfaNullability.$$$reportNull$$$0(17);
                }
                return dfReferenceType;
            }
            case UNKNOWN: {
                DfReferenceType dfReferenceType = DfTypes.OBJECT_OR_NULL;
                if (dfReferenceType == null) {
                    DfaNullability.$$$reportNull$$$0(18);
                }
                return dfReferenceType;
            }
        }
        DfReferenceType dfReferenceType = DfTypes.customObject(TypeConstraints.TOP, this, Mutability.UNKNOWN, null, DfTypes.BOTTOM);
        if (dfReferenceType == null) {
            DfaNullability.$$$reportNull$$$0(19);
        }
        return dfReferenceType;
    }

    @NotNull
    public static DfaNullability fromDfType(@NotNull DfType type2) {
        if (type2 == null) {
            DfaNullability.$$$reportNull$$$0(20);
        }
        DfaNullability dfaNullability = type2 instanceof DfReferenceType ? ((DfReferenceType)type2).getNullability() : UNKNOWN;
        if (dfaNullability == null) {
            DfaNullability.$$$reportNull$$$0(21);
        }
        return dfaNullability;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "internalName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentationalName";
                break;
            }
            case 2: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nullability";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/DfaNullability";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "right";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/DfaNullability";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getInternalName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentationName";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "unite";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "toNullability";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "fromNullability";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "asDfType";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "fromDfType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "unite";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "intersect";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "fromNullability";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "fromDfType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

