/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInsight.Nullability;
import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInspection.dataFlow.DataFlowRunner;
import com.intellij.codeInspection.dataFlow.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.DfaMemoryStateImpl;
import com.intellij.codeInspection.dataFlow.DfaNullability;
import com.intellij.codeInspection.dataFlow.InstructionVisitor;
import com.intellij.codeInspection.dataFlow.StandardInstructionVisitor;
import com.intellij.codeInspection.dataFlow.instructions.AssignInstruction;
import com.intellij.codeInspection.dataFlow.instructions.Instruction;
import com.intellij.codeInspection.dataFlow.instructions.PushInstruction;
import com.intellij.codeInspection.dataFlow.instructions.ReturnInstruction;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.search.JavaNullMethodArgumentUtil;
import com.intellij.util.SmartList;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

class NullParameterConstraintChecker
extends DataFlowRunner {
    private final Set<PsiParameter> myPossiblyViolatedParameters;
    private final Set<PsiParameter> myUsedParameters;
    private final Set<PsiParameter> myParametersWithSuccessfulExecutionInNotNullState;

    private NullParameterConstraintChecker(Project project, Collection<PsiParameter> parameters2) {
        super(project);
        this.myPossiblyViolatedParameters = new THashSet(parameters2);
        this.myParametersWithSuccessfulExecutionInNotNullState = new THashSet();
        this.myUsedParameters = new THashSet();
    }

    static PsiParameter @NotNull [] checkMethodParameters(PsiMethod method) {
        if (method.getBody() == null) {
            if (PsiParameter.EMPTY_ARRAY == null) {
                NullParameterConstraintChecker.$$$reportNull$$$0(0);
            }
            return PsiParameter.EMPTY_ARRAY;
        }
        SmartList nullableParameters = new SmartList();
        PsiParameter[] parameters2 = method.getParameterList().getParameters();
        for (int index = 0; index < parameters2.length; ++index) {
            PsiParameter parameter2 = parameters2[index];
            if (parameter2.getType() instanceof PsiPrimitiveType || NullableNotNullManager.getNullability((PsiModifierListOwner)parameter2) != Nullability.UNKNOWN || !JavaNullMethodArgumentUtil.hasNullArgument(method, index)) continue;
            nullableParameters.add(parameter2);
        }
        if (nullableParameters.isEmpty()) {
            if (PsiParameter.EMPTY_ARRAY == null) {
                NullParameterConstraintChecker.$$$reportNull$$$0(1);
            }
            return PsiParameter.EMPTY_ARRAY;
        }
        NullParameterConstraintChecker checker = new NullParameterConstraintChecker(method.getProject(), (Collection<PsiParameter>)nullableParameters);
        checker.analyzeMethod((PsiElement)method.getBody(), new StandardInstructionVisitor());
        PsiParameter[] psiParameterArray = (PsiParameter[])checker.myPossiblyViolatedParameters.stream().filter(checker.myUsedParameters::contains).filter(checker.myParametersWithSuccessfulExecutionInNotNullState::contains).toArray(PsiParameter[]::new);
        if (psiParameterArray == null) {
            NullParameterConstraintChecker.$$$reportNull$$$0(2);
        }
        return psiParameterArray;
    }

    @Override
    protected DfaInstructionState @NotNull [] acceptInstruction(@NotNull InstructionVisitor visitor2, @NotNull DfaInstructionState instructionState) {
        PsiModifierListOwner psiVariable;
        DfaValue value2;
        PsiModifierListOwner psiVar;
        DfaValue var;
        Instruction instruction;
        if (visitor2 == null) {
            NullParameterConstraintChecker.$$$reportNull$$$0(3);
        }
        if (instructionState == null) {
            NullParameterConstraintChecker.$$$reportNull$$$0(4);
        }
        if ((instruction = instructionState.getInstruction()) instanceof PushInstruction && (var = ((PushInstruction)instruction).getValue()) instanceof DfaVariableValue && (psiVar = ((DfaVariableValue)var).getPsiVariable()) instanceof PsiParameter) {
            this.myUsedParameters.add((PsiParameter)psiVar);
        }
        if (instruction instanceof AssignInstruction && (value2 = ((AssignInstruction)instruction).getAssignedValue()) instanceof DfaVariableValue && (psiVariable = ((DfaVariableValue)value2).getPsiVariable()) instanceof PsiParameter) {
            this.myPossiblyViolatedParameters.remove(psiVariable);
        }
        if (instruction instanceof ReturnInstruction && !((ReturnInstruction)instruction).isViaException()) {
            DfaMemoryState memState = instructionState.getMemoryState();
            for (PsiParameter parameter2 : this.myPossiblyViolatedParameters.toArray(PsiParameter.EMPTY_ARRAY)) {
                DfaVariableValue dfaVar = this.getFactory().getVarFactory().createVariableValue((PsiVariable)parameter2);
                if (memState.isNotNull(dfaVar)) {
                    this.myParametersWithSuccessfulExecutionInNotNullState.add(parameter2);
                    continue;
                }
                this.myPossiblyViolatedParameters.remove(parameter2);
            }
        }
        DfaInstructionState[] dfaInstructionStateArray = super.acceptInstruction(visitor2, instructionState);
        if (dfaInstructionStateArray == null) {
            NullParameterConstraintChecker.$$$reportNull$$$0(5);
        }
        return dfaInstructionStateArray;
    }

    @Override
    @NotNull
    protected DfaMemoryState createMemoryState() {
        return new MyDfaMemoryState(this.getFactory());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/NullParameterConstraintChecker";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instructionState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "checkMethodParameters";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/NullParameterConstraintChecker";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "acceptInstruction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "acceptInstruction";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyDfaMemoryState
    extends DfaMemoryStateImpl {
        protected MyDfaMemoryState(DfaValueFactory factory) {
            super(factory);
            for (PsiParameter parameter2 : NullParameterConstraintChecker.this.myPossiblyViolatedParameters) {
                this.recordVariableType(this.getFactory().getVarFactory().createVariableValue((PsiVariable)parameter2), DfaNullability.NULLABLE.asDfType());
            }
        }

        protected MyDfaMemoryState(MyDfaMemoryState toCopy) {
            super(toCopy);
        }

        @Override
        protected void flushVariable(@NotNull DfaVariableValue variable, boolean shouldMarkFlushed) {
            PsiModifierListOwner psi;
            if (variable == null) {
                MyDfaMemoryState.$$$reportNull$$$0(0);
            }
            if ((psi = variable.getPsiVariable()) instanceof PsiParameter && NullParameterConstraintChecker.this.myPossiblyViolatedParameters.contains(psi)) {
                return;
            }
            super.flushVariable(variable, shouldMarkFlushed);
        }

        @Override
        @NotNull
        public DfaMemoryStateImpl createCopy() {
            return new MyDfaMemoryState(this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/codeInspection/dataFlow/NullParameterConstraintChecker$MyDfaMemoryState", "flushVariable"));
        }
    }
}

