/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.fix;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SurroundWithRequireNonNullFix
implements LocalQuickFix {
    private final String myText;
    private final SmartPsiElementPointer<PsiExpression> myQualifierPointer;

    public SurroundWithRequireNonNullFix(@NotNull PsiExpression expressionToSurround) {
        if (expressionToSurround == null) {
            SurroundWithRequireNonNullFix.$$$reportNull$$$0(0);
        }
        this.myText = expressionToSurround.getText();
        this.myQualifierPointer = SmartPointerManager.getInstance((Project)expressionToSurround.getProject()).createSmartPsiElementPointer((PsiElement)expressionToSurround);
    }

    @Nls
    @NotNull
    public String getName() {
        String string = JavaAnalysisBundle.message((String)"inspection.surround.requirenonnull.quickfix", (Object[])new Object[]{this.myText});
        if (string == null) {
            SurroundWithRequireNonNullFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = JavaAnalysisBundle.message((String)"inspection.surround.requirenonnull.quickfix", (Object[])new Object[]{""});
        if (string == null) {
            SurroundWithRequireNonNullFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiExpression qualifier;
        if (project == null) {
            SurroundWithRequireNonNullFix.$$$reportNull$$$0(3);
        }
        if (descriptor == null) {
            SurroundWithRequireNonNullFix.$$$reportNull$$$0(4);
        }
        if ((qualifier = (PsiExpression)this.myQualifierPointer.getElement()) == null) {
            return;
        }
        PsiExpression replacement = JavaPsiFacade.getElementFactory((Project)project).createExpressionFromText("java.util.Objects.requireNonNull(" + qualifier.getText() + ")", (PsiElement)qualifier);
        JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(qualifier.replace((PsiElement)replacement));
    }

    @Nullable
    public FileModifier getFileModifierForPreview(@NotNull PsiFile target) {
        PsiExpression expression2;
        if (target == null) {
            SurroundWithRequireNonNullFix.$$$reportNull$$$0(5);
        }
        if ((expression2 = (PsiExpression)this.myQualifierPointer.getElement()) == null) {
            return null;
        }
        return new SurroundWithRequireNonNullFix((PsiExpression)PsiTreeUtil.findSameElementInCopy((PsiElement)expression2, (PsiFile)target));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressionToSurround";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/fix/SurroundWithRequireNonNullFix";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/fix/SurroundWithRequireNonNullFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getFileModifierForPreview";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

