/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.inference;

import com.intellij.codeInspection.dataFlow.inference.ExpressionRange;
import com.intellij.codeInspection.dataFlow.inference.PurityInferenceResult;
import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.impl.source.FileLocalResolver;
import com.intellij.psi.impl.source.JavaLightTreeUtil;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.LightTreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PurityInferenceVisitor {
    private final LighterAST tree;
    private final LighterASTNode body;
    private final Map<String, LighterASTNode> myFieldModifiers;
    private final List<LighterASTNode> mutatedRefs = new ArrayList<LighterASTNode>();
    private final boolean constructor;
    private boolean mutatesThis;
    private boolean hasVolatileReads;
    private final List<LighterASTNode> calls = new ArrayList<LighterASTNode>();

    PurityInferenceVisitor(LighterAST tree, LighterASTNode body2, Map<String, LighterASTNode> fieldModifiers, boolean isConstructor) {
        this.tree = tree;
        this.body = body2;
        this.constructor = isConstructor;
        this.myFieldModifiers = fieldModifiers;
    }

    boolean visitNode(LighterASTNode element) {
        IElementType type2 = element.getTokenType();
        if (type2 == JavaElementType.ASSIGNMENT_EXPRESSION) {
            this.addMutation((LighterASTNode)this.tree.getChildren(element).get(0));
        } else if ((type2 == JavaElementType.PREFIX_EXPRESSION || type2 == JavaElementType.POSTFIX_EXPRESSION) && this.isMutatingOperation(element)) {
            this.addMutation(JavaLightTreeUtil.findExpressionChild(this.tree, element));
        } else if (this.isCall(element, type2)) {
            this.calls.add(element);
        } else if (type2 == JavaElementType.REFERENCE_EXPRESSION && !this.myFieldModifiers.isEmpty() && this.isEffectivelyUnqualified(element)) {
            LighterASTNode target;
            boolean isVolatile;
            LighterASTNode modifiers = this.myFieldModifiers.get(JavaLightTreeUtil.getNameIdentifierText(this.tree, element));
            boolean bl = isVolatile = LightTreeUtil.firstChildOfType((LighterAST)this.tree, (LighterASTNode)modifiers, (IElementType)JavaTokenType.VOLATILE_KEYWORD) != null;
            if (isVolatile && (target = new FileLocalResolver(this.tree).resolveLocally(element).getTarget()) != null && target.getTokenType() == JavaElementType.FIELD && JavaLightTreeUtil.hasExplicitModifier(this.tree, target, JavaTokenType.VOLATILE_KEYWORD)) {
                this.hasVolatileReads = true;
            }
        }
        return !this.unknownPurity();
    }

    private boolean isEffectivelyUnqualified(LighterASTNode element) {
        LighterASTNode qualifier = JavaLightTreeUtil.findExpressionChild(this.tree, element);
        return qualifier == null || qualifier.getTokenType() == JavaElementType.THIS_EXPRESSION && JavaLightTreeUtil.findExpressionChild(this.tree, qualifier) == null;
    }

    private void addMutation(LighterASTNode mutated) {
        LighterASTNode modifiers;
        IElementType type2;
        if (mutated == null) {
            return;
        }
        if (!this.myFieldModifiers.isEmpty() && (type2 = mutated.getTokenType()) == JavaElementType.REFERENCE_EXPRESSION && this.isEffectivelyUnqualified(mutated) && (modifiers = this.myFieldModifiers.get(JavaLightTreeUtil.getNameIdentifierText(this.tree, mutated))) != null) {
            boolean isStatic;
            boolean bl = isStatic = LightTreeUtil.firstChildOfType((LighterAST)this.tree, (LighterASTNode)modifiers, (IElementType)JavaTokenType.STATIC_KEYWORD) != null;
            if (!isStatic) {
                if (!this.constructor) {
                    this.mutatesThis = true;
                }
                return;
            }
        }
        this.mutatedRefs.add(mutated);
    }

    private boolean isCall(@NotNull LighterASTNode element, IElementType type2) {
        if (element == null) {
            PurityInferenceVisitor.$$$reportNull$$$0(0);
        }
        return type2 == JavaElementType.NEW_EXPRESSION && (LightTreeUtil.firstChildOfType((LighterAST)this.tree, (LighterASTNode)element, (IElementType)JavaElementType.EXPRESSION_LIST) != null || LightTreeUtil.firstChildOfType((LighterAST)this.tree, (LighterASTNode)element, (IElementType)JavaElementType.ANONYMOUS_CLASS) != null) || type2 == JavaElementType.METHOD_CALL_EXPRESSION;
    }

    private boolean isMutatingOperation(@NotNull LighterASTNode element) {
        if (element == null) {
            PurityInferenceVisitor.$$$reportNull$$$0(1);
        }
        return LightTreeUtil.firstChildOfType((LighterAST)this.tree, (LighterASTNode)element, (IElementType)JavaTokenType.PLUSPLUS) != null || LightTreeUtil.firstChildOfType((LighterAST)this.tree, (LighterASTNode)element, (IElementType)JavaTokenType.MINUSMINUS) != null;
    }

    @Nullable
    PurityInferenceResult getResult() {
        if (this.unknownPurity()) {
            return null;
        }
        int bodyStart = this.body.getStartOffset();
        return new PurityInferenceResult(this.mutatesThis, ContainerUtil.map(this.mutatedRefs, node -> ExpressionRange.create(node, bodyStart)), this.calls.isEmpty() ? null : ExpressionRange.create(this.calls.get(0), bodyStart));
    }

    private boolean unknownPurity() {
        return this.calls.size() > 1 || !this.constructor && this.hasVolatileReads;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "element";
        objectArray2[1] = "com/intellij/codeInspection/dataFlow/inference/PurityInferenceVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isCall";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isMutatingOperation";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

