/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.inliner;

import com.intellij.codeInspection.dataFlow.CFGBuilder;
import com.intellij.codeInspection.dataFlow.inliner.CallInliner;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.callMatcher.CallMatcher;
import org.jetbrains.annotations.NotNull;

public class ClassMethodsInliner
implements CallInliner {
    private static final CallMatcher IS_ASSIGNABLE_FROM = CallMatcher.instanceCall("java.lang.Class", "isAssignableFrom").parameterTypes("java.lang.Class");
    private static final CallMatcher IS_INSTANCE = CallMatcher.instanceCall("java.lang.Class", "isInstance").parameterTypes("java.lang.Object");
    private static final CallMatcher OBJECT_GET_CLASS = CallMatcher.instanceCall("java.lang.Object", "getClass").parameterCount(0);

    @Override
    public boolean tryInlineCall(@NotNull CFGBuilder builder, @NotNull PsiMethodCallExpression call) {
        PsiExpression qualifier;
        if (builder == null) {
            ClassMethodsInliner.$$$reportNull$$$0(0);
        }
        if (call == null) {
            ClassMethodsInliner.$$$reportNull$$$0(1);
        }
        if ((qualifier = call.getMethodExpression().getQualifierExpression()) == null) {
            return false;
        }
        if (IS_ASSIGNABLE_FROM.matches((PsiExpression)call)) {
            PsiExpression getClassQualifier;
            PsiExpression arg = call.getArgumentList().getExpressions()[0];
            PsiMethodCallExpression nestedCall = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)arg), PsiMethodCallExpression.class);
            PsiExpression psiExpression = getClassQualifier = OBJECT_GET_CLASS.matches((PsiExpression)nestedCall) ? nestedCall.getMethodExpression().getQualifierExpression() : null;
            if (getClassQualifier != null) {
                builder.pushExpression(qualifier).pushExpression(getClassQualifier);
            } else {
                builder.pushExpression(qualifier).pushExpression(arg).objectOf();
            }
            builder.swap().isInstance(call);
            return true;
        }
        if (IS_INSTANCE.matches((PsiExpression)call)) {
            builder.pushExpression(qualifier).pushExpression(call.getArgumentList().getExpressions()[0]).swap().isInstance(call);
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "builder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "call";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeInspection/dataFlow/inliner/ClassMethodsInliner";
        objectArray[2] = "tryInlineCall";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

