/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.miscGenerics;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.miscGenerics.GenericsInspectionToolBase;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.impl.PsiDiamondTypeUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ig.psiutils.CommentTracker;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class RedundantTypeArgsInspection
extends GenericsInspectionToolBase {
    private static final Logger LOG = Logger.getInstance(RedundantTypeArgsInspection.class);
    private static final LocalQuickFix ourQuickFixAction = new MyQuickFixAction();
    public static final String SHORT_NAME = "RedundantTypeArguments";

    @NotNull
    public String getGroupDisplayName() {
        String string = InspectionsBundle.message((String)"group.names.verbose.or.redundant.code.constructs", (Object[])new Object[0]);
        if (string == null) {
            RedundantTypeArgsInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        return SHORT_NAME;
    }

    @Override
    public ProblemDescriptor[] checkMethod(@NotNull PsiMethod psiMethod, @NotNull InspectionManager manager, boolean isOnTheFly) {
        PsiCodeBlock body2;
        if (psiMethod == null) {
            RedundantTypeArgsInspection.$$$reportNull$$$0(1);
        }
        if (manager == null) {
            RedundantTypeArgsInspection.$$$reportNull$$$0(2);
        }
        if ((body2 = psiMethod.getBody()) != null) {
            return this.getDescriptions((PsiElement)body2, manager, isOnTheFly);
        }
        return null;
    }

    @Override
    public ProblemDescriptor[] getDescriptions(@NotNull PsiElement place, final @NotNull InspectionManager inspectionManager, final boolean isOnTheFly) {
        if (place == null) {
            RedundantTypeArgsInspection.$$$reportNull$$$0(3);
        }
        if (inspectionManager == null) {
            RedundantTypeArgsInspection.$$$reportNull$$$0(4);
        }
        final ArrayList problems = new ArrayList();
        place.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
                super.visitMethodCallExpression(expression2);
                PsiType[] typeArguments = expression2.getTypeArguments();
                if (typeArguments.length > 0) {
                    RedundantTypeArgsInspection.checkCallExpression((PsiJavaCodeReferenceElement)expression2.getMethodExpression(), typeArguments, (PsiCallExpression)expression2, inspectionManager, problems, isOnTheFly);
                }
            }

            public void visitNewExpression(PsiNewExpression expression2) {
                PsiJavaCodeReferenceElement classReference2;
                super.visitNewExpression(expression2);
                PsiType[] typeArguments = expression2.getTypeArguments();
                if (typeArguments.length > 0 && (classReference2 = expression2.getClassReference()) != null) {
                    RedundantTypeArgsInspection.checkCallExpression(classReference2, typeArguments, (PsiCallExpression)expression2, inspectionManager, problems, isOnTheFly);
                }
            }

            public void visitMethodReferenceExpression(PsiMethodReferenceExpression expression2) {
                super.visitMethodReferenceExpression(expression2);
                RedundantTypeArgsInspection.checkMethodReference(expression2, inspectionManager, problems, isOnTheFly);
            }
        });
        if (problems.isEmpty()) {
            return null;
        }
        return problems.toArray(ProblemDescriptor.EMPTY_ARRAY);
    }

    private static void checkCallExpression(PsiJavaCodeReferenceElement reference, PsiType[] typeArguments, PsiCallExpression expression2, InspectionManager inspectionManager, List<? super ProblemDescriptor> problems, boolean isOnTheFly) {
        PsiMethod method;
        PsiTypeParameter[] typeParameters;
        PsiExpressionList argumentList = expression2.getArgumentList();
        if (argumentList == null) {
            return;
        }
        JavaResolveResult resolveResult = reference.advancedResolve(false);
        PsiElement element = resolveResult.getElement();
        if (element instanceof PsiMethod && resolveResult.isValidResult() && ((typeParameters = (method = (PsiMethod)element).getTypeParameters()).length == typeArguments.length && PsiDiamondTypeUtil.areTypeArgumentsRedundant(typeArguments, (PsiExpression)expression2, false, method, typeParameters) || typeParameters.length == 0)) {
            String key2 = typeParameters.length == 0 ? "inspection.redundant.type.no.generics.problem.descriptor" : "inspection.redundant.type.problem.descriptor";
            ProblemDescriptor descriptor = inspectionManager.createProblemDescriptor((PsiElement)expression2.getTypeArgumentList(), JavaAnalysisBundle.message((String)key2, (Object[])new Object[0]), ourQuickFixAction, ProblemHighlightType.LIKE_UNUSED_SYMBOL, isOnTheFly);
            problems.add((ProblemDescriptor)descriptor);
        }
    }

    private static void checkMethodReference(PsiMethodReferenceExpression expression2, InspectionManager inspectionManager, List<? super ProblemDescriptor> problems, boolean isOnTheFly) {
        PsiTypeElement qualifierTypeElement = expression2.getQualifierType();
        if (qualifierTypeElement != null) {
            PsiType psiType = qualifierTypeElement.getType();
            if (psiType instanceof PsiClassType && !((PsiClassType)psiType).isRaw()) {
                PsiClass aClass = ((PsiClassType)psiType).resolve();
                if (aClass == null) {
                    return;
                }
                JavaResolveResult result = expression2.advancedResolve(false);
                PsiElement element = result.getElement();
                if (element instanceof PsiTypeParameterListOwner) {
                    PsiMethod method;
                    PsiMethod psiMethod = method = element instanceof PsiMethod ? (PsiMethod)element : null;
                    if (PsiDiamondTypeUtil.areTypeArgumentsRedundant(((PsiClassType)psiType).getParameters(), (PsiExpression)expression2, false, method, aClass.getTypeParameters())) {
                        PsiJavaCodeReferenceElement referenceElement = qualifierTypeElement.getInnermostComponentReferenceElement();
                        LOG.assertTrue(referenceElement != null, (Object)qualifierTypeElement);
                        PsiReferenceParameterList parameterList = referenceElement.getParameterList();
                        LOG.assertTrue(parameterList != null);
                        ProblemDescriptor descriptor = inspectionManager.createProblemDescriptor((PsiElement)parameterList, JavaAnalysisBundle.message((String)"inspection.redundant.type.problem.descriptor", (Object[])new Object[0]), ourQuickFixAction, ProblemHighlightType.LIKE_UNUSED_SYMBOL, isOnTheFly);
                        problems.add((ProblemDescriptor)descriptor);
                    }
                }
            }
        } else {
            PsiType[] typeArguments = expression2.getTypeParameters();
            PsiReferenceParameterList parameterList = expression2.getParameterList();
            if (typeArguments.length > 0 && parameterList != null) {
                PsiTypeParameter[] typeParameters;
                PsiElement resolve2 = expression2.resolve();
                if (resolve2 == null) {
                    return;
                }
                PsiTypeParameter[] psiTypeParameterArray = typeParameters = resolve2 instanceof PsiClass ? PsiTypeParameter.EMPTY_ARRAY : ((PsiMethod)resolve2).getTypeParameters();
                if (typeParameters.length == 0 || typeParameters.length == typeArguments.length && PsiDiamondTypeUtil.areTypeArgumentsRedundant(typeArguments, (PsiExpression)expression2, false, (PsiMethod)resolve2, typeParameters)) {
                    String key2 = typeParameters.length == 0 ? "inspection.redundant.type.no.generics.method.reference.problem.descriptor" : "inspection.redundant.type.problem.descriptor";
                    ProblemDescriptor descriptor = inspectionManager.createProblemDescriptor((PsiElement)parameterList, JavaAnalysisBundle.message((String)key2, (Object[])new Object[0]), (LocalQuickFix)new MyQuickFixAction(), ProblemHighlightType.LIKE_UNUSED_SYMBOL, isOnTheFly);
                    problems.add((ProblemDescriptor)descriptor);
                }
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/miscGenerics/RedundantTypeArgsInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMethod";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspectionManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/miscGenerics/RedundantTypeArgsInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "checkMethod";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getDescriptions";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyQuickFixAction
    implements LocalQuickFix {
        private MyQuickFixAction() {
        }

        @NotNull
        public String getFamilyName() {
            String string = JavaAnalysisBundle.message((String)"inspection.redundant.type.remove.quickfix", (Object[])new Object[0]);
            if (string == null) {
                MyQuickFixAction.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement element;
            if (project == null) {
                MyQuickFixAction.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                MyQuickFixAction.$$$reportNull$$$0(2);
            }
            if (!((element = descriptor.getPsiElement()) instanceof PsiReferenceParameterList)) {
                return;
            }
            PsiReferenceParameterList typeArgumentList = (PsiReferenceParameterList)element;
            try {
                PsiMethodCallExpression expr2 = (PsiMethodCallExpression)JavaPsiFacade.getElementFactory((Project)project).createExpressionFromText("foo()", null);
                new CommentTracker().replaceAndRestoreComments((PsiElement)typeArgumentList, (PsiElement)expr2.getTypeArgumentList());
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/miscGenerics/RedundantTypeArgsInspection$MyQuickFixAction";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/miscGenerics/RedundantTypeArgsInspection$MyQuickFixAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

