/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.optionalToIf;

import com.intellij.codeInspection.optionalToIf.OptionalToIfInspection;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

interface Instruction {
    public String generate();

    @Nullable
    public static Instruction create(@NotNull PsiStatement statement) {
        PsiAssignmentExpression assignment;
        PsiDeclarationStatement declaration2;
        if (statement == null) {
            Instruction.$$$reportNull$$$0(0);
        }
        if ((declaration2 = (PsiDeclarationStatement)ObjectUtils.tryCast((Object)statement, PsiDeclarationStatement.class)) != null) {
            return Declaration.create(declaration2);
        }
        PsiReturnStatement returnStatement = (PsiReturnStatement)ObjectUtils.tryCast((Object)statement, PsiReturnStatement.class);
        if (returnStatement != null) {
            return Return.create(returnStatement);
        }
        PsiThrowStatement throwStatement = (PsiThrowStatement)ObjectUtils.tryCast((Object)statement, PsiThrowStatement.class);
        if (throwStatement != null) {
            return Throw.create(throwStatement);
        }
        PsiIfStatement ifStatement = (PsiIfStatement)ObjectUtils.tryCast((Object)statement, PsiIfStatement.class);
        if (ifStatement != null) {
            return Check.create(ifStatement);
        }
        PsiBlockStatement block = (PsiBlockStatement)ObjectUtils.tryCast((Object)statement, PsiBlockStatement.class);
        if (block != null) {
            return new CodeBlock(block);
        }
        PsiExpressionStatement expressionStatement = (PsiExpressionStatement)ObjectUtils.tryCast((Object)statement, PsiExpressionStatement.class);
        if (expressionStatement != null && (assignment = (PsiAssignmentExpression)ObjectUtils.tryCast((Object)expressionStatement.getExpression(), PsiAssignmentExpression.class)) != null) {
            return Assignment.create(assignment);
        }
        return new Statement(statement);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/codeInspection/optionalToIf/Instruction", "create"));
    }

    public static class Throw
    implements Instruction {
        final PsiExpression myException;

        @Contract(pure=true)
        public Throw(@NotNull PsiExpression exception) {
            if (exception == null) {
                Throw.$$$reportNull$$$0(0);
            }
            this.myException = exception;
        }

        @Override
        public String generate() {
            return "throw " + this.myException.getText() + ";\n";
        }

        @Nullable
        static Throw create(@NotNull PsiThrowStatement throwStatement) {
            PsiExpression exception;
            if (throwStatement == null) {
                Throw.$$$reportNull$$$0(1);
            }
            return (exception = throwStatement.getException()) == null ? null : new Throw(exception);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "exception";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "throwStatement";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInspection/optionalToIf/Instruction$Throw";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "create";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class Return
    implements Instruction {
        final PsiExpression myExpression;

        @Contract(pure=true)
        public Return(@NotNull PsiExpression expression2) {
            if (expression2 == null) {
                Return.$$$reportNull$$$0(0);
            }
            this.myExpression = expression2;
        }

        @Override
        public String generate() {
            return "return " + this.myExpression.getText() + ";\n";
        }

        @Nullable
        static Return create(@NotNull PsiReturnStatement returnStatement) {
            PsiExpression returnValue;
            if (returnStatement == null) {
                Return.$$$reportNull$$$0(1);
            }
            return (returnValue = returnStatement.getReturnValue()) == null ? null : new Return(returnValue);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "returnStatement";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInspection/optionalToIf/Instruction$Return";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "create";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class Check
    implements Instruction {
        final PsiExpression myCondition;
        List<Instruction> myInstructions;
        private final List<Instruction> myElseInstructions;

        @Contract(pure=true)
        public Check(PsiExpression condition2, List<Instruction> instructions, @Nullable List<Instruction> elseInstructions) {
            this.myCondition = condition2;
            this.myInstructions = instructions;
            this.myElseInstructions = elseInstructions;
        }

        public boolean hasElseBranch() {
            return this.myElseInstructions != null;
        }

        @Override
        public String generate() {
            if (this.myInstructions.size() == 1 && !this.hasElseBranch() && !(this.myInstructions.get(0) instanceof Declaration)) {
                return "if(" + this.myCondition.getText() + ")" + this.myInstructions.get(0).generate();
            }
            String thenBranch = "if(" + this.myCondition.getText() + "){\n" + StringUtil.join(this.myInstructions, i -> i.generate(), (String)"") + "}\n";
            if (this.myElseInstructions == null) {
                return thenBranch;
            }
            return thenBranch + "else{\n" + StringUtil.join(this.myElseInstructions, i -> i.generate(), (String)"") + "\n}";
        }

        @Nullable
        static Check create(@NotNull PsiIfStatement ifStatement) {
            PsiExpression condition2;
            if (ifStatement == null) {
                Check.$$$reportNull$$$0(0);
            }
            if ((condition2 = ifStatement.getCondition()) == null) {
                return null;
            }
            PsiStatement thenBranch = ifStatement.getThenBranch();
            if (thenBranch == null) {
                return null;
            }
            List<Instruction> instructions = OptionalToIfInspection.createInstructions(ControlFlowUtils.unwrapBlock(thenBranch));
            if (instructions == null) {
                return null;
            }
            PsiStatement elseBranch = ifStatement.getElseBranch();
            List<Instruction> elseInstructions = null;
            if (elseBranch != null && (elseInstructions = OptionalToIfInspection.createInstructions(ControlFlowUtils.unwrapBlock(elseBranch))) == null) {
                return null;
            }
            return new Check(condition2, instructions, elseInstructions);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ifStatement", "com/intellij/codeInspection/optionalToIf/Instruction$Check", "create"));
        }
    }

    public static class Declaration
    implements Instruction {
        final PsiVariable myLhs;
        final PsiExpression myRhs;

        @Contract(pure=true)
        public Declaration(PsiVariable lhs, PsiExpression rhs) {
            this.myLhs = lhs;
            this.myRhs = rhs;
        }

        @Override
        public String generate() {
            if (this.myLhs.getInitializer() == this.myRhs) {
                return this.myLhs.getText();
            }
            PsiVariable copy = (PsiVariable)this.myLhs.copy();
            copy.setInitializer(this.myRhs);
            return copy.getText();
        }

        @Nullable
        static Declaration create(@NotNull PsiDeclarationStatement declaration2) {
            PsiElement[] declared;
            if (declaration2 == null) {
                Declaration.$$$reportNull$$$0(0);
            }
            if ((declared = declaration2.getDeclaredElements()).length != 1) {
                return null;
            }
            PsiVariable lhs = (PsiVariable)ObjectUtils.tryCast((Object)declared[0], PsiVariable.class);
            if (lhs == null) {
                return null;
            }
            PsiExpression rhs = lhs.getInitializer();
            return rhs == null ? null : new Declaration(lhs, rhs);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "com/intellij/codeInspection/optionalToIf/Instruction$Declaration", "create"));
        }
    }

    public static class Assignment
    implements Instruction {
        final PsiVariable myLhs;
        final PsiExpression myRhs;

        @Contract(pure=true)
        public Assignment(@NotNull PsiVariable lhs, @NotNull PsiExpression rhs) {
            if (lhs == null) {
                Assignment.$$$reportNull$$$0(0);
            }
            if (rhs == null) {
                Assignment.$$$reportNull$$$0(1);
            }
            this.myLhs = lhs;
            this.myRhs = rhs;
        }

        @Override
        public String generate() {
            return this.myLhs.getName() + "=" + this.myRhs.getText() + ";\n";
        }

        @Nullable
        static Assignment create(@NotNull PsiAssignmentExpression assignment) {
            PsiExpression rhs;
            if (assignment == null) {
                Assignment.$$$reportNull$$$0(2);
            }
            if ((rhs = assignment.getRExpression()) == null) {
                return null;
            }
            PsiReference reference = (PsiReference)ObjectUtils.tryCast((Object)assignment.getLExpression(), PsiReference.class);
            if (reference == null) {
                return null;
            }
            PsiVariable lhs = (PsiVariable)ObjectUtils.tryCast((Object)reference.resolve(), PsiVariable.class);
            return lhs == null ? null : new Assignment(lhs, rhs);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "lhs";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rhs";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "assignment";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInspection/optionalToIf/Instruction$Assignment";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "create";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class Statement
    implements Instruction {
        private final PsiStatement myStatement;

        @Contract(pure=true)
        public Statement(@NotNull PsiStatement statement) {
            if (statement == null) {
                Statement.$$$reportNull$$$0(0);
            }
            this.myStatement = statement;
        }

        @Override
        public String generate() {
            return this.myStatement.getText();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/codeInspection/optionalToIf/Instruction$Statement", "<init>"));
        }
    }

    public static class CodeBlock
    implements Instruction {
        private final PsiBlockStatement myBlock;

        public CodeBlock(PsiBlockStatement block) {
            this.myBlock = block;
        }

        @Override
        public String generate() {
            return StringUtil.join((Object[])this.myBlock.getCodeBlock().getStatements(), s -> s.getText(), (String)"\n");
        }
    }
}

